<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تذكير بسداد الفاتورة</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            direction: rtl;
            text-align: right;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header.warning {
            background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
        }
        .header.urgent {
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 300;
        }
        .reminder-badge {
            background-color: rgba(255,255,255,0.2);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
        }
        .content {
            padding: 30px;
        }
        .greeting {
            font-size: 18px;
            color: #495057;
            margin-bottom: 25px;
            line-height: 1.6;
        }
        .invoice-summary {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin: 25px 0;
            border-right: 4px solid #007bff;
        }
        .invoice-summary.warning {
            border-right-color: #ffc107;
            background-color: #fff3cd;
        }
        .invoice-summary.urgent {
            border-right-color: #dc3545;
            background-color: #f8d7da;
        }
        .invoice-summary h3 {
            margin-top: 0;
            color: #495057;
            font-size: 20px;
            margin-bottom: 15px;
        }
        .summary-row {
            display: flex;
            justify-content: space-between;
            margin: 12px 0;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }
        .summary-row:last-child {
            border-bottom: none;
            font-weight: bold;
            font-size: 16px;
        }
        .label {
            color: #6c757d;
            font-weight: 500;
        }
        .value {
            color: #495057;
            font-weight: 600;
        }
        .amount {
            font-size: 22px;
            font-weight: bold;
            color: #28a745;
        }
        .overdue-amount {
            color: #dc3545;
        }
        .reminder-message {
            background-color: #e7f3ff;
            border: 1px solid #b8daff;
            border-radius: 6px;
            padding: 20px;
            margin: 25px 0;
            text-align: center;
        }
        .reminder-message.warning {
            background-color: #fff3cd;
            border-color: #ffeaa7;
        }
        .reminder-message.urgent {
            background-color: #f8d7da;
            border-color: #f5c6cb;
        }
        .reminder-message h4 {
            margin-top: 0;
            color: #0c5460;
        }
        .reminder-message.warning h4 {
            color: #856404;
        }
        .reminder-message.urgent h4 {
            color: #721c24;
        }
        .action-buttons {
            text-align: center;
            margin: 30px 0;
        }
        .btn {
            display: inline-block;
            padding: 12px 25px;
            margin: 10px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            text-align: center;
            border: none;
            cursor: pointer;
        }
        .btn-primary {
            background-color: #007bff;
            color: white;
        }
        .btn-success {
            background-color: #28a745;
            color: white;
        }
        .btn-warning {
            background-color: #ffc107;
            color: #212529;
        }
        .payment-methods {
            background-color: #e9ecef;
            border-radius: 6px;
            padding: 20px;
            margin: 25px 0;
        }
        .payment-methods h4 {
            margin-top: 0;
            color: #495057;
        }
        .payment-method {
            background-color: white;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            padding: 15px;
            margin: 10px 0;
        }
        .contact-info {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 20px;
            margin: 25px 0;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
        }
        .company-info {
            margin-bottom: 20px;
        }
        .urgency-indicator {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: bold;
            color: white;
        }
        .urgency-low { background-color: #28a745; }
        .urgency-medium { background-color: #ffc107; color: #212529; }
        .urgency-high { background-color: #dc3545; }
    </style>
</head>
<body>
    @php
        $overdueDays = now()->diffInDays($invoice->due_date);
        $urgencyClass = '';
        $urgencyText = '';
        $reminderText = '';
        
        if ($reminderType === 'first') {
            $urgencyClass = '';
            $urgencyText = 'تذكير ودي';
            $reminderText = 'تذكير أول';
        } elseif ($reminderType === 'second') {
            $urgencyClass = 'warning';
            $urgencyText = 'تذكير مهم';
            $reminderText = 'تذكير ثاني';
        } else {
            $urgencyClass = 'urgent';
            $urgencyText = 'تذكير عاجل';
            $reminderText = 'تذكير نهائي';
        }
    @endphp

    <div class="container">
        <div class="header {{ $urgencyClass }}">
            <div class="reminder-badge">{{ $reminderText }}</div>
            <h1>{{ $urgencyText }}</h1>
            <p style="margin: 0; opacity: 0.9;">تذكير بسداد فاتورة مستحقة</p>
        </div>
        
        <div class="content">
            <div class="greeting">
                السلام عليكم ورحمة الله وبركاته {{ $invoice->customer->name ?? 'عزيزي العميل' }}،
                <br><br>
                نأمل أن تكونوا بخير وعافية.
            </div>
            
            @if($reminderType === 'first')
                <p>نود تذكيركم بأن لديكم فاتورة مستحقة السداد. نقدر تعاملكم معنا ونأمل في سداد المستحق في أقرب وقت ممكن.</p>
            @elseif($reminderType === 'second')
                <p style="color: #856404; font-weight: bold;">نود تذكيركم مرة أخرى بوجود فاتورة متأخرة عن موعد السداد. يرجى المبادرة بالسداد لتجنب أي رسوم إضافية.</p>
            @else
                <p style="color: #721c24; font-weight: bold;">هذا تذكير نهائي بخصوص الفاتورة المتأخرة. يرجى السداد فوراً لتجنب اتخاذ إجراءات إضافية.</p>
            @endif
            
            <div class="invoice-summary {{ $urgencyClass }}">
                <h3>📄 تفاصيل الفاتورة</h3>
                
                <div class="summary-row">
                    <span class="label">رقم الفاتورة:</span>
                    <span class="value">{{ $invoice->invoice_number }}</span>
                </div>
                
                <div class="summary-row">
                    <span class="label">تاريخ الإصدار:</span>
                    <span class="value">{{ $invoice->issue_date->format('Y-m-d') }}</span>
                </div>
                
                <div class="summary-row">
                    <span class="label">تاريخ الاستحقاق:</span>
                    <span class="value" style="color: #dc3545; font-weight: bold;">
                        {{ $invoice->due_date->format('Y-m-d') }}
                    </span>
                </div>
                
                <div class="summary-row">
                    <span class="label">أيام التأخير:</span>
                    <span class="value">
                        <span class="urgency-indicator urgency-{{ $overdueDays <= 7 ? 'low' : ($overdueDays <= 30 ? 'medium' : 'high') }}">
                            {{ $overdueDays }} يوم
                        </span>
                    </span>
                </div>
                
                <div class="summary-row">
                    <span class="label">المبلغ الإجمالي:</span>
                    <span class="value amount">{{ number_format($invoice->total_amount, 2) }} ر.س</span>
                </div>
                
                @if($invoice->paid_amount > 0)
                <div class="summary-row">
                    <span class="label">المدفوع:</span>
                    <span class="value">{{ number_format($invoice->paid_amount, 2) }} ر.س</span>
                </div>
                @endif
                
                <div class="summary-row">
                    <span class="label">المبلغ المستحق:</span>
                    <span class="value amount overdue-amount">{{ number_format($invoice->remaining_amount, 2) }} ر.س</span>
                </div>
            </div>
            
            <div class="reminder-message {{ $urgencyClass }}">
                @if($reminderType === 'first')
                    <h4>🔔 تذكير ودي</h4>
                    <p>نقدر علاقتنا التجارية معكم ونأمل في تسوية هذا المستحق قريباً. إذا كان لديكم أي استفسارات، فلا تترددوا في التواصل معنا.</p>
                @elseif($reminderType === 'second')
                    <h4>⚠️ تذكير مهم</h4>
                    <p>لقد تجاوز موعد السداد، يرجى المبادرة بالسداد لتجنب أي إجراءات إضافية. نحن متاحون لمناقشة أي ترتيبات خاصة إذا لزم الأمر.</p>
                @else
                    <h4>🚨 تذكير نهائي</h4>
                    <p>هذا آخر تذكير قبل اتخاذ إجراءات إضافية. يرجى السداد فوراً أو التواصل معنا لمناقشة الوضع.</p>
                @endif
            </div>
            
            <div class="action-buttons">
                <a href="{{ route('invoices.verify', $invoice->uuid) }}" class="btn btn-primary">
                    📄 عرض الفاتورة
                </a>
                
                @if($invoice->customer && $invoice->customer->phone)
                <a href="https://wa.me/{{ $invoice->customer->phone }}" class="btn btn-success">
                    💬 تواصل عبر الواتساب
                </a>
                @endif
                
                @if($reminderType !== 'final')
                <a href="#" class="btn btn-warning">
                    💳 ادفع الآن
                </a>
                @endif
            </div>
            
            <div class="payment-methods">
                <h4>💳 طرق السداد المتاحة</h4>
                
                <div class="payment-method">
                    <strong>تحويل بنكي:</strong><br>
                    اسم البنك: {{ $invoice->company->bank_name ?? 'سيتم توفيره عند الطلب' }}<br>
                    رقم الحساب: {{ $invoice->company->bank_account ?? 'سيتم توفيره عند الطلب' }}
                </div>
                
                <div class="payment-method">
                    <strong>الدفع النقدي:</strong><br>
                    يمكنكم زيارة مقرنا أو ترتيب موعد لتحصيل المبلغ
                </div>
                
                <div class="payment-method">
                    <strong>الشيكات:</strong><br>
                    يرجى إصدار الشيك باسم: {{ $invoice->company->name }}
                </div>
            </div>
            
            @if($reminderType === 'final')
            <div style="background-color: #f8d7da; border: 2px solid #dc3545; border-radius: 6px; padding: 20px; margin: 25px 0; text-align: center;">
                <h4 style="color: #721c24; margin-top: 0;">⚠️ إشعار مهم</h4>
                <p style="color: #721c24; font-weight: bold; margin: 0;">
                    في حالة عدم السداد خلال 7 أيام من تاريخ هذا الإشعار، سيتم اتخاذ الإجراءات القانونية اللازمة لاستيفاء المستحقات وفقاً للأنظمة المعمول بها.
                </p>
            </div>
            @endif
            
            <div class="contact-info">
                <h4>📞 للاستفسارات والمساعدة</h4>
                <p><strong>الهاتف:</strong> {{ $invoice->company->phone ?? 'غير محدد' }}</p>
                <p><strong>البريد الإلكتروني:</strong> {{ $invoice->company->email ?? 'غير محدد' }}</p>
                <p><strong>العنوان:</strong> {{ $invoice->company->address ?? 'غير محدد' }}</p>
            </div>
            
            <div style="text-align: center; margin: 30px 0; color: #6c757d;">
                <p>نقدر تفهمكم وتعاونكم معنا</p>
                <p><strong>شكراً لثقتكم في خدماتنا</strong></p>
            </div>
        </div>
        
        <div class="footer">
            <div class="company-info">
                <strong>{{ $invoice->company->name ?? 'اسم الشركة' }}</strong><br>
                @if($invoice->company->vat_number)
                    الرقم الضريبي: {{ $invoice->company->vat_number }}<br>
                @endif
                @if($invoice->company->commercial_registration)
                    السجل التجاري: {{ $invoice->company->commercial_registration }}<br>
                @endif
            </div>
            
            <p>تم إرسال هذا التذكير تلقائياً في: {{ now()->format('Y-m-d H:i:s') }}</p>
            <p style="font-size: 12px; color: #adb5bd;">
                هذا إشعار آلي، يرجى عدم الرد على هذا البريد الإلكتروني
            </p>
        </div>
    </div>
</body>
</html>