<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة رقم {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            direction: rtl;
            text-align: right;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 700;
        }
        
        .header p {
            margin: 10px 0 0 0;
            font-size: 16px;
            opacity: 0.9;
        }
        
        .content {
            padding: 30px;
        }
        
        .invoice-info {
            background: linear-gradient(135deg, #f8f9ff 0%, #e6f2ff 100%);
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            border: 1px solid rgba(0,123,255,0.2);
        }
        
        .invoice-info h3 {
            color: #007bff;
            margin: 0 0 15px 0;
            font-size: 20px;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
        }
        
        .info-label {
            font-weight: 600;
            color: #495057;
        }
        
        .info-value {
            color: #212529;
        }
        
        .amount-highlight {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 15px;
            border-radius: 10px;
            text-align: center;
            margin: 20px 0;
            font-size: 18px;
            font-weight: 700;
        }
        
        .payment-info {
            background: linear-gradient(135deg, #fff8e1 0%, #ffe082 100%);
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            border: 1px solid rgba(255,193,7,0.3);
        }
        
        .payment-status {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 14px;
        }
        
        .status-paid {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
        }
        
        .status-partial {
            background: linear-gradient(135deg, #ffc107 0%, #ffca2c 100%);
            color: #212529;
        }
        
        .status-unpaid {
            background: linear-gradient(135deg, #dc3545 0%, #e74c3c 100%);
            color: white;
        }
        
        .cta-section {
            text-align: center;
            margin: 30px 0;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            text-decoration: none;
            border-radius: 25px;
            font-weight: 600;
            margin: 5px;
            transition: transform 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn-secondary {
            background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
        }
        
        .footer {
            background-color: #f8f9fa;
            padding: 25px;
            text-align: center;
            border-top: 1px solid #dee2e6;
        }
        
        .company-info {
            color: #6c757d;
            font-size: 14px;
            line-height: 1.6;
        }
        
        .qr-section {
            text-align: center;
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 10px;
        }
        
        .qr-code {
            width: 120px;
            height: 120px;
            border: 2px solid #dee2e6;
            border-radius: 8px;
        }
        
        @media (max-width: 600px) {
            .email-container {
                margin: 10px;
                border-radius: 10px;
            }
            
            .header, .content, .footer {
                padding: 20px;
            }
            
            .header h1 {
                font-size: 24px;
            }
            
            .info-row {
                flex-direction: column;
                gap: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="header">
            <h1>{{ $invoice->company->name }}</h1>
            <p>فاتورة رقم {{ $invoice->invoice_number }}</p>
        </div>
        
        <!-- Content -->
        <div class="content">
            <!-- Greeting -->
            <h2 style="color: #212529; margin-bottom: 20px;">
                @if($invoice->customer)
                    مرحباً {{ $invoice->customer->name }}،
                @else
                    مرحباً عزيزي العميل،
                @endif
            </h2>
            
            <p style="color: #6c757d; line-height: 1.6; margin-bottom: 25px;">
                نتشرف بإرسال فاتورتكم الضريبية. نرجو مراجعة التفاصيل أدناه والتأكد من صحة البيانات.
            </p>
            
            <!-- Invoice Information -->
            <div class="invoice-info">
                <h3>تفاصيل الفاتورة</h3>
                
                <div class="info-row">
                    <span class="info-label">رقم الفاتورة:</span>
                    <span class="info-value">{{ $invoice->invoice_number }}</span>
                </div>
                
                <div class="info-row">
                    <span class="info-label">نوع الفاتورة:</span>
                    <span class="info-value">
                        @if($invoice->type == 'standard')
                            فاتورة ضريبية معيارية (B2B)
                        @else
                            فاتورة ضريبية مبسطة (B2C)
                        @endif
                    </span>
                </div>
                
                <div class="info-row">
                    <span class="info-label">تاريخ الإصدار:</span>
                    <span class="info-value">{{ $invoice->issue_date->format('Y-m-d') }}</span>
                </div>
                
                @if($invoice->due_date)
                <div class="info-row">
                    <span class="info-label">تاريخ الاستحقاق:</span>
                    <span class="info-value">{{ $invoice->due_date->format('Y-m-d') }}</span>
                </div>
                @endif
                
                <div class="info-row">
                    <span class="info-label">عدد البنود:</span>
                    <span class="info-value">{{ $invoice->items->count() }} بند</span>
                </div>
            </div>
            
            <!-- Amount Highlight -->
            <div class="amount-highlight">
                المبلغ الإجمالي: {{ number_format($invoice->total_amount, 2) }} ر.س
                <br>
                <small style="opacity: 0.9; font-size: 14px;">شامل ضريبة القيمة المضافة</small>
            </div>
            
            <!-- Payment Information -->
            @if($invoice->paid_amount > 0 || $invoice->payment_method)
            <div class="payment-info">
                <h4 style="margin: 0 0 15px 0; color: #856404;">معلومات السداد</h4>
                
                @if($invoice->payment_method)
                <div class="info-row">
                    <span class="info-label">طريقة السداد:</span>
                    <span class="info-value">{{ $invoice->getPaymentMethodText() }}</span>
                </div>
                @endif
                
                @if($invoice->paid_amount > 0)
                <div class="info-row">
                    <span class="info-label">المبلغ المدفوع:</span>
                    <span class="info-value">{{ number_format($invoice->paid_amount, 2) }} ر.س</span>
                </div>
                
                <div class="info-row">
                    <span class="info-label">المبلغ المتبقي:</span>
                    <span class="info-value">{{ number_format($invoice->remaining_amount, 2) }} ر.س</span>
                </div>
                @endif
                
                <div style="margin-top: 15px;">
                    <span class="info-label">حالة السداد:</span>
                    <span class="payment-status status-{{ $invoice->payment_status }}">
                        {{ $invoice->getPaymentStatusText() }}
                    </span>
                </div>
                
                @if($invoice->payment_date)
                <div class="info-row" style="margin-top: 10px;">
                    <span class="info-label">تاريخ السداد:</span>
                    <span class="info-value">{{ $invoice->payment_date->format('Y-m-d H:i') }}</span>
                </div>
                @endif
            </div>
            @endif
            
            <!-- QR Code Section -->
            @if($invoice->qr_code)
            <div class="qr-section">
                <h4 style="margin: 0 0 15px 0; color: #495057;">رمز التحقق</h4>
                <img src="{{ $invoice->getQrCodeDataUrl() }}" alt="QR Code للتحقق من الفاتورة" class="qr-code">
                <p style="margin: 10px 0 0 0; font-size: 12px; color: #6c757d;">
                    امسح الرمز للتحقق من صحة الفاتورة
                </p>
            </div>
            @endif
            
            <!-- Call to Action -->
            <div class="cta-section">
                <p style="color: #495057; margin-bottom: 20px;">
                    يمكنكم تحميل نسخة PDF من الفاتورة أو التحقق من صحتها من خلال الروابط أدناه:
                </p>
                
                <a href="{{ route('invoices.pdf', $invoice) }}" class="btn">
                    📄 تحميل PDF
                </a>
                
                @if($invoice->uuid)
                <a href="{{ route('invoices.verify', $invoice->uuid) }}" class="btn btn-secondary">
                    🔍 التحقق من الفاتورة
                </a>
                @endif
            </div>
            
            <!-- Contact Information -->
            <div style="background: #f8f9fa; padding: 20px; border-radius: 10px; margin-top: 30px;">
                <h4 style="margin: 0 0 15px 0; color: #495057;">تواصل معنا</h4>
                <p style="margin: 0; color: #6c757d; line-height: 1.6;">
                    في حالة وجود أي استفسارات حول هذه الفاتورة، يرجى التواصل معنا:
                    <br>
                    @if($invoice->company->phone)
                        📞 {{ $invoice->company->phone }}
                        <br>
                    @endif
                    @if($invoice->company->email)
                        ✉️ {{ $invoice->company->email }}
                        <br>
                    @endif
                    📍 {{ $invoice->company->getFullAddressAttribute() }}
                </p>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <div class="company-info">
                <strong>{{ $invoice->company->name }}</strong>
                <br>
                الرقم الضريبي: {{ $invoice->company->vat_number }}
                @if($invoice->company->cr_number)
                    <br>رقم السجل التجاري: {{ $invoice->company->cr_number }}
                @endif
                <br>
                {{ $invoice->company->getFullAddressAttribute() }}
            </div>
            
            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #dee2e6;">
                <p style="margin: 0; font-size: 12px; color: #adb5bd;">
                    هذه رسالة آلية، يرجى عدم الرد عليها مباشرة.
                    <br>
                    تم إنشاء هذه الفاتورة باستخدام نظام المبيعات المتوافق مع هيئة الزكاة والضريبة والجمارك.
                </p>
            </div>
        </div>
    </div>
</body>
</html>