<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تنبيه: فاتورة عالية المخاطر</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            direction: rtl;
            text-align: right;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 300;
        }
        .alert-badge {
            background-color: rgba(255,255,255,0.2);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
        }
        .content {
            padding: 30px;
        }
        .danger-alert {
            background-color: #f8d7da;
            border: 2px solid #dc3545;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
            text-align: center;
        }
        .danger-alert h3 {
            color: #721c24;
            margin: 0 0 10px 0;
            font-size: 20px;
        }
        .danger-alert p {
            color: #721c24;
            margin: 0;
            font-weight: bold;
        }
        .invoice-details {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .invoice-details h3 {
            color: #495057;
            margin-top: 0;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 10px;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin: 10px 0;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .label {
            font-weight: bold;
            color: #6c757d;
        }
        .value {
            color: #495057;
        }
        .amount {
            font-size: 20px;
            font-weight: bold;
            color: #dc3545;
        }
        .risk-factors {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .risk-factors h4 {
            color: #856404;
            margin-top: 0;
        }
        .risk-factor {
            background-color: white;
            border: 1px solid #ffeaa7;
            border-radius: 4px;
            padding: 10px;
            margin: 10px 0;
        }
        .risk-factor.critical {
            border-color: #dc3545;
            background-color: #fff5f5;
        }
        .actions-needed {
            background-color: #d1ecf1;
            border: 1px solid #b8daff;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .actions-needed h4 {
            color: #0c5460;
            margin-top: 0;
        }
        .action-item {
            background-color: white;
            border: 1px solid #b8daff;
            border-radius: 4px;
            padding: 10px;
            margin: 10px 0;
            display: flex;
            align-items: center;
        }
        .action-item .priority {
            background-color: #dc3545;
            color: white;
            font-size: 10px;
            padding: 2px 8px;
            border-radius: 10px;
            margin-left: 10px;
            font-weight: bold;
        }
        .action-item .priority.medium {
            background-color: #ffc107;
        }
        .action-item .priority.low {
            background-color: #28a745;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
        }
        .customer-info {
            background-color: #e9ecef;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="alert-badge">تنبيه عاجل</div>
            <h1>🚨 فاتورة عالية المخاطر</h1>
        </div>
        
        <div class="content">
            <div class="danger-alert">
                <h3>⚠️ تحتاج إلى اهتمام فوري</h3>
                <p>تم تصنيف الفاتورة التالية كعالية المخاطر وتتطلب تدخلاً عاجلاً</p>
            </div>
            
            <div class="invoice-details">
                <h3>📋 تفاصيل الفاتورة</h3>
                
                <div class="detail-row">
                    <span class="label">رقم الفاتورة:</span>
                    <span class="value">{{ $invoice->invoice_number }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">تاريخ الإصدار:</span>
                    <span class="value">{{ $invoice->issue_date->format('Y-m-d') }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">تاريخ الاستحقاق:</span>
                    <span class="value">{{ $invoice->due_date->format('Y-m-d') }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">أيام التأخير:</span>
                    <span class="value" style="color: #dc3545; font-weight: bold;">
                        {{ now()->diffInDays($invoice->due_date) }} يوم
                    </span>
                </div>
                
                <div class="detail-row">
                    <span class="label">المبلغ المتبقي:</span>
                    <span class="value amount">{{ number_format($invoice->remaining_amount, 2) }} ر.س</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">نسبة السداد:</span>
                    <span class="value">
                        {{ $invoice->total_amount > 0 ? round(($invoice->paid_amount / $invoice->total_amount) * 100, 1) : 0 }}%
                    </span>
                </div>
            </div>
            
            @if($invoice->customer)
            <div class="customer-info">
                <h4 style="margin-top: 0; color: #495057;">👤 معلومات العميل</h4>
                <p><strong>الاسم:</strong> {{ $invoice->customer->name }}</p>
                @if($invoice->customer->email)
                    <p><strong>البريد الإلكتروني:</strong> {{ $invoice->customer->email }}</p>
                @endif
                @if($invoice->customer->phone)
                    <p><strong>الهاتف:</strong> {{ $invoice->customer->phone }}</p>
                @endif
                @if($invoice->customer->vat_number)
                    <p><strong>الرقم الضريبي:</strong> {{ $invoice->customer->vat_number }}</p>
                @endif
            </div>
            @endif
            
            <div class="risk-factors">
                <h4>⚠️ عوامل المخاطر</h4>
                
                @php
                    $overdueDays = now()->diffInDays($invoice->due_date);
                @endphp
                
                @if($overdueDays > 90)
                    <div class="risk-factor critical">
                        <strong>تأخير حرج:</strong> الفاتورة متأخرة أكثر من 90 يوم
                    </div>
                @elseif($overdueDays > 60)
                    <div class="risk-factor">
                        <strong>تأخير كبير:</strong> الفاتورة متأخرة أكثر من 60 يوم
                    </div>
                @endif
                
                @if($invoice->remaining_amount > 10000)
                    <div class="risk-factor critical">
                        <strong>مبلغ كبير:</strong> المبلغ المتبقي يتجاوز 10,000 ر.س
                    </div>
                @endif
                
                @if($invoice->customer && $invoice->customer->invoices()->where('payment_status', '!=', 'paid')->count() > 3)
                    <div class="risk-factor">
                        <strong>تاريخ متكرر:</strong> العميل لديه عدة فواتير غير مدفوعة
                    </div>
                @endif
                
                @if(!$invoice->customer || !$invoice->customer->email)
                    <div class="risk-factor">
                        <strong>صعوبة التواصل:</strong> لا يوجد بريد إلكتروني للعميل
                    </div>
                @endif
            </div>
            
            <div class="actions-needed">
                <h4>📝 الإجراءات المطلوبة</h4>
                
                <div class="action-item">
                    <span class="priority">عاجل</span>
                    <span>الاتصال المباشر بالعميل خلال 24 ساعة</span>
                </div>
                
                <div class="action-item">
                    <span class="priority">عاجل</span>
                    <span>إرسال إشعار نهائي بالسداد</span>
                </div>
                
                <div class="action-item">
                    <span class="priority medium">متوسط</span>
                    <span>مراجعة شروط الدفع مع العميل</span>
                </div>
                
                <div class="action-item">
                    <span class="priority medium">متوسط</span>
                    <span>تقييم إمكانية الجدولة أو التقسيط</span>
                </div>
                
                @if($overdueDays > 120)
                <div class="action-item">
                    <span class="priority">عاجل</span>
                    <span>النظر في الإجراءات القانونية</span>
                </div>
                @endif
                
                <div class="action-item">
                    <span class="priority low">منخفض</span>
                    <span>توثيق جميع محاولات التواصل</span>
                </div>
            </div>
            
            <div style="background-color: #fff3cd; border: 1px solid #ffeaa7; border-radius: 6px; padding: 15px; margin: 20px 0;">
                <h4 style="color: #856404; margin-top: 0;">💡 اقتراحات للمتابعة</h4>
                <ul style="color: #856404; margin: 0; padding-right: 20px;">
                    <li>إجراء مكالمة هاتفية عاجلة</li>
                    <li>إرسال رسالة نصية تذكيرية</li>
                    <li>زيارة العميل شخصياً إذا أمكن</li>
                    <li>تقييم إمكانية تسوية جزئية</li>
                    <li>مراجعة سياسة الائتمان للعميل</li>
                </ul>
            </div>
            
            <div style="text-align: center; margin: 30px 0;">
                <p style="color: #dc3545; font-weight: bold; font-size: 16px;">
                    هذا الإشعار تم إرساله تلقائياً بناءً على معايير تقييم المخاطر
                </p>
                <p style="color: #6c757d;">
                    يرجى اتخاذ الإجراءات اللازمة في أقرب وقت ممكن
                </p>
            </div>
        </div>
        
        <div class="footer">
            <p><strong>نظام إدارة الفواتير</strong></p>
            <p>تم إرسال هذا التنبيه تلقائياً في: {{ now()->format('Y-m-d H:i:s') }}</p>
            <p style="color: #dc3545;">⚠️ هذا إشعار داخلي - لا تقم بإعادة توجيهه للعملاء</p>
        </div>
    </div>
</body>
</html>