@extends('layouts.app')

@section('title', 'لوحة التحكم الرئيسية')
@section('page-title', 'لوحة التحكم')

@section('page-actions')
<div class="d-flex gap-2">
    <a href="{{ route('invoices.create') }}" class="btn btn-primary btn-modern">
        <i class="fas fa-plus me-2"></i>
        فاتورة جديدة
    </a>
    <a href="{{ route('customers.create') }}" class="btn btn-outline-primary btn-modern">
        <i class="fas fa-user-plus me-2"></i>
        عميل جديد
    </a>
</div>
@endsection

@section('content')
<div class="modern-dashboard">
    
    

    <!-- Modern Hero Section -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="hero-section" data-aos="fade-up">
                <div class="hero-background"></div>
                <div class="hero-content">
                    <div class="container-fluid">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <div class="hero-text">
                                    <h1 class="hero-title">
                                        <span class="greeting">مرحباً</span>
                                        <span class="user-name">{{ auth()->user()->name }}</span>
                                    </h1>
                                    <p class="hero-subtitle">
                                        نظام المبيعات الإلكتروني المتوافق مع هيئة الزكاة والضريبة والجمارك
                                    </p>
                                    <div class="hero-badges">
                                        <span class="badge badge-modern badge-success">
                                            <i class="fas fa-shield-alt me-1"></i>
                                            متوافق مع ZATCA
                                        </span>
                                        <span class="badge badge-modern badge-info">
                                            <i class="fas fa-cloud me-1"></i>
                                            نظام سحابي
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="hero-stats">
                                    <div class="row g-3">
                                        <div class="col-6">
                                            <div class="quick-stat-modern">
                                                <div class="stat-icon bg-primary">
                                                    <i class="fas fa-chart-line"></i>
                                                </div>
                                                <div class="stat-info">
                                                    <h3 class="stat-number">{{ number_format($totalSales, 0) }}</h3>
                                                    <p class="stat-label">إجمالي المبيعات</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="quick-stat-modern">
                                                <div class="stat-icon bg-success">
                                                    <i class="fas fa-file-invoice"></i>
                                                </div>
                                                <div class="stat-info">
                                                    <h3 class="stat-number">{{ $invoicesCount }}</h3>
                                                    <p class="stat-label">إجمالي الفواتير</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="quick-stat-modern">
                                                <div class="stat-icon bg-info">
                                                    <i class="fas fa-users"></i>
                                                </div>
                                                <div class="stat-info">
                                                    <h3 class="stat-number">{{ $customersCount }}</h3>
                                                    <p class="stat-label">العملاء</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="quick-stat-modern">
                                                <div class="stat-icon bg-warning">
                                                    <i class="fas fa-boxes"></i>
                                                </div>
                                                <div class="stat-info">
                                                    <h3 class="stat-number">{{ $productsCount }}</h3>
                                                    <p class="stat-label">المنتجات</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="hero-decoration">
                    <div class="decoration-circle circle-1"></div>
                    <div class="decoration-circle circle-2"></div>
                    <div class="decoration-circle circle-3"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modern KPI Cards -->
    <div class="row g-4 mb-5">
        <div class="col-xl-3 col-lg-6 col-md-6">
            <div class="kpi-card kpi-primary" data-aos="fade-up" data-aos-delay="100">
                <div class="kpi-header">
                    <div class="kpi-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="kpi-trend trend-up">
                        <i class="fas fa-arrow-up"></i>
                        <span>{{ number_format($salesGrowthPercentage, 1) }}%</span>
                    </div>
                </div>
                <div class="kpi-body">
                    <h3 class="kpi-value">{{ number_format($currentMonthSales, 0) }} <span class="currency">ريال</span></h3>
                    <p class="kpi-label">مبيعات الشهر</p>
                </div>
                <div class="kpi-footer">
                    <div class="progress-modern">
                        <div class="progress-bar bg-primary" style="width: {{ min($salesGrowthPercentage, 100) }}%"></div>
                    </div>
                    <small class="text-muted">مقارنة بالشهر الماضي</small>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6">
            <div class="kpi-card kpi-success" data-aos="fade-up" data-aos-delay="200">
                <div class="kpi-header">
                    <div class="kpi-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="kpi-trend trend-up">
                        <i class="fas fa-arrow-up"></i>
                        <span>{{ number_format($customersGrowthPercentage, 1) }}%</span>
                    </div>
                </div>
                <div class="kpi-body">
                    <h3 class="kpi-value">{{ $newCustomersThisMonth }}</h3>
                    <p class="kpi-label">عملاء جدد</p>
                </div>
                <div class="kpi-footer">
                    <div class="progress-modern">
                        <div class="progress-bar bg-success" style="width: {{ min($customersGrowthPercentage, 100) }}%"></div>
                    </div>
                    <small class="text-muted">في الشهر الحالي</small>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6">
            <div class="kpi-card kpi-info" data-aos="fade-up" data-aos-delay="300">
                <div class="kpi-header">
                    <div class="kpi-icon">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <div class="kpi-trend trend-up">
                        <i class="fas fa-arrow-up"></i>
                        <span>{{ number_format($ordersGrowthPercentage, 1) }}%</span>
                    </div>
                </div>
                <div class="kpi-body">
                    <h3 class="kpi-value">{{ $ordersThisMonth }}</h3>
                    <p class="kpi-label">طلبات الشهر</p>
                </div>
                <div class="kpi-footer">
                    <div class="progress-modern">
                        <div class="progress-bar bg-info" style="width: {{ min($ordersGrowthPercentage, 100) }}%"></div>
                    </div>
                    <small class="text-muted">مقارنة بالشهر الماضي</small>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6">
            <div class="kpi-card kpi-warning" data-aos="fade-up" data-aos-delay="400">
                <div class="kpi-header">
                    <div class="kpi-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="kpi-info-badge">AOV</div>
                </div>
                <div class="kpi-body">
                    <h3 class="kpi-value">{{ number_format($averageOrderValue, 0) }} <span class="currency">ريال</span></h3>
                    <p class="kpi-label">متوسط قيمة الطلب</p>
                </div>
                <div class="kpi-footer">
                    <div class="progress-modern">
                        <div class="progress-bar bg-warning" style="width: 75%"></div>
                    </div>
                    <small class="text-muted">للطلبات المكتملة</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts and Analytics Section -->
    <div class="row g-4 mb-5">
        <!-- Sales Chart -->
        <div class="col-xl-8">
            <div class="chart-card-modern" data-aos="fade-up" data-aos-delay="500">
                <div class="card-header-modern">
                    <div class="header-content">
                        <h5 class="card-title-modern">
                            <i class="fas fa-chart-line me-2 text-primary"></i>
                            تطور المبيعات
                        </h5>
                        <p class="card-subtitle-modern">تحليل مبيعات آخر 6 أشهر</p>
                    </div>
                    <div class="header-actions">
                        <div class="btn-group btn-group-modern" role="group">
                            <button type="button" class="btn btn-sm btn-outline-primary active" data-period="6months">6 أشهر</button>
                            <button type="button" class="btn btn-sm btn-outline-primary" data-period="year">سنة</button>
                        </div>
                        <button class="btn btn-sm btn-icon-modern" onclick="refreshChart()">
                            <i class="fas fa-sync-alt"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body-modern">
                    <div class="chart-container">
                        <canvas id="salesChart" height="350"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Status -->
        <div class="col-xl-4">
            <div class="row g-4">
                <!-- ZATCA Status -->
                <div class="col-12">
                    <div class="status-card-modern" data-aos="fade-up" data-aos-delay="600">
                        <div class="card-header-modern">
                            <h6 class="card-title-modern">
                                <i class="fas fa-shield-alt me-2"></i>
                                حالة نظام ZATCA
                            </h6>
                        </div>
                        <div class="card-body-modern">
                            <div class="zatca-status-modern">
                                @if($zatcaStatus)
                                <div class="status-indicator status-success">
                                    <div class="status-icon">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                    <div class="status-content">
                                        <h6 class="status-title">متصل وجاهز</h6>
                                        <p class="status-text">البيئة: {{ ucfirst($zatcaEnvironment) }}</p>
                                        @if($lastConnectionTest)
                                        <small class="status-time">آخر اختبار: {{ $lastConnectionTest }}</small>
                                        @endif
                                    </div>
                                </div>
                                @else
                                <div class="status-indicator status-warning">
                                    <div class="status-icon">
                                        <i class="fas fa-exclamation-triangle"></i>
                                    </div>
                                    <div class="status-content">
                                        <h6 class="status-title">غير مُعد</h6>
                                        <p class="status-text">يرجى إعداد الاتصال مع ZATCA</p>
                                    </div>
                                </div>
                                @endif
                                <div class="status-actions">
                                    <a href="{{ route('zatca-settings.index') }}" class="btn btn-modern btn-primary btn-sm">
                                        <i class="fas fa-cog me-1"></i>
                                        إدارة الإعدادات
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Performance Metrics -->
                <div class="col-12">
                    <div class="metrics-card-modern" data-aos="fade-up" data-aos-delay="700">
                        <div class="card-header-modern">
                            <h6 class="card-title-modern">
                                <i class="fas fa-tachometer-alt me-2"></i>
                                مؤشرات الأداء
                            </h6>
                        </div>
                        <div class="card-body-modern">
                            <div class="metrics-grid">
                                <div class="metric-item-modern">
                                    <div class="metric-icon bg-primary">
                                        <i class="fas fa-percentage"></i>
                                    </div>
                                    <div class="metric-content">
                                        <h6 class="metric-value">{{ $kpis['conversion_rate'] }}%</h6>
                                        <p class="metric-label">معدل التحويل</p>
                                    </div>
                                </div>
                                <div class="metric-item-modern">
                                    <div class="metric-icon bg-success">
                                        <i class="fas fa-undo"></i>
                                    </div>
                                    <div class="metric-content">
                                        <h6 class="metric-value">{{ $kpis['return_rate'] }}%</h6>
                                        <p class="metric-label">معدل الإرجاع</p>
                                    </div>
                                </div>
                                <div class="metric-item-modern">
                                    <div class="metric-icon bg-warning">
                                        <i class="fas fa-star"></i>
                                    </div>
                                    <div class="metric-content">
                                        <h6 class="metric-value">{{ $kpis['customer_satisfaction'] }}/5</h6>
                                        <p class="metric-label">رضا العملاء</p>
                                    </div>
                                </div>
                                <div class="metric-item-modern">
                                    <div class="metric-icon bg-info">
                                        <i class="fas fa-coins"></i>
                                    </div>
                                    <div class="metric-content">
                                        <h6 class="metric-value">{{ number_format($kpis['avg_order_value'], 0) }}</h6>
                                        <p class="metric-label">متوسط الطلب</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Data Tables Section -->
    <div class="row g-4">
        <!-- Recent Invoices -->
        <div class="col-xl-8">
            <div class="table-card-modern" data-aos="fade-up" data-aos-delay="800">
                <div class="card-header-modern">
                    <div class="header-content">
                        <h5 class="card-title-modern">
                            <i class="fas fa-file-invoice me-2 text-primary"></i>
                            آخر الفواتير
                        </h5>
                        <p class="card-subtitle-modern">أحدث العمليات في النظام</p>
                    </div>
                    <div class="header-actions">
                        <a href="{{ route('invoices.index') }}" class="btn btn-modern btn-outline-primary btn-sm">
                            عرض الكل
                            <i class="fas fa-arrow-left ms-1"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body-modern p-0">
                    <div class="table-responsive">
                        <table class="table table-modern">
                            <thead>
                                <tr>
                                    <th>رقم الفاتورة</th>
                                    <th>العميل</th>
                                    <th>المبلغ</th>
                                    <th>الحالة</th>
                                    <th>التاريخ</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($recentInvoices as $invoice)
                                <tr class="table-row-modern">
                                    <td>
                                        <div class="invoice-number">
                                            <span class="number">{{ $invoice['invoice_number'] }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="customer-info">
                                            <span class="name">{{ $invoice['customer_name'] }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="amount">
                                            <span class="value">{{ number_format($invoice['total_amount'], 2) }}</span>
                                            <span class="currency">ريال</span>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="status-badge status-{{ $invoice['status'] === 'cleared' ? 'success' : ($invoice['status'] === 'pending' ? 'warning' : 'secondary') }}">
                                            {{ $invoice['status_label'] }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="date">{{ $invoice['created_at'] }}</span>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="{{ route('invoices.show', $invoice['id']) }}" class="btn btn-action btn-primary" title="عرض">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6">
                                        <div class="empty-state">
                                            <i class="fas fa-file-invoice fa-3x text-muted mb-3"></i>
                                            <p class="text-muted mb-0">لا توجد فواتير بعد</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Invoice Summary -->
        <div class="col-xl-4">
            <div class="summary-card-modern" data-aos="fade-up" data-aos-delay="900">
                <div class="card-header-modern">
                    <h6 class="card-title-modern">
                        <i class="fas fa-chart-pie me-2"></i>
                        ملخص الفواتير
                    </h6>
                </div>
                <div class="card-body-modern">
                    <div class="summary-grid">
                        <div class="summary-item-modern item-primary">
                            <div class="summary-icon">
                                <i class="fas fa-file-invoice"></i>
                            </div>
                            <div class="summary-content">
                                <h6 class="summary-number">{{ $standardInvoicesCount }}</h6>
                                <p class="summary-label">فواتير قياسية</p>
                            </div>
                            <div class="summary-trend">
                                <i class="fas fa-arrow-up"></i>
                            </div>
                        </div>
                        
                        <div class="summary-item-modern item-info">
                            <div class="summary-icon">
                                <i class="fas fa-receipt"></i>
                            </div>
                            <div class="summary-content">
                                <h6 class="summary-number">{{ $simplifiedInvoicesCount }}</h6>
                                <p class="summary-label">فواتير مبسطة</p>
                            </div>
                            <div class="summary-trend">
                                <i class="fas fa-arrow-up"></i>
                            </div>
                        </div>
                        
                        <div class="summary-item-modern item-success">
                            <div class="summary-icon">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="summary-content">
                                <h6 class="summary-number">{{ $clearedInvoicesCount }}</h6>
                                <p class="summary-label">فواتير مكتملة</p>
                            </div>
                            <div class="summary-trend">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                        
                        <div class="summary-item-modern item-warning">
                            <div class="summary-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="summary-content">
                                <h6 class="summary-number">{{ $pendingInvoicesCount }}</h6>
                                <p class="summary-label">مسودات</p>
                            </div>
                            <div class="summary-trend">
                                <i class="fas fa-edit"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<style>
/* ========== Modern Dashboard Styles ========== */
.modern-dashboard {
    padding: 0;
}

/* Modern Button Styles */
.btn-modern {
    border-radius: 12px;
    padding: 0.75rem 1.5rem;
    font-weight: 600;
    font-size: 0.9rem;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    border: none;
    position: relative;
    overflow: hidden;
}

.btn-modern::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.btn-modern:hover::before {
    left: 100%;
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
}

/* Modern Alert Styles */
.alert-modern {
    border-radius: 16px;
    border: none;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    backdrop-filter: blur(10px);
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.25rem 1.5rem;
    margin-bottom: 1rem;
    position: relative;
    overflow: hidden;
}

.alert-modern::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 4px;
}

.alert-modern.alert-success::before { background: var(--success-500); }
.alert-modern.alert-warning::before { background: var(--warning-500); }
.alert-modern.alert-danger::before { background: var(--danger-500); }
.alert-modern.alert-info::before { background: var(--primary-500); }

.alert-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    font-size: 1.1rem;
    flex-shrink: 0;
}

.alert-success .alert-icon { background: var(--success-50); color: var(--success-600); }
.alert-warning .alert-icon { background: var(--warning-50); color: var(--warning-600); }
.alert-danger .alert-icon { background: var(--danger-50); color: var(--danger-600); }
.alert-info .alert-icon { background: rgba(59, 130, 246, 0.1); color: var(--primary-600); }

.alert-content {
    flex: 1;
}

.alert-title {
    font-weight: 600;
    font-size: 0.95rem;
    margin-bottom: 0.25rem;
}

.alert-message {
    font-size: 0.9rem;
    margin: 0;
    opacity: 0.9;
}

.btn-close-modern {
    background: none;
    border: none;
    font-size: 0.9rem;
    opacity: 0.6;
    transition: opacity 0.2s;
}

.btn-close-modern:hover {
    opacity: 1;
}

/* Hero Section */
.hero-section {
    background: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-700) 100%);
    border-radius: 24px;
    padding: 3rem 2rem;
    color: white;
    position: relative;
    overflow: hidden;
    margin-bottom: 0;
}

.hero-background {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
    opacity: 0.3;
}

.hero-content {
    position: relative;
    z-index: 2;
}

.hero-title {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 1rem;
    line-height: 1.2;
}

.greeting {
    display: block;
    font-size: 1.2rem;
    font-weight: 400;
    opacity: 0.9;
    margin-bottom: 0.25rem;
}

.user-name {
    background: linear-gradient(45deg, #ffffff, #e0f2fe);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.hero-subtitle {
    font-size: 1.1rem;
    opacity: 0.9;
    margin-bottom: 1.5rem;
    line-height: 1.6;
}

.hero-badges {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 50px;
    font-weight: 500;
    font-size: 0.85rem;
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
}

.badge-success {
    background: rgba(34, 197, 94, 0.2);
    color: #dcfce7;
}

.badge-info {
    background: rgba(59, 130, 246, 0.2);
    color: #dbeafe;
}

.hero-stats {
    padding: 1rem;
}

.quick-stat-modern {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border-radius: 16px;
    padding: 1.25rem;
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.quick-stat-modern:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateY(-2px);
}

.stat-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.1rem;
    color: white;
    flex-shrink: 0;
}

.stat-info {
    flex: 1;
    min-width: 0;
}

.stat-number {
    font-size: 1.4rem;
    font-weight: 700;
    margin: 0;
    line-height: 1.2;
}

.stat-label {
    font-size: 0.8rem;
    opacity: 0.8;
    margin: 0;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.hero-decoration {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    pointer-events: none;
    overflow: hidden;
}

.decoration-circle {
    position: absolute;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
    animation: float 6s ease-in-out infinite;
}

.circle-1 {
    width: 80px;
    height: 80px;
    top: 20%;
    left: 10%;
    animation-delay: 0s;
}

.circle-2 {
    width: 120px;
    height: 120px;
    top: 60%;
    right: 15%;
    animation-delay: 2s;
}

.circle-3 {
    width: 60px;
    height: 60px;
    bottom: 30%;
    left: 70%;
    animation-delay: 4s;
}

@keyframes float {
    0%, 100% { transform: translateY(0px) rotate(0deg); }
    33% { transform: translateY(-15px) rotate(120deg); }
    66% { transform: translateY(-8px) rotate(240deg); }
}

/* Modern KPI Cards */
.kpi-card {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
    border: 1px solid rgba(0, 0, 0, 0.05);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.kpi-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    transition: all 0.3s ease;
}

.kpi-primary::before { background: linear-gradient(90deg, var(--primary-500), var(--primary-600)); }
.kpi-success::before { background: linear-gradient(90deg, var(--success-500), var(--success-600)); }
.kpi-info::before { background: linear-gradient(90deg, #06b6d4, #0891b2); }
.kpi-warning::before { background: linear-gradient(90deg, var(--warning-500), var(--warning-600)); }

.kpi-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 20px 48px rgba(0, 0, 0, 0.15);
}

.kpi-card:hover::before {
    height: 6px;
}

.kpi-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 1rem;
}

.kpi-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.3rem;
    color: white;
}

.kpi-primary .kpi-icon { background: linear-gradient(135deg, var(--primary-500), var(--primary-600)); }
.kpi-success .kpi-icon { background: linear-gradient(135deg, var(--success-500), var(--success-600)); }
.kpi-info .kpi-icon { background: linear-gradient(135deg, #06b6d4, #0891b2); }
.kpi-warning .kpi-icon { background: linear-gradient(135deg, var(--warning-500), var(--warning-600)); }

.kpi-trend {
    display: flex;
    align-items: center;
    gap: 0.25rem;
    padding: 0.25rem 0.5rem;
    border-radius: 50px;
    font-size: 0.8rem;
    font-weight: 600;
}

.trend-up {
    background: rgba(34, 197, 94, 0.1);
    color: var(--success-600);
}

.kpi-info-badge {
    background: rgba(6, 182, 212, 0.1);
    color: #0891b2;
    padding: 0.25rem 0.5rem;
    border-radius: 50px;
    font-size: 0.75rem;
    font-weight: 600;
}

.kpi-body {
    margin-bottom: 1.5rem;
}

.kpi-value {
    font-size: 2rem;
    font-weight: 700;
    margin: 0 0 0.25rem 0;
    line-height: 1.1;
    color: var(--gray-900);
}

.currency {
    font-size: 1.2rem;
    font-weight: 500;
    color: var(--gray-600);
}

.kpi-label {
    color: var(--gray-600);
    font-size: 0.9rem;
    font-weight: 500;
    margin: 0;
}

.kpi-footer {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.progress-modern {
    height: 6px;
    background: var(--gray-200);
    border-radius: 3px;
    overflow: hidden;
}

.progress-bar {
    height: 100%;
    border-radius: 3px;
    transition: width 1s ease-in-out;
}

/* Chart and Modern Cards */
.chart-card-modern, .status-card-modern, .metrics-card-modern, .table-card-modern, .summary-card-modern {
    background: white;
    border-radius: 20px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
    border: 1px solid rgba(0, 0, 0, 0.05);
    overflow: hidden;
}

.card-header-modern {
    padding: 1.5rem 1.5rem 0;
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    gap: 1rem;
}

.header-content {
    flex: 1;
}

.card-title-modern {
    font-size: 1.25rem;
    font-weight: 700;
    margin: 0 0 0.25rem 0;
    color: var(--gray-900);
    display: flex;
    align-items: center;
}

.card-subtitle-modern {
    color: var(--gray-600);
    font-size: 0.9rem;
    margin: 0;
}

.header-actions {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.btn-group-modern {
    background: var(--gray-100);
    border-radius: 10px;
    padding: 0.25rem;
}

.btn-group-modern .btn {
    border: none;
    background: transparent;
    color: var(--gray-600);
    font-size: 0.8rem;
    padding: 0.5rem 1rem;
    border-radius: 8px;
    transition: all 0.2s ease;
}

.btn-group-modern .btn.active,
.btn-group-modern .btn:hover {
    background: white;
    color: var(--primary-600);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.btn-icon-modern {
    width: 36px;
    height: 36px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: var(--gray-100);
    border: none;
    color: var(--gray-600);
    transition: all 0.2s ease;
}

.btn-icon-modern:hover {
    background: var(--primary-100);
    color: var(--primary-600);
}

.card-body-modern {
    padding: 1.5rem;
}

.chart-container {
    position: relative;
    height: 350px;
}

/* Status Components */
.zatca-status-modern {
    text-align: center;
}

.status-indicator {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    border-radius: 12px;
    margin-bottom: 1rem;
}

.status-success {
    background: linear-gradient(135deg, rgba(34, 197, 94, 0.1), rgba(34, 197, 94, 0.05));
    border: 1px solid rgba(34, 197, 94, 0.2);
}

.status-warning {
    background: linear-gradient(135deg, rgba(245, 158, 11, 0.1), rgba(245, 158, 11, 0.05));
    border: 1px solid rgba(245, 158, 11, 0.2);
}

.status-icon {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    flex-shrink: 0;
}

.status-success .status-icon {
    background: var(--success-500);
    color: white;
}

.status-warning .status-icon {
    background: var(--warning-500);
    color: white;
}

.status-content {
    flex: 1;
    text-align: right;
}

.status-title {
    font-weight: 600;
    font-size: 1rem;
    margin: 0 0 0.25rem 0;
}

.status-success .status-title { color: var(--success-600); }
.status-warning .status-title { color: var(--warning-600); }

.status-text {
    font-size: 0.9rem;
    color: var(--gray-600);
    margin: 0;
}

.status-time {
    font-size: 0.8rem;
    color: var(--gray-500);
}

.status-actions {
    margin-top: 1rem;
}

/* Metrics Grid */
.metrics-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.metric-item-modern {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem;
    background: var(--gray-50);
    border-radius: 12px;
    transition: all 0.3s ease;
}

.metric-item-modern:hover {
    background: var(--gray-100);
    transform: translateY(-2px);
}

.metric-icon {
    width: 36px;
    height: 36px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.9rem;
    flex-shrink: 0;
}

.metric-content {
    flex: 1;
    min-width: 0;
}

.metric-value {
    font-size: 1.1rem;
    font-weight: 700;
    margin: 0 0 0.25rem 0;
    color: var(--gray-900);
}

.metric-label {
    font-size: 0.8rem;
    color: var(--gray-600);
    margin: 0;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* Modern Table */
.table-modern {
    margin: 0;
}

.table-modern thead th {
    background: var(--gray-50);
    border: none;
    font-weight: 600;
    color: var(--gray-700);
    font-size: 0.9rem;
    padding: 1rem 1.5rem;
    white-space: nowrap;
}

.table-row-modern {
    transition: all 0.2s ease;
}

.table-row-modern:hover {
    background: var(--gray-50);
}

.table-row-modern td {
    padding: 1rem 1.5rem;
    border: none;
    vertical-align: middle;
}

.invoice-number .number {
    font-weight: 600;
    color: var(--primary-600);
}

.customer-info .name {
    font-weight: 500;
    color: var(--gray-800);
}

.amount .value {
    font-weight: 700;
    color: var(--gray-900);
}

.amount .currency {
    font-size: 0.9rem;
    color: var(--gray-600);
    margin-left: 0.25rem;
}

.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 50px;
    font-size: 0.8rem;
    font-weight: 600;
    border: none;
}

.status-success {
    background: var(--success-50);
    color: var(--success-600);
}

.status-warning {
    background: var(--warning-50);
    color: var(--warning-600);
}

.status-secondary {
    background: var(--gray-100);
    color: var(--gray-600);
}

.date {
    color: var(--gray-600);
    font-size: 0.9rem;
}

.btn-action {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: none;
    font-size: 0.8rem;
    transition: all 0.2s ease;
}

.btn-action.btn-primary {
    background: var(--primary-100);
    color: var(--primary-600);
}

.btn-action:hover {
    transform: scale(1.1);
}

.empty-state {
    text-align: center;
    padding: 3rem;
}

/* Summary Grid */
.summary-grid {
    display: grid;
    gap: 1rem;
}

.summary-item-modern {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.25rem;
    background: var(--gray-50);
    border-radius: 16px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.summary-item-modern::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 4px;
    transition: width 0.3s ease;
}

.item-primary::before { background: var(--primary-500); }
.item-info::before { background: #06b6d4; }
.item-success::before { background: var(--success-500); }
.item-warning::before { background: var(--warning-500); }

.summary-item-modern:hover {
    background: white;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
    transform: translateX(-4px);
}

.summary-item-modern:hover::before {
    width: 8px;
}

.summary-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    flex-shrink: 0;
}

.item-primary .summary-icon {
    background: var(--primary-100);
    color: var(--primary-600);
}

.item-info .summary-icon {
    background: rgba(6, 182, 212, 0.1);
    color: #0891b2;
}

.item-success .summary-icon {
    background: var(--success-100);
    color: var(--success-600);
}

.item-warning .summary-icon {
    background: var(--warning-100);
    color: var(--warning-600);
}

.summary-content {
    flex: 1;
}

.summary-number {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0 0 0.25rem 0;
    color: var(--gray-900);
}

.summary-label {
    color: var(--gray-600);
    font-size: 0.9rem;
    margin: 0;
}

.summary-trend {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.8rem;
    background: rgba(34, 197, 94, 0.1);
    color: var(--success-600);
}

/* Responsive Design */
@media (max-width: 768px) {
    .hero-section {
        padding: 2rem 1rem;
    }
    
    .hero-title {
        font-size: 2rem;
    }
    
    .hero-decoration {
        display: none;
    }
    
    .kpi-card {
        padding: 1.25rem;
    }
    
    .kpi-value {
        font-size: 1.5rem;
    }
    
    .metrics-grid {
        grid-template-columns: 1fr;
    }
    
    .card-header-modern {
        flex-direction: column;
        align-items: stretch;
        gap: 1rem;
    }
    
    .header-actions {
        justify-content: space-between;
    }
    
    .table-responsive {
        font-size: 0.9rem;
    }
    
    .quick-stat-modern {
        padding: 1rem;
    }
    
    .stat-number {
        font-size: 1.2rem;
    }
}

/* Animation Classes */
.fade-in-up {
    animation: fadeInUp 0.6s ease-out forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize AOS
    AOS.init({
        duration: 800,
        easing: 'ease-out',
        once: true,
        offset: 100
    });

    // Sales Chart Data
    const monthlyLabels = @json($monthlyLabels);
    const monthlyRevenue = @json($monthlyRevenue);
    
    // Enhanced Chart Configuration
    const ctx = document.getElementById('salesChart').getContext('2d');
    const gradient = ctx.createLinearGradient(0, 0, 0, 300);
    gradient.addColorStop(0, 'rgba(59, 130, 246, 0.2)');
    gradient.addColorStop(1, 'rgba(59, 130, 246, 0.02)');

    const salesChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: monthlyLabels,
            datasets: [{
                label: 'المبيعات (ريال)',
                data: monthlyRevenue,
                borderColor: 'rgb(59, 130, 246)',
                backgroundColor: gradient,
                borderWidth: 3,
                fill: true,
                tension: 0.4,
                pointBackgroundColor: 'rgb(59, 130, 246)',
                pointBorderColor: '#ffffff',
                pointBorderWidth: 3,
                pointRadius: 6,
                pointHoverRadius: 8,
                pointHoverBorderWidth: 3
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(17, 24, 39, 0.95)',
                    titleColor: '#ffffff',
                    bodyColor: '#ffffff',
                    borderColor: 'rgb(59, 130, 246)',
                    borderWidth: 1,
                    cornerRadius: 8,
                    displayColors: false,
                    callbacks: {
                        label: function(context) {
                            return new Intl.NumberFormat('ar-SA', {
                                style: 'currency',
                                currency: 'SAR',
                                minimumFractionDigits: 0
                            }).format(context.parsed.y);
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    border: {
                        display: false
                    },
                    grid: {
                        color: 'rgba(107, 114, 128, 0.1)',
                        drawBorder: false
                    },
                    ticks: {
                        color: 'rgb(107, 114, 128)',
                        font: {
                            size: 12,
                            weight: '500'
                        },
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA', {
                                style: 'currency',
                                currency: 'SAR',
                                minimumFractionDigits: 0,
                                notation: 'compact'
                            }).format(value);
                        }
                    }
                },
                x: {
                    border: {
                        display: false
                    },
                    grid: {
                        display: false
                    },
                    ticks: {
                        color: 'rgb(107, 114, 128)',
                        font: {
                            size: 12,
                            weight: '500'
                        }
                    }
                }
            },
            interaction: {
                intersect: false,
                mode: 'index'
            },
            hover: {
                animationDuration: 200
            },
            animation: {
                duration: 1000,
                easing: 'easeOutCubic'
            }
        }
    });
    
    // Chart refresh functionality
    window.refreshChart = function() {
        salesChart.update('active');
    };

    // Period selector functionality
    document.querySelectorAll('[data-period]').forEach(btn => {
        btn.addEventListener('click', function() {
            document.querySelectorAll('[data-period]').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            // Here you would typically fetch new data
            console.log('Period changed to:', this.dataset.period);
        });
    });

    // Counter animation for KPI cards
    function animateCounters() {
        const counters = document.querySelectorAll('.kpi-value, .stat-number, .summary-number');
        
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const counter = entry.target;
                    const target = parseInt(counter.textContent.replace(/[^0-9]/g, ''));
                    const duration = 1000;
                    const step = target / (duration / 16);
                    let current = 0;
                    
                    const timer = setInterval(() => {
                        current += step;
                        if (current >= target) {
                            counter.textContent = counter.textContent.replace(/[0-9,]+/, target.toLocaleString('ar-SA'));
                            clearInterval(timer);
                        } else {
                            counter.textContent = counter.textContent.replace(/[0-9,]+/, Math.floor(current).toLocaleString('ar-SA'));
                        }
                    }, 16);
                    
                    observer.unobserve(counter);
                }
            });
        });
        
        counters.forEach(counter => observer.observe(counter));
    }

    // Initialize counter animation
    setTimeout(animateCounters, 500);

    // Progress bar animation
    function animateProgressBars() {
        const progressBars = document.querySelectorAll('.progress-bar');
        
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const bar = entry.target;
                    const width = bar.style.width;
                    bar.style.width = '0%';
                    setTimeout(() => {
                        bar.style.width = width;
                    }, 200);
                    observer.unobserve(bar);
                }
            });
        });
        
        progressBars.forEach(bar => observer.observe(bar));
    }

    // Initialize progress bar animation
    setTimeout(animateProgressBars, 800);

    // Enhanced hover effects for cards
    const cards = document.querySelectorAll('.kpi-card, .chart-card-modern, .status-card-modern, .metrics-card-modern, .table-card-modern, .summary-card-modern');
    cards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-4px)';
        });
        
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
        });
    });

    // Auto refresh data every 5 minutes
    setInterval(() => {
        console.log('Auto-refreshing dashboard data...');
        // Here you would typically make an AJAX call to refresh the data
    }, 300000);

    // Smooth scroll for internal links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            document.querySelector(this.getAttribute('href')).scrollIntoView({
                behavior: 'smooth'
            });
        });
    });

    // Loading animation for buttons
    document.querySelectorAll('.btn-modern').forEach(btn => {
        btn.addEventListener('click', function(e) {
            if (!this.classList.contains('loading')) {
                this.classList.add('loading');
                setTimeout(() => this.classList.remove('loading'), 1000);
            }
        });
    });
});
</script>
@endpush