@extends('layouts.app')

@section('title', 'إضافة عميل جديد')
@section('page-title', 'إضافة عميل جديد')

@section('page-actions')
<div class="btn-group shadow-sm">
    <a href="{{ route('customers.index') }}" class="btn btn-outline-secondary btn-custom">
        <i class="fas fa-arrow-left me-2"></i>
        العودة للقائمة
    </a>
    <button type="button" class="btn btn-info btn-custom" onclick="showHelp()">
        <i class="fas fa-question-circle me-2"></i>
        مساعدة
    </button>
</div>
@endsection

@section('content')
<!-- Welcome Banner -->
<div class="welcome-banner mb-4">
    <div class="card border-0">
        <div class="card-body p-4" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 15px;">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h3 class="text-white mb-2">
                        <i class="fas fa-user-plus me-3"></i>
                        إضافة عميل جديد
                    </h3>
                    <p class="text-white opacity-75 mb-0">
                        أضف عميل جديد إلى النظام مع جميع المعلومات المطلوبة حسب معايير ZATCA
                    </p>
                </div>
                <div class="col-md-4 text-end">
                    <div class="welcome-icon">
                        <i class="fas fa-users fa-4x text-white opacity-25"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Progress Indicator -->
<div class="card form-progress-card mb-4">
    <div class="card-body py-2">
        <div class="progress-steps">
            <div class="step active" data-step="1">
                <div class="step-icon"><i class="fas fa-user-tag"></i></div>
                <div class="step-text">نوع العميل</div>
            </div>
            <div class="step" data-step="2">
                <div class="step-icon"><i class="fas fa-info-circle"></i></div>
                <div class="step-text">المعلومات الأساسية</div>
            </div>
            <div class="step" data-step="3">
                <div class="step-icon"><i class="fas fa-map-marker-alt"></i></div>
                <div class="step-text">العنوان</div>
            </div>
            <div class="step" data-step="4">
                <div class="step-icon"><i class="fas fa-check"></i></div>
                <div class="step-text">المراجعة</div>
            </div>
        </div>
    </div>
</div>

<form method="POST" action="{{ route('customers.store') }}" id="customer-form" novalidate>
    @csrf
    
    <div class="row">
        <div class="col-lg-8">
            <!-- نوع العميل -->
            <div class="card form-card animate-card" id="customer-type-card">
                <div class="card-header bg-gradient-primary">
                    <h5 class="card-title mb-0 text-white">
                        <i class="fas fa-user-tag me-2"></i>
                        نوع العميل
                        <span class="badge bg-light text-primary ms-2">خطوة 1</span>
                    </h5>
                </div>
                <div class="card-body p-4">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="form-check form-check-card customer-type-option">
                                <input type="radio" name="customer_type" value="individual" class="form-check-input"
                                       id="individual" {{ old('customer_type', 'individual') == 'individual' ? 'checked' : '' }}
                                       onchange="toggleCustomerType()">
                                <label class="form-check-label w-100" for="individual">
                                    <div class="card h-100 option-card">
                                        <div class="card-body text-center p-4">
                                            <div class="option-icon mb-3">
                                                <i class="fas fa-user fa-3x text-info"></i>
                                            </div>
                                            <h5 class="option-title">عميل فرد</h5>
                                            <p class="text-muted mb-0">شخص طبيعي بهوية وطنية</p>
                                            <div class="option-features mt-3">
                                                <small class="text-success d-block"><i class="fas fa-check me-1"></i> سهولة في التسجيل</small>
                                                <small class="text-success d-block"><i class="fas fa-check me-1"></i> للأفراد والمتاجر الصغيرة</small>
                                            </div>
                                        </div>
                                        <div class="selection-indicator">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-check form-check-card customer-type-option">
                                <input type="radio" name="customer_type" value="business" class="form-check-input"
                                       id="business" {{ old('customer_type') == 'business' ? 'checked' : '' }}
                                       onchange="toggleCustomerType()">
                                <label class="form-check-label w-100" for="business">
                                    <div class="card h-100 option-card">
                                        <div class="card-body text-center p-4">
                                            <div class="option-icon mb-3">
                                                <i class="fas fa-building fa-3x text-primary"></i>
                                            </div>
                                            <h5 class="option-title">عميل شركة</h5>
                                            <p class="text-muted mb-0">شخص اعتباري برقم ضريبي</p>
                                            <div class="option-features mt-3">
                                                <small class="text-success d-block"><i class="fas fa-check me-1"></i> للشركات والمؤسسات</small>
                                                <small class="text-success d-block"><i class="fas fa-check me-1"></i> متوافق مع ZATCA</small>
                                            </div>
                                        </div>
                                        <div class="selection-indicator">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                    @error('customer_type')
                        <div class="alert alert-danger mt-3 animate-error">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
            
            <!-- المعلومات الأساسية -->
            <div class="card form-card animate-card mt-4" id="basic-info-card">
                <div class="card-header bg-gradient-info">
                    <h5 class="card-title mb-0 text-white">
                        <i class="fas fa-info-circle me-2"></i>
                        المعلومات الأساسية
                        <span class="badge bg-light text-info ms-2">خطوة 2</span>
                    </h5>
                </div>
                <div class="card-body p-4">
                    <div class="row g-4">
                        <div class="col-md-12">
                            <div class="form-floating">
                                <input type="text" name="name" id="customer-name"
                                       class="form-control form-control-lg @error('name') is-invalid @enderror"
                                       value="{{ old('name') }}" required
                                       placeholder="اسم العميل الكامل">
                                <label for="customer-name">
                                    <i class="fas fa-user text-primary me-2"></i>
                                    الاسم الكامل <span class="text-danger">*</span>
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        اسم صحيح
                                    </div>
                                    @error('name')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- حقول الهوية -->
                    <div class="row g-4 mt-2" id="identity-fields">
                        <!-- سيتم ملؤها ديناميكياً حسب نوع العميل -->
                    </div>
                    
                    <div class="row g-4 mt-2">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="email" name="email" id="customer-email"
                                       class="form-control @error('email') is-invalid @enderror"
                                       value="{{ old('email') }}"
                                       placeholder="example@domain.com">
                                <label for="customer-email">
                                    <i class="fas fa-envelope text-success me-2"></i>
                                    البريد الإلكتروني
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        بريد إلكتروني صحيح
                                    </div>
                                    @error('email')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="tel" name="phone" id="customer-phone"
                                       class="form-control @error('phone') is-invalid @enderror"
                                       value="{{ old('phone') }}"
                                       placeholder="+966501234567">
                                <label for="customer-phone">
                                    <i class="fas fa-phone text-warning me-2"></i>
                                    رقم الهاتف
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        رقم هاتف صحيح
                                    </div>
                                    @error('phone')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- نصائح ومساعدة -->
                    <div class="alert alert-info mt-4 help-alert">
                        <div class="d-flex align-items-start">
                            <i class="fas fa-lightbulb text-info me-3 mt-1"></i>
                            <div>
                                <h6 class="alert-heading mb-2">نصائح لإدخال البيانات:</h6>
                                <ul class="mb-0 small">
                                    <li>تأكد من كتابة الاسم كاملاً كما هو في الهوية</li>
                                    <li>للأفراد: رقم الهوية الوطنية اختياري</li>
                                    <li>البريد الإلكتروني اختياري ولكن مفيد لإرسال الفواتير</li>
                                    <li>رقم الهاتف يُفضل أن يكون بالصيغة الدولية (+966)</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- العنوان الوطني -->
            <div class="card form-card animate-card mt-4" id="address-card">
                <div class="card-header bg-gradient-success">
                    <h5 class="card-title mb-0 text-white">
                        <i class="fas fa-map-marker-alt me-2"></i>
                        العنوان الوطني
                        <span class="badge bg-light text-success ms-2">خطوة 3</span>
                        <small class="d-block mt-1 opacity-75" id="address-requirement-text">
                            <i class="fas fa-info-circle me-1"></i>
                            <span class="individual-text" style="display: none;">اختياري للعملاء الأفراد</span>
                            <span class="business-text">إجباري للشركات حسب لوائح ZATCA</span>
                        </small>
                    </h5>
                </div>
                <div class="card-body p-4">
                    <!-- المدينة والحي -->
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" name="city" id="customer-city"
                                       class="form-control @error('city') is-invalid @enderror"
                                       value="{{ old('city') }}"
                                       placeholder="الرياض">
                                <label for="customer-city">
                                    <i class="fas fa-city text-primary me-2"></i>
                                    المدينة <span class="text-danger required-star">*</span>
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        مدينة صحيحة
                                    </div>
                                    @error('city')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" name="district" id="customer-district"
                                       class="form-control @error('district') is-invalid @enderror"
                                       value="{{ old('district') }}"
                                       placeholder="النخيل">
                                <label for="customer-district">
                                    <i class="fas fa-map-signs text-info me-2"></i>
                                    الحي <span class="text-danger required-star">*</span>
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        حي صحيح
                                    </div>
                                    @error('district')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- الشارع -->
                    <div class="row g-4 mt-2">
                        <div class="col-md-12">
                            <div class="form-floating">
                                <input type="text" name="street" id="customer-street"
                                       class="form-control @error('street') is-invalid @enderror"
                                       value="{{ old('street') }}"
                                       placeholder="شارع الملك فهد">
                                <label for="customer-street">
                                    <i class="fas fa-road text-warning me-2"></i>
                                    اسم الشارع <span class="text-danger required-star">*</span>
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        شارع صحيح
                                    </div>
                                    @error('street')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- تفاصيل العنوان -->
                    <div class="row g-4 mt-2">
                        <div class="col-md-3">
                            <div class="form-floating">
                                <input type="text" name="building_number" id="customer-building"
                                       class="form-control @error('building_number') is-invalid @enderror"
                                       value="{{ old('building_number') }}"
                                       placeholder="1234" maxlength="4">
                                <label for="customer-building">
                                    <i class="fas fa-building text-primary me-2"></i>
                                    رقم المبنى <span class="text-danger required-star">*</span>
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        رقم صحيح
                                    </div>
                                    @error('building_number')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="form-floating">
                                <input type="text" name="additional_number" id="customer-additional"
                                       class="form-control @error('additional_number') is-invalid @enderror"
                                       value="{{ old('additional_number') }}"
                                       placeholder="5678" maxlength="4">
                                <label for="customer-additional">
                                    <i class="fas fa-plus text-success me-2"></i>
                                    الرقم الإضافي <span class="text-danger required-star">*</span>
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        رقم صحيح
                                    </div>
                                    @error('additional_number')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="form-floating">
                                <input type="text" name="postal_code" id="customer-postal"
                                       class="form-control @error('postal_code') is-invalid @enderror"
                                       value="{{ old('postal_code') }}"
                                       placeholder="12345" maxlength="5">
                                <label for="customer-postal">
                                    <i class="fas fa-mail-bulk text-danger me-2"></i>
                                    الرمز البريدي <span class="text-danger required-star">*</span>
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        رمز صحيح
                                    </div>
                                    @error('postal_code')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="form-floating">
                                <input type="text" name="unit_number" id="customer-unit"
                                       class="form-control @error('unit_number') is-invalid @enderror"
                                       value="{{ old('unit_number') }}"
                                       placeholder="101">
                                <label for="customer-unit">
                                    <i class="fas fa-door-open text-secondary me-2"></i>
                                    رقم الوحدة
                                </label>
                                <div class="form-validation">
                                    <div class="valid-feedback">
                                        <i class="fas fa-check-circle me-1"></i>
                                        رقم صحيح
                                    </div>
                                    @error('unit_number')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle me-1"></i>
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- نصائح العنوان -->
                    <div class="alert alert-warning mt-4 help-alert">
                        <div class="d-flex align-items-start">
                            <i class="fas fa-map-marked-alt text-warning me-3 mt-1"></i>
                            <div>
                                <h6 class="alert-heading mb-2">متطلبات العنوان الوطني:</h6>
                                <ul class="mb-0 small">
                                    <li>للأفراد: العنوان الوطني اختياري</li>
                                    <li>للشركات: العنوان الوطني إجباري حسب لوائح ZATCA</li>
                                    <li>عند الإدخال: الرمز البريدي يجب أن يكون 5 أرقام صحيحة</li>
                                    <li>عند الإدخال: رقم المبنى والرقم الإضافي كلاهما 4 أرقام</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- معاينة العميل -->
        <div class="col-lg-4">
            <div class="card preview-card sticky-top" style="top: 20px;">
                <div class="card-header bg-gradient-dark text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-eye me-2"></i>
                        معاينة مباشرة
                        <span class="badge bg-light text-dark ms-2">خطوة 4</span>
                    </h5>
                </div>
                <div class="card-body p-0">
                    <!-- Customer Avatar Section -->
                    <div class="customer-avatar-section text-center p-4 border-bottom">
                        <div class="avatar-container mb-3">
                            <div class="avatar-circle">
                                <i id="customer-icon" class="fas fa-user fa-3x text-white"></i>
                            </div>
                            <div class="avatar-status online"></div>
                        </div>
                        <h5 id="customer-preview-name" class="customer-name mb-1">اسم العميل الجديد</h5>
                        <span id="customer-preview-type" class="customer-type badge bg-info">
                            عميل فرد
                        </span>
                    </div>
                    
                    <!-- Customer Details -->
                    <div class="customer-details p-4">
                        <!-- Identity Information -->
                        <div class="info-item mb-3">
                            <div class="info-label">
                                <i class="fas fa-id-card text-primary me-2"></i>
                                رقم التعريف
                            </div>
                            <div id="customer-preview-identity" class="info-value">
                                <div class="info-label">
                                    <i class="fas fa-id-badge text-info me-2"></i>
                                    الهوية الوطنية
                                </div>
                                <div class="info-value">غير محدد</div>
                            </div>
                        </div>
                        
                        <!-- Address Information -->
                        <div class="info-item mb-3">
                            <div class="info-label">
                                <i class="fas fa-map-marker-alt text-success me-2"></i>
                                العنوان
                            </div>
                            <div id="customer-preview-address" class="info-value">
                                لم يتم إدخال العنوان
                            </div>
                        </div>
                        
                        <!-- Contact Information -->
                        <div class="info-item mb-3">
                            <div class="info-label">
                                <i class="fas fa-phone text-warning me-2"></i>
                                معلومات الاتصال
                            </div>
                            <div id="customer-preview-contact" class="info-value">
                                <span class="text-muted">غير متوفرة</span>
                            </div>
                        </div>
                        
                        <!-- Status Toggle -->
                        <div class="status-toggle mb-4">
                            <div class="form-check form-switch">
                                <input type="checkbox" name="is_active" class="form-check-input"
                                       id="customer-active" value="1"
                                       {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="customer-active">
                                    <i class="fas fa-toggle-on text-success me-2"></i>
                                    عميل نشط
                                </label>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="action-buttons">
                            <button type="submit" class="btn btn-success btn-lg w-100 mb-2 save-btn">
                                <i class="fas fa-save me-2"></i>
                                حفظ العميل الجديد
                                <span class="spinner-border spinner-border-sm ms-2 d-none" role="status"></span>
                            </button>
                            <div class="d-flex gap-2">
                                <button type="button" class="btn btn-outline-primary flex-fill" onclick="validateForm()">
                                    <i class="fas fa-check-circle me-1"></i>
                                    تحقق
                                </button>
                                <button type="reset" class="btn btn-outline-secondary flex-fill">
                                    <i class="fas fa-undo me-1"></i>
                                    إعادة تعيين
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- معلومات مهمة -->
            <div class="card mt-3 info-card">
                <div class="card-header bg-gradient-warning text-white">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        متطلبات ZATCA
                    </h6>
                </div>
                <div class="card-body">
                    <div class="requirements-list">
                        <div class="requirement-item">
                            <i class="fas fa-info-circle text-info me-2"></i>
                            <span>العنوان الوطني اختياري للأفراد</span>
                        </div>
                        <div class="requirement-item">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            <span>العنوان الوطني إجباري للشركات</span>
                        </div>
                        <div class="requirement-item">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            <span>الرقم الضريبي إجباري للشركات</span>
                        </div>
                        <div class="requirement-item">
                            <i class="fas fa-info-circle text-info me-2"></i>
                            <span>الهوية الوطنية اختيارية للأفراد</span>
                        </div>
                        <div class="requirement-item">
                            <i class="fas fa-info-circle text-info me-2"></i>
                            <span>البريد الإلكتروني اختياري لجميع العملاء</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Quick Tips -->
            <div class="card mt-3 tips-card">
                <div class="card-header bg-gradient-info text-white">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-lightbulb me-2"></i>
                        نصائح سريعة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="tip-item mb-3">
                        <div class="tip-icon">
                            <i class="fas fa-user-friends text-primary"></i>
                        </div>
                        <div class="tip-content">
                            <h6 class="tip-title">اختر النوع المناسب</h6>
                            <p class="tip-text">حدد نوع العميل بعناية لضمان إدخال البيانات الصحيحة</p>
                        </div>
                    </div>
                    
                    <div class="tip-item mb-3">
                        <div class="tip-icon">
                            <i class="fas fa-map-marker-alt text-success"></i>
                        </div>
                        <div class="tip-content">
                            <h6 class="tip-title">العنوان الدقيق</h6>
                            <p class="tip-text">تأكد من صحة العنوان الوطني لتجنب مشاكل الفوترة</p>
                        </div>
                    </div>
                    
                    <div class="tip-item">
                        <div class="tip-icon">
                            <i class="fas fa-shield-alt text-warning"></i>
                        </div>
                        <div class="tip-content">
                            <h6 class="tip-title">التحقق من البيانات</h6>
                            <p class="tip-text">استخدم زر "تحقق" للتأكد من صحة جميع البيانات</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@push('styles')
<style>
/* ===== WELCOME BANNER ===== */
.welcome-banner .card {
    border: none;
    overflow: hidden;
}

.welcome-icon {
    position: relative;
}

.welcome-icon::before {
    content: '';
    position: absolute;
    top: -20px;
    right: -20px;
    width: 100px;
    height: 100px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
    animation: pulse 3s infinite;
}

@keyframes pulse {
    0%, 100% { transform: scale(1); opacity: 0.7; }
    50% { transform: scale(1.1); opacity: 0.3; }
}

/* ===== PROGRESS STEPS ===== */
.form-progress-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 15px;
    overflow: hidden;
}

.progress-steps {
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: relative;
    padding: 10px 0;
}

.step {
    display: flex;
    flex-direction: column;
    align-items: center;
    position: relative;
    flex: 1;
    opacity: 0.5;
    transition: all 0.3s ease;
}

.step.active {
    opacity: 1;
}

.step-icon {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 8px;
    transition: all 0.3s ease;
}

.step.active .step-icon {
    background: rgba(255, 255, 255, 0.9);
    color: #667eea;
    transform: scale(1.1);
}

.step-text {
    color: white;
    font-size: 12px;
    font-weight: 500;
    text-align: center;
}

/* ===== FORM CARDS ===== */
.form-card {
    border: none;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
    transition: all 0.3s ease;
    margin-bottom: 25px;
}

.form-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
}

.animate-card {
    animation: slideInUp 0.6s ease-out;
}

@keyframes slideInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* ===== CARD HEADERS ===== */
.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
}

.bg-gradient-info {
    background: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%) !important;
}

.bg-gradient-success {
    background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%) !important;
}

.bg-gradient-dark {
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%) !important;
}

.bg-gradient-warning {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%) !important;
}

/* ===== CUSTOMER TYPE OPTIONS ===== */
.customer-type-option {
    position: relative;
}

.form-check-card .form-check-input {
    position: absolute;
    top: 15px;
    right: 15px;
    z-index: 10;
    transform: scale(1.2);
}

.option-card {
    cursor: pointer;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    border: 2px solid #e9ecef;
    border-radius: 12px;
    overflow: hidden;
    position: relative;
}

.option-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
}

.form-check-card .form-check-input:checked + .form-check-label .option-card {
    border-color: #667eea;
    background: linear-gradient(135deg, #f8f9ff 0%, #e3f2fd 100%);
    transform: translateY(-3px);
}

.option-icon {
    transition: all 0.3s ease;
}

.form-check-card .form-check-input:checked + .form-check-label .option-icon i {
    transform: scale(1.1);
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.2));
}

.option-title {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 10px;
}

.option-features {
    border-top: 1px solid #e9ecef;
    padding-top: 10px;
}

.selection-indicator {
    position: absolute;
    top: 10px;
    left: 10px;
    width: 25px;
    height: 25px;
    border-radius: 50%;
    background: #667eea;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    transform: scale(0);
    transition: all 0.3s ease;
}

.form-check-card .form-check-input:checked + .form-check-label .selection-indicator {
    transform: scale(1);
}

/* ===== FORM FLOATING LABELS ===== */
.form-floating > .form-control {
    border-radius: 10px;
    border: 2px solid #e9ecef;
    padding: 1rem 0.75rem;
    font-size: 16px;
    transition: all 0.3s ease;
}

.form-floating > .form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    transform: translateY(-1px);
}

.form-floating > label {
    color: #6c757d;
    font-weight: 500;
}

.form-floating > .form-control:focus ~ label {
    color: #667eea;
}

/* ===== VALIDATION FEEDBACK ===== */
.form-validation .valid-feedback,
.form-validation .invalid-feedback {
    display: block;
    margin-top: 8px;
    font-size: 14px;
    font-weight: 500;
}

.valid-feedback {
    color: #28a745 !important;
}

.invalid-feedback {
    color: #dc3545 !important;
}

/* ===== HELP ALERTS ===== */
.help-alert {
    border: none;
    border-radius: 12px;
    border-left: 4px solid;
}

.alert-info.help-alert {
    background: linear-gradient(135deg, #e3f2fd 0%, #f3e5f5 100%);
    border-left-color: #2196f3;
}

.alert-warning.help-alert {
    background: linear-gradient(135deg, #fff3e0 0%, #fce4ec 100%);
    border-left-color: #ff9800;
}

/* ===== PREVIEW CARD ===== */
.preview-card {
    border: none;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
}

.customer-avatar-section {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
}

.avatar-container {
    position: relative;
    display: inline-block;
}

.avatar-circle {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    margin: 0 auto;
    transition: all 0.3s ease;
}

.avatar-circle:hover {
    transform: scale(1.05);
}

.avatar-status {
    position: absolute;
    bottom: 5px;
    right: 5px;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    border: 3px solid white;
}

.avatar-status.online {
    background: #28a745;
}

.customer-name {
    font-weight: 600;
    color: #2c3e50;
}

.customer-type {
    font-size: 12px;
    padding: 4px 12px;
    border-radius: 20px;
}

/* ===== INFO ITEMS ===== */
.info-item {
    padding: 12px;
    border-radius: 8px;
    background: #f8f9fa;
    transition: all 0.3s ease;
}

.info-item:hover {
    background: #e9ecef;
    transform: translateX(-2px);
}

.info-label {
    font-weight: 600;
    color: #495057;
    font-size: 14px;
    margin-bottom: 5px;
}

.info-value {
    color: #6c757d;
    font-size: 14px;
    line-height: 1.4;
}

.contact-item {
    margin-bottom: 4px;
}

/* ===== STATUS TOGGLE ===== */
.status-toggle {
    padding: 15px;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 10px;
    border: 2px solid #dee2e6;
}

.form-check-input:checked {
    background-color: #28a745;
    border-color: #28a745;
}

/* ===== ACTION BUTTONS ===== */
.action-buttons .btn {
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.save-btn {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    border: none;
    position: relative;
    overflow: hidden;
}

.save-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(40, 167, 69, 0.4);
}

.save-btn:active {
    transform: translateY(0);
}

/* ===== BUTTON CUSTOM STYLES ===== */
.btn-custom {
    border-radius: 10px;
    font-weight: 500;
    padding: 10px 20px;
    transition: all 0.3s ease;
}

.btn-custom:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
}

/* ===== INFO CARDS ===== */
.info-card, .tips-card {
    border: none;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
}

.requirements-list {
    padding: 0;
}

.requirement-item {
    display: flex;
    align-items: center;
    padding: 8px 0;
    font-size: 14px;
    color: #495057;
}

.requirement-item:not(:last-child) {
    border-bottom: 1px solid #f8f9fa;
}

/* ===== TIPS SECTION ===== */
.tip-item {
    display: flex;
    align-items: flex-start;
    gap: 15px;
}

.tip-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.tip-content {
    flex: 1;
}

.tip-title {
    font-size: 14px;
    font-weight: 600;
    color: #495057;
    margin-bottom: 4px;
}

.tip-text {
    font-size: 12px;
    color: #6c757d;
    margin: 0;
    line-height: 1.4;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 768px) {
    .progress-steps {
        flex-direction: column;
        gap: 10px;
    }
    
    .step {
        flex-direction: row;
        gap: 10px;
    }
    
    .step-icon {
        margin-bottom: 0;
        width: 35px;
        height: 35px;
    }
    
    .form-card {
        margin-bottom: 15px;
    }
    
    .welcome-banner h3 {
        font-size: 1.5rem;
    }
    
    .welcome-banner p {
        font-size: 0.9rem;
    }
}

/* ===== ANIMATIONS ===== */
.animate-error {
    animation: shake 0.5s ease-in-out;
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}
</style>
@endpush

@push('scripts')
<script>
// ===== ENHANCED FORM FUNCTIONALITY =====

function toggleCustomerType() {
    const customerType = document.querySelector('input[name="customer_type"]:checked').value;
    const identityFields = document.getElementById('identity-fields');
    
    // Update progress steps
    updateProgressSteps();
    
    // Update address requirement text
    const addressText = document.getElementById('address-requirement-text');
    const individualText = addressText.querySelector('.individual-text');
    const businessText = addressText.querySelector('.business-text');
    
    // Update required attributes for address fields
    const addressFields = ['city', 'district', 'street', 'building_number', 'additional_number', 'postal_code'];
    const requiredStars = document.querySelectorAll('.required-star');
    
    if (customerType === 'individual') {
        // For individuals: make address fields optional
        addressFields.forEach(fieldName => {
            const field = document.querySelector(`input[name="${fieldName}"]`);
            if (field) {
                field.removeAttribute('required');
            }
        });
        
        // Hide required stars for address fields
        requiredStars.forEach(star => star.style.display = 'none');
        
        // Update address requirement text
        individualText.style.display = 'inline';
        businessText.style.display = 'none';
        
        identityFields.innerHTML = `
            <div class="col-md-12">
                <div class="form-floating">
                    <input type="text" name="national_id" id="customer-national-id"
                           class="form-control" value="{{ old('national_id') }}"
                           placeholder="1234567890" maxlength="10">
                    <label for="customer-national-id">
                        <i class="fas fa-id-badge text-info me-2"></i>
                        رقم الهوية الوطنية
                    </label>
                    <div class="form-validation">
                        <div class="valid-feedback">
                            <i class="fas fa-check-circle me-1"></i>
                            رقم هوية صحيح
                        </div>
                        <div class="invalid-feedback">
                            <i class="fas fa-exclamation-circle me-1"></i>
                            يجب أن يكون 10 أرقام
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        document.getElementById('customer-icon').className = 'fas fa-user fa-3x text-white';
        document.getElementById('customer-preview-type').textContent = 'عميل فرد';
        document.getElementById('customer-preview-type').className = 'customer-type badge bg-info';
    } else {
        // For businesses: make address fields required
        addressFields.forEach(fieldName => {
            const field = document.querySelector(`input[name="${fieldName}"]`);
            if (field) {
                field.setAttribute('required', 'required');
            }
        });
        
        // Show required stars for address fields
        requiredStars.forEach(star => star.style.display = 'inline');
        
        // Update address requirement text
        individualText.style.display = 'none';
        businessText.style.display = 'inline';
        
        identityFields.innerHTML = `
            <div class="col-md-6">
                <div class="form-floating">
                    <input type="text" name="vat_number" id="customer-vat-number"
                           class="form-control" value="{{ old('vat_number') }}"
                           required placeholder="300000000000003" maxlength="15">
                    <label for="customer-vat-number">
                        <i class="fas fa-receipt text-primary me-2"></i>
                        الرقم الضريبي <span class="text-danger">*</span>
                    </label>
                    <div class="form-validation">
                        <div class="valid-feedback">
                            <i class="fas fa-check-circle me-1"></i>
                            رقم ضريبي صحيح
                        </div>
                        <div class="invalid-feedback">
                            <i class="fas fa-exclamation-circle me-1"></i>
                            يجب أن يكون 15 رقم ويبدأ بـ 3
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-floating">
                    <input type="text" name="cr_number" id="customer-cr-number"
                           class="form-control" value="{{ old('cr_number') }}"
                           placeholder="1010000000" maxlength="10">
                    <label for="customer-cr-number">
                        <i class="fas fa-building text-secondary me-2"></i>
                        رقم السجل التجاري
                    </label>
                    <div class="form-validation">
                        <div class="valid-feedback">
                            <i class="fas fa-check-circle me-1"></i>
                            رقم سجل تجاري صحيح
                        </div>
                        <div class="invalid-feedback">
                            <i class="fas fa-exclamation-circle me-1"></i>
                            يجب أن يكون 10 أرقام
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        document.getElementById('customer-icon').className = 'fas fa-building fa-3x text-white';
        document.getElementById('customer-preview-type').textContent = 'عميل شركة';
        document.getElementById('customer-preview-type').className = 'customer-type badge bg-primary';
    }
    
    // إعادة ربط أحداث التحديث للحقول الجديدة
    bindUpdateEvents();
    updatePreview();
}

function updateProgressSteps() {
    const steps = document.querySelectorAll('.step');
    let currentStep = 1;
    
    // تحديد الخطوة الحالية بناءً على الحقول المملوءة
    const customerType = document.querySelector('input[name="customer_type"]:checked');
    if (customerType) currentStep = 2;
    
    const name = document.querySelector('input[name="name"]').value;
    if (name) currentStep = 3;
    
    const city = document.querySelector('input[name="city"]').value;
    const street = document.querySelector('input[name="street"]').value;
    if (city && street) currentStep = 4;
    
    steps.forEach((step, index) => {
        if (index < currentStep) {
            step.classList.add('active');
        } else {
            step.classList.remove('active');
        }
    });
}

function updatePreview() {
    const name = document.querySelector('input[name="name"]').value || 'اسم العميل الجديد';
    
    // تحديث الاسم
    document.getElementById('customer-preview-name').textContent = name;
    
    // تحديث رقم التعريف
    const customerType = document.querySelector('input[name="customer_type"]:checked').value;
    const identityDiv = document.getElementById('customer-preview-identity');
    
    if (customerType === 'individual') {
        const nationalId = document.querySelector('input[name="national_id"]')?.value || 'غير محدد';
        identityDiv.innerHTML = `
            <div class="info-label">
                <i class="fas fa-id-badge text-info me-2"></i>
                الهوية الوطنية
            </div>
            <div class="info-value">${nationalId}</div>
        `;
    } else {
        const vatNumber = document.querySelector('input[name="vat_number"]')?.value || 'غير محدد';
        identityDiv.innerHTML = `
            <div class="info-label">
                <i class="fas fa-receipt text-primary me-2"></i>
                الرقم الضريبي
            </div>
            <div class="info-value">${vatNumber}</div>
        `;
    }
    
    // تحديث العنوان
    updateAddressPreview();
    
    // تحديث معلومات الاتصال
    updateContactPreview();
    
    // تحديث شريط التقدم
    updateProgressSteps();
}

function updateAddressPreview() {
    const city = document.querySelector('input[name="city"]').value;
    const district = document.querySelector('input[name="district"]').value;
    const street = document.querySelector('input[name="street"]').value;
    const building = document.querySelector('input[name="building_number"]').value;
    const postal = document.querySelector('input[name="postal_code"]').value;
    
    let address = '';
    if (street) address += street;
    if (building) address += (address ? '، مبنى ' : 'مبنى ') + building;
    if (district) address += (address ? '، ' : '') + district;
    if (city) address += (address ? '، ' : '') + city;
    if (postal) address += (address ? ' ' : '') + postal;
    
    document.getElementById('customer-preview-address').innerHTML = `
        <div class="info-value">${address || 'لم يتم إدخال العنوان'}</div>
    `;
}

function updateContactPreview() {
    const email = document.querySelector('input[name="email"]').value;
    const phone = document.querySelector('input[name="phone"]').value;
    
    let contactHTML = '';
    if (email) {
        contactHTML += `
            <div class="contact-item">
                <i class="fas fa-envelope text-muted me-1"></i>
                ${email}
            </div>
        `;
    }
    if (phone) {
        contactHTML += `
            <div class="contact-item">
                <i class="fas fa-phone text-muted me-1"></i>
                ${phone}
            </div>
        `;
    }
    
    if (!contactHTML) {
        contactHTML = '<span class="text-muted">غير متوفرة</span>';
    }
    
    document.getElementById('customer-preview-contact').innerHTML = contactHTML;
}

// ===== FORM VALIDATION =====
function validateForm() {
    let isValid = true;
    const form = document.getElementById('customer-form');
    const customerType = document.querySelector('input[name="customer_type"]:checked').value;
    
    // إزالة الحالات السابقة
    form.querySelectorAll('.is-valid, .is-invalid').forEach(el => {
        el.classList.remove('is-valid', 'is-invalid');
    });
    
    // التحقق من الحقول المطلوبة
    const requiredFields = form.querySelectorAll('input[required]');
    requiredFields.forEach(field => {
        if (!field.value.trim()) {
            field.classList.add('is-invalid');
            isValid = false;
        } else {
            field.classList.add('is-valid');
        }
    });
    
    // التحقق من صحة البريد الإلكتروني
    const emailField = form.querySelector('input[name="email"]');
    if (emailField && emailField.value) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailRegex.test(emailField.value)) {
            emailField.classList.add('is-invalid');
            isValid = false;
        } else {
            emailField.classList.add('is-valid');
        }
    }
    
    // التحقق من رقم الهوية الوطنية (للأفراد فقط وإذا تم إدخاله)
    const nationalIdField = form.querySelector('input[name="national_id"]');
    if (nationalIdField && nationalIdField.value) {
        if (nationalIdField.value.length !== 10 || !/^\d+$/.test(nationalIdField.value)) {
            nationalIdField.classList.add('is-invalid');
            isValid = false;
        } else {
            nationalIdField.classList.add('is-valid');
        }
    }
    
    // التحقق من الرقم الضريبي (للشركات)
    const vatField = form.querySelector('input[name="vat_number"]');
    if (vatField && vatField.value) {
        if (vatField.value.length !== 15 || !vatField.value.startsWith('3') || !/^\d+$/.test(vatField.value)) {
            vatField.classList.add('is-invalid');
            isValid = false;
        } else {
            vatField.classList.add('is-valid');
        }
    }
    
    // التحقق من الرمز البريدي (إذا تم إدخاله)
    const postalField = form.querySelector('input[name="postal_code"]');
    if (postalField && postalField.value) {
        if (postalField.value.length !== 5 || !/^\d+$/.test(postalField.value)) {
            postalField.classList.add('is-invalid');
            isValid = false;
        } else {
            postalField.classList.add('is-valid');
        }
    }
    
    // التحقق من رقم المبنى والرقم الإضافي (إذا تم إدخالهما)
    const buildingField = form.querySelector('input[name="building_number"]');
    if (buildingField && buildingField.value) {
        if (buildingField.value.length !== 4 || !/^\d+$/.test(buildingField.value)) {
            buildingField.classList.add('is-invalid');
            isValid = false;
        } else {
            buildingField.classList.add('is-valid');
        }
    }
    
    const additionalField = form.querySelector('input[name="additional_number"]');
    if (additionalField && additionalField.value) {
        if (additionalField.value.length !== 4 || !/^\d+$/.test(additionalField.value)) {
            additionalField.classList.add('is-invalid');
            isValid = false;
        } else {
            additionalField.classList.add('is-valid');
        }
    }
    
    if (isValid) {
        showNotification('تم التحقق بنجاح! جميع البيانات صحيحة.', 'success');
    } else {
        showNotification('يرجى تصحيح الأخطاء المحددة باللون الأحمر.', 'error');
    }
    
    return isValid;
}

// ===== NOTIFICATIONS =====
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'error' ? 'danger' : type} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        <i class="fas fa-${type === 'success' ? 'check-circle' : type === 'error' ? 'exclamation-circle' : 'info-circle'} me-2"></i>
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}

// ===== HELP MODAL =====
function showHelp() {
    const helpModal = `
        <div class="modal fade" id="helpModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">
                            <i class="fas fa-question-circle me-2"></i>
                            دليل إضافة العميل
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6><i class="fas fa-user-tag text-primary me-2"></i>نوع العميل</h6>
                                <ul class="small">
                                    <li><strong>عميل فرد:</strong> للأشخاص الطبيعيين</li>
                                    <li><strong>عميل شركة:</strong> للشركات والمؤسسات</li>
                                </ul>
                                
                                <h6 class="mt-3"><i class="fas fa-id-card text-info me-2"></i>أرقام التعريف</h6>
                                <ul class="small">
                                    <li><strong>الهوية الوطنية:</strong> 10 أرقام للأفراد</li>
                                    <li><strong>الرقم الضريبي:</strong> 15 رقم يبدأ بـ 3 للشركات</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h6><i class="fas fa-map-marker-alt text-success me-2"></i>العنوان الوطني</h6>
                                <ul class="small">
                                    <li>إجباري حسب لوائح ZATCA</li>
                                    <li>يجب أن يكون دقيق ومطابق للواقع</li>
                                    <li>الرمز البريدي 5 أرقام</li>
                                    <li>رقم المبنى والرقم الإضافي 4 أرقام لكل منهما</li>
                                </ul>
                                
                                <h6 class="mt-3"><i class="fas fa-phone text-warning me-2"></i>معلومات الاتصال</h6>
                                <ul class="small">
                                    <li>البريد الإلكتروني اختياري</li>
                                    <li>رقم الهاتف يفضل بالصيغة الدولية</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // إزالة المودال السابق إن وجد
    const existingModal = document.getElementById('helpModal');
    if (existingModal) {
        existingModal.remove();
    }
    
    document.body.insertAdjacentHTML('beforeend', helpModal);
    const modal = new bootstrap.Modal(document.getElementById('helpModal'));
    modal.show();
}

// ===== FORM SUBMISSION =====
function handleFormSubmission() {
    const form = document.getElementById('customer-form');
    const saveBtn = form.querySelector('.save-btn');
    const spinner = saveBtn.querySelector('.spinner-border');
    
    form.addEventListener('submit', function(e) {
        if (!validateForm()) {
            e.preventDefault();
            return false;
        }
        
        // إظهار حالة التحميل
        saveBtn.disabled = true;
        spinner.classList.remove('d-none');
        document.body.classList.add('loading');
        
        showNotification('جاري حفظ العميل الجديد...', 'info');
    });
}

// ===== EVENT BINDING =====
function bindUpdateEvents() {
    document.querySelectorAll('input[type="text"], input[type="email"], input[type="tel"]').forEach(input => {
        input.removeEventListener('input', updatePreview);
        input.addEventListener('input', updatePreview);
        
        // إضافة التحقق المباشر
        input.addEventListener('blur', function() {
            validateField(this);
        });
    });
}

function validateField(field) {
    const value = field.value.trim();
    const name = field.name;
    const customerType = document.querySelector('input[name="customer_type"]:checked').value;
    
    field.classList.remove('is-valid', 'is-invalid');
    
    // For individuals, address fields and national_id are optional
    // For businesses, address fields are required, vat_number is required
    if (field.required && !value) {
        field.classList.add('is-invalid');
        return false;
    }
    
    switch (name) {
        case 'email':
            if (value && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value)) {
                field.classList.add('is-invalid');
                return false;
            }
            break;
        case 'national_id':
            if (value && (value.length !== 10 || !/^\d+$/.test(value))) {
                field.classList.add('is-invalid');
                return false;
            }
            break;
        case 'vat_number':
            if (value && (value.length !== 15 || !value.startsWith('3') || !/^\d+$/.test(value))) {
                field.classList.add('is-invalid');
                return false;
            }
            break;
        case 'postal_code':
            if (value && (value.length !== 5 || !/^\d+$/.test(value))) {
                field.classList.add('is-invalid');
                return false;
            }
            break;
        case 'building_number':
        case 'additional_number':
            if (value && (value.length !== 4 || !/^\d+$/.test(value))) {
                field.classList.add('is-invalid');
                return false;
            }
            break;
    }
    
    if (value) {
        field.classList.add('is-valid');
    }
    
    return true;
}

// ===== INITIALIZATION =====
document.addEventListener('DOMContentLoaded', function() {
    // تهيئة النموذج
    toggleCustomerType();
    bindUpdateEvents();
    handleFormSubmission();
    
    // إضافة تأثيرات الرسوم المتحركة
    const cards = document.querySelectorAll('.form-card');
    cards.forEach((card, index) => {
        card.style.animationDelay = `${index * 0.1}s`;
    });
    
    // إضافة معالج إعادة تعيين النموذج
    const resetBtn = document.querySelector('button[type="reset"]');
    if (resetBtn) {
        resetBtn.addEventListener('click', function(e) {
            e.preventDefault();
            if (confirm('هل أنت متأكد من إعادة تعيين جميع البيانات؟')) {
                document.getElementById('customer-form').reset();
                toggleCustomerType();
                updatePreview();
                showNotification('تم إعادة تعيين النموذج.', 'info');
            }
        });
    }
    
    console.log('✨ تم تحميل نموذج إضافة العميل المحسن بنجاح!');
});
</script>
@endpush