@extends('layouts.app')

@section('title', 'تفاصيل مركز التكلفة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Cost Center Details Card -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-building"></i> تفاصيل مركز التكلفة: {{ $costCenter->name }}
                    </h5>
                    <div>
                        <a href="{{ route('accounting.cost-centers.edit', $costCenter) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('accounting.cost-centers.budget-analysis', $costCenter) }}" class="btn btn-info">
                            <i class="fas fa-chart-line"></i> تحليل الموازنة
                        </a>
                        <a href="{{ route('accounting.cost-centers.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="35%">كود المركز:</th>
                                    <td><span class="badge bg-primary fs-6">{{ $costCenter->code }}</span></td>
                                </tr>
                                <tr>
                                    <th>اسم المركز:</th>
                                    <td><strong>{{ $costCenter->name }}</strong></td>
                                </tr>
                                <tr>
                                    <th>المسؤول:</th>
                                    <td>{{ $costCenter->manager ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>الحالة:</th>
                                    <td>
                                        @if($costCenter->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-danger">غير نشط</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء:</th>
                                    <td>{{ $costCenter->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <table class="table table-borderless">
                                @php
                                    $currentYear = date('Y');
                                    $actualAmount = \App\Models\JournalEntryLine::where('cost_center_id', $costCenter->id)
                                        ->whereHas('journalEntry', function($query) use ($currentYear) {
                                            $query->whereYear('entry_date', $currentYear)
                                                  ->where('status', 'posted');
                                        })
                                        ->sum('debit_amount') - \App\Models\JournalEntryLine::where('cost_center_id', $costCenter->id)
                                        ->whereHas('journalEntry', function($query) use ($currentYear) {
                                            $query->whereYear('entry_date', $currentYear)
                                                  ->where('status', 'posted');
                                        })
                                        ->sum('credit_amount');
                                    
                                    $utilization = $costCenter->budget_amount && $costCenter->budget_amount > 0 
                                        ? ($actualAmount / $costCenter->budget_amount) * 100 
                                        : 0;
                                @endphp
                                <tr>
                                    <th width="35%">الموازنة المخططة:</th>
                                    <td>
                                        @if($costCenter->budget_amount)
                                            <span class="text-primary">{{ number_format($costCenter->budget_amount, 2) }} ريال</span>
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>المبلغ الفعلي ({{ $currentYear }}):</th>
                                    <td>
                                        <span class="{{ $actualAmount >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($actualAmount, 2) }} ريال
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>نسبة الاستغلال:</th>
                                    <td>
                                        @if($costCenter->budget_amount)
                                            @if($utilization <= 80)
                                                <span class="badge bg-success fs-6">{{ number_format($utilization, 1) }}%</span>
                                            @elseif($utilization <= 100)
                                                <span class="badge bg-warning fs-6">{{ number_format($utilization, 1) }}%</span>
                                            @else
                                                <span class="badge bg-danger fs-6">{{ number_format($utilization, 1) }}%</span>
                                            @endif
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>المتبقي من الموازنة:</th>
                                    <td>
                                        @if($costCenter->budget_amount)
                                            @php $remaining = $costCenter->budget_amount - $actualAmount; @endphp
                                            <span class="{{ $remaining >= 0 ? 'text-success' : 'text-danger' }}">
                                                {{ number_format($remaining, 2) }} ريال
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>عدد الحركات:</th>
                                    <td>{{ $totalTransactions }} حركة</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($costCenter->description)
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>الوصف:</h6>
                            <div class="alert alert-light">{{ $costCenter->description }}</div>
                        </div>
                    </div>
                    @endif

                    <!-- Budget Progress -->
                    @if($costCenter->budget_amount)
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>تقدم الموازنة:</h6>
                            <div class="progress" style="height: 25px;">
                                @php
                                    $progressPercent = min(100, $utilization);
                                    $progressClass = $utilization <= 80 ? 'bg-success' : ($utilization <= 100 ? 'bg-warning' : 'bg-danger');
                                @endphp
                                <div class="progress-bar {{ $progressClass }}" role="progressbar" 
                                     style="width: {{ $progressPercent }}%">
                                    {{ number_format($utilization, 1) }}%
                                </div>
                            </div>
                            <small class="text-muted">
                                تم استخدام {{ number_format($actualAmount, 2) }} ريال من أصل {{ number_format($costCenter->budget_amount, 2) }} ريال
                            </small>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Monthly Analysis -->
            @if($costCenter->budget_amount && $monthlyData->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar"></i> التحليل الشهري للعام {{ $currentYear }}
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th>الشهر</th>
                                    <th>الموازنة الشهرية</th>
                                    <th>المبلغ الفعلي</th>
                                    <th>الفرق</th>
                                    <th>النسبة</th>
                                </tr>
                            <tbody>
                                @php
                                    $monthlyBudget = $costCenter->budget_amount / 12;
                                    $months = [
                                        1 => 'يناير', 2 => 'فبراير', 3 => 'مارس', 4 => 'إبريل',
                                        5 => 'مايو', 6 => 'يونيو', 7 => 'يوليو', 8 => 'أغسطس',
                                        9 => 'سبتمبر', 10 => 'أكتوبر', 11 => 'نوفمبر', 12 => 'ديسمبر'
                                    ];
                                @endphp
                                @for($month = 1; $month <= 12; $month++)
                                    @php
                                        $monthData = $monthlyData->where('month', $month)->first();
                                        $actualAmount = $monthData ? $monthData->total_amount : 0;
                                        $difference = $monthlyBudget - $actualAmount;
                                        $percentage = $monthlyBudget > 0 ? ($actualAmount / $monthlyBudget) * 100 : 0;
                                    @endphp
                                    <tr>
                                        <td><strong>{{ $months[$month] }}</strong></td>
                                        <td>{{ number_format($monthlyBudget, 2) }} ريال</td>
                                        <td>
                                            <span class="{{ $actualAmount > 0 ? 'text-success' : 'text-muted' }}">
                                                {{ number_format($actualAmount, 2) }} ريال
                                            </span>
                                        </td>
                                        <td>
                                            <span class="{{ $difference >= 0 ? 'text-success' : 'text-danger' }}">
                                                {{ $difference >= 0 ? '+' : '' }}{{ number_format($difference, 2) }} ريال
                                            </span>
                                        </td>
                                        <td>
                                            @if($percentage <= 80)
                                                <span class="badge bg-success">{{ number_format($percentage, 1) }}%</span>
                                            @elseif($percentage <= 100)
                                                <span class="badge bg-warning">{{ number_format($percentage, 1) }}%</span>
                                            @else
                                                <span class="badge bg-danger">{{ number_format($percentage, 1) }}%</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endfor
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @endif

            <!-- Recent Transactions -->
            @if($recentTransactions->count() > 0)
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-history"></i> آخر الحركات على مركز التكلفة
                    </h6>
                    <a href="{{ route('accounting.journal-entries.index') }}?cost_center_id={{ $costCenter->id }}" class="btn btn-sm btn-outline-primary">
                        عرض جميع الحركات
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th>التاريخ</th>
                                    <th>رقم القيد</th>
                                    <th>الحساب</th>
                                    <th>البيان</th>
                                    <th>مدين</th>
                                    <th>دائن</th>
                                </tr>
                            <tbody>
                                @foreach($recentTransactions as $transaction)
                                <tr>
                                    <td>{{ $transaction->journalEntry->entry_date->format('Y-m-d') }}</td>
                                    <td>
                                        <a href="{{ route('accounting.journal-entries.show', $transaction->journalEntry) }}">
                                            {{ $transaction->journalEntry->entry_number }}
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $transaction->account) }}">
                                            {{ $transaction->account->code }} - {{ $transaction->account->name }}
                                        </a>
                                    </td>
                                    <td>{{ $transaction->description }}</td>
                                    <td class="text-success">
                                        {{ $transaction->debit_amount > 0 ? number_format($transaction->debit_amount, 2) : '-' }}
                                    </td>
                                    <td class="text-danger">
                                        {{ $transaction->credit_amount > 0 ? number_format($transaction->credit_amount, 2) : '-' }}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @else
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-chart-line fa-5x text-muted mb-3"></i>
                    <h5>لا توجد حركات مالية</h5>
                    <p class="text-muted">لم يتم تسجيل أي حركات مالية على مركز التكلفة هذا بعد.</p>
                    <a href="{{ route('accounting.journal-entries.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إنشاء قيد يومية
                    </a>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// إضافة تفاعل لشريط التقدم
$(document).ready(function() {
    $('.progress-bar').each(function() {
        const $this = $(this);
        const width = $this.css('width');
        $this.css('width', '0%').animate({
            width: width
        }, 1000);
    });
});
</script>
@endpush