@extends('layouts.app')

@section('title', 'مراكز التكلفة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Cost Centers Card -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-building"></i> مراكز التكلفة
                    </h5>
                    <div>
                        <a href="{{ route('accounting.cost-centers.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة مركز تكلفة جديد
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if($costCenters->count() > 0)
                        <!-- Summary Cards -->
                        <div class="row mb-4">
                            @php
                                $totalCenters = $costCenters->count();
                                $activeCenters = $costCenters->where('is_active', true)->count();
                                $centersWithBudget = $costCenters->where('budget_amount', '>', 0)->count();
                                $totalBudget = $costCenters->sum('budget_amount');
                                
                                // حساب إجمالي المصروفات الفعلية
                                $currentYear = date('Y');
                                $totalActual = 0;
                                foreach($costCenters as $center) {
                                    $actual = \App\Models\JournalEntryLine::where('cost_center_id', $center->id)
                                        ->whereHas('journalEntry', function($query) use ($currentYear) {
                                            $query->whereYear('entry_date', $currentYear)
                                                  ->where('status', 'posted');
                                        })
                                        ->sum('debit_amount') - \App\Models\JournalEntryLine::where('cost_center_id', $center->id)
                                        ->whereHas('journalEntry', function($query) use ($currentYear) {
                                            $query->whereYear('entry_date', $currentYear)
                                                  ->where('status', 'posted');
                                        })
                                        ->sum('credit_amount');
                                    $totalActual += $actual;
                                }
                                
                                $overallUtilization = $totalBudget > 0 ? ($totalActual / $totalBudget) * 100 : 0;
                            @endphp
                            
                            <div class="col-md-3">
                                <div class="card text-center border-primary">
                                    <div class="card-body">
                                        <h4 class="card-title text-primary">{{ $totalCenters }}</h4>
                                        <p class="card-text">إجمالي مراكز التكلفة</p>
                                        <small class="text-muted">{{ $activeCenters }} مركز نشط</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="card text-center border-info">
                                    <div class="card-body">
                                        <h4 class="card-title text-info">{{ number_format($totalBudget, 0) }}</h4>
                                        <p class="card-text">إجمالي الموازنات (ريال)</p>
                                        <small class="text-muted">{{ $centersWithBudget }} مركز لديه موازنة</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="card text-center border-success">
                                    <div class="card-body">
                                        <h4 class="card-title text-success">{{ number_format($totalActual, 0) }}</h4>
                                        <p class="card-text">إجمالي المصروفات (ريال)</p>
                                        <small class="text-muted">للعام {{ $currentYear }}</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="card text-center border-warning">
                                    <div class="card-body">
                                        <h4 class="card-title {{ $overallUtilization <= 80 ? 'text-success' : ($overallUtilization <= 100 ? 'text-warning' : 'text-danger') }}">
                                            {{ number_format($overallUtilization, 1) }}%
                                        </h4>
                                        <p class="card-text">نسبة الاستغلال العامة</p>
                                        <small class="text-muted">للموازنات المحددة</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Overall Budget Progress -->
                        @if($totalBudget > 0)
                        <div class="card mb-4 bg-light">
                            <div class="card-body">
                                <h6>إجمالي استغلال الموازنات للعام {{ $currentYear }}:</h6>
                                <div class="progress" style="height: 25px;">
                                    @php
                                        $progressPercent = min(100, $overallUtilization);
                                        $progressClass = $overallUtilization <= 80 ? 'bg-success' : ($overallUtilization <= 100 ? 'bg-warning' : 'bg-danger');
                                    @endphp
                                    <div class="progress-bar {{ $progressClass }}" role="progressbar" 
                                         style="width: {{ $progressPercent }}%">
                                        {{ number_format($overallUtilization, 1) }}%
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between mt-2">
                                    <small class="text-muted">تم صرف {{ number_format($totalActual, 2) }} ريال من أصل {{ number_format($totalBudget, 2) }} ريال</small>
                                    <small class="text-muted">المتبقي: {{ number_format($totalBudget - $totalActual, 2) }} ريال</small>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Cost Centers Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                    <tr>
                                        <th>الكود</th>
                                        <th>اسم مركز التكلفة</th>
                                        <th>المسؤول</th>
                                        <th>الموازنة السنوية</th>
                                        <th>المصروف الفعلي</th>
                                        <th>نسبة الاستغلال</th>
                                        <th>المتبقي</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                <tbody>
                                    @foreach($costCenters as $costCenter)
                                        @php
                                            $actualAmount = \App\Models\JournalEntryLine::where('cost_center_id', $costCenter->id)
                                                ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                    $query->whereYear('entry_date', $currentYear)
                                                          ->where('status', 'posted');
                                                })
                                                ->sum('debit_amount') - \App\Models\JournalEntryLine::where('cost_center_id', $costCenter->id)
                                                ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                    $query->whereYear('entry_date', $currentYear)
                                                          ->where('status', 'posted');
                                                })
                                                ->sum('credit_amount');
                                            
                                            $utilization = $costCenter->budget_amount && $costCenter->budget_amount > 0 
                                                ? ($actualAmount / $costCenter->budget_amount) * 100 
                                                : 0;
                                            
                                            $remaining = $costCenter->budget_amount ? $costCenter->budget_amount - $actualAmount : 0;
                                            
                                            $transactionCount = \App\Models\JournalEntryLine::where('cost_center_id', $costCenter->id)->count();
                                        @endphp
                                        <tr>
                                            <td>
                                                <span class="badge bg-primary">{{ $costCenter->code }}</span>
                                            </td>
                                            <td>
                                                <a href="{{ route('accounting.cost-centers.show', $costCenter) }}">
                                                    <strong>{{ $costCenter->name }}</strong>
                                                </a>
                                                @if($costCenter->description)
                                                    <br><small class="text-muted">{{ Str::limit($costCenter->description, 50) }}</small>
                                                @endif
                                            </td>
                                            <td>{{ $costCenter->manager ?: '-' }}</td>
                                            <td>
                                                @if($costCenter->budget_amount)
                                                    <span class="text-primary">{{ number_format($costCenter->budget_amount, 2) }} ريال</span>
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="{{ $actualAmount >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($actualAmount, 2) }} ريال
                                                </span>
                                                @if($transactionCount > 0)
                                                    <br><small class="text-muted">{{ $transactionCount }} حركة</small>
                                                @endif
                                            </td>
                                            <td>
                                                @if($costCenter->budget_amount)
                                                    <div class="d-flex align-items-center">
                                                        @if($utilization <= 80)
                                                            <span class="badge bg-success me-2">{{ number_format($utilization, 1) }}%</span>
                                                        @elseif($utilization <= 100)
                                                            <span class="badge bg-warning me-2">{{ number_format($utilization, 1) }}%</span>
                                                        @else
                                                            <span class="badge bg-danger me-2">{{ number_format($utilization, 1) }}%</span>
                                                        @endif
                                                        <div class="progress flex-grow-1" style="height: 10px; min-width: 60px;">
                                                            @php
                                                                $progressPercent = min(100, $utilization);
                                                                $progressClass = $utilization <= 80 ? 'bg-success' : ($utilization <= 100 ? 'bg-warning' : 'bg-danger');
                                                            @endphp
                                                            <div class="progress-bar {{ $progressClass }}" 
                                                                 style="width: {{ $progressPercent }}%"></div>
                                                        </div>
                                                    </div>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($costCenter->budget_amount)
                                                    <span class="{{ $remaining >= 0 ? 'text-success' : 'text-danger' }}">
                                                        {{ number_format($remaining, 2) }} ريال
                                                    </span>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($costCenter->is_active)
                                                    <span class="badge bg-success">نشط</span>
                                                @else
                                                    <span class="badge bg-danger">غير نشط</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('accounting.cost-centers.show', $costCenter) }}" 
                                                       class="btn btn-sm btn-outline-primary" title="عرض">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('accounting.cost-centers.edit', $costCenter) }}" 
                                                       class="btn btn-sm btn-outline-warning" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    @if($costCenter->budget_amount)
                                                        <a href="{{ route('accounting.cost-centers.budget-analysis', $costCenter) }}" 
                                                           class="btn btn-sm btn-outline-info" title="تحليل الموازنة">
                                                            <i class="fas fa-chart-line"></i>
                                                        </a>
                                                    @endif
                                                    @if($transactionCount == 0)
                                                        <button type="button" class="btn btn-sm btn-outline-danger" 
                                                                onclick="deleteCostCenter({{ $costCenter->id }})" title="حذف">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Performance Analysis -->
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <div class="card border-success">
                                    <div class="card-header bg-success text-white">
                                        <h6 class="mb-0">أفضل أداء (أقل استغلالاً للموازنة)</h6>
                                    </div>
                                    <div class="card-body">
                                        @php
                                            $bestPerformers = $costCenters->filter(function($center) {
                                                return $center->budget_amount > 0;
                                            })->sortBy(function($center) use ($currentYear) {
                                                $actual = \App\Models\JournalEntryLine::where('cost_center_id', $center->id)
                                                    ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                        $query->whereYear('entry_date', $currentYear)->where('status', 'posted');
                                                    })->sum('debit_amount') - \App\Models\JournalEntryLine::where('cost_center_id', $center->id)
                                                    ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                        $query->whereYear('entry_date', $currentYear)->where('status', 'posted');
                                                    })->sum('credit_amount');
                                                return $center->budget_amount > 0 ? ($actual / $center->budget_amount) * 100 : 0;
                                            })->take(3);
                                        @endphp
                                        @if($bestPerformers->count() > 0)
                                            @foreach($bestPerformers as $performer)
                                                @php
                                                    $actual = \App\Models\JournalEntryLine::where('cost_center_id', $performer->id)
                                                        ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                            $query->whereYear('entry_date', $currentYear)->where('status', 'posted');
                                                        })->sum('debit_amount') - \App\Models\JournalEntryLine::where('cost_center_id', $performer->id)
                                                        ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                            $query->whereYear('entry_date', $currentYear)->where('status', 'posted');
                                                        })->sum('credit_amount');
                                                    $utilization = $performer->budget_amount > 0 ? ($actual / $performer->budget_amount) * 100 : 0;
                                                @endphp
                                                <div class="d-flex justify-content-between">
                                                    <span>{{ $performer->name }}</span>
                                                    <span class="badge bg-success">{{ number_format($utilization, 1) }}%</span>
                                                </div>
                                            @endforeach
                                        @else
                                            <p class="text-muted">لا توجد مراكز بموازنات محددة</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="card border-warning">
                                    <div class="card-header bg-warning text-dark">
                                        <h6 class="mb-0">يحتاج متابعة (أعلى استغلالاً للموازنة)</h6>
                                    </div>
                                    <div class="card-body">
                                        @php
                                            $needsAttention = $costCenters->filter(function($center) {
                                                return $center->budget_amount > 0;
                                            })->sortByDesc(function($center) use ($currentYear) {
                                                $actual = \App\Models\JournalEntryLine::where('cost_center_id', $center->id)
                                                    ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                        $query->whereYear('entry_date', $currentYear)->where('status', 'posted');
                                                    })->sum('debit_amount') - \App\Models\JournalEntryLine::where('cost_center_id', $center->id)
                                                    ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                        $query->whereYear('entry_date', $currentYear)->where('status', 'posted');
                                                    })->sum('credit_amount');
                                                return $center->budget_amount > 0 ? ($actual / $center->budget_amount) * 100 : 0;
                                            })->take(3);
                                        @endphp
                                        @if($needsAttention->count() > 0)
                                            @foreach($needsAttention as $center)
                                                @php
                                                    $actual = \App\Models\JournalEntryLine::where('cost_center_id', $center->id)
                                                        ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                            $query->whereYear('entry_date', $currentYear)->where('status', 'posted');
                                                        })->sum('debit_amount') - \App\Models\JournalEntryLine::where('cost_center_id', $center->id)
                                                        ->whereHas('journalEntry', function($query) use ($currentYear) {
                                                            $query->whereYear('entry_date', $currentYear)->where('status', 'posted');
                                                        })->sum('credit_amount');
                                                    $utilization = $center->budget_amount > 0 ? ($actual / $center->budget_amount) * 100 : 0;
                                                @endphp
                                                <div class="d-flex justify-content-between">
                                                    <span>{{ $center->name }}</span>
                                                    <span class="badge {{ $utilization > 100 ? 'bg-danger' : 'bg-warning' }}">{{ number_format($utilization, 1) }}%</span>
                                                </div>
                                            @endforeach
                                        @else
                                            <p class="text-muted">لا توجد مراكز بموازنات محددة</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-building fa-5x text-muted mb-3"></i>
                            <h4 class="text-muted">لا توجد مراكز تكلفة</h4>
                            <p class="text-muted">ابدأ بإضافة أول مركز تكلفة للنظام</p>
                            <a href="{{ route('accounting.cost-centers.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> إضافة مركز تكلفة
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد الحذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من حذف مركز التكلفة؟ لا يمكن التراجع عن هذا الإجراء.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">حذف نهائي</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function deleteCostCenter(costCenterId) {
    const deleteForm = document.getElementById('deleteForm');
    deleteForm.action = `/accounting/cost-centers/${costCenterId}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}

// إضافة تفاعل لأشرطة التقدم
$(document).ready(function() {
    $('.progress-bar').each(function() {
        const $this = $(this);
        const width = $this.css('width');
        $this.css('width', '0%').animate({
            width: width
        }, 1000);
    });
});
</script>
@endpush