@extends('layouts.app')

@section('title', 'إضافة مركز تكلفة جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-plus-circle"></i>
                        إضافة مركز تكلفة جديد
                    </h3>
                    <a href="{{ route('accounting.cost-centers.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route('accounting.cost-centers.store') }}">
                        @csrf
                        
                        <div class="row">
                            <!-- رمز مركز التكلفة -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="code" class="form-label">رمز مركز التكلفة <span class="text-danger">*</span></label>
                                    <input type="text" name="code" id="code" 
                                           class="form-control @error('code') is-invalid @enderror"
                                           value="{{ old('code') }}" required 
                                           placeholder="مثال: CC001">
                                    @error('code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">رمز فريد لمركز التكلفة</div>
                                </div>
                            </div>

                            <!-- اسم مركز التكلفة -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">اسم مركز التكلفة <span class="text-danger">*</span></label>
                                    <input type="text" name="name" id="name"
                                           class="form-control searchable-input @error('name') is-invalid @enderror"
                                           value="{{ old('name') }}" required
                                           placeholder="مثال: قسم المبيعات"
                                           list="cost-center-names-list"
                                           autocomplete="off">
                                    <datalist id="cost-center-names-list">
                                        @if(isset($existingCostCenters))
                                            @foreach($existingCostCenters as $costCenter)
                                                <option value="{{ $costCenter->name }}">{{ $costCenter->code }} - {{ $costCenter->name }}</option>
                                            @endforeach
                                        @endif
                                    </datalist>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">ابدأ بالكتابة للبحث في أسماء مراكز التكلفة الموجودة</div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- نوع مركز التكلفة -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">نوع مركز التكلفة <span class="text-danger">*</span></label>
                                    <select name="type" id="type" class="form-select @error('type') is-invalid @enderror" required>
                                        <option value="">اختر نوع مركز التكلفة</option>
                                        <option value="department" {{ old('type') == 'department' ? 'selected' : '' }}>
                                            قسم (Department)
                                        </option>
                                        <option value="project" {{ old('type') == 'project' ? 'selected' : '' }}>
                                            مشروع (Project)
                                        </option>
                                        <option value="branch" {{ old('type') == 'branch' ? 'selected' : '' }}>
                                            فرع (Branch)
                                        </option>
                                        <option value="activity" {{ old('type') == 'activity' ? 'selected' : '' }}>
                                            نشاط (Activity)
                                        </option>
                                        <option value="service" {{ old('type') == 'service' ? 'selected' : '' }}>
                                            خدمة (Service)
                                        </option>
                                    </select>
                                    @error('type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- مركز التكلفة الأب -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="parent_id" class="form-label">مركز التكلفة الأب</label>
                                    <select name="parent_id" id="parent_id"
                                            class="form-select searchable-select @error('parent_id') is-invalid @enderror"
                                            style="width: 100%;">
                                        <option value="">مركز تكلفة رئيسي (بدون أب)</option>
                                        @foreach($parentCostCenters as $costCenter)
                                            <option value="{{ $costCenter->id }}" {{ old('parent_id') == $costCenter->id ? 'selected' : '' }}>
                                                {{ $costCenter->code }} - {{ $costCenter->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('parent_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">ابحث واختر مركز التكلفة الأب</div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- المدير المسؤول -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="manager_name" class="form-label">المدير المسؤول</label>
                                    <input type="text" name="manager_name" id="manager_name" 
                                           class="form-control @error('manager_name') is-invalid @enderror"
                                           value="{{ old('manager_name') }}" 
                                           placeholder="اسم المدير المسؤول">
                                    @error('manager_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- الهاتف -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="phone" class="form-label">الهاتف</label>
                                    <input type="text" name="phone" id="phone" 
                                           class="form-control @error('phone') is-invalid @enderror"
                                           value="{{ old('phone') }}" 
                                           placeholder="رقم الهاتف">
                                    @error('phone')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- الوصف -->
                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف</label>
                            <textarea name="description" id="description" rows="3" 
                                      class="form-control @error('description') is-invalid @enderror"
                                      placeholder="وصف مفصل لمركز التكلفة">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- إعدادات الميزانية -->
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-calculator"></i>
                                    إعدادات الميزانية
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="budget_amount" class="form-label">الميزانية السنوية</label>
                                            <div class="input-group">
                                                <input type="number" name="budget_amount" id="budget_amount" 
                                                       step="0.01" min="0" class="form-control @error('budget_amount') is-invalid @enderror"
                                                       value="{{ old('budget_amount') }}" 
                                                       placeholder="0.00">
                                                <span class="input-group-text">ريال</span>
                                            </div>
                                            @error('budget_amount')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="budget_period" class="form-label">فترة الميزانية</label>
                                            <select name="budget_period" id="budget_period" class="form-select">
                                                <option value="monthly" {{ old('budget_period', 'monthly') == 'monthly' ? 'selected' : '' }}>
                                                    شهرية
                                                </option>
                                                <option value="quarterly" {{ old('budget_period') == 'quarterly' ? 'selected' : '' }}>
                                                    ربع سنوية
                                                </option>
                                                <option value="annual" {{ old('budget_period') == 'annual' ? 'selected' : '' }}>
                                                    سنوية
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="actual_amount" class="form-label">المبلغ الفعلي المنفق</label>
                                            <div class="input-group">
                                                <input type="number" name="actual_amount" id="actual_amount" 
                                                       step="0.01" min="0" class="form-control @error('actual_amount') is-invalid @enderror"
                                                       value="{{ old('actual_amount', '0') }}" 
                                                       placeholder="0.00">
                                                <span class="input-group-text">ريال</span>
                                            </div>
                                            @error('actual_amount')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="variance_threshold" class="form-label">حد التنبيه للانحراف (%)</label>
                                            <div class="input-group">
                                                <input type="number" name="variance_threshold" id="variance_threshold" 
                                                       step="1" min="0" max="100" class="form-control"
                                                       value="{{ old('variance_threshold', '10') }}" 
                                                       placeholder="10">
                                                <span class="input-group-text">%</span>
                                            </div>
                                            <div class="form-text">تنبيه عند تجاوز هذه النسبة من الميزانية</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- الإعدادات العامة -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-cogs"></i>
                                    الإعدادات العامة
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="is_active" id="is_active" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('is_active', '1') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_active">
                                                مركز تكلفة نشط
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="allow_budget_exceeded" id="allow_budget_exceeded" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('allow_budget_exceeded') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="allow_budget_exceeded">
                                                السماح بتجاوز الميزانية
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="requires_approval" id="requires_approval" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('requires_approval') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="requires_approval">
                                                يتطلب موافقة للمصروفات
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="track_performance" id="track_performance" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('track_performance', '1') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="track_performance">
                                                تتبع الأداء
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- أزرار الحفظ -->
                        <div class="d-flex justify-content-between mt-4">
                            <div>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ مركز التكلفة
                                </button>
                                <button type="submit" name="save_and_new" value="1" class="btn btn-success">
                                    <i class="fas fa-plus"></i> حفظ وإضافة جديد
                                </button>
                            </div>
                            <a href="{{ route('accounting.cost-centers.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const budgetAmount = document.getElementById('budget_amount');
    const actualAmount = document.getElementById('actual_amount');
    const varianceThreshold = document.getElementById('variance_threshold');
    const codeInput = document.getElementById('code');
    const nameInput = document.getElementById('name');
    const costCenterNamesList = document.getElementById('cost-center-names-list');

    // Initialize Select2 for parent cost center field
    $('#parent_id').select2({
        theme: 'bootstrap-5',
        placeholder: 'ابحث عن مركز التكلفة الأب...',
        allowClear: true,
        language: {
            noResults: function() {
                return "لا توجد نتائج";
            },
            searching: function() {
                return "جاري البحث...";
            },
            inputTooShort: function(args) {
                return "أدخل " + (args.minimum - args.input.length) + " أحرف أو أكثر";
            }
        },
        escapeMarkup: function(markup) {
            return markup;
        }
    });

    // Enhanced search functionality for cost center name field
    nameInput.addEventListener('input', function() {
        const query = this.value.toLowerCase();
        if (query.length >= 2) {
            // Filter datalist options based on input
            const options = costCenterNamesList.querySelectorAll('option');
            options.forEach(option => {
                const text = option.textContent.toLowerCase();
                option.style.display = text.includes(query) ? 'block' : 'none';
            });
        }
    });

    // Add autocomplete styling and behavior
    nameInput.addEventListener('focus', function() {
        this.setAttribute('placeholder', 'ابدأ بالكتابة للبحث في أسماء مراكز التكلفة...');
    });

    nameInput.addEventListener('blur', function() {
        this.setAttribute('placeholder', 'مثال: قسم المبيعات');
    });

    // تحديث الحسابات عند تغيير المبالغ
    function updateCalculations() {
        const budget = parseFloat(budgetAmount.value) || 0;
        const actual = parseFloat(actualAmount.value) || 0;
        const threshold = parseFloat(varianceThreshold.value) || 0;

        if (budget > 0) {
            const variance = ((actual - budget) / budget) * 100;
            const warningThreshold = threshold;

            // إظهار تحذير إذا تجاوز الحد المسموح
            if (variance > warningThreshold) {
                showVarianceWarning(variance);
            } else {
                hideVarianceWarning();
            }
        }
    }

    function showVarianceWarning(variance) {
        const existingWarning = document.getElementById('variance-warning');
        if (existingWarning) {
            existingWarning.remove();
        }

        const warning = document.createElement('div');
        warning.id = 'variance-warning';
        warning.className = 'alert alert-warning mt-2';
        warning.innerHTML = `
            <i class="fas fa-exclamation-triangle"></i>
            <strong>تحذير:</strong> الانحراف عن الميزانية ${variance.toFixed(2)}%
        `;

        actualAmount.parentNode.appendChild(warning);
    }

    function hideVarianceWarning() {
        const warning = document.getElementById('variance-warning');
        if (warning) {
            warning.remove();
        }
    }

    // ربط الأحداث
    budgetAmount.addEventListener('input', updateCalculations);
    actualAmount.addEventListener('input', updateCalculations);
    varianceThreshold.addEventListener('input', updateCalculations);

    // تنسيق رمز مركز التكلفة
    codeInput.addEventListener('input', function() {
        this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
    });

    // التحقق من صحة النموذج
    const form = document.querySelector('form');
    form.addEventListener('submit', function(e) {
        const code = codeInput.value;
        const name = document.getElementById('name').value;
        const type = document.getElementById('type').value;

        if (!code || !name || !type) {
            e.preventDefault();
            showValidationModal('حقول مطلوبة', 'يرجى ملء جميع الحقول المطلوبة', 'warning');
            return;
        }

        if (code.length < 2) {
            e.preventDefault();
            showValidationModal('رمز غير صحيح', 'رمز مركز التكلفة يجب أن يكون على الأقل حرفين', 'danger');
            return;
        }
    });

    // حساب أولي
    updateCalculations();
});

// دالة عرض رسائل التحقق في modal
function showValidationModal(title, message, type = 'warning') {
    const iconClass = type === 'danger' ? 'fas fa-exclamation-triangle' :
                     type === 'warning' ? 'fas fa-exclamation-circle' :
                     'fas fa-info-circle';
    
    const modalHtml = `
        <div class="modal fade" id="validationModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header bg-${type} text-white">
                        <h5 class="modal-title">
                            <i class="${iconClass}"></i>
                            ${title}
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-${type} border-0">
                            <i class="${iconClass} me-2"></i>
                            ${message}
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-check"></i>
                            فهمت
                        </button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // إزالة modal سابق إن وجد
    const existingModal = document.getElementById('validationModal');
    if (existingModal) {
        existingModal.remove();
    }
    
    // إضافة modal جديد
    document.body.insertAdjacentHTML('beforeend', modalHtml);
    
    // عرض modal
    const modal = new bootstrap.Modal(document.getElementById('validationModal'));
    modal.show();
    
    // إزالة modal بعد إغلاقه
    document.getElementById('validationModal').addEventListener('hidden.bs.modal', function() {
        this.remove();
    });
}
</script>
@endsection

@section('styles')
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<style>
.form-label {
    font-weight: 600;
    color: #495057;
}

.form-control:focus,
.form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.form-check-input:checked {
    background-color: #0d6efd;
    border-color: #0d6efd;
}

.card {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

.btn {
    font-weight: 500;
}

.form-text {
    font-size: 0.875em;
    color: #6c757d;
}

.input-group-text {
    background-color: #f8f9fa;
    border-color: #ced4da;
}

.alert {
    border-radius: 0.375rem;
}

#variance-warning {
    font-size: 0.875rem;
}

.searchable-input {
    position: relative;
}

.searchable-input:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.searchable-select {
    min-height: 38px;
}

/* Select2 custom styling */
.select2-container--bootstrap-5 .select2-selection {
    min-height: 38px;
    border: 1px solid #ced4da;
}

.select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
    padding-left: 12px;
    padding-right: 20px;
    color: #495057;
    line-height: 36px;
}

.select2-container--bootstrap-5 .select2-selection--single .select2-selection__arrow {
    height: 36px;
    right: 3px;
}

.select2-container--bootstrap-5.select2-container--focus .select2-selection {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.select2-dropdown {
    border: 1px solid #ced4da;
    border-radius: 0.375rem;
}

.select2-search--dropdown .select2-search__field {
    border: 1px solid #ced4da;
    border-radius: 0.25rem;
    padding: 6px 12px;
}

.select2-results__option {
    padding: 8px 12px;
}

.select2-results__option--highlighted {
    background-color: #0d6efd;
    color: white;
}

/* Datalist styling */
datalist {
    position: absolute;
    background-color: white;
    border: 1px solid #ced4da;
    border-radius: 0.375rem;
    max-height: 200px;
    overflow-y: auto;
    z-index: 1000;
}
</style>
@endsection