@extends('layouts.app')

@section('title', 'تحليل موازنة مركز التكلفة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Cost Center Header -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-chart-line"></i> تحليل موازنة مركز التكلفة: {{ $costCenter->name }}
                    </h5>
                    <div>
                        <button type="button" class="btn btn-outline-primary" onclick="window.print()">
                            <i class="fas fa-print"></i> طباعة التقرير
                        </button>
                        <a href="{{ route('accounting.cost-centers.show', $costCenter) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للمركز
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">كود المركز:</th>
                                    <td><span class="badge bg-primary fs-6">{{ $costCenter->code }}</span></td>
                                </tr>
                                <tr>
                                    <th>اسم المركز:</th>
                                    <td><strong>{{ $costCenter->name }}</strong></td>
                                </tr>
                                <tr>
                                    <th>المسؤول:</th>
                                    <td>{{ $costCenter->manager ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>فترة التحليل:</th>
                                    <td><strong>{{ $year }}</strong></td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <table class="table table-borderless">
                                @php
                                    $budgetAmount = $costCenter->budget_amount ?: 0;
                                    $utilization = $budgetAmount > 0 ? ($actualAmount / $budgetAmount) * 100 : 0;
                                    $remaining = $budgetAmount - $actualAmount;
                                @endphp
                                <tr>
                                    <th width="30%">الموازنة المخططة:</th>
                                    <td>
                                        @if($budgetAmount > 0)
                                            <span class="text-primary">{{ number_format($budgetAmount, 2) }} ريال</span>
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>المبلغ الفعلي:</th>
                                    <td>
                                        <span class="{{ $actualAmount >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($actualAmount, 2) }} ريال
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>نسبة الاستغلال:</th>
                                    <td>
                                        @if($budgetAmount > 0)
                                            @if($utilization <= 80)
                                                <span class="badge bg-success fs-6">{{ number_format($utilization, 1) }}%</span>
                                            @elseif($utilization <= 100)
                                                <span class="badge bg-warning fs-6">{{ number_format($utilization, 1) }}%</span>
                                            @else
                                                <span class="badge bg-danger fs-6">{{ number_format($utilization, 1) }}%</span>
                                            @endif
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>المتبقي:</th>
                                    <td>
                                        @if($budgetAmount > 0)
                                            <span class="{{ $remaining >= 0 ? 'text-success' : 'text-danger' }}">
                                                {{ number_format($remaining, 2) }} ريال
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($budgetAmount > 0)
                    <!-- Budget Progress -->
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>تقدم الموازنة:</h6>
                            <div class="progress" style="height: 30px;">
                                @php
                                    $progressPercent = min(100, $utilization);
                                    $progressClass = $utilization <= 80 ? 'bg-success' : ($utilization <= 100 ? 'bg-warning' : 'bg-danger');
                                @endphp
                                <div class="progress-bar {{ $progressClass }}" role="progressbar" 
                                     style="width: {{ $progressPercent }}%">
                                    {{ number_format($utilization, 1) }}%
                                </div>
                            </div>
                            <div class="d-flex justify-content-between mt-2">
                                <small class="text-muted">0 ريال</small>
                                <small class="text-muted">{{ number_format($budgetAmount, 2) }} ريال</small>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Monthly Analysis -->
            @if($budgetAmount > 0 && $monthlyData->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar"></i> التحليل الشهري للعام {{ $year }}
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th>الشهر</th>
                                    <th>الموازنة الشهرية</th>
                                    <th>المبلغ الفعلي</th>
                                    <th>الفرق</th>
                                    <th>النسبة</th>
                                    <th>التراكمي المخطط</th>
                                    <th>التراكمي الفعلي</th>
                                    <th>أداء التراكمي</th>
                                </tr>
                            <tbody>
                                @php
                                    $monthlyBudget = $budgetAmount / 12;
                                    $months = [
                                        1 => 'يناير', 2 => 'فبراير', 3 => 'مارس', 4 => 'إبريل',
                                        5 => 'مايو', 6 => 'يونيو', 7 => 'يوليو', 8 => 'أغسطس',
                                        9 => 'سبتمبر', 10 => 'أكتوبر', 11 => 'نوفمبر', 12 => 'ديسمبر'
                                    ];
                                    $cumulativeBudget = 0;
                                    $cumulativeActual = 0;
                                @endphp
                                @for($month = 1; $month <= 12; $month++)
                                    @php
                                        $monthData = $monthlyData->where('month', $month)->first();
                                        $monthlyActualAmount = $monthData ? $monthData->total_amount : 0;
                                        $difference = $monthlyBudget - $monthlyActualAmount;
                                        $percentage = $monthlyBudget > 0 ? ($monthlyActualAmount / $monthlyBudget) * 100 : 0;
                                        
                                        $cumulativeBudget += $monthlyBudget;
                                        $cumulativeActual += $monthlyActualAmount;
                                        $cumulativePerformance = $cumulativeBudget > 0 ? ($cumulativeActual / $cumulativeBudget) * 100 : 0;
                                    @endphp
                                    <tr>
                                        <td><strong>{{ $months[$month] }}</strong></td>
                                        <td>{{ number_format($monthlyBudget, 2) }}</td>
                                        <td>
                                            <span class="{{ $monthlyActualAmount > 0 ? 'text-success' : 'text-muted' }}">
                                                {{ number_format($monthlyActualAmount, 2) }}
                                            </span>
                                        </td>
                                        <td>
                                            <span class="{{ $difference >= 0 ? 'text-success' : 'text-danger' }}">
                                                {{ $difference >= 0 ? '+' : '' }}{{ number_format($difference, 2) }}
                                            </span>
                                        </td>
                                        <td>
                                            @if($percentage <= 80)
                                                <span class="badge bg-success">{{ number_format($percentage, 1) }}%</span>
                                            @elseif($percentage <= 100)
                                                <span class="badge bg-warning">{{ number_format($percentage, 1) }}%</span>
                                            @else
                                                <span class="badge bg-danger">{{ number_format($percentage, 1) }}%</span>
                                            @endif
                                        </td>
                                        <td class="text-info">{{ number_format($cumulativeBudget, 2) }}</td>
                                        <td class="text-primary">{{ number_format($cumulativeActual, 2) }}</td>
                                        <td>
                                            @if($cumulativePerformance <= 80)
                                                <span class="badge bg-success">{{ number_format($cumulativePerformance, 1) }}%</span>
                                            @elseif($cumulativePerformance <= 100)
                                                <span class="badge bg-warning">{{ number_format($cumulativePerformance, 1) }}%</span>
                                            @else
                                                <span class="badge bg-danger">{{ number_format($cumulativePerformance, 1) }}%</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endfor
                            </tbody>
                            <tfoot class="table-secondary">
                                <tr>
                                    <th>الإجمالي</th>
                                    <th>{{ number_format($budgetAmount, 2) }}</th>
                                    <th>{{ number_format($actualAmount, 2) }}</th>
                                    <th>{{ number_format($budgetAmount - $actualAmount, 2) }}</th>
                                    <th>
                                        @if($utilization <= 80)
                                            <span class="badge bg-success">{{ number_format($utilization, 1) }}%</span>
                                        @elseif($utilization <= 100)
                                            <span class="badge bg-warning">{{ number_format($utilization, 1) }}%</span>
                                        @else
                                            <span class="badge bg-danger">{{ number_format($utilization, 1) }}%</span>
                                        @endif
                                    </th>
                                    <th>{{ number_format($budgetAmount, 2) }}</th>
                                    <th>{{ number_format($actualAmount, 2) }}</th>
                                    <th>
                                        @if($utilization <= 80)
                                            <span class="badge bg-success">{{ number_format($utilization, 1) }}%</span>
                                        @elseif($utilization <= 100)
                                            <span class="badge bg-warning">{{ number_format($utilization, 1) }}%</span>
                                        @else
                                            <span class="badge bg-danger">{{ number_format($utilization, 1) }}%</span>
                                        @endif
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            @endif

            <!-- Recent Transactions -->
            @if($recentTransactions->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-history"></i> آخر الحركات على مركز التكلفة ({{ $recentTransactions->count() }} حركة)
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th>التاريخ</th>
                                    <th>رقم القيد</th>
                                    <th>الحساب</th>
                                    <th>البيان</th>
                                    <th>مدين</th>
                                    <th>دائن</th>
                                    <th>الصافي</th>
                                </tr>
                            <tbody>
                                @foreach($recentTransactions as $transaction)
                                <tr>
                                    <td>{{ $transaction->journalEntry->entry_date->format('Y-m-d') }}</td>
                                    <td>
                                        <a href="{{ route('accounting.journal-entries.show', $transaction->journalEntry) }}">
                                            {{ $transaction->journalEntry->entry_number }}
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $transaction->account) }}">
                                            {{ $transaction->account->code }} - {{ $transaction->account->name }}
                                        </a>
                                    </td>
                                    <td>{{ Str::limit($transaction->description, 40) }}</td>
                                    <td class="text-success">
                                        {{ $transaction->debit_amount > 0 ? number_format($transaction->debit_amount, 2) : '-' }}
                                    </td>
                                    <td class="text-danger">
                                        {{ $transaction->credit_amount > 0 ? number_format($transaction->credit_amount, 2) : '-' }}
                                    </td>
                                    <td class="{{ ($transaction->debit_amount - $transaction->credit_amount) >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($transaction->debit_amount - $transaction->credit_amount, 2) }}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="text-center mt-3">
                        <a href="{{ route('accounting.journal-entries.index') }}?cost_center_id={{ $costCenter->id }}" 
                           class="btn btn-outline-primary">
                            عرض جميع حركات مركز التكلفة
                        </a>
                    </div>
                </div>
            </div>
            @endif

            <!-- Analysis Summary -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie"></i> ملخص التحليل والتوصيات
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>النتائج الرئيسية:</h6>
                            <ul class="list-unstyled">
                                @if($budgetAmount > 0)
                                    <li class="mb-2">
                                        <i class="fas fa-circle {{ $utilization <= 80 ? 'text-success' : ($utilization <= 100 ? 'text-warning' : 'text-danger') }}"></i>
                                        <strong>مستوى الأداء:</strong> 
                                        @if($utilization <= 80)
                                            ممتاز - في حدود الموازنة
                                        @elseif($utilization <= 100)
                                            جيد - يقترب من حد الموازنة
                                        @else
                                            تحذير - تجاوز الموازنة المحددة
                                        @endif
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-circle {{ $remaining >= 0 ? 'text-success' : 'text-danger' }}"></i>
                                        <strong>الوضع المالي:</strong> 
                                        @if($remaining >= 0)
                                            يتوفر {{ number_format($remaining, 2) }} ريال من الموازنة
                                        @else
                                            تجاوز الموازنة بمبلغ {{ number_format(abs($remaining), 2) }} ريال
                                        @endif
                                    </li>
                                @else
                                    <li class="mb-2">
                                        <i class="fas fa-circle text-muted"></i>
                                        <strong>لا توجد موازنة محددة</strong> لهذا المركز
                                    </li>
                                @endif
                                <li class="mb-2">
                                    <i class="fas fa-circle text-info"></i>
                                    <strong>عدد الحركات:</strong> {{ $totalTransactions }} حركة خلال {{ $year }}
                                </li>
                                <li class="mb-2">
                                    <i class="fas fa-circle text-primary"></i>
                                    <strong>متوسط شهري:</strong> {{ number_format($actualAmount / 12, 2) }} ريال
                                </li>
                            </ul>
                        </div>

                        <div class="col-md-6">
                            <h6>التوصيات:</h6>
                            <ul class="list-unstyled">
                                @if($budgetAmount == 0)
                                    <li class="mb-2">
                                        <i class="fas fa-lightbulb text-warning"></i>
                                        يُنصح بتحديد موازنة سنوية لهذا المركز لتحسين المراقبة المالية
                                    </li>
                                @elseif($utilization > 100)
                                    <li class="mb-2">
                                        <i class="fas fa-exclamation-triangle text-danger"></i>
                                        يجب مراجعة المصروفات وإعادة تقييم الموازنة
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-search text-info"></i>
                                        تحليل أسباب تجاوز الموازنة واتخاذ إجراءات تصحيحية
                                    </li>
                                @elseif($utilization > 80)
                                    <li class="mb-2">
                                        <i class="fas fa-eye text-warning"></i>
                                        مراقبة دقيقة للمصروفات خلال المدة المتبقية
                                    </li>
                                @else
                                    <li class="mb-2">
                                        <i class="fas fa-thumbs-up text-success"></i>
                                        الأداء ممتاز - استمرار المراقبة الدورية
                                    </li>
                                @endif
                                <li class="mb-2">
                                    <i class="fas fa-chart-line text-primary"></i>
                                    متابعة دورية شهرية لضمان البقاء في حدود الموازنة
                                </li>
                                <li class="mb-2">
                                    <i class="fas fa-file-alt text-info"></i>
                                    توثيق جميع المصروفات بمبررات واضحة
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
@media print {
    .btn, nav, .sidebar {
        display: none !important;
    }
    
    .card {
        border: 1px solid #ddd !important;
        box-shadow: none !important;
        page-break-inside: avoid;
    }
    
    .table {
        font-size: 11px;
    }
    
    .badge {
        border: 1px solid #000;
        color: #000 !important;
        background-color: transparent !important;
    }
    
    body {
        font-size: 12px;
    }
    
    .progress {
        border: 1px solid #000;
    }
    
    .progress-bar {
        background-color: #ccc !important;
    }
}

.progress-bar {
    transition: width 0.6s ease;
}

.table td, .table th {
    vertical-align: middle;
}
</style>
@endpush

@push('scripts')
<script>
// إضافة تفاعل لشريط التقدم
$(document).ready(function() {
    $('.progress-bar').each(function() {
        const $this = $(this);
        const width = $this.css('width');
        $this.css('width', '0%').animate({
            width: width
        }, 1500);
    });
});
</script>
@endpush