@props(['paginator', 'showInfo' => true, 'size' => 'md'])

@if ($paginator->hasPages())
<div class="pagination-wrapper d-flex {{ $showInfo ? 'justify-content-between' : 'justify-content-center' }} align-items-center flex-wrap gap-3">
    @if($showInfo)
    <div class="pagination-info">
        <span class="text-muted">
            <i class="fas fa-info-circle me-1"></i>
            عرض {{ $paginator->firstItem() }} - {{ $paginator->lastItem() }} من أصل {{ $paginator->total() }} عنصر
        </span>
    </div>
    @endif
    
    <nav aria-label="صفحات التنقل">
        <ul class="pagination pagination-{{ $size }} mb-0 simple-pagination">
            {{-- الصفحة الأولى --}}
            @if (!$paginator->onFirstPage())
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->url(1) }}" title="الصفحة الأولى">
                        <i class="fas fa-angle-double-right"></i>
                    </a>
                </li>
            @endif

            {{-- الصفحة السابقة --}}
            @if ($paginator->onFirstPage())
                <li class="page-item disabled">
                    <span class="page-link">
                        <i class="fas fa-chevron-right"></i>
                    </span>
                </li>
            @else
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev" title="الصفحة السابقة">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                </li>
            @endif

            {{-- أرقام الصفحات --}}
            @php
                $start = max($paginator->currentPage() - 2, 1);
                $end = min($start + 4, $paginator->lastPage());
                $start = max($end - 4, 1);
            @endphp

            @if($start > 1)
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->url(1) }}">1</a>
                </li>
                @if($start > 2)
                    <li class="page-item disabled">
                        <span class="page-link">...</span>
                    </li>
                @endif
            @endif

            @for ($i = $start; $i <= $end; $i++)
                @if ($i == $paginator->currentPage())
                    <li class="page-item active">
                        <span class="page-link">{{ $i }}</span>
                    </li>
                @else
                    <li class="page-item">
                        <a class="page-link" href="{{ $paginator->url($i) }}">{{ $i }}</a>
                    </li>
                @endif
            @endfor

            @if($end < $paginator->lastPage())
                @if($end < $paginator->lastPage() - 1)
                    <li class="page-item disabled">
                        <span class="page-link">...</span>
                    </li>
                @endif
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->url($paginator->lastPage()) }}">{{ $paginator->lastPage() }}</a>
                </li>
            @endif

            {{-- الصفحة التالية --}}
            @if ($paginator->hasMorePages())
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next" title="الصفحة التالية">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                </li>
            @else
                <li class="page-item disabled">
                    <span class="page-link">
                        <i class="fas fa-chevron-left"></i>
                    </span>
                </li>
            @endif

            {{-- الصفحة الأخيرة --}}
            @if (!$paginator->hasMorePages())
            @else
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->url($paginator->lastPage()) }}" title="الصفحة الأخيرة">
                        <i class="fas fa-angle-double-left"></i>
                    </a>
                </li>
            @endif
        </ul>
    </nav>
</div>

<style>
.simple-pagination {
    --pagination-bg: #ffffff;
    --pagination-border: #e0e6ed;
    --pagination-color: #74788d;
    --pagination-hover-bg: #f8f9fa;
    --pagination-hover-border: #d1d5db;
    --pagination-active-bg: #556ee6;
    --pagination-active-border: #556ee6;
    --pagination-active-color: #ffffff;
    --pagination-disabled-bg: #f8f9fa;
    --pagination-disabled-color: #adb5bd;
}

.simple-pagination .page-link {
    color: var(--pagination-color);
    background-color: var(--pagination-bg);
    border: 1px solid var(--pagination-border);
    border-radius: 6px;
    margin: 0 2px;
    padding: 8px 12px;
    min-width: 40px;
    text-align: center;
    font-weight: 500;
    transition: all 0.15s ease-in-out;
    text-decoration: none;
    display: flex;
    align-items: center;
    justify-content: center;
}

.simple-pagination .page-item:first-child .page-link,
.simple-pagination .page-item:last-child .page-link {
    border-radius: 6px;
}

.simple-pagination .page-link:hover {
    color: #495057;
    background-color: var(--pagination-hover-bg);
    border-color: var(--pagination-hover-border);
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.08);
}

.simple-pagination .page-item.active .page-link {
    color: var(--pagination-active-color);
    background-color: var(--pagination-active-bg);
    border-color: var(--pagination-active-border);
    font-weight: 600;
    box-shadow: 0 2px 4px rgba(85, 110, 230, 0.3);
}

.simple-pagination .page-item.disabled .page-link {
    color: var(--pagination-disabled-color);
    background-color: var(--pagination-disabled-bg);
    border-color: var(--pagination-border);
    cursor: not-allowed;
}

.pagination-info {
    font-size: 0.875rem;
    color: #74788d;
}

.pagination-wrapper {
    padding: 1rem 0;
    border-top: 1px solid #f0f0f0;
    margin-top: 1rem;
}

/* أحجام مختلفة */
.pagination-sm .page-link {
    padding: 6px 10px;
    min-width: 32px;
    font-size: 0.8rem;
}

.pagination-lg .page-link {
    padding: 10px 16px;
    min-width: 48px;
    font-size: 1rem;
}

/* تصميم متجاوب */
@media (max-width: 768px) {
    .pagination-wrapper {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .simple-pagination .page-link {
        padding: 6px 8px;
        min-width: 32px;
        font-size: 0.85rem;
        margin: 0 1px;
    }
    
    .pagination-info {
        font-size: 0.8rem;
    }
}

@media (max-width: 480px) {
    .simple-pagination {
        flex-wrap: wrap;
        justify-content: center;
    }
    
    .simple-pagination .page-link {
        padding: 4px 6px;
        min-width: 28px;
        font-size: 0.8rem;
    }
}
</style>

@else
<div class="text-center py-3">
    <span class="text-muted">
        <i class="fas fa-list me-1"></i>
        {{ $paginator->total() }} عنصر
    </span>
</div>
@endif