{{-- أمثلة على استخدام مكونات الترقيم --}}

{{-- الاستخدام الأساسي --}}
<x-simple-paginator :paginator="$products" />

{{-- مع إخفاء معلومات العدد --}}
<x-simple-paginator :paginator="$products" :show-info="false" />

{{-- حجم صغير --}}
<x-simple-paginator :paginator="$products" size="sm" />

{{-- حجم كبير --}}
<x-simple-paginator :paginator="$products" size="lg" />

{{-- مع الاحتفاظ بالمعاملات --}}
<x-simple-paginator :paginator="$products->appends(request()->query())" />

{{-- مثال كامل في جدول --}}
<div class="card">
    <div class="card-header">
        <h5>قائمة المنتجات</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>الاسم</th>
                        <th>السعر</th>
                        <th>الحالة</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $product)
                    <tr>
                        <td>{{ $product->name }}</td>
                        <td>{{ $product->price }}</td>
                        <td>{{ $product->status }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        {{-- الترقيم --}}
        <x-simple-paginator :paginator="$products" />
    </div>
</div>