{{-- Modern Pagination Component --}}
@if ($paginator->hasPages())
    <nav role="navigation" aria-label="تنقل الصفحات" class="modern-pagination-nav">
        <ul class="pagination">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="page-item disabled" aria-disabled="true">
                    <span class="page-link" aria-hidden="true">
                        <i class="fas fa-chevron-right"></i>
                    </span>
                </li>
            @else
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev" aria-label="السابق">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                </li>
            @endif

            {{-- Pagination Elements --}}
            @foreach ($elements as $element)
                {{-- "Three Dots" Separator --}}
                @if (is_string($element))
                    <li class="page-item disabled" aria-disabled="true">
                        <span class="page-link dots">{{ $element }}</span>
                    </li>
                @endif

                {{-- Array Of Links --}}
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
                            <li class="page-item active" aria-current="page">
                                <span class="page-link">{{ $page }}</span>
                            </li>
                        @else
                            <li class="page-item">
                                <a class="page-link" href="{{ $url }}">{{ $page }}</a>
                            </li>
                        @endif
                    @endforeach
                @endif
            @endforeach

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next" aria-label="التالي">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                </li>
            @else
                <li class="page-item disabled" aria-disabled="true">
                    <span class="page-link" aria-hidden="true">
                        <i class="fas fa-chevron-left"></i>
                    </span>
                </li>
            @endif
        </ul>
    </nav>
@endif

<style>
    .modern-pagination-nav {
        direction: ltr;
    }

    .modern-pagination-nav .pagination {
        margin: 0;
        padding: 0;
        list-style: none;
        display: flex;
        align-items: center;
        gap: 0.375rem;
    }

    .modern-pagination-nav .page-item {
        margin: 0;
    }

    .modern-pagination-nav .page-link {
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 44px;
        height: 44px;
        padding: 0 0.75rem;
        border: 2px solid var(--surface-gray-200, #e2e8f0);
        border-radius: var(--radius-lg, 12px);
        background: var(--surface-white, #ffffff);
        color: var(--text-secondary, #64748b);
        text-decoration: none;
        font-weight: 600;
        font-size: 0.875rem;
        transition: all 0.2s ease;
        position: relative;
        overflow: hidden;
        cursor: pointer;
    }

    .modern-pagination-nav .page-link::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
        transition: left 0.3s ease;
    }

    .modern-pagination-nav .page-link:hover {
        border-color: var(--report-primary, #2563eb);
        color: var(--report-primary, #2563eb);
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    }

    .modern-pagination-nav .page-link:hover::before {
        left: 100%;
    }

    .modern-pagination-nav .page-item.active .page-link {
        background: linear-gradient(135deg, var(--report-primary, #2563eb) 0%, #1e40af 100%);
        border-color: var(--report-primary, #2563eb);
        color: white;
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        transform: scale(1.05);
    }

    .modern-pagination-nav .page-item.active .page-link:hover {
        transform: scale(1.05) translateY(-1px);
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }

    .modern-pagination-nav .page-item.disabled .page-link {
        background: var(--surface-gray-100, #f1f5f9);
        border-color: var(--surface-gray-200, #e2e8f0);
        color: var(--surface-gray-400, #94a3b8);
        cursor: not-allowed;
        opacity: 0.6;
    }

    .modern-pagination-nav .page-item.disabled .page-link:hover {
        transform: none;
        box-shadow: none;
        border-color: var(--surface-gray-200, #e2e8f0);
        color: var(--surface-gray-400, #94a3b8);
    }

    .modern-pagination-nav .page-link.dots {
        border: none;
        background: transparent;
        cursor: default;
        font-weight: 700;
        color: var(--text-muted, #64748b);
    }

    .modern-pagination-nav .page-link.dots:hover {
        transform: none;
        box-shadow: none;
        color: var(--text-muted, #64748b);
    }

    /* Special styling for first/last navigation buttons */
    .modern-pagination-nav .page-item:first-child .page-link,
    .modern-pagination-nav .page-item:last-child .page-link {
        width: 48px;
        font-size: 1rem;
        background: linear-gradient(135deg, var(--surface-gray-100, #f1f5f9) 0%, var(--surface-white, #ffffff) 100%);
    }

    .modern-pagination-nav .page-item:first-child .page-link:hover,
    .modern-pagination-nav .page-item:last-child .page-link:hover {
        background: linear-gradient(135deg, var(--report-primary, #2563eb) 0%, #1e40af 100%);
        color: white;
    }

    /* Animation for page transitions */
    .modern-pagination-nav .page-link {
        animation: fadeInScale 0.3s ease forwards;
    }

    @keyframes fadeInScale {
        from {
            opacity: 0;
            transform: scale(0.9);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }

    /* Responsive design */
    @media (max-width: 768px) {
        .modern-pagination-nav .page-link {
            min-width: 40px;
            height: 40px;
            font-size: 0.8rem;
        }

        .modern-pagination-nav .page-item:first-child .page-link,
        .modern-pagination-nav .page-item:last-child .page-link {
            width: 44px;
        }
    }

    @media (max-width: 480px) {
        .modern-pagination-nav .pagination {
            gap: 0.25rem;
        }

        .modern-pagination-nav .page-link {
            min-width: 36px;
            height: 36px;
            font-size: 0.75rem;
        }
    }
</style>