@php
    // احصائيات المخزون السريعة
    $totalProducts = \App\Models\Product::count();
    $lowStockProducts = \App\Models\Product::lowStock()->count();
    $outOfStockProducts = \App\Models\Product::where('stock_quantity', '<=', 0)->count();
    $pendingAdjustments = \App\Models\InventoryAdjustment::where('status', 'pending')->count();
    $pendingReceipts = \App\Models\GoodsReceipt::where('status', 'pending')->count();
    $pendingPurchaseOrders = \App\Models\PurchaseOrder::where('status', 'pending')->count();
    
    // حساب قيمة المخزون الإجمالية
    $inventoryValue = \App\Models\Product::all()->sum(function($product) {
        return $product->getCurrentInventoryValue();
    });
    
    // آخر الحركات
    $recentMovements = \App\Models\InventoryMovement::with('product')
        ->latest()
        ->take(5)
        ->get();
@endphp

<div class="row mb-4">
    <div class="col-12">
        <h5 class="mb-3">
            <i class="fas fa-warehouse me-2"></i>
            نظرة عامة على المخزون
        </h5>
    </div>
</div>

<!-- إحصائيات سريعة -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="card bg-primary text-white h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="text-white-75 small">إجمالي المنتجات</div>
                        <div class="text-lg fw-bold">{{ number_format($totalProducts) }}</div>
                    </div>
                    <div>
                        <i class="fas fa-boxes fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex align-items-center justify-content-between small">
                <a class="text-white stretched-link" href="{{ route('inventory.index') }}">عرض التفاصيل</a>
                <div class="text-white"><i class="fas fa-angle-left"></i></div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="card bg-warning text-white h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="text-white-75 small">منتجات منخفضة المخزون</div>
                        <div class="text-lg fw-bold">{{ number_format($lowStockProducts) }}</div>
                    </div>
                    <div>
                        <i class="fas fa-exclamation-triangle fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex align-items-center justify-content-between small">
                <a class="text-white stretched-link" href="{{ route('inventory.index', ['low_stock' => 1]) }}">عرض المنتجات</a>
                <div class="text-white"><i class="fas fa-angle-left"></i></div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="card bg-danger text-white h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="text-white-75 small">منتجات نافدة</div>
                        <div class="text-lg fw-bold">{{ number_format($outOfStockProducts) }}</div>
                    </div>
                    <div>
                        <i class="fas fa-times-circle fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex align-items-center justify-content-between small">
                <a class="text-white stretched-link" href="{{ route('inventory.index', ['out_of_stock' => 1]) }}">عرض المنتجات</a>
                <div class="text-white"><i class="fas fa-angle-left"></i></div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="card bg-success text-white h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="text-white-75 small">قيمة المخزون الإجمالية</div>
                        <div class="text-lg fw-bold">{{ number_format($inventoryValue, 0) }}</div>
                        <div class="text-white-75 small">ر.س</div>
                    </div>
                    <div>
                        <i class="fas fa-money-bill fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex align-items-center justify-content-between small">
                <a class="text-white stretched-link" href="{{ route('inventory.valuation') }}">تقرير التقييم</a>
                <div class="text-white"><i class="fas fa-angle-left"></i></div>
            </div>
        </div>
    </div>
</div>

<!-- إشعارات المهام المعلقة -->
@if($pendingAdjustments > 0 || $pendingReceipts > 0 || $pendingPurchaseOrders > 0)
<div class="row mb-4">
    <div class="col-12">
        <div class="alert alert-warning">
            <h6 class="alert-heading">
                <i class="fas fa-bell me-2"></i>
                مهام تحتاج انتباهك
            </h6>
            <div class="row">
                @if($pendingPurchaseOrders > 0)
                <div class="col-md-4">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-shopping-cart me-2"></i>
                        <a href="{{ route('purchase-orders.index', ['status' => 'pending']) }}" class="text-decoration-none">
                            {{ $pendingPurchaseOrders }} أوامر شراء معلقة
                        </a>
                    </div>
                </div>
                @endif
                
                @if($pendingReceipts > 0)
                <div class="col-md-4">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-dolly me-2"></i>
                        <a href="{{ route('goods-receipts.index', ['status' => 'pending']) }}" class="text-decoration-none">
                            {{ $pendingReceipts }} استلامات معلقة
                        </a>
                    </div>
                </div>
                @endif
                
                @if($pendingAdjustments > 0)
                <div class="col-md-4">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-tools me-2"></i>
                        <a href="{{ route('inventory.adjustments.index', ['status' => 'pending']) }}" class="text-decoration-none">
                            {{ $pendingAdjustments }} تسويات تحتاج موافقة
                        </a>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endif

<!-- آخر حركات المخزون -->
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h6 class="m-0">
                    <i class="fas fa-exchange-alt me-2"></i>
                    آخر حركات المخزون
                </h6>
            </div>
            <div class="card-body">
                @if($recentMovements->count() > 0)
                <div class="table-responsive">
                    <table class="table table-sm">
                            <tr>
                                <th>المنتج</th>
                                <th>النوع</th>
                                <th>الكمية</th>
                                <th>التاريخ</th>
                            </tr>
                        <tbody>
                            @foreach($recentMovements as $movement)
                            <tr>
                                <td>
                                    <small>{{ Str::limit($movement->product->name, 25) }}</small>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $movement->isInbound() ? 'success' : 'warning' }} bg-opacity-75">
                                        @switch($movement->type)
                                            @case('purchase')
                                                شراء
                                                @break
                                            @case('sale')
                                                بيع
                                                @break
                                            @case('adjustment_in')
                                                تسوية +
                                                @break
                                            @case('adjustment_out')
                                                تسوية -
                                                @break
                                            @default
                                                {{ $movement->type }}
                                        @endswitch
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $movement->isInbound() ? 'success' : 'danger' }}">
                                        {{ $movement->isInbound() ? '+' : '-' }}{{ number_format($movement->quantity) }}
                                    </span>
                                </td>
                                <td>
                                    <small class="text-muted">{{ $movement->movement_date->diffForHumans() }}</small>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="text-center">
                    <a href="{{ route('inventory.movements') }}" class="btn btn-outline-primary btn-sm">
                        عرض جميع الحركات
                    </a>
                </div>
                @else
                <div class="text-center text-muted py-3">
                    <i class="fas fa-info-circle me-2"></i>
                    لا توجد حركات مخزون حديثة
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h6 class="m-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    توزيع حالة المخزون
                </h6>
            </div>
            <div class="card-body">
                @php
                    $availableProducts = $totalProducts - $lowStockProducts;
                    $lowStockOnly = $lowStockProducts - $outOfStockProducts;
                @endphp
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="small">متوفر</span>
                        <span class="badge bg-success">{{ $availableProducts }}</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar bg-success" 
                             style="width: {{ $totalProducts > 0 ? ($availableProducts / $totalProducts) * 100 : 0 }}%"></div>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="small">منخفض</span>
                        <span class="badge bg-warning">{{ $lowStockOnly }}</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar bg-warning" 
                             style="width: {{ $totalProducts > 0 ? ($lowStockOnly / $totalProducts) * 100 : 0 }}%"></div>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="small">نافد</span>
                        <span class="badge bg-danger">{{ $outOfStockProducts }}</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar bg-danger" 
                             style="width: {{ $totalProducts > 0 ? ($outOfStockProducts / $totalProducts) * 100 : 0 }}%"></div>
                    </div>
                </div>
                
                <div class="text-center mt-3">
                    <a href="{{ route('inventory.index') }}" class="btn btn-outline-primary btn-sm">
                        عرض تفاصيل المخزون
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>