@extends('layouts.app')

@section('title', 'عرض الفئة: ' . $category->name)
@section('page-title', 'عرض الفئة: ' . $category->name)

@section('page-actions')
<div class="btn-group">
    <a href="{{ route('categories.edit', $category) }}" class="btn btn-warning">
        <i class="fas fa-edit me-2"></i>
        تعديل الفئة
    </a>
    <button type="button" class="btn btn-info dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">
        <span class="visually-hidden">Toggle Dropdown</span>
    </button>
    <ul class="dropdown-menu">
        <li>
            <form method="POST" action="{{ route('categories.toggle-status', $category) }}" class="d-inline">
                @csrf
                <button type="submit" class="dropdown-item">
                    <i class="fas fa-{{ $category->is_active ? 'pause' : 'play' }} me-2"></i>
                    {{ $category->is_active ? 'إلغاء التفعيل' : 'تفعيل' }}
                </button>
            </form>
        </li>
        <li>
            <form method="POST" action="{{ route('categories.duplicate', $category) }}" class="d-inline">
                @csrf
                <button type="submit" class="dropdown-item">
                    <i class="fas fa-copy me-2"></i>
                    نسخ الفئة
                </button>
            </form>
        </li>
        <li><hr class="dropdown-divider"></li>
        <li>
            <a class="dropdown-item" href="{{ route('categories.index') }}">
                <i class="fas fa-list me-2"></i>
                العودة للقائمة
            </a>
        </li>
    </ul>
</div>
@endsection

@section('content')
<div class="row">
    <!-- معلومات الفئة الأساسية -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    معلومات الفئة
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-4">
                            <label class="form-label fw-bold">اسم الفئة</label>
                            <div class="form-control-plaintext">{{ $category->name }}</div>
                        </div>
                        
                        @if($category->name_en)
                        <div class="mb-4">
                            <label class="form-label fw-bold">الاسم بالإنجليزية</label>
                            <div class="form-control-plaintext">{{ $category->name_en }}</div>
                        </div>
                        @endif
                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">رمز الفئة</label>
                            <div class="form-control-plaintext">
                                <code>{{ $category->code }}</code>
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">نوع الفئة</label>
                            <div class="form-control-plaintext">
                                <span class="badge bg-{{ $category->type == 'product' ? 'primary' : ($category->type == 'service' ? 'info' : 'success') }} fs-6">
                                    {{ $category->type_text }}
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="mb-4">
                            <label class="form-label fw-bold">الحالة</label>
                            <div class="form-control-plaintext">
                                <span class="badge bg-{{ $category->status_color }} fs-6">{{ $category->status_text }}</span>
                                @if($category->is_featured)
                                    <span class="badge bg-warning fs-6 ms-2">⭐ مميز</span>
                                @endif
                                @if(!$category->show_on_menu)
                                    <span class="badge bg-secondary fs-6 ms-2">مخفي من القائمة</span>
                                @endif
                            </div>
                        </div>
                        
                        @if($category->parent)
                        <div class="mb-4">
                            <label class="form-label fw-bold">الفئة الأساسية</label>
                            <div class="form-control-plaintext">
                                <a href="{{ route('categories.show', $category->parent) }}" class="text-decoration-none">
                                    <i class="{{ $category->parent->icon }}" style="color: {{ $category->parent->color }};"></i>
                                    {{ $category->parent->name }}
                                </a>
                                <small class="text-muted d-block">المستوى {{ $category->level }}</small>
                            </div>
                        </div>
                        @endif
                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">ترتيب العرض</label>
                            <div class="form-control-plaintext">{{ $category->sort_order }}</div>
                        </div>
                        
                        @if($category->requires_inventory)
                        <div class="mb-4">
                            <label class="form-label fw-bold">إدارة المخزون</label>
                            <div class="form-control-plaintext">
                                <span class="badge bg-info fs-6">
                                    <i class="fas fa-boxes me-1"></i>
                                    تتطلب إدارة مخزون
                                </span>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
                
                @if($category->description)
                <div class="mb-4">
                    <label class="form-label fw-bold">وصف الفئة</label>
                    <div class="form-control-plaintext">{{ $category->description }}</div>
                </div>
                @endif
                
                <!-- الإعدادات المتقدمة -->
                @if($category->default_tax_rate || $category->default_unit)
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">الإعدادات الافتراضية</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @if($category->default_tax_rate)
                            <div class="col-md-6">
                                <label class="form-label fw-bold">معدل الضريبة الافتراضي</label>
                                <div class="form-control-plaintext">{{ $category->default_tax_rate }}%</div>
                            </div>
                            @endif
                            
                            @if($category->default_unit)
                            <div class="col-md-6">
                                <label class="form-label fw-bold">الوحدة الافتراضية</label>
                                <div class="form-control-plaintext">{{ $category->default_unit }}</div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
                
                <!-- معلومات SEO -->
                @if($category->meta_title || $category->meta_description || $category->meta_keywords)
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-search me-2"></i>
                            معلومات SEO
                        </h6>
                    </div>
                    <div class="card-body">
                        @if($category->meta_title)
                        <div class="mb-3">
                            <label class="form-label fw-bold">عنوان SEO</label>
                            <div class="form-control-plaintext">{{ $category->meta_title }}</div>
                        </div>
                        @endif
                        
                        @if($category->meta_description)
                        <div class="mb-3">
                            <label class="form-label fw-bold">وصف SEO</label>
                            <div class="form-control-plaintext">{{ $category->meta_description }}</div>
                        </div>
                        @endif
                        
                        @if($category->meta_keywords)
                        <div class="mb-3">
                            <label class="form-label fw-bold">الكلمات المفتاحية</label>
                            <div class="form-control-plaintext">
                                @if(is_array($category->meta_keywords))
                                    @foreach($category->meta_keywords as $keyword)
                                        <span class="badge bg-light text-dark me-1">{{ $keyword }}</span>
                                    @endforeach
                                @else
                                    {{ $category->meta_keywords }}
                                @endif
                            </div>
                        </div>
                        @endif
                        
                        <div>
                            <label class="form-label fw-bold">الرابط الصديق</label>
                            <div class="form-control-plaintext">
                                <code>{{ $category->slug }}</code>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
        
        <!-- الفئات الفرعية -->
        @if($category->children->count() > 0)
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-sitemap me-2"></i>
                    الفئات الفرعية ({{ $category->children->count() }})
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($category->children as $child)
                    <div class="col-md-6 mb-3">
                        <div class="card border">
                            <div class="card-body p-3">
                                <div class="d-flex align-items-start">
                                    <div class="me-3">
                                        @if($child->image)
                                            <img src="{{ Storage::url($child->image) }}" alt="{{ $child->name }}"
                                                 class="rounded" style="width: 40px; height: 40px; object-fit: cover;">
                                        @else
                                            <div class="rounded d-flex align-items-center justify-content-center"
                                                 style="width: 40px; height: 40px; background-color: {{ $child->color }}20; border: 1px solid {{ $child->color }};">
                                                <i class="{{ $child->icon }}" style="color: {{ $child->color }};"></i>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">
                                            <a href="{{ route('categories.show', $child) }}" class="text-decoration-none">
                                                {{ $child->name }}
                                            </a>
                                        </h6>
                                        <small class="text-muted">
                                            {{ $child->products_count }} منتج
                                            @if($child->children->count() > 0)
                                                | {{ $child->children->count() }} فرعي
                                            @endif
                                        </small>
                                        <div class="mt-1">
                                            <span class="badge bg-{{ $child->is_active ? 'success' : 'secondary' }} badge-sm">
                                                {{ $child->status_text }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif
        
        <!-- المنتجات -->
        @if($category->products->count() > 0)
        <div class="card mt-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-boxes me-2"></i>
                    المنتجات ({{ $category->products->count() }})
                </h5>
                <a href="{{ route('products.index', ['category_id' => $category->id]) }}" class="btn btn-sm btn-outline-primary">
                    عرض الكل
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>المنتج</th>
                                <th>النوع</th>
                                <th>السعر</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($category->products->take(10) as $product)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($product->image_url)
                                            <img src="{{ $product->image_url }}" alt="{{ $product->name }}"
                                                 class="rounded me-2" style="width: 30px; height: 30px; object-fit: cover;">
                                        @else
                                            <div class="bg-light rounded me-2 d-flex align-items-center justify-content-center"
                                                 style="width: 30px; height: 30px;">
                                                <i class="fas fa-box text-muted"></i>
                                            </div>
                                        @endif
                                        <div>
                                            <strong>{{ $product->name }}</strong>
                                            @if($product->sku)
                                                <br><small class="text-muted">{{ $product->sku }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $product->type == 'product' ? 'primary' : 'info' }}">
                                        {{ $product->type == 'product' ? 'منتج' : 'خدمة' }}
                                    </span>
                                </td>
                                <td>{{ number_format($product->price, 2) }} ر.س</td>
                                <td>
                                    <span class="badge bg-{{ $product->is_active ? 'success' : 'secondary' }}">
                                        {{ $product->is_active ? 'نشط' : 'غير نشط' }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('products.show', $product) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                @if($category->products->count() > 10)
                <div class="text-center mt-3">
                    <a href="{{ route('products.index', ['category_id' => $category->id]) }}" class="btn btn-outline-primary">
                        <i class="fas fa-eye me-2"></i>
                        عرض جميع المنتجات ({{ $category->products->count() }})
                    </a>
                </div>
                @endif
            </div>
        </div>
        @endif
    </div>
    
    <!-- الشريط الجانبي -->
    <div class="col-lg-4">
        <!-- معاينة الفئة -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-eye me-2"></i>
                    معاينة الفئة
                </h6>
            </div>
            <div class="card-body text-center">
                <div class="mb-3">
                    @if($category->image)
                        <img src="{{ Storage::url($category->image) }}" alt="{{ $category->name }}"
                             class="rounded" style="width: 100px; height: 100px; object-fit: cover;">
                    @else
                        <div class="rounded d-inline-flex align-items-center justify-content-center"
                             style="width: 100px; height: 100px; background-color: {{ $category->color }}20; border: 2px solid {{ $category->color }};">
                            <i class="{{ $category->icon }}" style="color: {{ $category->color }}; font-size: 2.5rem;"></i>
                        </div>
                    @endif
                </div>
                <h5>{{ $category->name }}</h5>
                @if($category->name_en)
                    <p class="text-muted">{{ $category->name_en }}</p>
                @endif
                @if($category->description)
                    <p class="text-muted small">{{ $category->description }}</p>
                @endif
                <div class="d-flex justify-content-center gap-2">
                    <span class="badge bg-{{ $category->type == 'product' ? 'primary' : ($category->type == 'service' ? 'info' : 'success') }}">
                        {{ $category->type_text }}
                    </span>
                    <span class="badge bg-{{ $category->status_color }}">{{ $category->status_text }}</span>
                </div>
            </div>
        </div>
        
        <!-- الإحصائيات -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    الإحصائيات
                </h6>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6 mb-3">
                        <h4 class="text-primary mb-1">{{ $stats['products_count'] }}</h4>
                        <small class="text-muted">إجمالي المنتجات</small>
                    </div>
                    <div class="col-6 mb-3">
                        <h4 class="text-success mb-1">{{ $stats['active_products'] }}</h4>
                        <small class="text-muted">منتج نشط</small>
                    </div>
                    <div class="col-6 mb-3">
                        <h4 class="text-info mb-1">{{ $stats['children_count'] }}</h4>
                        <small class="text-muted">فئة فرعية</small>
                    </div>
                    <div class="col-6 mb-3">
                        <h4 class="text-warning mb-1">{{ $stats['descendants_count'] }}</h4>
                        <small class="text-muted">إجمالي الفروع</small>
                    </div>
                </div>
                
                @if($stats['total_sales'] > 0)
                <hr>
                <div class="text-center">
                    <h5 class="text-success">{{ number_format($stats['total_sales'], 2) }} ر.س</h5>
                    <small class="text-muted">إجمالي المبيعات</small>
                </div>
                @endif
                
                <hr>
                <div class="text-center">
                    <h6 class="text-info">{{ number_format($stats['views_count']) }}</h6>
                    <small class="text-muted">مشاهدة</small>
                </div>
            </div>
        </div>
        
        <!-- المسار الهرمي -->
        @if($category->breadcrumb && count($category->breadcrumb) > 1)
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-sitemap me-2"></i>
                    المسار الهرمي
                </h6>
            </div>
            <div class="card-body">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        @foreach($category->breadcrumb as $crumb)
                            @if($loop->last)
                                <li class="breadcrumb-item active">{{ $crumb['name'] }}</li>
                            @else
                                <li class="breadcrumb-item">
                                    <a href="{{ route('categories.show', $crumb['id']) }}">{{ $crumb['name'] }}</a>
                                </li>
                            @endif
                        @endforeach
                    </ol>
                </nav>
            </div>
        </div>
        @endif
        
        <!-- معلومات إضافية -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    معلومات إضافية
                </h6>
            </div>
            <div class="card-body">
                <div class="small">
                    <div class="mb-2">
                        <strong>تاريخ الإنشاء:</strong><br>
                        {{ $category->created_at->format('d/m/Y H:i') }}
                    </div>
                    <div class="mb-2">
                        <strong>آخر تحديث:</strong><br>
                        {{ $category->updated_at->format('d/m/Y H:i') }}
                    </div>
                    @if($category->last_activity_at)
                    <div class="mb-2">
                        <strong>آخر نشاط:</strong><br>
                        {{ $category->last_activity_at->format('d/m/Y H:i') }}
                    </div>
                    @endif
                    @if($category->creator)
                    <div class="mb-2">
                        <strong>أنشئ بواسطة:</strong><br>
                        {{ $category->creator->name }}
                    </div>
                    @endif
                    @if($category->updater && $category->updater->id !== $category->creator?->id)
                    <div>
                        <strong>آخر تحديث بواسطة:</strong><br>
                        {{ $category->updater->name }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- إجراءات سريعة -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    إجراءات سريعة
                </h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('categories.edit', $category) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit me-2"></i>
                        تعديل الفئة
                    </a>
                    
                    @if($category->products_count == 0)
                    <a href="{{ route('products.create', ['category_id' => $category->id]) }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-2"></i>
                        إضافة منتج
                    </a>
                    @endif
                    
                    <a href="{{ route('categories.create', ['parent_id' => $category->id]) }}" class="btn btn-info btn-sm">
                        <i class="fas fa-plus me-2"></i>
                        إضافة فئة فرعية
                    </a>
                    
                    <form method="POST" action="{{ route('categories.duplicate', $category) }}" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-secondary btn-sm w-100">
                            <i class="fas fa-copy me-2"></i>
                            نسخ الفئة
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// يمكن إضافة أي سكريبت خاص بصفحة العرض هنا
</script>
@endpush