@extends('layouts.app')

@section('title', 'إدارة الفئات')
@section('page-title', 'إدارة الفئات')

@section('page-actions')
<a href="{{ route('categories.create') }}" class="btn btn-primary">
    <i class="fas fa-plus me-2"></i>
    إضافة فئة جديدة
</a>
@endsection

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="fas fa-folder me-2"></i>
            قائمة الفئات
        </h5>
        
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="toggleFilters()">
                <i class="fas fa-filter me-1"></i>
                البحث
            </button>
        </div>
    </div>
    
    <!-- نموذج البحث -->
    <div class="card-body border-bottom" id="filters-section" style="display: none;">
        <form method="GET" action="{{ route('categories.index') }}" class="row g-3">
            <div class="col-md-8">
                <label class="form-label">البحث في أسماء الفئات</label>
                <div class="input-group">
                    <input type="text" name="search" class="form-control"
                           placeholder="ابحث عن اسم الفئة" value="{{ request('search') }}">
                    <button type="submit" class="btn btn-outline-secondary">
                        <i class="fas fa-search"></i>
                    </button>
                    @if(request('search'))
                        <a href="{{ route('categories.index') }}" class="btn btn-outline-danger">
                            <i class="fas fa-times"></i>
                        </a>
                    @endif
                </div>
            </div>
        </form>
    </div>
    
    <div class="card-body">
        @if($categories->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="60">#</th>
                            <th>اسم الفئة</th>
                            <th width="150">تاريخ الإنشاء</th>
                            <th width="200" class="text-center">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($categories as $index => $category)
                        <tr>
                            <td>{{ $categories->firstItem() + $index }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="me-3">
                                        <div class="rounded d-flex align-items-center justify-content-center bg-primary bg-opacity-10"
                                             style="width: 40px; height: 40px;">
                                            <i class="fas fa-folder text-primary"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <strong>{{ $category->name }}</strong>
                                        @if($category->products_count > 0)
                                            <br><small class="text-muted">{{ $category->products_count }} منتج</small>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td>
                                <small class="text-muted">{{ $category->created_at->format('d/m/Y') }}</small>
                                <br><small class="text-muted">{{ $category->created_at->format('H:i') }}</small>
                            </td>
                            <td class="text-center">
                                <div class="btn-group btn-group-sm" role="group">
                                    <a href="{{ route('categories.show', $category) }}" 
                                       class="btn btn-outline-primary btn-sm" title="عرض">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    
                                    <a href="{{ route('categories.edit', $category) }}" 
                                       class="btn btn-outline-warning btn-sm" title="تعديل">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    
                                    <button type="button" class="btn btn-outline-danger btn-sm" title="حذف"
                                            data-bs-toggle="modal"
                                            data-bs-target="#deleteCategoryModal"
                                            data-category-id="{{ $category->id }}"
                                            data-category-name="{{ $category->name }}"
                                            data-products-count="{{ $category->products_count }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- الترقيم -->
            @if(method_exists($categories, 'links'))
                <div class="d-flex justify-content-center">
                    {{ $categories->appends(request()->query())->links() }}
                </div>
            @endif
        @else
            <div class="text-center py-4">
                <i class="fas fa-folder fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">لا توجد فئات</h5>
                <p class="text-muted">لم يتم العثور على فئات مطابقة للبحث</p>
                <a href="{{ route('categories.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>
                    إضافة فئة جديدة
                </a>
            </div>
        @endif
    </div>
</div>

<!-- إحصائيات سريعة -->
@if(isset($stats))
<div class="row mt-4">
    <div class="col-md-4">
        <div class="card text-center">
            <div class="card-body">
                <h4 class="text-primary">{{ $stats['total'] ?? $categories->total() }}</h4>
                <p class="text-muted mb-0">إجمالي الفئات</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-center">
            <div class="card-body">
                <h4 class="text-success">{{ $stats['with_products'] ?? 0 }}</h4>
                <p class="text-muted mb-0">فئة تحتوي على منتجات</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-center">
            <div class="card-body">
                <h4 class="text-info">{{ $stats['empty'] ?? 0 }}</h4>
                <p class="text-muted mb-0">فئة فارغة</p>
            </div>
        </div>
    </div>
</div>
@endif

<!-- Modal تأكيد حذف الفئة -->
<div class="modal fade" id="deleteCategoryModal" tabindex="-1" aria-labelledby="deleteCategoryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteCategoryModalLabel">
                    <i class="fas fa-exclamation-triangle"></i>
                    تأكيد حذف الفئة
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>تحذير:</strong> هذا الإجراء لا يمكن التراجع عنه!
                </div>
                <p class="mb-3">هل تريد حذف هذه الفئة؟</p>
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">تفاصيل الفئة:</h6>
                        <p class="mb-1"><strong>الاسم:</strong> <span id="categoryNameToDelete"></span></p>
                        <p class="mb-0"><strong>عدد المنتجات:</strong> <span id="productsCountToDelete"></span></p>
                    </div>
                </div>
                <div class="alert alert-info mt-3" id="deleteWarnings" style="display: none;">
                    <i class="fas fa-info-circle"></i>
                    <strong>ملاحظة:</strong> <span id="deleteWarningText"></span>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times"></i>
                    إلغاء
                </button>
                <form id="deleteCategoryForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger" id="confirmDeleteBtn">
                        <i class="fas fa-trash"></i>
                        تأكيد الحذف
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleFilters() {
    const filtersSection = document.getElementById('filters-section');
    if (filtersSection.style.display === 'none') {
        filtersSection.style.display = 'block';
    } else {
        filtersSection.style.display = 'none';
    }
}

// إظهار البحث إذا كان هناك بحث مطبق
$(document).ready(function() {
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.has('search')) {
        document.getElementById('filters-section').style.display = 'block';
    }
});

// Modal تأكيد الحذف
document.addEventListener('DOMContentLoaded', function() {
    const deleteModal = document.getElementById('deleteCategoryModal');
    const deleteForm = document.getElementById('deleteCategoryForm');
    const categoryName = document.getElementById('categoryNameToDelete');
    const productsCount = document.getElementById('productsCountToDelete');
    const deleteWarnings = document.getElementById('deleteWarnings');
    const deleteWarningText = document.getElementById('deleteWarningText');
    const confirmDeleteBtn = document.getElementById('confirmDeleteBtn');

    deleteModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const categoryId = button.getAttribute('data-category-id');
        const categoryNameValue = button.getAttribute('data-category-name');
        const productsCountValue = button.getAttribute('data-products-count');

        // تحديث النموذج
        deleteForm.action = `{{ url('categories') }}/${categoryId}`;
        
        // تحديث محتوى المودال
        categoryName.textContent = categoryNameValue;
        productsCount.textContent = productsCountValue;

        // إظهار التحذيرات إذا لزم الأمر
        if (parseInt(productsCountValue) > 0) {
            deleteWarningText.textContent = `تحتوي الفئة على ${productsCountValue} منتج. لا يمكن حذف الفئة.`;
            deleteWarnings.style.display = 'block';
            confirmDeleteBtn.disabled = true;
            confirmDeleteBtn.textContent = 'لا يمكن الحذف';
        } else {
            deleteWarnings.style.display = 'none';
            confirmDeleteBtn.disabled = false;
            confirmDeleteBtn.innerHTML = '<i class="fas fa-trash"></i> تأكيد الحذف';
        }
    });
});
</script>
@endpush