@extends('layouts.app')

@section('title', 'تعديل الفئة: ' . $category->name)
@section('page-title', 'تعديل الفئة: ' . $category->name)

@section('page-actions')
<div class="btn-group">
    <a href="{{ route('categories.show', $category) }}" class="btn btn-info">
        <i class="fas fa-eye me-2"></i>
        عرض الفئة
    </a>
    <a href="{{ route('categories.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-right me-2"></i>
        العودة للقائمة
    </a>
</div>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-edit me-2"></i>
                    تعديل الفئة
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('categories.update', $category) }}">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-4">
                        <label for="name" class="form-label">اسم الفئة <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" 
                               id="name" name="name" value="{{ old('name', $category->name) }}" required
                               placeholder="أدخل اسم الفئة">
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">اسم واضح ومفهوم للفئة</div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            حفظ التغييرات
                        </button>
                        <div>
                            <a href="{{ route('categories.show', $category) }}" class="btn btn-info me-2">
                                <i class="fas fa-eye me-2"></i>
                                عرض الفئة
                            </a>
                            <a href="{{ route('categories.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>
                                إلغاء
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-6">
        <!-- معلومات إضافية -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    معلومات الفئة
                </h6>
            </div>
            <div class="card-body">
                <div class="row text-center mb-3">
                    <div class="col-6">
                        <h6 class="text-primary">{{ $category->products_count ?? 0 }}</h6>
                        <small class="text-muted">منتج</small>
                    </div>
                    <div class="col-6">
                        <h6 class="text-info">{{ $category->children()->count() }}</h6>
                        <small class="text-muted">فئة فرعية</small>
                    </div>
                </div>
                <hr>
                <div class="small">
                    <div class="mb-1">
                        <strong>تاريخ الإنشاء:</strong> {{ $category->created_at->format('d/m/Y H:i') }}
                    </div>
                    <div class="mb-1">
                        <strong>آخر تحديث:</strong> {{ $category->updated_at->format('d/m/Y H:i') }}
                    </div>
                    @if($category->creator)
                        <div class="mb-1">
                            <strong>أنشئ بواسطة:</strong> {{ $category->creator->name }}
                        </div>
                    @endif
                    @if($category->updater && $category->updater->id !== $category->creator?->id)
                        <div>
                            <strong>آخر تحديث بواسطة:</strong> {{ $category->updater->name }}
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- نصائح -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-lightbulb me-2"></i>
                    نصائح مفيدة
                </h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled mb-0">
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        اختر اسماً واضحاً ومفهوماً للفئة
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        تجنب الأسماء المكررة أو المتشابهة
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        استخدم أسماء قصيرة ومعبرة
                    </li>
                    <li class="mb-0">
                        <i class="fas fa-check text-success me-2"></i>
                        تأكد من عدم وجود منتجات مرتبطة قبل التغيير الجذري
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection