@extends('layouts.app')

@section('title', 'تفاصيل الحركة البنكية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Transaction Details Card -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-credit-card"></i> تفاصيل الحركة البنكية
                    </h5>
                    <div>
                        @if($bankTransaction->status == 'pending')
                            <a href="{{ route('accounting.bank-transactions.edit', $bankTransaction) }}" class="btn btn-warning">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            <button type="button" class="btn btn-success" onclick="clearTransaction()">
                                <i class="fas fa-check"></i> تصفية
                            </button>
                            <button type="button" class="btn btn-danger" onclick="cancelTransaction()">
                                <i class="fas fa-times"></i> إلغاء
                            </button>
                        @endif
                        <a href="{{ route('accounting.bank-transactions.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="35%">تاريخ الحركة:</th>
                                    <td><strong>{{ $bankTransaction->transaction_date->format('Y-m-d') }}</strong></td>
                                </tr>
                                <tr>
                                    <th>نوع الحركة:</th>
                                    <td>
                                        @switch($bankTransaction->transaction_type)
                                            @case('deposit')
                                                <span class="badge bg-success fs-6">
                                                    <i class="fas fa-arrow-down"></i> إيداع
                                                </span>
                                                @break
                                            @case('withdrawal')
                                                <span class="badge bg-danger fs-6">
                                                    <i class="fas fa-arrow-up"></i> سحب
                                                </span>
                                                @break
                                            @case('transfer')
                                                <span class="badge bg-info fs-6">
                                                    <i class="fas fa-exchange-alt"></i> تحويل
                                                </span>
                                                @break
                                        @endswitch
                                    </td>
                                </tr>
                                <tr>
                                    <th>المبلغ:</th>
                                    <td>
                                        <span class="fs-5 {{ $bankTransaction->type == 'deposit' ? 'text-success' : 'text-danger' }}">
                                            {{ $bankTransaction->type == 'deposit' ? '+' : '-' }}{{ number_format($bankTransaction->amount, 2) }}
                                            {{ $bankTransaction->bankAccount->currency }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>الحالة:</th>
                                    <td>
                                        @switch($bankTransaction->status)
                                            @case('pending')
                                                <span class="badge bg-warning fs-6">معلق</span>
                                                @break
                                            @case('cleared')
                                                <span class="badge bg-success fs-6">مصفى</span>
                                                @break
                                            @case('cancelled')
                                                <span class="badge bg-danger fs-6">ملغي</span>
                                                @break
                                        @endswitch
                                    </td>
                                </tr>
                                <tr>
                                    <th>رقم المرجع:</th>
                                    <td>{{ $bankTransaction->reference_number ?: 'غير محدد' }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="35%">الحساب البنكي:</th>
                                    <td>
                                        <a href="{{ route('accounting.bank-accounts.show', $bankTransaction->bankAccount) }}">
                                            <strong>{{ $bankTransaction->bankAccount->bank_name }}</strong><br>
                                            <small class="text-muted">{{ $bankTransaction->bankAccount->account_number }}</small>
                                        </a>
                                    </td>
                                </tr>
                                @if($bankTransaction->transaction_type == 'transfer' && $bankTransaction->to_bank_account_id)
                                <tr>
                                    <th>تحويل إلى:</th>
                                    <td>
                                        <a href="{{ route('accounting.bank-accounts.show', $bankTransaction->toBankAccount) }}">
                                            <strong>{{ $bankTransaction->toBankAccount->bank_name }}</strong><br>
                                            <small class="text-muted">{{ $bankTransaction->toBankAccount->account_number }}</small>
                                        </a>
                                    </td>
                                </tr>
                                @endif
                                <tr>
                                    <th>الحساب المحاسبي:</th>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $bankTransaction->bankAccount->account) }}">
                                            {{ $bankTransaction->bankAccount->account->code }} - {{ $bankTransaction->bankAccount->account->name }}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء:</th>
                                    <td>{{ $bankTransaction->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                @if($bankTransaction->status == 'cleared')
                                <tr>
                                    <th>تاريخ التصفية:</th>
                                    <td>{{ $bankTransaction->updated_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>البيان:</h6>
                            <div class="alert alert-light">{{ $bankTransaction->description }}</div>
                        </div>
                    </div>

                    <!-- Transfer Fees -->
                    @if($bankTransaction->transaction_type == 'transfer' && $bankTransaction->transfer_fees > 0)
                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i>
                                <strong>رسوم التحويل:</strong> {{ number_format($bankTransaction->transfer_fees, 2) }} {{ $bankTransaction->bankAccount->currency }}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Account Balance Impact -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-line"></i> تأثير الحركة على الرصيد
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        @php
                            $currency = $bankTransaction->bankAccount->currency;
                            $currentBalance = $bankTransaction->bankAccount->current_balance;
                            
                            if ($bankTransaction->status == 'cleared') {
                                // حساب الرصيد قبل الحركة
                                if ($bankTransaction->type == 'deposit') {
                                    $balanceBefore = $currentBalance - $bankTransaction->amount;
                                } else {
                                    $fees = $bankTransaction->transfer_fees ?? 0;
                                    $balanceBefore = $currentBalance + $bankTransaction->amount + $fees;
                                }
                                $balanceAfter = $currentBalance;
                            } else {
                                // الحركة معلقة، لا تؤثر على الرصيد الحالي
                                $balanceBefore = $currentBalance;
                                if ($bankTransaction->type == 'deposit') {
                                    $balanceAfter = $currentBalance + $bankTransaction->amount;
                                } else {
                                    $fees = $bankTransaction->transfer_fees ?? 0;
                                    $balanceAfter = $currentBalance - $bankTransaction->amount - $fees;
                                }
                            }
                        @endphp
                        
                        <div class="col-md-4">
                            <div class="card text-center border-info">
                                <div class="card-body">
                                    <h6 class="card-title">الرصيد قبل الحركة</h6>
                                    <h5 class="card-text {{ $balanceBefore >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($balanceBefore, 2) }} {{ $currency }}
                                    </h5>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="card text-center border-primary">
                                <div class="card-body">
                                    <h6 class="card-title">مبلغ الحركة</h6>
                                    <h5 class="card-text {{ $bankTransaction->type == 'deposit' ? 'text-success' : 'text-danger' }}">
                                        {{ $bankTransaction->type == 'deposit' ? '+' : '-' }}{{ number_format($bankTransaction->amount, 2) }} {{ $currency }}
                                        @if($bankTransaction->transfer_fees > 0)
                                            <br><small class="text-muted">رسوم: {{ number_format($bankTransaction->transfer_fees, 2) }} {{ $currency }}</small>
                                        @endif
                                    </h5>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="card text-center border-success">
                                <div class="card-body">
                                    <h6 class="card-title">
                                        @if($bankTransaction->status == 'cleared')
                                            الرصيد الحالي
                                        @else
                                            الرصيد المتوقع
                                        @endif
                                    </h6>
                                    <h5 class="card-text {{ $balanceAfter >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($balanceAfter, 2) }} {{ $currency }}
                                    </h5>
                                    @if($bankTransaction->status == 'pending')
                                        <small class="text-muted">(عند التصفية)</small>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Related Journal Entry -->
            @if($bankTransaction->journal_entry_id)
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-book"></i> القيد المحاسبي المرتبط
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>رقم القيد:</strong> 
                                <a href="{{ route('accounting.journal-entries.show', $bankTransaction->journalEntry) }}">
                                    {{ $bankTransaction->journalEntry->entry_number }}
                                </a>
                            </p>
                            <p><strong>تاريخ القيد:</strong> {{ $bankTransaction->journalEntry->entry_date->format('Y-m-d') }}</p>
                            <p><strong>حالة القيد:</strong> 
                                @if($bankTransaction->journalEntry->status == 'draft')
                                    <span class="badge bg-warning">مسودة</span>
                                @else
                                    <span class="badge bg-success">مرحل</span>
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>البيان:</strong> {{ $bankTransaction->journalEntry->description }}</p>
                            <p><strong>إجمالي المدين:</strong> {{ number_format($bankTransaction->journalEntry->journalEntryLines->sum('debit_amount'), 2) }} ريال</p>
                            <p><strong>إجمالي الدائن:</strong> {{ number_format($bankTransaction->journalEntry->journalEntryLines->sum('credit_amount'), 2) }} ريال</p>
                        </div>
                    </div>
                    
                    <div class="mt-3">
                        <h6>تفاصيل القيد:</h6>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped">
                                    <tr>
                                        <th>الحساب</th>
                                        <th>البيان</th>
                                        <th>مدين</th>
                                        <th>دائن</th>
                                    </tr>
                                <tbody>
                                    @foreach($bankTransaction->journalEntry->journalEntryLines as $line)
                                    <tr>
                                        <td>
                                            <a href="{{ route('accounting.accounts.show', $line->account) }}">
                                                {{ $line->account->code }} - {{ $line->account->name }}
                                            </a>
                                        </td>
                                        <td>{{ $line->description }}</td>
                                        <td class="text-success">{{ $line->debit > 0 ? number_format($line->debit, 2) : '-' }}</td>
                                        <td class="text-danger">{{ $line->credit > 0 ? number_format($line->credit, 2) : '-' }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Action Buttons -->
            <div class="card">
                <div class="card-body text-center">
                    @if($bankTransaction->status == 'pending')
                        <a href="{{ route('accounting.bank-transactions.edit', $bankTransaction) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل الحركة
                        </a>
                        <button type="button" class="btn btn-success" onclick="clearTransaction()">
                            <i class="fas fa-check"></i> تصفية الحركة
                        </button>
                        <button type="button" class="btn btn-danger" onclick="cancelTransaction()">
                            <i class="fas fa-times"></i> إلغاء الحركة
                        </button>
                    @elseif($bankTransaction->status == 'cleared')
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle"></i>
                            <strong>هذه الحركة مصفاة وتم تطبيقها على الحساب البنكي.</strong>
                        </div>
                    @else
                        <div class="alert alert-danger">
                            <i class="fas fa-times-circle"></i>
                            <strong>هذه الحركة ملغية ولا تؤثر على الحساب البنكي.</strong>
                        </div>
                    @endif
                    
                    <a href="{{ route('accounting.bank-transactions.index') }}" class="btn btn-secondary">
                        <i class="fas fa-list"></i> العودة لقائمة الحركات
                    </a>
                    
                    <a href="{{ route('accounting.bank-accounts.show', $bankTransaction->bankAccount) }}" class="btn btn-info">
                        <i class="fas fa-university"></i> عرض الحساب البنكي
                    </a>
                    
                    <button type="button" class="btn btn-outline-primary" onclick="printTransaction()">
                        <i class="fas fa-print"></i> طباعة الحركة
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function clearTransaction() {
    if (confirm('هل تريد تصفية هذه الحركة؟ سيتم تطبيقها على الرصيد وإنشاء قيد محاسبي إن لم يكن موجوداً.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/accounting/bank-transactions/{{ $bankTransaction->id }}/clear`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}

function cancelTransaction() {
    if (confirm('هل تريد إلغاء هذه الحركة؟ لا يمكن التراجع عن هذا الإجراء.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/accounting/bank-transactions/{{ $bankTransaction->id }}/cancel`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}

function printTransaction() {
    window.print();
}

// Print styles
window.addEventListener('beforeprint', function() {
    document.querySelectorAll('.btn, .card-header .btn, nav').forEach(function(element) {
        element.style.display = 'none';
    });
});

window.addEventListener('afterprint', function() {
    document.querySelectorAll('.btn, .card-header .btn, nav').forEach(function(element) {
        element.style.display = '';
    });
});
</script>
@endpush

@push('styles')
<style>
@media print {
    .btn, .card-header .btn, nav, .modal {
        display: none !important;
    }
    
    .card {
        border: 1px solid #ddd !important;
        box-shadow: none !important;
    }
    
    .table {
        font-size: 12px;
    }
    
    .badge {
        border: 1px solid #000;
        color: #000 !important;
        background-color: transparent !important;
    }
}
</style>
@endpush