@extends('layouts.app')

@section('title', 'الحركات البنكية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Filters Card -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-filter"></i> تصفية النتائج
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('accounting.bank-transactions.index') }}">
                        <div class="row">
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="bank_account_id" class="form-label">الحساب البنكي</label>
                                    <select class="form-select" id="bank_account_id" name="bank_account_id">
                                        <option value="">جميع الحسابات</option>
                                        @foreach(\App\Models\BankAccount::orderBy('bank_name')->get() as $bankAccount)
                                            <option value="{{ $bankAccount->id }}" {{ request('bank_account_id') == $bankAccount->id ? 'selected' : '' }}>
                                                {{ $bankAccount->bank_name }} - {{ $bankAccount->account_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="transaction_type" class="form-label">نوع الحركة</label>
                                    <select class="form-select" id="transaction_type" name="transaction_type">
                                        <option value="">جميع الأنواع</option>
                                        <option value="deposit" {{ request('type') == 'deposit' ? 'selected' : '' }}>إيداع</option>
                                        <option value="withdrawal" {{ request('type') == 'withdrawal' ? 'selected' : '' }}>سحب</option>
                                        <option value="transfer" {{ request('transaction_type') == 'transfer' ? 'selected' : '' }}>تحويل</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="status" class="form-label">الحالة</label>
                                    <select class="form-select" id="status" name="status">
                                        <option value="">جميع الحالات</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                                        <option value="cleared" {{ request('status') == 'cleared' ? 'selected' : '' }}>مصفى</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="start_date" class="form-label">من تاريخ</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" 
                                           value="{{ request('start_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="end_date" class="form-label">إلى تاريخ</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" 
                                           value="{{ request('end_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <div class="d-grid gap-2">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-search"></i> بحث
                                        </button>
                                        <a href="{{ route('accounting.bank-transactions.index') }}" class="btn btn-secondary">
                                            <i class="fas fa-times"></i> إعادة تعيين
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Bank Transactions Card -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-credit-card"></i> الحركات البنكية
                        @if(request()->hasAny(['bank_account_id', 'transaction_type', 'status', 'start_date', 'end_date']))
                            <small class="text-muted">({{ $bankTransactions->total() }} نتيجة)</small>
                        @endif
                    </h5>
                    <div>
                        <a href="{{ route('accounting.bank-transactions.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة حركة بنكية
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if($bankTransactions->count() > 0)
                        <!-- Summary Cards -->
                        @php
                            $filteredTransactions = $bankTransactions->getCollection();
                            $totalDeposits = $filteredTransactions->where('transaction_type', 'deposit')->where('status', 'cleared')->sum('amount');
                            $totalWithdrawals = $filteredTransactions->where('transaction_type', 'withdrawal')->where('status', 'cleared')->sum('amount');
                            $totalTransfers = $filteredTransactions->where('transaction_type', 'transfer')->where('status', 'cleared')->sum('amount');
                            $pendingCount = $filteredTransactions->where('status', 'pending')->count();
                            $clearedCount = $filteredTransactions->where('status', 'cleared')->count();
                            $cancelledCount = $filteredTransactions->where('status', 'cancelled')->count();
                            $netAmount = $totalDeposits - $totalWithdrawals - $totalTransfers;
                        @endphp
                        
                        <div class="row mb-4">
                            <div class="col-md-2">
                                <div class="card text-center border-success">
                                    <div class="card-body p-3">
                                        <h5 class="card-title text-success">{{ number_format($totalDeposits, 2) }}</h5>
                                        <p class="card-text small">إجمالي الإيداعات</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card text-center border-danger">
                                    <div class="card-body p-3">
                                        <h5 class="card-title text-danger">{{ number_format($totalWithdrawals, 2) }}</h5>
                                        <p class="card-text small">إجمالي السحوبات</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card text-center border-info">
                                    <div class="card-body p-3">
                                        <h5 class="card-title text-info">{{ number_format($totalTransfers, 2) }}</h5>
                                        <p class="card-text small">إجمالي التحويلات</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card text-center border-primary">
                                    <div class="card-body p-3">
                                        <h5 class="card-title {{ $netAmount >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($netAmount, 2) }}
                                        </h5>
                                        <p class="card-text small">صافي الحركات</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card text-center border-warning">
                                    <div class="card-body p-3">
                                        <h5 class="card-title text-warning">{{ $pendingCount }}</h5>
                                        <p class="card-text small">حركات معلقة</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="card text-center border-secondary">
                                    <div class="card-body p-3">
                                        <h5 class="card-title text-secondary">{{ $clearedCount }}</h5>
                                        <p class="card-text small">حركات مصفاة</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Transactions Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                    <tr>
                                        <th>التاريخ</th>
                                        <th>الحساب البنكي</th>
                                        <th>نوع الحركة</th>
                                        <th>المبلغ</th>
                                        <th>البيان</th>
                                        <th>المرجع</th>
                                        <th>الحالة</th>
                                        <th>القيد المرتبط</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                <tbody>
                                    @foreach($bankTransactions as $transaction)
                                    <tr class="{{ $transaction->status == 'cancelled' ? 'table-secondary' : '' }}">
                                        <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                        <td>
                                            <a href="{{ route('accounting.bank-accounts.show', $transaction->bankAccount) }}">
                                                <strong>{{ $transaction->bankAccount->bank_name }}</strong>
                                                <br><small class="text-muted">{{ $transaction->bankAccount->account_number }}</small>
                                            </a>
                                        </td>
                                        <td>
                                            @switch($transaction->transaction_type)
                                                @case('deposit')
                                                    <span class="badge bg-success">
                                                        <i class="fas fa-arrow-down"></i> إيداع
                                                    </span>
                                                    @break
                                                @case('withdrawal')
                                                    <span class="badge bg-danger">
                                                        <i class="fas fa-arrow-up"></i> سحب
                                                    </span>
                                                    @break
                                                @case('transfer')
                                                    <span class="badge bg-info">
                                                        <i class="fas fa-exchange-alt"></i> تحويل
                                                    </span>
                                                    @if($transaction->to_bank_account_id)
                                                        <br><small class="text-muted">إلى: {{ $transaction->toBankAccount->bank_name }}</small>
                                                    @endif
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>
                                            <span class="fs-6 {{ $transaction->type == 'deposit' ? 'text-success' : 'text-danger' }}">
                                                {{ $transaction->type == 'deposit' ? '+' : '-' }}{{ number_format($transaction->amount, 2) }}
                                                {{ $transaction->bankAccount->currency }}
                                            </span>
                                            @if($transaction->transfer_fees > 0)
                                                <br><small class="text-muted">رسوم: {{ number_format($transaction->transfer_fees, 2) }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            {{ Str::limit($transaction->description, 40) }}
                                            @if(strlen($transaction->description) > 40)
                                                <span class="text-muted" data-bs-toggle="tooltip" 
                                                      title="{{ $transaction->description }}">...</span>
                                            @endif
                                        </td>
                                        <td>{{ $transaction->reference_number ?: '-' }}</td>
                                        <td>
                                            @switch($transaction->status)
                                                @case('pending')
                                                    <span class="badge bg-warning">معلق</span>
                                                    @break
                                                @case('cleared')
                                                    <span class="badge bg-success">مصفى</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge bg-danger">ملغي</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>
                                            @if($transaction->journal_entry_id)
                                                <a href="{{ route('accounting.journal-entries.show', $transaction->journal_entry_id) }}" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    {{ $transaction->journalEntry->entry_number }}
                                                </a>
                                            @else
                                                <span class="text-muted">لا يوجد</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('accounting.bank-transactions.show', $transaction) }}" 
                                                   class="btn btn-sm btn-outline-primary" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($transaction->status == 'pending')
                                                    <a href="{{ route('accounting.bank-transactions.edit', $transaction) }}" 
                                                       class="btn btn-sm btn-outline-warning" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-sm btn-outline-success" 
                                                            onclick="clearTransaction({{ $transaction->id }})" title="تصفية">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                                            onclick="cancelTransaction({{ $transaction->id }})" title="إلغاء">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                عرض {{ $bankTransactions->firstItem() }} إلى {{ $bankTransactions->lastItem() }} من {{ $bankTransactions->total() }} نتيجة
                            </div>
                            <div>
                                {{ $bankTransactions->appends(request()->query())->links() }}
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="row mt-4">
                            <div class="col-md-4">
                                <div class="card border-success">
                                    <div class="card-header bg-success text-white">
                                        <h6 class="mb-0">إجراءات سريعة</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="d-grid gap-2">
                                            <a href="{{ route('accounting.bank-transactions.create') }}" class="btn btn-success btn-sm">
                                                <i class="fas fa-plus"></i> حركة بنكية جديدة
                                            </a>
                                            @if($pendingCount > 0)
                                                <button type="button" class="btn btn-warning btn-sm" onclick="clearAllPending()">
                                                    <i class="fas fa-check-double"></i> تصفية جميع المعلقة ({{ $pendingCount }})
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="card border-info">
                                    <div class="card-header bg-info text-white">
                                        <h6 class="mb-0">الحركات المعلقة</h6>
                                    </div>
                                    <div class="card-body">
                                        @php
                                            $pendingTransactions = $filteredTransactions->where('status', 'pending')->take(3);
                                        @endphp
                                        @if($pendingTransactions->count() > 0)
                                            @foreach($pendingTransactions as $pending)
                                                <div class="d-flex justify-content-between mb-1">
                                                    <small>{{ $pending->bankAccount->bank_name }}</small>
                                                    <small class="text-muted">{{ number_format($pending->amount, 2) }}</small>
                                                </div>
                                            @endforeach
                                            @if($pendingCount > 3)
                                                <small class="text-muted">و {{ $pendingCount - 3 }} حركة أخرى...</small>
                                            @endif
                                        @else
                                            <p class="text-muted small">لا توجد حركات معلقة</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="card border-primary">
                                    <div class="card-header bg-primary text-white">
                                        <h6 class="mb-0">آخر الحركات</h6>
                                    </div>
                                    <div class="card-body">
                                        @php
                                            $latestTransactions = $filteredTransactions->sortByDesc('transaction_date')->take(3);
                                        @endphp
                                        @foreach($latestTransactions as $latest)
                                            <div class="d-flex justify-content-between mb-1">
                                                <small>{{ $latest->transaction_date->format('m-d') }}</small>
                                                <small class="{{ $latest->type == 'deposit' ? 'text-success' : 'text-danger' }}">
                                                    {{ $latest->type == 'deposit' ? '+' : '-' }}{{ number_format($latest->amount, 2) }}
                                                </small>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>

                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-credit-card fa-5x text-muted mb-3"></i>
                            <h4 class="text-muted">لا توجد حركات بنكية</h4>
                            @if(request()->hasAny(['bank_account_id', 'transaction_type', 'status', 'start_date', 'end_date']))
                                <p class="text-muted">لا توجد نتائج للبحث المحدد. جرب تغيير معايير البحث.</p>
                                <a href="{{ route('accounting.bank-transactions.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إعادة تعيين البحث
                                </a>
                            @else
                                <p class="text-muted">ابدأ بإضافة أول حركة بنكية في النظام</p>
                                <a href="{{ route('accounting.bank-transactions.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> إضافة حركة بنكية
                                </a>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function clearTransaction(transactionId) {
    if (confirm('هل تريد تصفية هذه الحركة؟ سيتم تطبيقها على الرصيد وإنشاء قيد محاسبي إن لم يكن موجوداً.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/accounting/bank-transactions/${transactionId}/clear`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}

function cancelTransaction(transactionId) {
    if (confirm('هل تريد إلغاء هذه الحركة؟ لا يمكن التراجع عن هذا الإجراء.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/accounting/bank-transactions/${transactionId}/cancel`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}

function clearAllPending() {
    if (confirm('هل تريد تصفية جميع الحركات المعلقة؟ سيتم تطبيقها على الأرصدة وإنشاء القيود المحاسبية.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/accounting/bank-transactions/clear-all-pending`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}

// تحديث التصفية تلقائياً عند تغيير القيم
$(document).ready(function() {
    $('#bank_account_id, #transaction_type, #status').change(function() {
        $(this).closest('form').submit();
    });
    
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>
@endpush