@extends('layouts.app')

@section('title', 'كشف الحساب البنكي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Bank Account Header -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-file-alt"></i> كشف الحساب البنكي
                    </h5>
                    <div>
                        <button type="button" class="btn btn-outline-primary" onclick="window.print()">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                        <a href="{{ route('accounting.bank-accounts.show', $bankAccount) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للحساب
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>معلومات الحساب البنكي:</h6>
                            <table class="table table-borderless table-sm">
                                <tr>
                                    <th width="40%">اسم البنك:</th>
                                    <td><strong>{{ $bankAccount->bank_name }}</strong></td>
                                </tr>
                                <tr>
                                    <th>رقم الحساب:</th>
                                    <td><span class="font-monospace">{{ $bankAccount->account_number }}</span></td>
                                </tr>
                                <tr>
                                    <th>رقم الآيبان:</th>
                                    <td><span class="font-monospace">{{ $bankAccount->iban ?: 'غير محدد' }}</span></td>
                                </tr>
                                <tr>
                                    <th>العملة:</th>
                                    <td><span class="badge bg-secondary">{{ $bankAccount->currency }}</span></td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <h6>معلومات الكشف:</h6>
                            <table class="table table-borderless table-sm">
                                <tr>
                                    <th width="40%">فترة الكشف:</th>
                                    <td>{{ $startDate->format('Y-m-d') }} إلى {{ $endDate->format('Y-m-d') }}</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الطباعة:</th>
                                    <td>{{ now()->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>عدد الحركات:</th>
                                    <td><strong>{{ $transactions->count() }} حركة</strong></td>
                                </tr>
                                <tr>
                                    <th>الرصيد الحالي:</th>
                                    <td>
                                        <strong class="{{ $bankAccount->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($bankAccount->current_balance, 2) }} {{ $bankAccount->currency }}
                                        </strong>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters Card -->
            <div class="card mb-4 no-print">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-filter"></i> تصفية الكشف
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('accounting.bank-accounts.statement', $bankAccount) }}">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="start_date" class="form-label">من تاريخ</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" 
                                           value="{{ request('start_date', $startDate->format('Y-m-d')) }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="end_date" class="form-label">إلى تاريخ</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" 
                                           value="{{ request('end_date', $endDate->format('Y-m-d')) }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="transaction_type" class="form-label">نوع الحركة</label>
                                    <select class="form-select" id="transaction_type" name="transaction_type">
                                        <option value="">جميع الأنواع</option>
                                        <option value="deposit" {{ request('type') == 'deposit' ? 'selected' : '' }}>إيداع</option>
                                        <option value="withdrawal" {{ request('type') == 'withdrawal' ? 'selected' : '' }}>سحب</option>
                                        <option value="transfer" {{ request('transaction_type') == 'transfer' ? 'selected' : '' }}>تحويل</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="status" class="form-label">الحالة</label>
                                    <select class="form-select" id="status" name="status">
                                        <option value="">جميع الحالات</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                                        <option value="cleared" {{ request('status') == 'cleared' ? 'selected' : '' }}>مصفى</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary d-block">
                                        <i class="fas fa-search"></i> تطبيق
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Summary Card -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar"></i> ملخص الحركات للفترة
                    </h6>
                </div>
                <div class="card-body">
                    @php
                        $totalDeposits = $transactions->where('transaction_type', 'deposit')->where('status', 'cleared')->sum('amount');
                        $totalWithdrawals = $transactions->where('transaction_type', 'withdrawal')->where('status', 'cleared')->sum('amount');
                        $totalTransfers = $transactions->where('transaction_type', 'transfer')->where('status', 'cleared')->sum('amount');
                        $pendingCount = $transactions->where('status', 'pending')->count();
                        $clearedCount = $transactions->where('status', 'cleared')->count();
                        $cancelledCount = $transactions->where('status', 'cancelled')->count();
                        $netAmount = $totalDeposits - $totalWithdrawals - $totalTransfers;
                    @endphp
                    
                    <div class="row">
                        <div class="col-md-2">
                            <div class="text-center">
                                <h5 class="text-success">{{ number_format($totalDeposits, 2) }}</h5>
                                <small class="text-muted">إجمالي الإيداعات</small>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="text-center">
                                <h5 class="text-danger">{{ number_format($totalWithdrawals, 2) }}</h5>
                                <small class="text-muted">إجمالي السحوبات</small>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="text-center">
                                <h5 class="text-info">{{ number_format($totalTransfers, 2) }}</h5>
                                <small class="text-muted">إجمالي التحويلات</small>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="text-center">
                                <h5 class="{{ $netAmount >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ number_format($netAmount, 2) }}
                                </h5>
                                <small class="text-muted">صافي الحركات</small>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="text-center">
                                <h5 class="text-warning">{{ $pendingCount }}</h5>
                                <small class="text-muted">حركات معلقة</small>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="text-center">
                                <h5 class="text-primary">{{ $clearedCount }}</h5>
                                <small class="text-muted">حركات مصفاة</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transactions Statement -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-list"></i> تفاصيل الحركات
                    </h6>
                </div>
                <div class="card-body">
                    @if($transactions->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                    <tr>
                                        <th>التاريخ</th>
                                        <th>البيان</th>
                                        <th>نوع الحركة</th>
                                        <th>المرجع</th>
                                        <th>إيداع</th>
                                        <th>سحب</th>
                                        <th>الرصيد الجاري</th>
                                        <th>الحالة</th>
                                        <th class="no-print">الإجراءات</th>
                                    </tr>
                                <tbody>
                                    @php
                                        // حساب الرصيد الافتتاحي للفترة
                                        $openingBalance = $bankAccount->opening_balance;
                                        $previousTransactions = \App\Models\BankTransaction::where('bank_account_id', $bankAccount->id)
                                            ->where('transaction_date', '<', $startDate)
                                            ->where('status', 'cleared')
                                            ->get();
                                        
                                        foreach($previousTransactions as $prevTrans) {
                                            if($prevTrans->type == 'deposit') {
                                                $openingBalance += $prevTrans->amount;
                                            } else {
                                                $openingBalance -= $prevTrans->amount + ($prevTrans->transfer_fees ?? 0);
                                            }
                                        }
                                        
                                        $runningBalance = $openingBalance;
                                    @endphp
                                    
                                    <!-- Opening Balance Row -->
                                    <tr class="table-info">
                                        <td colspan="6"><strong>الرصيد الافتتاحي للفترة</strong></td>
                                        <td><strong>{{ number_format($openingBalance, 2) }} {{ $bankAccount->currency }}</strong></td>
                                        <td colspan="2"></td>
                                    </tr>
                                    
                                    @foreach($transactions->sortBy('transaction_date') as $transaction)
                                        @php
                                            // حساب الرصيد الجاري فقط للحركات المصفاة
                                            if($transaction->status == 'cleared') {
                                                if($transaction->type == 'deposit') {
                                                    $runningBalance += $transaction->amount;
                                                } else {
                                                    $runningBalance -= $transaction->amount + ($transaction->transfer_fees ?? 0);
                                                }
                                            }
                                        @endphp
                                        <tr class="{{ $transaction->status == 'cancelled' ? 'text-muted' : '' }}">
                                            <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                            <td>{{ $transaction->description }}</td>
                                            <td>
                                                @switch($transaction->transaction_type)
                                                    @case('deposit')
                                                        <span class="badge bg-success">إيداع</span>
                                                        @break
                                                    @case('withdrawal')
                                                        <span class="badge bg-danger">سحب</span>
                                                        @break
                                                    @case('transfer')
                                                        <span class="badge bg-info">تحويل</span>
                                                        @break
                                                @endswitch
                                            </td>
                                            <td>{{ $transaction->reference_number ?: '-' }}</td>
                                            <td class="text-success">
                                                {{ $transaction->type == 'deposit' ? number_format($transaction->amount, 2) : '-' }}
                                            </td>
                                            <td class="text-danger">
                                                @if($transaction->type != 'deposit')
                                                    {{ number_format($transaction->amount + ($transaction->transfer_fees ?? 0), 2) }}
                                                    @if($transaction->transfer_fees > 0)
                                                        <br><small class="text-muted">(شامل رسوم {{ number_format($transaction->transfer_fees, 2) }})</small>
                                                    @endif
                                                @else
                                                    -
                                                @endif
                                            </td>
                                            <td class="{{ $runningBalance >= 0 ? 'text-success' : 'text-danger' }}">
                                                @if($transaction->status == 'cleared')
                                                    <strong>{{ number_format($runningBalance, 2) }} {{ $bankAccount->currency }}</strong>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @switch($transaction->status)
                                                    @case('pending')
                                                        <span class="badge bg-warning">معلق</span>
                                                        @break
                                                    @case('cleared')
                                                        <span class="badge bg-success">مصفى</span>
                                                        @break
                                                    @case('cancelled')
                                                        <span class="badge bg-danger">ملغي</span>
                                                        @break
                                                @endswitch
                                            </td>
                                            <td class="no-print">
                                                <a href="{{ route('accounting.bank-transactions.show', $transaction) }}" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    
                                    <!-- Closing Balance Row -->
                                    <tr class="table-success">
                                        <td colspan="6"><strong>الرصيد الختامي للفترة</strong></td>
                                        <td><strong>{{ number_format($runningBalance, 2) }} {{ $bankAccount->currency }}</strong></td>
                                        <td colspan="2"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Statement Footer -->
                        <div class="mt-4 pt-3 border-top">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>ملخص الفترة:</h6>
                                    <ul class="list-unstyled">
                                        <li><strong>الرصيد الافتتاحي:</strong> {{ number_format($openingBalance, 2) }} {{ $bankAccount->currency }}</li>
                                        <li><strong>إجمالي الإيداعات:</strong> +{{ number_format($totalDeposits, 2) }} {{ $bankAccount->currency }}</li>
                                        <li><strong>إجمالي السحوبات:</strong> -{{ number_format($totalWithdrawals + $totalTransfers, 2) }} {{ $bankAccount->currency }}</li>
                                        <li><strong>الرصيد الختامي:</strong> {{ number_format($runningBalance, 2) }} {{ $bankAccount->currency }}</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6>إحصائيات الحركات:</h6>
                                    <ul class="list-unstyled">
                                        <li><strong>إجمالي الحركات:</strong> {{ $transactions->count() }} حركة</li>
                                        <li><strong>حركات مصفاة:</strong> {{ $clearedCount }} حركة</li>
                                        <li><strong>حركات معلقة:</strong> {{ $pendingCount }} حركة</li>
                                        <li><strong>حركات ملغية:</strong> {{ $cancelledCount }} حركة</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-file-alt fa-5x text-muted mb-3"></i>
                            <h4 class="text-muted">لا توجد حركات في الفترة المحددة</h4>
                            <p class="text-muted">جرب تغيير فترة البحث أو إلغاء التصفية</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
@media print {
    .no-print, .btn, nav, .sidebar, .card-header .btn {
        display: none !important;
    }
    
    .card {
        border: 1px solid #ddd !important;
        box-shadow: none !important;
        page-break-inside: avoid;
    }
    
    .table {
        font-size: 12px;
    }
    
    .badge {
        border: 1px solid #000;
        color: #000 !important;
        background-color: transparent !important;
    }
    
    body {
        font-size: 12px;
    }
    
    h5, h6 {
        font-size: 14px;
    }
}

.table td, .table th {
    vertical-align: middle;
}

.font-monospace {
    font-family: 'Courier New', monospace;
}
</style>
@endpush