@extends('layouts.app')

@section('title', 'تفاصيل الحساب البنكي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Bank Account Details Card -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-university"></i> تفاصيل الحساب البنكي
                    </h5>
                    <div>
                        <a href="{{ route('accounting.bank-accounts.edit', $bankAccount) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('accounting.bank-accounts.statement', $bankAccount) }}" class="btn btn-info">
                            <i class="fas fa-file-alt"></i> كشف الحساب
                        </a>
                        <a href="{{ route('accounting.bank-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="35%">اسم البنك:</th>
                                    <td><strong>{{ $bankAccount->bank_name }}</strong></td>
                                </tr>
                                <tr>
                                    <th>رقم الحساب:</th>
                                    <td><span class="font-monospace badge bg-primary">{{ $bankAccount->account_number }}</span></td>
                                </tr>
                                <tr>
                                    <th>رقم الآيبان:</th>
                                    <td>
                                        @if($bankAccount->iban)
                                            <span class="font-monospace">{{ $bankAccount->iban }}</span>
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>رمز SWIFT:</th>
                                    <td>
                                        @if($bankAccount->swift_code)
                                            <span class="font-monospace badge bg-info">{{ $bankAccount->swift_code }}</span>
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>الفرع:</th>
                                    <td>{{ $bankAccount->branch ?: 'غير محدد' }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="35%">الحساب المحاسبي:</th>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $bankAccount->account) }}">
                                            {{ $bankAccount->account->code }} - {{ $bankAccount->account->name }}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>العملة:</th>
                                    <td><span class="badge bg-secondary">{{ $bankAccount->currency }}</span></td>
                                </tr>
                                <tr>
                                    <th>الرصيد الافتتاحي:</th>
                                    <td>{{ number_format($bankAccount->opening_balance, 2) }} {{ $bankAccount->currency }}</td>
                                </tr>
                                <tr>
                                    <th>الرصيد الحالي:</th>
                                    <td>
                                        <strong class="{{ $bankAccount->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($bankAccount->current_balance, 2) }} {{ $bankAccount->currency }}
                                        </strong>
                                    </td>
                                </tr>
                                <tr>
                                    <th>الحالة:</th>
                                    <td>
                                        @if($bankAccount->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-danger">غير نشط</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($bankAccount->notes)
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>الملاحظات:</h6>
                            <div class="alert alert-light">{{ $bankAccount->notes }}</div>
                        </div>
                    </div>
                    @endif

                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h6 class="mb-0">إحصائيات الحساب</h6>
                                </div>
                                <div class="card-body">
                                    <p><strong>تاريخ الإنشاء:</strong> {{ $bankAccount->created_at->format('Y-m-d H:i') }}</p>
                                    <p><strong>آخر تحديث:</strong> {{ $bankAccount->updated_at->format('Y-m-d H:i') }}</p>
                                    <p><strong>عدد الحركات:</strong> {{ $bankAccount->transactions->count() }} حركة</p>
                                    <p><strong>آخر حركة:</strong> 
                                        @if($bankAccount->transactions->count() > 0)
                                            {{ $bankAccount->transactions->latest()->first()->transaction_date->format('Y-m-d') }}
                                        @else
                                            لا توجد حركات
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card border-success">
                                <div class="card-header bg-success text-white">
                                    <h6 class="mb-0">ملخص الحركات</h6>
                                </div>
                                <div class="card-body">
                                    @php
                                        $totalDeposits = $bankAccount->transactions()->where('type', 'deposit')->where('status', 'cleared')->sum('amount');
                                        $totalWithdrawals = $bankAccount->transactions()->where('type', 'withdrawal')->where('status', 'cleared')->sum('amount');
                                        $pendingTransactions = $bankAccount->transactions()->where('status', 'pending')->count();
                                    @endphp
                                    <p><strong>إجمالي الإيداعات:</strong> <span class="text-success">{{ number_format($totalDeposits, 2) }} {{ $bankAccount->currency }}</span></p>
                                    <p><strong>إجمالي السحوبات:</strong> <span class="text-danger">{{ number_format($totalWithdrawals, 2) }} {{ $bankAccount->currency }}</span></p>
                                    <p><strong>الحركات المعلقة:</strong> <span class="text-warning">{{ $pendingTransactions }} حركة</span></p>
                                    <p><strong>صافي الحركات:</strong> 
                                        <span class="{{ ($totalDeposits - $totalWithdrawals) >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($totalDeposits - $totalWithdrawals, 2) }} {{ $bankAccount->currency }}
                                        </span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Transactions -->
            @if($bankAccount->transactions->count() > 0)
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-history"></i> آخر الحركات البنكية
                    </h6>
                    <div>
                        <a href="{{ route('accounting.bank-transactions.create') }}?bank_account_id={{ $bankAccount->id }}" class="btn btn-sm btn-success">
                            <i class="fas fa-plus"></i> إضافة حركة جديدة
                        </a>
                        <a href="{{ route('accounting.bank-accounts.statement', $bankAccount) }}" class="btn btn-sm btn-outline-primary">
                            عرض كشف الحساب الكامل
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th>التاريخ</th>
                                    <th>نوع الحركة</th>
                                    <th>البيان</th>
                                    <th>المبلغ</th>
                                    <th>الحالة</th>
                                    <th>المرجع</th>
                                    <th>الإجراءات</th>
                                </tr>
                            <tbody>
                                @foreach($bankAccount->transactions()->latest()->limit(10)->get() as $transaction)
                                <tr>
                                    <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                    <td>
                                        @switch($transaction->type)
                                            @case('deposit')
                                                <span class="badge bg-success">إيداع</span>
                                                @break
                                            @case('withdrawal')
                                                <span class="badge bg-danger">سحب</span>
                                                @break
                                            @case('transfer')
                                                <span class="badge bg-info">تحويل</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>{{ $transaction->description }}</td>
                                    <td>
                                        <span class="{{ $transaction->type == 'deposit' ? 'text-success' : 'text-danger' }}">
                                            {{ $transaction->type == 'deposit' ? '+' : '-' }}{{ number_format($transaction->amount, 2) }} {{ $bankAccount->currency }}
                                        </span>
                                    </td>
                                    <td>
                                        @switch($transaction->status)
                                            @case('pending')
                                                <span class="badge bg-warning">معلق</span>
                                                @break
                                            @case('cleared')
                                                <span class="badge bg-success">مصفى</span>
                                                @break
                                            @case('cancelled')
                                                <span class="badge bg-danger">ملغي</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>{{ $transaction->reference_number ?: '-' }}</td>
                                    <td>
                                        <a href="{{ route('accounting.bank-transactions.show', $transaction) }}" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if($transaction->status == 'pending')
                                            <button type="button" class="btn btn-sm btn-outline-success" 
                                                    onclick="clearTransaction({{ $transaction->id }})">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @else
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-credit-card fa-5x text-muted mb-3"></i>
                    <h5>لا توجد حركات بنكية</h5>
                    <p class="text-muted">لم يتم تسجيل أي حركات على هذا الحساب البنكي بعد.</p>
                    <a href="{{ route('accounting.bank-transactions.create') }}?bank_account_id={{ $bankAccount->id }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة أول حركة بنكية
                    </a>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function clearTransaction(transactionId) {
    if (confirm('هل تريد تصفية هذه الحركة؟')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/accounting/bank-transactions/${transactionId}/clear`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
@endpush