@extends('layouts.app')

@section('title', 'تعديل الحساب البنكي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">تعديل الحساب البنكي: {{ $bankAccount->bank_name }}</h5>
                    <div>
                        <a href="{{ route('accounting.bank-accounts.show', $bankAccount) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> عرض الحساب
                        </a>
                        <a href="{{ route('accounting.bank-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <form action="{{ route('accounting.bank-accounts.update', $bankAccount) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="account_id" class="form-label">الحساب المحاسبي <span class="text-danger">*</span></label>
                                    <select class="form-select @error('account_id') is-invalid @enderror" 
                                            id="account_id" name="account_id" required>
                                        <option value="">اختر الحساب المحاسبي</option>
                                        @foreach($bankingAccounts as $account)
                                            <option value="{{ $account->id }}" 
                                                    {{ old('account_id', $bankAccount->account_id) == $account->id ? 'selected' : '' }}>
                                                {{ $account->code }} - {{ $account->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('account_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="bank_name" class="form-label">اسم البنك <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('bank_name') is-invalid @enderror" 
                                           id="bank_name" name="bank_name" value="{{ old('bank_name', $bankAccount->bank_name) }}" 
                                           placeholder="مثال: البنك الأهلي السعودي" required>
                                    @error('bank_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="account_number" class="form-label">رقم الحساب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('account_number') is-invalid @enderror" 
                                           id="account_number" name="account_number" value="{{ old('account_number', $bankAccount->account_number) }}" 
                                           placeholder="123456789" required>
                                    @error('account_number')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="iban" class="form-label">رقم الآيبان (IBAN)</label>
                                    <input type="text" class="form-control @error('iban') is-invalid @enderror" 
                                           id="iban" name="iban" value="{{ old('iban', $bankAccount->iban) }}" 
                                           placeholder="SA1234567890123456789012">
                                    @error('iban')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="swift_code" class="form-label">رمز SWIFT</label>
                                    <input type="text" class="form-control @error('swift_code') is-invalid @enderror" 
                                           id="swift_code" name="swift_code" value="{{ old('swift_code', $bankAccount->swift_code) }}" 
                                           placeholder="ALBILARI">
                                    @error('swift_code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="branch" class="form-label">الفرع</label>
                                    <input type="text" class="form-control @error('branch') is-invalid @enderror" 
                                           id="branch" name="branch" value="{{ old('branch', $bankAccount->branch) }}" 
                                           placeholder="فرع الرياض الرئيسي">
                                    @error('branch')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="currency" class="form-label">العملة <span class="text-danger">*</span></label>
                                    <select class="form-select @error('currency') is-invalid @enderror" 
                                            id="currency" name="currency" required>
                                        <option value="SAR" {{ old('currency', $bankAccount->currency) == 'SAR' ? 'selected' : '' }}>ريال سعودي (SAR)</option>
                                        <option value="USD" {{ old('currency', $bankAccount->currency) == 'USD' ? 'selected' : '' }}>دولار أمريكي (USD)</option>
                                        <option value="EUR" {{ old('currency', $bankAccount->currency) == 'EUR' ? 'selected' : '' }}>يورو (EUR)</option>
                                        <option value="GBP" {{ old('currency', $bankAccount->currency) == 'GBP' ? 'selected' : '' }}>جنيه إسترليني (GBP)</option>
                                    </select>
                                    @error('currency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check mt-4">
                                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                               {{ old('is_active', $bankAccount->is_active) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            <strong>حساب نشط</strong>
                                        </label>
                                        <div class="form-text">
                                            يمكن استخدام الحساب في المعاملات المالية
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" 
                                      id="notes" name="notes" rows="3" 
                                      placeholder="أي ملاحظات إضافية حول الحساب البنكي">{{ old('notes', $bankAccount->notes) }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- معلومات إضافية -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card border-info">
                                    <div class="card-header bg-info text-white">
                                        <h6 class="mb-0">معلومات الحساب</h6>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>تاريخ الإنشاء:</strong> {{ $bankAccount->created_at->format('Y-m-d H:i') }}</p>
                                        <p><strong>آخر تحديث:</strong> {{ $bankAccount->updated_at->format('Y-m-d H:i') }}</p>
                                        <p><strong>عدد الحركات:</strong> {{ $bankAccount->transactions->count() }} حركة</p>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="card border-warning">
                                    <div class="card-header bg-warning text-dark">
                                        <h6 class="mb-0">تنبيهات</h6>
                                    </div>
                                    <div class="card-body">
                                        @if($bankAccount->transactions->count() > 0)
                                            <div class="alert alert-warning">
                                                <i class="fas fa-exclamation-triangle"></i>
                                                يوجد {{ $bankAccount->transactions->count() }} حركة مرتبطة بهذا الحساب. 
                                                تغيير بعض البيانات قد يؤثر على التقارير المالية.
                                            </div>
                                        @else
                                            <div class="alert alert-success">
                                                <i class="fas fa-check-circle"></i>
                                                لا توجد حركات مرتبطة بهذا الحساب. يمكن تعديل جميع البيانات بأمان.
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ التغييرات
                            </button>
                            <div>
                                <a href="{{ route('accounting.bank-accounts.show', $bankAccount) }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                                @if($bankAccount->transactions->count() == 0)
                                    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                                        <i class="fas fa-trash"></i> حذف الحساب
                                    </button>
                                @endif
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
@if($bankAccount->transactions->count() == 0)
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد الحذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من حذف الحساب البنكي "{{ $bankAccount->bank_name }} - {{ $bankAccount->account_number }}"؟
                <br><small class="text-muted">لا يمكن التراجع عن هذا الإجراء.</small>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form action="{{ route('accounting.bank-accounts.destroy', $bankAccount) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">حذف نهائي</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endif
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // تنسيق IBAN تلقائياً
    $('#iban').on('input', function() {
        let value = this.value.replace(/\s/g, '').toUpperCase();
        if (!value.startsWith('SA') && value.length > 0) {
            value = 'SA' + value;
        }
        
        // إضافة مسافات كل 4 أحرف
        let formatted = value.replace(/(.{4})/g, '$1 ').trim();
        if (formatted.length <= 34) { // الحد الأقصى لطول IBAN
            this.value = formatted;
        }
    });
    
    // تنسيق رمز SWIFT
    $('#swift_code').on('input', function() {
        this.value = this.value.toUpperCase();
    });
    
    // التحقق من صحة IBAN
    $('#iban').on('blur', function() {
        const iban = this.value.replace(/\s/g, '');
        if (iban && iban.length > 0) {
            if (iban.length !== 24 || !iban.startsWith('SA')) {
                $(this).addClass('is-invalid');
                if (!$(this).next('.invalid-feedback').length) {
                    $(this).after('<div class="invalid-feedback">رقم الآيبان يجب أن يكون 24 رقم ويبدأ بـ SA</div>');
                }
            } else {
                $(this).removeClass('is-invalid');
                $(this).next('.invalid-feedback').remove();
            }
        }
    });
});
</script>
@endpush