@extends('layouts.app')

@section('title', 'إضافة حساب بنكي جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">إضافة حساب بنكي جديد</h5>
                    <a href="{{ route('accounting.bank-accounts.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    <form action="{{ route('accounting.bank-accounts.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="account_id" class="form-label">الحساب المحاسبي <span class="text-danger">*</span></label>
                                    <select class="form-select @error('account_id') is-invalid @enderror" 
                                            id="account_id" name="account_id" required>
                                        <option value="">اختر الحساب المحاسبي</option>
                                        @foreach($bankingAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->code }} - {{ $account->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('account_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">
                                        اختر الحساب المحاسبي المرتبط بهذا الحساب البنكي
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="bank_name" class="form-label">اسم البنك <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('bank_name') is-invalid @enderror" 
                                           id="bank_name" name="bank_name" value="{{ old('bank_name') }}" 
                                           placeholder="مثال: البنك الأهلي السعودي" required>
                                    @error('bank_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="account_number" class="form-label">رقم الحساب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('account_number') is-invalid @enderror" 
                                           id="account_number" name="account_number" value="{{ old('account_number') }}" 
                                           placeholder="123456789" required>
                                    @error('account_number')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="iban" class="form-label">رقم الآيبان (IBAN)</label>
                                    <input type="text" class="form-control @error('iban') is-invalid @enderror" 
                                           id="iban" name="iban" value="{{ old('iban') }}" 
                                           placeholder="SA1234567890123456789012">
                                    @error('iban')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">
                                        رقم الحساب المصرفي الدولي (اختياري)
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="swift_code" class="form-label">رمز SWIFT</label>
                                    <input type="text" class="form-control @error('swift_code') is-invalid @enderror" 
                                           id="swift_code" name="swift_code" value="{{ old('swift_code') }}" 
                                           placeholder="ALBILARI">
                                    @error('swift_code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">
                                        رمز التحويلات الدولية (اختياري)
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="branch" class="form-label">الفرع</label>
                                    <input type="text" class="form-control @error('branch') is-invalid @enderror" 
                                           id="branch" name="branch" value="{{ old('branch') }}" 
                                           placeholder="فرع الرياض الرئيسي">
                                    @error('branch')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="currency" class="form-label">العملة <span class="text-danger">*</span></label>
                                    <select class="form-select @error('currency') is-invalid @enderror" 
                                            id="currency" name="currency" required>
                                        <option value="SAR" {{ old('currency', 'SAR') == 'SAR' ? 'selected' : '' }}>ريال سعودي (SAR)</option>
                                        <option value="USD" {{ old('currency') == 'USD' ? 'selected' : '' }}>دولار أمريكي (USD)</option>
                                        <option value="EUR" {{ old('currency') == 'EUR' ? 'selected' : '' }}>يورو (EUR)</option>
                                        <option value="GBP" {{ old('currency') == 'GBP' ? 'selected' : '' }}>جنيه إسترليني (GBP)</option>
                                    </select>
                                    @error('currency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check mt-4">
                                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                               {{ old('is_active', true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            <strong>حساب نشط</strong>
                                        </label>
                                        <div class="form-text">
                                            يمكن استخدام الحساب في المعاملات المالية
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" 
                                      id="notes" name="notes" rows="3" 
                                      placeholder="أي ملاحظات إضافية حول الحساب البنكي">{{ old('notes') }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <strong>ملاحظة:</strong> سيتم ربط هذا الحساب البنكي بالحساب المحاسبي المحدد، وستظهر جميع الحركات في التقارير المالية.
                        </div>

                        <div class="d-flex justify-content-between">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ الحساب البنكي
                            </button>
                            <a href="{{ route('accounting.bank-accounts.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // تنسيق IBAN تلقائياً
    $('#iban').on('input', function() {
        let value = this.value.replace(/\s/g, '').toUpperCase();
        if (!value.startsWith('SA') && value.length > 0) {
            value = 'SA' + value;
        }
        
        // إضافة مسافات كل 4 أحرف
        let formatted = value.replace(/(.{4})/g, '$1 ').trim();
        if (formatted.length <= 34) { // الحد الأقصى لطول IBAN
            this.value = formatted;
        }
    });
    
    // تنسيق رمز SWIFT
    $('#swift_code').on('input', function() {
        this.value = this.value.toUpperCase();
    });
    
    // التحقق من صحة IBAN
    $('#iban').on('blur', function() {
        const iban = this.value.replace(/\s/g, '');
        if (iban && iban.length > 0) {
            if (iban.length !== 24 || !iban.startsWith('SA')) {
                $(this).addClass('is-invalid');
                if (!$(this).next('.invalid-feedback').length) {
                    $(this).after('<div class="invalid-feedback">رقم الآيبان يجب أن يكون 24 رقم ويبدأ بـ SA</div>');
                }
            } else {
                $(this).removeClass('is-invalid');
                $(this).next('.invalid-feedback').remove();
            }
        }
    });
});
</script>
@endpush