@extends('layouts.auth')

@section('title', 'إنشاء حساب جديد - نظام المبيعات')
@section('header-title', 'إنشاء حساب جديد')
@section('header-subtitle', 'انضم إلى نظام المبيعات')

@section('content')
<form method="POST" action="{{ route('register') }}" id="registerForm">
    @csrf
    
    <!-- Name Field -->
    <div class="form-floating">
        <input type="text" 
               class="form-control @error('name') is-invalid @enderror" 
               id="name" 
               name="name" 
               value="{{ old('name') }}" 
               placeholder="الاسم الكامل"
               required 
               autocomplete="name" 
               autofocus>
        <label for="name">
            <i class="fas fa-user me-2"></i>
            الاسم الكامل
        </label>
        @error('name')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    
    <!-- Email Field -->
    <div class="form-floating">
        <input type="email" 
               class="form-control @error('email') is-invalid @enderror" 
               id="email" 
               name="email" 
               value="{{ old('email') }}" 
               placeholder="البريد الإلكتروني"
               required 
               autocomplete="email">
        <label for="email">
            <i class="fas fa-envelope me-2"></i>
            البريد الإلكتروني
        </label>
        @error('email')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    
    <!-- Phone Field -->
    <div class="form-floating">
        <input type="tel" 
               class="form-control @error('phone') is-invalid @enderror" 
               id="phone" 
               name="phone" 
               value="{{ old('phone') }}" 
               placeholder="رقم الهاتف (اختياري)"
               autocomplete="tel">
        <label for="phone">
            <i class="fas fa-phone me-2"></i>
            رقم الهاتف (اختياري)
        </label>
        @error('phone')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    
    <!-- Role Field -->
    <div class="mb-4">
        <label for="role" class="form-label">
            <i class="fas fa-user-tag me-2"></i>
            الدور الوظيفي
        </label>
        <select class="form-select @error('role') is-invalid @enderror" 
                id="role" 
                name="role" 
                required>
            <option value="">اختر الدور...</option>
            <option value="admin" {{ old('role') === 'admin' ? 'selected' : '' }}>مدير النظام</option>
            <option value="manager" {{ old('role') === 'manager' ? 'selected' : '' }}>مدير</option>
            <option value="employee" {{ old('role') === 'employee' ? 'selected' : '' }}>موظف</option>
        </select>
        @error('role')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    
    <!-- Password Field -->
    <div class="form-floating">
        <input type="password" 
               class="form-control @error('password') is-invalid @enderror" 
               id="password" 
               name="password" 
               placeholder="كلمة المرور"
               required 
               autocomplete="new-password">
        <label for="password">
            <i class="fas fa-lock me-2"></i>
            كلمة المرور
        </label>
        @error('password')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    
    <!-- Confirm Password Field -->
    <div class="form-floating">
        <input type="password" 
               class="form-control @error('password_confirmation') is-invalid @enderror" 
               id="password_confirmation" 
               name="password_confirmation" 
               placeholder="تأكيد كلمة المرور"
               required 
               autocomplete="new-password">
        <label for="password_confirmation">
            <i class="fas fa-lock me-2"></i>
            تأكيد كلمة المرور
        </label>
        @error('password_confirmation')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    
    <!-- Submit Button -->
    <button type="submit" class="btn btn-auth" id="registerBtn">
        <span>
            <i class="fas fa-user-plus me-2"></i>
            إنشاء الحساب
        </span>
    </button>
    
    <!-- Links -->
    <div class="auth-links">
        <p class="mb-0">
            لديك حساب بالفعل؟ 
            <a href="{{ route('login') }}" class="text-decoration-none">
                <i class="fas fa-sign-in-alt me-1"></i>
                تسجيل الدخول
            </a>
        </p>
    </div>
</form>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // إضافة تأثير لإظهار/إخفاء كلمة المرور
        function addPasswordToggle(fieldId) {
            const passwordField = document.getElementById(fieldId);
            const toggleIcon = document.createElement('i');
            toggleIcon.className = 'fas fa-eye password-toggle';
            
            const passwordContainer = passwordField.parentElement;
            passwordContainer.style.position = 'relative';
            passwordContainer.appendChild(toggleIcon);
            
            toggleIcon.addEventListener('click', function() {
                if (passwordField.type === 'password') {
                    passwordField.type = 'text';
                    toggleIcon.className = 'fas fa-eye-slash password-toggle';
                } else {
                    passwordField.type = 'password';
                    toggleIcon.className = 'fas fa-eye password-toggle';
                }
            });
        }
        
        addPasswordToggle('password');
        addPasswordToggle('password_confirmation');
        
        // تحسين تأثيرات التركيز على الحقول
        const inputs = document.querySelectorAll('.form-control, .form-select');
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'translateY(-2px)';
                this.parentElement.style.transition = 'transform 0.4s cubic-bezier(0.4, 0, 0.2, 1)';
                this.parentElement.style.boxShadow = '0 8px 25px rgba(23, 164, 165, 0.15)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'translateY(0)';
                this.parentElement.style.boxShadow = 'none';
            });
            
            input.addEventListener('input', function() {
                if (this.value.length > 0) {
                    this.style.backgroundColor = 'rgba(255, 255, 255, 0.98)';
                } else {
                    this.style.backgroundColor = 'rgba(248, 251, 252, 0.8)';
                }
            });
        });
        
        // التحقق من تطابق كلمات المرور مع تأثيرات بصرية
        const password = document.getElementById('password');
        const passwordConfirm = document.getElementById('password_confirmation');
        
        function checkPasswordMatch() {
            if (password.value && passwordConfirm.value) {
                if (password.value === passwordConfirm.value) {
                    passwordConfirm.classList.remove('is-invalid');
                    passwordConfirm.style.borderColor = '#17a4a5';
                    passwordConfirm.style.backgroundColor = 'rgba(23, 164, 165, 0.05)';
                } else {
                    passwordConfirm.classList.add('is-invalid');
                    passwordConfirm.style.borderColor = '#dc3545';
                    passwordConfirm.style.backgroundColor = 'rgba(220, 53, 69, 0.05)';
                }
            }
        }
        
        password.addEventListener('input', checkPasswordMatch);
        passwordConfirm.addEventListener('input', checkPasswordMatch);
        
        // تحسين تأثير الزر مع حالة التحميل
        const registerForm = document.getElementById('registerForm');
        const registerBtn = document.getElementById('registerBtn');
        
        registerForm.addEventListener('submit', function(e) {
            registerBtn.classList.add('loading');
            registerBtn.innerHTML = '<span>جارٍ إنشاء الحساب...</span>';
            
            // منع الإرسال المتكرر
            setTimeout(() => {
                registerBtn.style.pointerEvents = 'none';
            }, 100);
        });
        
        // تأثيرات hover محسنة للروابط
        const authLinks = document.querySelectorAll('.auth-links a');
        authLinks.forEach(link => {
            link.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-1px)';
                this.style.textShadow = '0 2px 8px rgba(23, 164, 165, 0.3)';
            });
            
            link.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
                this.style.textShadow = 'none';
            });
        });
        
        // إضافة تأثير ripple للزر
        registerBtn.addEventListener('click', function(e) {
            const ripple = document.createElement('span');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;
            
            ripple.style.width = ripple.style.height = size + 'px';
            ripple.style.left = x + 'px';
            ripple.style.top = y + 'px';
            ripple.classList.add('ripple');
            
            this.appendChild(ripple);
            
            setTimeout(() => {
                ripple.remove();
            }, 600);
        });
        
        // تأثير الكتابة المتدرجة للعنوان
        const title = document.querySelector('.auth-header h2');
        const subtitle = document.querySelector('.auth-header p');
        
        if (title && subtitle) {
            title.style.opacity = '0';
            subtitle.style.opacity = '0';
            
            setTimeout(() => {
                title.style.animation = 'fadeInUp 0.8s ease-out forwards';
                title.style.opacity = '1';
            }, 300);
            
            setTimeout(() => {
                subtitle.style.animation = 'fadeInUp 0.8s ease-out forwards';
                subtitle.style.opacity = '1';
            }, 500);
        }
        
        // إضافة CSS للتأثيرات الإضافية
        const style = document.createElement('style');
        style.textContent = `
            @keyframes fadeInUp {
                from {
                    opacity: 0;
                    transform: translateY(20px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
            
            .ripple {
                position: absolute;
                border-radius: 50%;
                background: rgba(255, 255, 255, 0.3);
                transform: scale(0);
                animation: rippleEffect 0.6s linear;
                pointer-events: none;
            }
            
            @keyframes rippleEffect {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }
            
            .form-select {
                border: 2px solid #e8f4f8;
                border-radius: 12px;
                padding: 18px 20px;
                font-size: 1.1rem;
                transition: all 0.4s ease;
                background: rgba(248, 251, 252, 0.8);
                color: #2c3e50;
                font-weight: 500;
            }
            
            .form-select:focus {
                border-color: #17a4a5;
                box-shadow: 0 0 0 0.25rem rgba(23, 164, 165, 0.15);
                background: rgba(255, 255, 255, 0.95);
            }
            
            .form-label {
                font-weight: 600;
                color: #5a6c7d;
                margin-bottom: 10px;
                font-size: 1.1rem;
            }
        `;
        document.head.appendChild(style);
        
        // إضافة تأثير تنفس للشعار
        const logo = document.querySelector('.auth-header .logo');
        if (logo) {
            setInterval(() => {
                logo.style.transform = 'scale(1.05)';
                setTimeout(() => {
                    logo.style.transform = 'scale(1)';
                }, 1000);
            }, 3000);
        }
    });
</script>
@endpush
@endsection