@extends('layouts.auth')

@section('title', 'نسيت كلمة المرور - نظام المبيعات')
@section('header-title', 'نسيت كلمة المرور؟')
@section('header-subtitle', 'أدخل بريدك الإلكتروني لإعادة تعيين كلمة المرور')

@section('content')
<form method="POST" action="{{ route('password.email') }}">
    @csrf
    
    <div class="mb-4 text-center">
        <i class="fas fa-key fa-3x text-muted mb-3"></i>
        <p class="text-muted">
            أدخل عنوان بريدك الإلكتروني وسنرسل لك رابط إعادة تعيين كلمة المرور
        </p>
    </div>
    
    <!-- Email Field -->
    <div class="form-floating">
        <input type="email" 
               class="form-control @error('email') is-invalid @enderror" 
               id="email" 
               name="email" 
               value="{{ old('email') }}" 
               placeholder="البريد الإلكتروني"
               required 
               autocomplete="email" 
               autofocus>
        <label for="email">
            <i class="fas fa-envelope me-2"></i>
            البريد الإلكتروني
        </label>
        @error('email')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    
    <!-- Submit Button -->
    <button type="submit" class="btn btn-auth">
        <i class="fas fa-paper-plane me-2"></i>
        إرسال رابط إعادة التعيين
    </button>
    
    <!-- Links -->
    <div class="auth-links">
        <p class="mb-0">
            تذكرت كلمة المرور؟ 
            <a href="{{ route('login') }}" class="text-decoration-none">
                <i class="fas fa-sign-in-alt me-1"></i>
                تسجيل الدخول
            </a>
        </p>
    </div>
</form>
@endsection