@extends('layouts.app')

@section('title', 'ميزان المراجعة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-balance-scale"></i>
                        ميزان المراجعة
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.reports.export.trial-balance', request()->all()) }}" 
                           class="btn btn-success">
                            <i class="fas fa-file-excel"></i> تصدير Excel
                        </a>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر التاريخ -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="start_date" class="form-label">من تاريخ</label>
                                <input type="date" name="start_date" id="start_date" 
                                       class="form-control" value="{{ $startDate }}">
                            </div>
                            <div class="col-md-3">
                                <label for="end_date" class="form-label">إلى تاريخ</label>
                                <input type="date" name="end_date" id="end_date" 
                                       class="form-control" value="{{ $endDate }}">
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> عرض
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- معلومات التقرير -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">معلومات التقرير</h6>
                                    <p class="card-text mb-1">
                                        <strong>الفترة:</strong> من {{ $startDate }} إلى {{ $endDate }}
                                    </p>
                                    <p class="card-text mb-1">
                                        <strong>تاريخ الإنشاء:</strong> {{ now()->format('Y-m-d H:i:s') }}
                                    </p>
                                    <p class="card-text mb-0">
                                        <strong>عدد الحسابات:</strong> {{ count($trialBalanceData) }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">الإجماليات</h6>
                                    <p class="card-text mb-1">
                                        <strong>إجمالي المدين:</strong> 
                                        <span class="text-success">{{ number_format($totalDebits, 2) }} ريال</span>
                                    </p>
                                    <p class="card-text mb-1">
                                        <strong>إجمالي الدائن:</strong> 
                                        <span class="text-info">{{ number_format($totalCredits, 2) }} ريال</span>
                                    </p>
                                    <p class="card-text mb-0">
                                        <strong>الفرق:</strong> 
                                        <span class="{{ abs($totalDebits - $totalCredits) > 0.01 ? 'text-danger' : 'text-success' }}">
                                            {{ number_format($totalDebits - $totalCredits, 2) }} ريال
                                        </span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- تحذير في حالة عدم التوازن -->
                    @if(abs($totalDebits - $totalCredits) > 0.01)
                        <div class="alert alert-danger" role="alert">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>تحذير:</strong> ميزان المراجعة غير متوازن! الفرق هو {{ number_format($totalDebits - $totalCredits, 2) }} ريال
                        </div>
                    @else
                        <div class="alert alert-success" role="alert">
                            <i class="fas fa-check-circle"></i>
                            <strong>ممتاز:</strong> ميزان المراجعة متوازن
                        </div>
                    @endif

                    <!-- جدول ميزان المراجعة -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                                <tr>
                                    <th rowspan="2" class="text-center align-middle">رمز الحساب</th>
                                    <th rowspan="2" class="text-center align-middle">اسم الحساب</th>
                                    <th colspan="2" class="text-center">إجمالي الحركات</th>
                                    <th colspan="2" class="text-center">أرصدة الحسابات</th>
                                </tr>
                                <tr>
                                    <th class="text-center">مدين</th>
                                    <th class="text-center">دائن</th>
                                    <th class="text-center">مدين</th>
                                    <th class="text-center">دائن</th>
                                </tr>
                            <tbody>
                                @forelse($trialBalanceData as $data)
                                <tr>
                                    <td class="text-center">
                                        <strong>{{ $data['account']->code }}</strong>
                                    </td>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $data['account']) }}" 
                                           class="text-decoration-none">
                                            {{ $data['account']->name }}
                                        </a>
                                        @if($data['account']->is_cash_account)
                                            <span class="badge bg-success ms-1">نقدي</span>
                                        @endif
                                        @if($data['account']->is_bank_account)
                                            <span class="badge bg-info ms-1">بنكي</span>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        {{ $data['debit_movements'] > 0 ? number_format($data['debit_movements'], 2) : '-' }}
                                    </td>
                                    <td class="text-end">
                                        {{ $data['credit_movements'] > 0 ? number_format($data['credit_movements'], 2) : '-' }}
                                    </td>
                                    <td class="text-end">
                                        @if($data['debit_balance'] > 0)
                                            <strong class="text-success">{{ number_format($data['debit_balance'], 2) }}</strong>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        @if($data['credit_balance'] > 0)
                                            <strong class="text-info">{{ number_format($data['credit_balance'], 2) }}</strong>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">
                                        <i class="fas fa-info-circle"></i>
                                        لا توجد حركات في الفترة المحددة
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                            @if(count($trialBalanceData) > 0)
                            <tfoot class="table-secondary">
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">الإجمالي</td>
                                    <td class="text-end">
                                        {{ number_format(collect($trialBalanceData)->sum('debit_movements'), 2) }}
                                    </td>
                                    <td class="text-end">
                                        {{ number_format(collect($trialBalanceData)->sum('credit_movements'), 2) }}
                                    </td>
                                    <td class="text-end text-success">
                                        <strong>{{ number_format($totalDebits, 2) }}</strong>
                                    </td>
                                    <td class="text-end text-info">
                                        <strong>{{ number_format($totalCredits, 2) }}</strong>
                                    </td>
                                </tr>
                            </tfoot>
                            @endif
                        </table>
                    </div>

                    <!-- إحصائيات إضافية -->
                    @if(count($trialBalanceData) > 0)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">إحصائيات الحسابات</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="text-center">
                                                <h5 class="text-primary">
                                                    {{ collect($trialBalanceData)->where('account.type', 'asset')->count() }}
                                                </h5>
                                                <small class="text-muted">حسابات الأصول</small>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="text-center">
                                                <h5 class="text-danger">
                                                    {{ collect($trialBalanceData)->where('account.type', 'liability')->count() }}
                                                </h5>
                                                <small class="text-muted">حسابات الخصوم</small>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="text-center">
                                                <h5 class="text-success">
                                                    {{ collect($trialBalanceData)->where('account.type', 'revenue')->count() }}
                                                </h5>
                                                <small class="text-muted">حسابات الإيرادات</small>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="text-center">
                                                <h5 class="text-warning">
                                                    {{ collect($trialBalanceData)->where('account.type', 'expense')->count() }}
                                                </h5>
                                                <small class="text-muted">حسابات المصروفات</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
@media print {
    .btn-group, .card-header .btn-group, form {
        display: none !important;
    }
    
    .card {
        box-shadow: none !important;
        border: none !important;
    }
    
    .table {
        font-size: 12px;
    }
    
    .alert {
        break-inside: avoid;
    }
}
</style>
@endsection