@extends('layouts.app')

@section('title', 'قائمة الدخل')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-chart-pie"></i>
                        قائمة الدخل (الأرباح والخسائر)
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.reports.export.income-statement', request()->all()) }}" 
                           class="btn btn-success">
                            <i class="fas fa-file-excel"></i> تصدير Excel
                        </a>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر التاريخ -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="start_date" class="form-label">من تاريخ</label>
                                <input type="date" name="start_date" id="start_date" 
                                       class="form-control" value="{{ $startDate }}">
                            </div>
                            <div class="col-md-3">
                                <label for="end_date" class="form-label">إلى تاريخ</label>
                                <input type="date" name="end_date" id="end_date" 
                                       class="form-control" value="{{ $endDate }}">
                            </div>
                            <div class="col-md-3">
                                <label for="comparison" class="form-label">مقارنة</label>
                                <select name="comparison" id="comparison" class="form-select">
                                    <option value="">بدون مقارنة</option>
                                    <option value="previous_period" {{ request('comparison') == 'previous_period' ? 'selected' : '' }}>
                                        الفترة السابقة
                                    </option>
                                    <option value="previous_year" {{ request('comparison') == 'previous_year' ? 'selected' : '' }}>
                                        السنة السابقة
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> عرض
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- معلومات التقرير -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">معلومات التقرير</h6>
                                    <p class="card-text mb-1">
                                        <strong>الفترة:</strong> من {{ $startDate }} إلى {{ $endDate }}
                                    </p>
                                    <p class="card-text mb-1">
                                        <strong>تاريخ الإنشاء:</strong> {{ now()->format('Y-m-d H:i:s') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">النتيجة النهائية</h6>
                                    <p class="card-text mb-1">
                                        <strong>صافي الربح/الخسارة:</strong> 
                                        <span class="{{ $netIncome >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($netIncome, 2) }} ريال
                                        </span>
                                    </p>
                                    <p class="card-text mb-0">
                                        <strong>هامش الربح:</strong> 
                                        <span class="{{ $profitMargin >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($profitMargin, 2) }}%
                                        </span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الإيرادات -->
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-arrow-up"></i>
                                الإيرادات
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-sm">
                                        <tr>
                                            <th>البيان</th>
                                            <th class="text-end">المبلغ (ريال)</th>
                                            @if(isset($comparisonData))
                                            <th class="text-end">الفترة المقارنة</th>
                                            <th class="text-end">التغيير</th>
                                            @endif
                                        </tr>
                                    <tbody>
                                        @foreach($revenueAccounts as $account)
                                        <tr>
                                            <td>
                                                <a href="{{ route('accounting.accounts.show', $account['id']) }}" 
                                                   class="text-decoration-none">
                                                    {{ $account['name'] }}
                                                </a>
                                            </td>
                                            <td class="text-end">{{ number_format($account['amount'], 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($account['comparison_amount'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                @php 
                                                    $change = $account['amount'] - ($account['comparison_amount'] ?? 0);
                                                    $changePercent = ($account['comparison_amount'] ?? 0) > 0 ? ($change / $account['comparison_amount']) * 100 : 0;
                                                @endphp
                                                <span class="{{ $change >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($change, 2) }}
                                                    ({{ number_format($changePercent, 1) }}%)
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                        @endforeach
                                        <tr class="table-success fw-bold">
                                            <td>إجمالي الإيرادات</td>
                                            <td class="text-end">{{ number_format($totalRevenue, 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($comparisonData['total_revenue'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                @php 
                                                    $revenueChange = $totalRevenue - ($comparisonData['total_revenue'] ?? 0);
                                                    $revenueChangePercent = ($comparisonData['total_revenue'] ?? 0) > 0 ? ($revenueChange / $comparisonData['total_revenue']) * 100 : 0;
                                                @endphp
                                                <span class="{{ $revenueChange >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($revenueChange, 2) }}
                                                    ({{ number_format($revenueChangePercent, 1) }}%)
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- تكلفة البضاعة المباعة -->
                    @if($totalCOGS > 0)
                    <div class="card mb-4">
                        <div class="card-header bg-warning text-dark">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-boxes"></i>
                                تكلفة البضاعة المباعة
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <tbody>
                                        @foreach($cogsAccounts as $account)
                                        <tr>
                                            <td>
                                                <a href="{{ route('accounting.accounts.show', $account['id']) }}" 
                                                   class="text-decoration-none">
                                                    {{ $account['name'] }}
                                                </a>
                                            </td>
                                            <td class="text-end">{{ number_format($account['amount'], 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($account['comparison_amount'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                @php 
                                                    $change = $account['amount'] - ($account['comparison_amount'] ?? 0);
                                                    $changePercent = ($account['comparison_amount'] ?? 0) > 0 ? ($change / $account['comparison_amount']) * 100 : 0;
                                                @endphp
                                                <span class="{{ $change <= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($change, 2) }}
                                                    ({{ number_format($changePercent, 1) }}%)
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                        @endforeach
                                        <tr class="table-warning fw-bold">
                                            <td>إجمالي تكلفة البضاعة المباعة</td>
                                            <td class="text-end">{{ number_format($totalCOGS, 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($comparisonData['total_cogs'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                @php 
                                                    $cogsChange = $totalCOGS - ($comparisonData['total_cogs'] ?? 0);
                                                    $cogsChangePercent = ($comparisonData['total_cogs'] ?? 0) > 0 ? ($cogsChange / $comparisonData['total_cogs']) * 100 : 0;
                                                @endphp
                                                <span class="{{ $cogsChange <= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($cogsChange, 2) }}
                                                    ({{ number_format($cogsChangePercent, 1) }}%)
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                        <tr class="table-primary fw-bold">
                                            <td>إجمالي الربح</td>
                                            <td class="text-end">{{ number_format($grossProfit, 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($comparisonData['gross_profit'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                @php 
                                                    $grossProfitChange = $grossProfit - ($comparisonData['gross_profit'] ?? 0);
                                                    $grossProfitChangePercent = ($comparisonData['gross_profit'] ?? 0) > 0 ? ($grossProfitChange / $comparisonData['gross_profit']) * 100 : 0;
                                                @endphp
                                                <span class="{{ $grossProfitChange >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($grossProfitChange, 2) }}
                                                    ({{ number_format($grossProfitChangePercent, 1) }}%)
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- المصروفات -->
                    <div class="card mb-4">
                        <div class="card-header bg-danger text-white">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-arrow-down"></i>
                                المصروفات
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <tbody>
                                        @foreach($expenseAccounts as $account)
                                        <tr>
                                            <td>
                                                <a href="{{ route('accounting.accounts.show', $account['id']) }}" 
                                                   class="text-decoration-none">
                                                    {{ $account['name'] }}
                                                </a>
                                            </td>
                                            <td class="text-end">{{ number_format($account['amount'], 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($account['comparison_amount'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                @php 
                                                    $change = $account['amount'] - ($account['comparison_amount'] ?? 0);
                                                    $changePercent = ($account['comparison_amount'] ?? 0) > 0 ? ($change / $account['comparison_amount']) * 100 : 0;
                                                @endphp
                                                <span class="{{ $change <= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($change, 2) }}
                                                    ({{ number_format($changePercent, 1) }}%)
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                        @endforeach
                                        <tr class="table-danger fw-bold">
                                            <td>إجمالي المصروفات</td>
                                            <td class="text-end">{{ number_format($totalExpenses, 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($comparisonData['total_expenses'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                @php 
                                                    $expensesChange = $totalExpenses - ($comparisonData['total_expenses'] ?? 0);
                                                    $expensesChangePercent = ($comparisonData['total_expenses'] ?? 0) > 0 ? ($expensesChange / $comparisonData['total_expenses']) * 100 : 0;
                                                @endphp
                                                <span class="{{ $expensesChange <= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($expensesChange, 2) }}
                                                    ({{ number_format($expensesChangePercent, 1) }}%)
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- النتيجة النهائية -->
                    <div class="card">
                        <div class="card-header {{ $netIncome >= 0 ? 'bg-success' : 'bg-danger' }} text-white">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-chart-line"></i>
                                النتيجة النهائية
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td class="fw-bold">إجمالي الإيرادات</td>
                                            <td class="text-end fw-bold text-success">{{ number_format($totalRevenue, 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($comparisonData['total_revenue'] ?? 0, 2) }}</td>
                                            @endif
                                        </tr>
                                        @if($totalCOGS > 0)
                                        <tr>
                                            <td>ناقص: تكلفة البضاعة المباعة</td>
                                            <td class="text-end text-warning">{{ number_format($totalCOGS, 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($comparisonData['total_cogs'] ?? 0, 2) }}</td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td class="fw-bold">إجمالي الربح</td>
                                            <td class="text-end fw-bold">{{ number_format($grossProfit, 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($comparisonData['gross_profit'] ?? 0, 2) }}</td>
                                            @endif
                                        </tr>
                                        @endif
                                        <tr>
                                            <td>ناقص: إجمالي المصروفات</td>
                                            <td class="text-end text-danger">{{ number_format($totalExpenses, 2) }}</td>
                                            @if(isset($comparisonData))
                                            <td class="text-end">{{ number_format($comparisonData['total_expenses'] ?? 0, 2) }}</td>
                                            @endif
                                        </tr>
                                        <tr class="table-{{ $netIncome >= 0 ? 'success' : 'danger' }}">
                                            <td class="fw-bold fs-5">
                                                صافي {{ $netIncome >= 0 ? 'الربح' : 'الخسارة' }}
                                            </td>
                                            <td class="text-end fw-bold fs-5">
                                                <span class="{{ $netIncome >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($netIncome, 2) }}
                                                </span>
                                            </td>
                                            @if(isset($comparisonData))
                                            <td class="text-end fw-bold">
                                                {{ number_format($comparisonData['net_income'] ?? 0, 2) }}
                                            </td>
                                            @endif
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <!-- النسب المالية -->
                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <div class="card bg-light">
                                        <div class="card-body">
                                            <h6 class="card-title">النسب المالية</h6>
                                            <p class="card-text mb-1">
                                                <strong>هامش الربح الإجمالي:</strong> 
                                                {{ $totalRevenue > 0 ? number_format(($grossProfit / $totalRevenue) * 100, 2) : 0 }}%
                                            </p>
                                            <p class="card-text mb-1">
                                                <strong>هامش الربح الصافي:</strong> 
                                                {{ number_format($profitMargin, 2) }}%
                                            </p>
                                            <p class="card-text mb-0">
                                                <strong>نسبة المصروفات:</strong> 
                                                {{ $totalRevenue > 0 ? number_format(($totalExpenses / $totalRevenue) * 100, 2) : 0 }}%
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
@media print {
    .btn-group, .card-header .btn-group, form {
        display: none !important;
    }
    
    .card {
        box-shadow: none !important;
        border: none !important;
        page-break-inside: avoid;
    }
    
    .table {
        font-size: 12px;
    }
}
</style>
@endsection