@extends('layouts.app')

@section('title', 'دفتر الأستاذ العام')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-book"></i>
                        دفتر الأستاذ العام
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.reports.export.general-ledger', request()->all()) }}" 
                           class="btn btn-success">
                            <i class="fas fa-file-excel"></i> تصدير Excel
                        </a>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="start_date" class="form-label">من تاريخ</label>
                                <input type="date" name="start_date" id="start_date" 
                                       class="form-control" value="{{ $startDate }}">
                            </div>
                            <div class="col-md-3">
                                <label for="end_date" class="form-label">إلى تاريخ</label>
                                <input type="date" name="end_date" id="end_date" 
                                       class="form-control" value="{{ $endDate }}">
                            </div>
                            <div class="col-md-3">
                                <label for="account_id" class="form-label">الحساب</label>
                                <select name="account_id" id="account_id" class="form-select">
                                    <option value="">جميع الحسابات</option>
                                    @foreach($accounts as $account)
                                        <option value="{{ $account->id }}" 
                                                {{ request('account_id') == $account->id ? 'selected' : '' }}>
                                            {{ $account->code }} - {{ $account->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> عرض
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- معلومات التقرير -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">معلومات التقرير</h6>
                                    <p class="card-text mb-1">
                                        <strong>الفترة:</strong> من {{ $startDate }} إلى {{ $endDate }}
                                    </p>
                                    <p class="card-text mb-1">
                                        <strong>تاريخ الإنشاء:</strong> {{ now()->format('Y-m-d H:i:s') }}
                                    </p>
                                    <p class="card-text mb-0">
                                        <strong>عدد القيود:</strong> {{ $totalEntries }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">الإجماليات</h6>
                                    <p class="card-text mb-1">
                                        <strong>إجمالي المدين:</strong> 
                                        <span class="text-success">{{ number_format($totalDebits, 2) }} ريال</span>
                                    </p>
                                    <p class="card-text mb-0">
                                        <strong>إجمالي الدائن:</strong> 
                                        <span class="text-info">{{ number_format($totalCredits, 2) }} ريال</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- دفتر الأستاذ -->
                    @forelse($ledgerData as $accountData)
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <strong>{{ $accountData['account']->code }}</strong> - {{ $accountData['account']->name }}
                                @if($accountData['account']->is_cash_account)
                                    <span class="badge bg-success ms-2">نقدي</span>
                                @endif
                                @if($accountData['account']->is_bank_account)
                                    <span class="badge bg-info ms-2">بنكي</span>
                                @endif
                            </h5>
                        </div>
                        <div class="card-body">
                            <!-- الرصيد الافتتاحي -->
                            @if($accountData['opening_balance'] != 0)
                            <div class="alert alert-light">
                                <strong>الرصيد الافتتاحي:</strong> 
                                <span class="{{ $accountData['opening_balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ number_format(abs($accountData['opening_balance']), 2) }} ريال
                                    {{ $accountData['opening_balance'] >= 0 ? '(مدين)' : '(دائن)' }}
                                </span>
                            </div>
                            @endif

                            <div class="table-responsive">
                                <table class="table table-bordered table-sm">
                                        <tr>
                                            <th class="text-center">التاريخ</th>
                                            <th class="text-center">رقم القيد</th>
                                            <th>البيان</th>
                                            <th class="text-center">مدين</th>
                                            <th class="text-center">دائن</th>
                                            <th class="text-center">الرصيد</th>
                                        </tr>
                                    <tbody>
                                        @php $runningBalance = $accountData['opening_balance']; @endphp
                                        @forelse($accountData['entries'] as $entry)
                                        @php 
                                            $runningBalance += $entry->debit_amount - $entry->credit_amount;
                                        @endphp
                                        <tr>
                                            <td class="text-center">
                                                {{ \Carbon\Carbon::parse($entry->date)->format('Y-m-d') }}
                                            </td>
                                            <td class="text-center">
                                                <a href="{{ route('accounting.journal-entries.show', $entry->journal_entry_id) }}" 
                                                   class="text-decoration-none">
                                                    {{ $entry->reference }}
                                                </a>
                                            </td>
                                            <td>{{ $entry->description }}</td>
                                            <td class="text-end">
                                                {{ $entry->debit_amount > 0 ? number_format($entry->debit_amount, 2) : '-' }}
                                            </td>
                                            <td class="text-end">
                                                {{ $entry->credit_amount > 0 ? number_format($entry->credit_amount, 2) : '-' }}
                                            </td>
                                            <td class="text-end">
                                                <span class="{{ $runningBalance >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format(abs($runningBalance), 2) }}
                                                    {{ $runningBalance >= 0 ? 'مدين' : 'دائن' }}
                                                </span>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">
                                                لا توجد حركات في الفترة المحددة
                                            </td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                    @if(count($accountData['entries']) > 0)
                                    <tfoot class="table-secondary">
                                        <tr class="fw-bold">
                                            <td colspan="3" class="text-center">الإجمالي</td>
                                            <td class="text-end">
                                                {{ number_format($accountData['total_debits'], 2) }}
                                            </td>
                                            <td class="text-end">
                                                {{ number_format($accountData['total_credits'], 2) }}
                                            </td>
                                            <td class="text-end">
                                                <span class="{{ $accountData['closing_balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format(abs($accountData['closing_balance']), 2) }}
                                                    {{ $accountData['closing_balance'] >= 0 ? 'مدين' : 'دائن' }}
                                                </span>
                                            </td>
                                        </tr>
                                    </tfoot>
                                    @endif
                                </table>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        لا توجد حركات للحسابات المحددة في الفترة المحددة
                    </div>
                    @endforelse

                    <!-- ملخص الحسابات -->
                    @if(count($ledgerData) > 0)
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-chart-bar"></i>
                                ملخص الحسابات
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                        <tr>
                                            <th>رمز الحساب</th>
                                            <th>اسم الحساب</th>
                                            <th class="text-center">الرصيد الافتتاحي</th>
                                            <th class="text-center">إجمالي المدين</th>
                                            <th class="text-center">إجمالي الدائن</th>
                                            <th class="text-center">الرصيد الختامي</th>
                                        </tr>
                                    <tbody>
                                        @foreach($ledgerData as $accountData)
                                        <tr>
                                            <td class="text-center">
                                                <strong>{{ $accountData['account']->code }}</strong>
                                            </td>
                                            <td>
                                                <a href="{{ route('accounting.accounts.show', $accountData['account']) }}" 
                                                   class="text-decoration-none">
                                                    {{ $accountData['account']->name }}
                                                </a>
                                            </td>
                                            <td class="text-end">
                                                <span class="{{ $accountData['opening_balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format(abs($accountData['opening_balance']), 2) }}
                                                    {{ $accountData['opening_balance'] >= 0 ? 'مدين' : 'دائن' }}
                                                </span>
                                            </td>
                                            <td class="text-end">
                                                {{ number_format($accountData['total_debits'], 2) }}
                                            </td>
                                            <td class="text-end">
                                                {{ number_format($accountData['total_credits'], 2) }}
                                            </td>
                                            <td class="text-end">
                                                <span class="{{ $accountData['closing_balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format(abs($accountData['closing_balance']), 2) }}
                                                    {{ $accountData['closing_balance'] >= 0 ? 'مدين' : 'دائن' }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
@media print {
    .btn-group, .card-header .btn-group, form {
        display: none !important;
    }
    
    .card {
        box-shadow: none !important;
        border: none !important;
        page-break-inside: avoid;
    }
    
    .table {
        font-size: 11px;
    }
    
    .alert {
        break-inside: avoid;
    }
}
</style>
@endsection