@extends('layouts.app')

@section('title', 'تقرير التدفق النقدي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-chart-line"></i>
                        تقرير التدفق النقدي
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.reports.export.cash-flow', request()->all()) }}" 
                           class="btn btn-success">
                            <i class="fas fa-file-excel"></i> تصدير Excel
                        </a>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر التاريخ -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="start_date" class="form-label">من تاريخ</label>
                                <input type="date" name="start_date" id="start_date" 
                                       class="form-control" value="{{ $startDate }}">
                            </div>
                            <div class="col-md-3">
                                <label for="end_date" class="form-label">إلى تاريخ</label>
                                <input type="date" name="end_date" id="end_date" 
                                       class="form-control" value="{{ $endDate }}">
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> عرض
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- معلومات التقرير -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">معلومات التقرير</h6>
                                    <p class="card-text mb-1">
                                        <strong>الفترة:</strong> من {{ $startDate }} إلى {{ $endDate }}
                                    </p>
                                    <p class="card-text mb-1">
                                        <strong>تاريخ الإنشاء:</strong> {{ now()->format('Y-m-d H:i:s') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">ملخص التدفق النقدي</h6>
                                    <p class="card-text mb-1">
                                        <strong>صافي التدفق النقدي:</strong> 
                                        <span class="{{ $netCashFlow >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($netCashFlow, 2) }} ريال
                                        </span>
                                    </p>
                                    <p class="card-text mb-0">
                                        <strong>الرصيد النقدي النهائي:</strong> 
                                        <span class="text-info">{{ number_format($endingCashBalance, 2) }} ريال</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الأنشطة التشغيلية -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-cogs"></i>
                                التدفق النقدي من الأنشطة التشغيلية
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <tbody>
                                        @foreach($operatingActivities as $item)
                                        <tr>
                                            <td>{{ $item['description'] }}</td>
                                            <td class="text-end">
                                                <span class="{{ $item['amount'] >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($item['amount'], 2) }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                        <tr class="table-primary fw-bold">
                                            <td>صافي التدفق النقدي من الأنشطة التشغيلية</td>
                                            <td class="text-end">
                                                <span class="{{ $operatingCashFlow >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($operatingCashFlow, 2) }}
                                                </span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- الأنشطة الاستثمارية -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-chart-line"></i>
                                التدفق النقدي من الأنشطة الاستثمارية
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <tbody>
                                        @foreach($investingActivities as $item)
                                        <tr>
                                            <td>{{ $item['description'] }}</td>
                                            <td class="text-end">
                                                <span class="{{ $item['amount'] >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($item['amount'], 2) }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                        <tr class="table-warning fw-bold">
                                            <td>صافي التدفق النقدي من الأنشطة الاستثمارية</td>
                                            <td class="text-end">
                                                <span class="{{ $investingCashFlow >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($investingCashFlow, 2) }}
                                                </span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- الأنشطة التمويلية -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-university"></i>
                                التدفق النقدي من الأنشطة التمويلية
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <tbody>
                                        @foreach($financingActivities as $item)
                                        <tr>
                                            <td>{{ $item['description'] }}</td>
                                            <td class="text-end">
                                                <span class="{{ $item['amount'] >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($item['amount'], 2) }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                        <tr class="table-info fw-bold">
                                            <td>صافي التدفق النقدي من الأنشطة التمويلية</td>
                                            <td class="text-end">
                                                <span class="{{ $financingCashFlow >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($financingCashFlow, 2) }}
                                                </span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- ملخص التدفق النقدي -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-calculator"></i>
                                ملخص التدفق النقدي
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td>الرصيد النقدي في بداية الفترة</td>
                                            <td class="text-end fw-bold">{{ number_format($beginningCashBalance, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td>صافي التدفق النقدي من الأنشطة التشغيلية</td>
                                            <td class="text-end">{{ number_format($operatingCashFlow, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td>صافي التدفق النقدي من الأنشطة الاستثمارية</td>
                                            <td class="text-end">{{ number_format($investingCashFlow, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td>صافي التدفق النقدي من الأنشطة التمويلية</td>
                                            <td class="text-end">{{ number_format($financingCashFlow, 2) }}</td>
                                        </tr>
                                        <tr class="table-success">
                                            <td class="fw-bold">صافي التغير في النقدية</td>
                                            <td class="text-end fw-bold">
                                                <span class="{{ $netCashFlow >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($netCashFlow, 2) }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr class="table-primary">
                                            <td class="fw-bold">الرصيد النقدي في نهاية الفترة</td>
                                            <td class="text-end fw-bold text-primary">{{ number_format($endingCashBalance, 2) }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
@media print {
    .btn-group, .card-header .btn-group, form {
        display: none !important;
    }
    
    .card {
        box-shadow: none !important;
        border: none !important;
    }
    
    .table {
        font-size: 12px;
    }
}
</style>
@endsection