@extends('layouts.app')

@section('title', 'الميزانية العمومية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-balance-scale"></i>
                        الميزانية العمومية
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.reports.export.balance-sheet', request()->all()) }}" 
                           class="btn btn-success">
                            <i class="fas fa-file-excel"></i> تصدير Excel
                        </a>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر التاريخ -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="as_of_date" class="form-label">في تاريخ</label>
                                <input type="date" name="as_of_date" id="as_of_date" 
                                       class="form-control" value="{{ $asOfDate }}">
                            </div>
                            <div class="col-md-3">
                                <label for="comparison_date" class="form-label">تاريخ المقارنة</label>
                                <input type="date" name="comparison_date" id="comparison_date" 
                                       class="form-control" value="{{ $comparisonDate ?? '' }}">
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> عرض
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- معلومات التقرير -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">معلومات التقرير</h6>
                                    <p class="card-text mb-1">
                                        <strong>في تاريخ:</strong> {{ $asOfDate }}
                                    </p>
                                    <p class="card-text mb-1">
                                        <strong>تاريخ الإنشاء:</strong> {{ now()->format('Y-m-d H:i:s') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">التوازن المالي</h6>
                                    <p class="card-text mb-1">
                                        <strong>إجمالي الأصول:</strong> 
                                        <span class="text-success">{{ number_format($totalAssets, 2) }} ريال</span>
                                    </p>
                                    <p class="card-text mb-0">
                                        <strong>الخصوم + حقوق الملكية:</strong> 
                                        <span class="text-info">{{ number_format($totalLiabilitiesAndEquity, 2) }} ريال</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- تحذير في حالة عدم التوازن -->
                    @if(abs($totalAssets - $totalLiabilitiesAndEquity) > 0.01)
                        <div class="alert alert-danger" role="alert">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>تحذير:</strong> الميزانية العمومية غير متوازنة! الفرق هو {{ number_format($totalAssets - $totalLiabilitiesAndEquity, 2) }} ريال
                        </div>
                    @else
                        <div class="alert alert-success" role="alert">
                            <i class="fas fa-check-circle"></i>
                            <strong>ممتاز:</strong> الميزانية العمومية متوازنة
                        </div>
                    @endif

                    <div class="row">
                        <!-- الأصول -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-coins"></i>
                                        الأصول
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <!-- الأصول المتداولة -->
                                    <h6 class="text-primary mb-3">الأصول المتداولة</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                                <tr>
                                                    <th>البيان</th>
                                                    <th class="text-end">المبلغ (ريال)</th>
                                                    @if(isset($comparisonData))
                                                    <th class="text-end">المقارنة</th>
                                                    @endif
                                                </tr>
                                            <tbody>
                                                @foreach($currentAssets as $asset)
                                                <tr>
                                                    <td>
                                                        <a href="{{ route('accounting.accounts.show', $asset['id']) }}" 
                                                           class="text-decoration-none">
                                                            {{ $asset['name'] }}
                                                        </a>
                                                        @if($asset['is_cash'])
                                                            <span class="badge bg-success ms-1">نقدي</span>
                                                        @endif
                                                        @if($asset['is_bank'])
                                                            <span class="badge bg-info ms-1">بنكي</span>
                                                        @endif
                                                    </td>
                                                    <td class="text-end">{{ number_format($asset['balance'], 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($asset['comparison_balance'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                                @endforeach
                                                <tr class="table-light fw-bold">
                                                    <td>إجمالي الأصول المتداولة</td>
                                                    <td class="text-end">{{ number_format($totalCurrentAssets, 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($comparisonData['total_current_assets'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- الأصول الثابتة -->
                                    @if(count($fixedAssets) > 0)
                                    <h6 class="text-primary mb-3 mt-4">الأصول الثابتة</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <tbody>
                                                @foreach($fixedAssets as $asset)
                                                <tr>
                                                    <td>
                                                        <a href="{{ route('accounting.accounts.show', $asset['id']) }}" 
                                                           class="text-decoration-none">
                                                            {{ $asset['name'] }}
                                                        </a>
                                                    </td>
                                                    <td class="text-end">{{ number_format($asset['balance'], 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($asset['comparison_balance'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                                @endforeach
                                                <tr class="table-light fw-bold">
                                                    <td>إجمالي الأصول الثابتة</td>
                                                    <td class="text-end">{{ number_format($totalFixedAssets, 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($comparisonData['total_fixed_assets'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    @endif

                                    <!-- إجمالي الأصول -->
                                    <div class="table-responsive mt-3">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr class="table-success">
                                                    <td class="fw-bold fs-6">إجمالي الأصول</td>
                                                    <td class="text-end fw-bold fs-6">{{ number_format($totalAssets, 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end fw-bold">{{ number_format($comparisonData['total_assets'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- الخصوم وحقوق الملكية -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-danger text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-credit-card"></i>
                                        الخصوم وحقوق الملكية
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <!-- الخصوم المتداولة -->
                                    @if(count($currentLiabilities) > 0)
                                    <h6 class="text-danger mb-3">الخصوم المتداولة</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                                <tr>
                                                    <th>البيان</th>
                                                    <th class="text-end">المبلغ (ريال)</th>
                                                    @if(isset($comparisonData))
                                                    <th class="text-end">المقارنة</th>
                                                    @endif
                                                </tr>
                                            <tbody>
                                                @foreach($currentLiabilities as $liability)
                                                <tr>
                                                    <td>
                                                        <a href="{{ route('accounting.accounts.show', $liability['id']) }}" 
                                                           class="text-decoration-none">
                                                            {{ $liability['name'] }}
                                                        </a>
                                                    </td>
                                                    <td class="text-end">{{ number_format($liability['balance'], 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($liability['comparison_balance'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                                @endforeach
                                                <tr class="table-light fw-bold">
                                                    <td>إجمالي الخصوم المتداولة</td>
                                                    <td class="text-end">{{ number_format($totalCurrentLiabilities, 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($comparisonData['total_current_liabilities'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    @endif

                                    <!-- الخصوم طويلة الأجل -->
                                    @if(count($longTermLiabilities) > 0)
                                    <h6 class="text-danger mb-3 mt-4">الخصوم طويلة الأجل</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <tbody>
                                                @foreach($longTermLiabilities as $liability)
                                                <tr>
                                                    <td>
                                                        <a href="{{ route('accounting.accounts.show', $liability['id']) }}" 
                                                           class="text-decoration-none">
                                                            {{ $liability['name'] }}
                                                        </a>
                                                    </td>
                                                    <td class="text-end">{{ number_format($liability['balance'], 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($liability['comparison_balance'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                                @endforeach
                                                <tr class="table-light fw-bold">
                                                    <td>إجمالي الخصوم طويلة الأجل</td>
                                                    <td class="text-end">{{ number_format($totalLongTermLiabilities, 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($comparisonData['total_long_term_liabilities'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    @endif

                                    <!-- إجمالي الخصوم -->
                                    <div class="table-responsive mt-3">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr class="table-danger">
                                                    <td class="fw-bold">إجمالي الخصوم</td>
                                                    <td class="text-end fw-bold">{{ number_format($totalLiabilities, 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end fw-bold">{{ number_format($comparisonData['total_liabilities'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- حقوق الملكية -->
                                    <h6 class="text-primary mb-3 mt-4">حقوق الملكية</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <tbody>
                                                @foreach($equityAccounts as $equity)
                                                <tr>
                                                    <td>
                                                        <a href="{{ route('accounting.accounts.show', $equity['id']) }}" 
                                                           class="text-decoration-none">
                                                            {{ $equity['name'] }}
                                                        </a>
                                                    </td>
                                                    <td class="text-end">{{ number_format($equity['balance'], 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($equity['comparison_balance'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                                @endforeach
                                                <!-- إضافة صافي الدخل إلى حقوق الملكية -->
                                                <tr>
                                                    <td>صافي الدخل للفترة الحالية</td>
                                                    <td class="text-end {{ $retainedEarnings >= 0 ? 'text-success' : 'text-danger' }}">
                                                        {{ number_format($retainedEarnings, 2) }}
                                                    </td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($comparisonData['retained_earnings'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                                <tr class="table-light fw-bold">
                                                    <td>إجمالي حقوق الملكية</td>
                                                    <td class="text-end">{{ number_format($totalEquity, 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end">{{ number_format($comparisonData['total_equity'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- إجمالي الخصوم وحقوق الملكية -->
                                    <div class="table-responsive mt-3">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr class="table-info">
                                                    <td class="fw-bold fs-6">إجمالي الخصوم وحقوق الملكية</td>
                                                    <td class="text-end fw-bold fs-6">{{ number_format($totalLiabilitiesAndEquity, 2) }}</td>
                                                    @if(isset($comparisonData))
                                                    <td class="text-end fw-bold">{{ number_format($comparisonData['total_liabilities_and_equity'] ?? 0, 2) }}</td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- النسب المالية -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-chart-bar"></i>
                                        النسب المالية الرئيسية
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="text-center">
                                                <h5 class="text-primary">
                                                    {{ $totalCurrentLiabilities > 0 ? number_format($totalCurrentAssets / $totalCurrentLiabilities, 2) : '∞' }}
                                                </h5>
                                                <small class="text-muted">نسبة السيولة الجارية</small>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="text-center">
                                                <h5 class="text-success">
                                                    {{ $totalAssets > 0 ? number_format(($totalEquity / $totalAssets) * 100, 2) : 0 }}%
                                                </h5>
                                                <small class="text-muted">نسبة حقوق الملكية</small>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="text-center">
                                                <h5 class="text-warning">
                                                    {{ $totalEquity > 0 ? number_format($totalLiabilities / $totalEquity, 2) : '∞' }}
                                                </h5>
                                                <small class="text-muted">نسبة الدين إلى حقوق الملكية</small>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="text-center">
                                                <h5 class="text-info">
                                                    {{ number_format($totalAssets, 0) }}
                                                </h5>
                                                <small class="text-muted">إجمالي الأصول (ريال)</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
@media print {
    .btn-group, .card-header .btn-group, form {
        display: none !important;
    }
    
    .card {
        box-shadow: none !important;
        border: none !important;
    }
    
    .table {
        font-size: 11px;
    }
    
    .alert {
        break-inside: avoid;
    }
    
    .row {
        page-break-inside: avoid;
    }
}
</style>
@endsection