@extends('layouts.app')

@section('title', 'تفاصيل القيد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Journal Entry Header -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-book"></i> تفاصيل القيد: {{ $journalEntry->entry_number }}
                    </h5>
                    <div>
                        @if($journalEntry->status == 'draft')
                            <a href="{{ route('accounting.journal-entries.edit', $journalEntry) }}" class="btn btn-warning">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            <button type="button" class="btn btn-success" onclick="postEntry()">
                                <i class="fas fa-check"></i> ترحيل القيد
                            </button>
                        @endif
                        <a href="{{ route('accounting.journal-entries.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">رقم القيد:</th>
                                    <td><span class="badge bg-primary fs-6">{{ $journalEntry->entry_number }}</span></td>
                                </tr>
                                <tr>
                                    <th>تاريخ القيد:</th>
                                    <td><strong>{{ $journalEntry->entry_date->format('Y-m-d') }}</strong></td>
                                </tr>
                                <tr>
                                    <th>المرجع:</th>
                                    <td>{{ $journalEntry->reference ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>الحالة:</th>
                                    <td>
                                        @if($journalEntry->status == 'draft')
                                            <span class="badge bg-warning">مسودة</span>
                                        @elseif($journalEntry->status == 'posted')
                                            <span class="badge bg-success">مرحل</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <table class="table table-borderless">
                                @php
                                    $totalDebit = $journalEntry->journalEntryLines->sum('debit_amount');
                                    $totalCredit = $journalEntry->journalEntryLines->sum('credit_amount');
                                @endphp
                                <tr>
                                    <th width="30%">إجمالي المدين:</th>
                                    <td class="text-success"><strong>{{ number_format($totalDebit, 2) }} ريال</strong></td>
                                </tr>
                                <tr>
                                    <th>إجمالي الدائن:</th>
                                    <td class="text-danger"><strong>{{ number_format($totalCredit, 2) }} ريال</strong></td>
                                </tr>
                                <tr>
                                    <th>الفرق:</th>
                                    <td>
                                        @php $difference = abs($totalDebit - $totalCredit); @endphp
                                        @if($difference == 0)
                                            <span class="badge bg-success">متوازن</span>
                                        @else
                                            <span class="badge bg-danger">غير متوازن ({{ number_format($difference, 2) }})</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء:</th>
                                    <td>{{ $journalEntry->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>البيان:</h6>
                            <div class="alert alert-light">{{ $journalEntry->description }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Journal Entry Lines -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-list"></i> تفاصيل القيد ({{ $journalEntry->journalEntryLines->count() }} سطر)
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th width="25%">الحساب</th>
                                    <th width="20%">البيان</th>
                                    <th width="15%">مركز التكلفة</th>
                                    <th width="15%">مدين</th>
                                    <th width="15%">دائن</th>
                                    <th width="10%">الرصيد الجاري</th>
                                </tr>
                            <tbody>
                                @foreach($journalEntry->journalEntryLines as $line)
                                <tr>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $line->account) }}">
                                            <strong>{{ $line->account->code }}</strong><br>
                                            <small class="text-muted">{{ $line->account->name }}</small>
                                        </a>
                                    </td>
                                    <td>{{ $line->description ?: $journalEntry->description }}</td>
                                    <td>
                                        @if($line->costCenter)
                                            <a href="{{ route('accounting.cost-centers.show', $line->costCenter) }}">
                                                <span class="badge bg-info">{{ $line->costCenter->code }}</span><br>
                                                <small>{{ $line->costCenter->name }}</small>
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td class="text-success">
                                        {{ $line->debit > 0 ? number_format($line->debit, 2) : '-' }}
                                    </td>
                                    <td class="text-danger">
                                        {{ $line->credit > 0 ? number_format($line->credit, 2) : '-' }}
                                    </td>
                                    <td class="{{ $line->account->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($line->account->current_balance, 2) }}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot class="table-secondary">
                                <tr>
                                    <td colspan="3"><strong>الإجمالي</strong></td>
                                    <td class="text-success"><strong>{{ number_format($totalDebit, 2) }}</strong></td>
                                    <td class="text-danger"><strong>{{ number_format($totalCredit, 2) }}</strong></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Related Transactions -->
            @if($journalEntry->bankTransactions->count() > 0 || $journalEntry->cashTransactions->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-link"></i> العمليات المرتبطة
                    </h6>
                </div>
                <div class="card-body">
                    @if($journalEntry->bankTransactions->count() > 0)
                        <h6>الحركات البنكية:</h6>
                        <div class="table-responsive mb-3">
                            <table class="table table-sm">
                                    <tr>
                                        <th>التاريخ</th>
                                        <th>الحساب البنكي</th>
                                        <th>نوع الحركة</th>
                                        <th>المبلغ</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                <tbody>
                                    @foreach($journalEntry->bankTransactions as $transaction)
                                    <tr>
                                        <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                        <td>{{ $transaction->bankAccount->bank_name }} - {{ $transaction->bankAccount->account_number }}</td>
                                        <td>
                                            @switch($transaction->transaction_type)
                                                @case('deposit')
                                                    <span class="badge bg-success">إيداع</span>
                                                    @break
                                                @case('withdrawal')
                                                    <span class="badge bg-danger">سحب</span>
                                                    @break
                                                @case('transfer')
                                                    <span class="badge bg-info">تحويل</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>{{ number_format($transaction->amount, 2) }} {{ $transaction->bankAccount->currency }}</td>
                                        <td>
                                            @switch($transaction->status)
                                                @case('pending')
                                                    <span class="badge bg-warning">معلق</span>
                                                    @break
                                                @case('cleared')
                                                    <span class="badge bg-success">مصفى</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge bg-danger">ملغي</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>
                                            <a href="{{ route('accounting.bank-transactions.show', $transaction) }}" class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif

                    @if($journalEntry->cashTransactions->count() > 0)
                        <h6>الحركات النقدية:</h6>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                    <tr>
                                        <th>التاريخ</th>
                                        <th>نوع الحركة</th>
                                        <th>المبلغ</th>
                                        <th>البيان</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                <tbody>
                                    @foreach($journalEntry->cashTransactions as $transaction)
                                    <tr>
                                        <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if($transaction->transaction_type == 'receipt')
                                                <span class="badge bg-success">قبض</span>
                                            @else
                                                <span class="badge bg-danger">دفع</span>
                                            @endif
                                        </td>
                                        <td>{{ number_format($transaction->amount, 2) }} ريال</td>
                                        <td>{{ $transaction->description }}</td>
                                        <td>
                                            <a href="{{ route('accounting.cash-transactions.show', $transaction) }}" class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
            @endif

            <!-- Action Buttons -->
            <div class="card">
                <div class="card-body text-center">
                    @if($journalEntry->status == 'draft')
                        <a href="{{ route('accounting.journal-entries.edit', $journalEntry) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل القيد
                        </a>
                        <button type="button" class="btn btn-success" onclick="postEntry()">
                            <i class="fas fa-check"></i> ترحيل القيد
                        </button>
                        <button type="button" class="btn btn-danger" onclick="deleteEntry()">
                            <i class="fas fa-trash"></i> حذف القيد
                        </button>
                    @else
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle"></i>
                            <strong>هذا القيد مرحل ولا يمكن تعديله أو حذفه.</strong>
                        </div>
                    @endif
                    
                    <a href="{{ route('accounting.journal-entries.index') }}" class="btn btn-secondary">
                        <i class="fas fa-list"></i> العودة لقائمة القيود
                    </a>
                    
                    <button type="button" class="btn btn-info" onclick="printEntry()">
                        <i class="fas fa-print"></i> طباعة القيد
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
@if($journalEntry->status == 'draft')
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد الحذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من حذف القيد "{{ $journalEntry->entry_number }}"؟
                <br><small class="text-muted">لا يمكن التراجع عن هذا الإجراء.</small>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form action="{{ route('accounting.journal-entries.destroy', $journalEntry) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">حذف نهائي</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endif
@endsection

@push('scripts')
<script>
function postEntry() {
    if (confirm('هل تريد ترحيل هذا القيد؟ لن تتمكن من تعديله بعد الترحيل.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/accounting/journal-entries/{{ $journalEntry->id }}/post`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}

function deleteEntry() {
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}

function printEntry() {
    window.print();
}

// Print styles
window.addEventListener('beforeprint', function() {
    // Hide navigation and action buttons when printing
    document.querySelectorAll('.btn, .card-header, nav').forEach(function(element) {
        element.style.display = 'none';
    });
});

window.addEventListener('afterprint', function() {
    // Restore elements after printing
    document.querySelectorAll('.btn, .card-header, nav').forEach(function(element) {
        element.style.display = '';
    });
});
</script>
@endpush

@push('styles')
<style>
@media print {
    .btn, .card-header .btn, nav, .modal {
        display: none !important;
    }
    
    .card {
        border: 1px solid #ddd !important;
        box-shadow: none !important;
    }
    
    .table {
        font-size: 12px;
    }
    
    .badge {
        border: 1px solid #000;
        color: #000 !important;
        background-color: transparent !important;
    }
}
</style>
@endpush