@extends('layouts.app')

@section('title', 'قيود اليومية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Filters Card -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-filter"></i> تصفية النتائج
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('accounting.journal-entries.index') }}">
                        <div class="row">
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="entry_number" class="form-label">رقم القيد</label>
                                    <input type="text" class="form-control" id="entry_number" name="entry_number" 
                                           value="{{ request('entry_number') }}" placeholder="JE-2025-001">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="status" class="form-label">الحالة</label>
                                    <select class="form-select" id="status" name="status">
                                        <option value="">جميع الحالات</option>
                                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                                        <option value="posted" {{ request('status') == 'posted' ? 'selected' : '' }}>مرحل</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="start_date" class="form-label">من تاريخ</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" 
                                           value="{{ request('start_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="end_date" class="form-label">إلى تاريخ</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" 
                                           value="{{ request('end_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="account_id" class="form-label">الحساب</label>
                                    <select class="form-select" id="account_id" name="account_id">
                                        <option value="">جميع الحسابات</option>
                                        @foreach(\App\Models\Account::orderBy('code')->get() as $account)
                                            <option value="{{ $account->id }}" {{ request('account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->code }} - {{ $account->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="cost_center_id" class="form-label">مركز التكلفة</label>
                                    <select class="form-select" id="cost_center_id" name="cost_center_id">
                                        <option value="">جميع المراكز</option>
                                        @foreach(\App\Models\CostCenter::where('is_active', true)->orderBy('code')->get() as $costCenter)
                                            <option value="{{ $costCenter->id }}" {{ request('cost_center_id') == $costCenter->id ? 'selected' : '' }}>
                                                {{ $costCenter->code }} - {{ $costCenter->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label for="description" class="form-label">البيان</label>
                                    <input type="text" class="form-control" id="description" name="description" 
                                           value="{{ request('description') }}" placeholder="البحث في البيان">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary d-block">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <a href="{{ route('accounting.journal-entries.index') }}" class="btn btn-secondary d-block">
                                        <i class="fas fa-times"></i> إعادة تعيين
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Journal Entries Card -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-book"></i> قيود اليومية
                        @if(request()->hasAny(['entry_number', 'status', 'start_date', 'end_date', 'account_id', 'cost_center_id', 'description']))
                            <small class="text-muted">({{ $journalEntries->total() }} نتيجة)</small>
                        @endif
                    </h5>
                    <div>
                        <a href="{{ route('accounting.journal-entries.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إنشاء قيد جديد
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if($journalEntries->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                    <tr>
                                        <th>رقم القيد</th>
                                        <th>التاريخ</th>
                                        <th>البيان</th>
                                        <th>المرجع</th>
                                        <th>إجمالي المدين</th>
                                        <th>إجمالي الدائن</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                <tbody>
                                    @foreach($journalEntries as $entry)
                                    @php
                                        $totalDebit = $entry->journalEntryLines->sum('debit_amount');
                                        $totalCredit = $entry->journalEntryLines->sum('credit_amount');
                                    @endphp
                                    <tr>
                                        <td>
                                            <a href="{{ route('accounting.journal-entries.show', $entry) }}">
                                                <strong>{{ $entry->entry_number }}</strong>
                                            </a>
                                        </td>
                                        <td>{{ $entry->entry_date->format('Y-m-d') }}</td>
                                        <td>{{ Str::limit($entry->description, 50) }}</td>
                                        <td>{{ $entry->reference ?: '-' }}</td>
                                        <td class="text-success">{{ number_format($totalDebit, 2) }} ريال</td>
                                        <td class="text-danger">{{ number_format($totalCredit, 2) }} ريال</td>
                                        <td>
                                            @if($entry->status == 'draft')
                                                <span class="badge bg-warning">مسودة</span>
                                            @elseif($entry->status == 'posted')
                                                <span class="badge bg-success">مرحل</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('accounting.journal-entries.show', $entry) }}" 
                                                   class="btn btn-sm btn-outline-primary" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($entry->status == 'draft')
                                                    <a href="{{ route('accounting.journal-entries.edit', $entry) }}" 
                                                       class="btn btn-sm btn-outline-warning" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-sm btn-outline-success" 
                                                            onclick="postEntry({{ $entry->id }})" title="ترحيل">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                                            onclick="deleteEntry({{ $entry->id }})" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                عرض {{ $journalEntries->firstItem() }} إلى {{ $journalEntries->lastItem() }} من {{ $journalEntries->total() }} نتيجة
                            </div>
                            <div>
                                {{ $journalEntries->appends(request()->query())->links() }}
                            </div>
                        </div>

                        <!-- Summary Cards -->
                        <div class="row mt-4">
                            @php
                                $filteredEntries = $journalEntries->getCollection();
                                $totalDebitSum = 0;
                                $totalCreditSum = 0;
                                $draftCount = $filteredEntries->where('status', 'draft')->count();
                                $postedCount = $filteredEntries->where('status', 'posted')->count();
                                
                                foreach($filteredEntries as $entry) {
                                    $totalDebitSum += $entry->journalEntryLines->sum('debit_amount');
                                    $totalCreditSum += $entry->journalEntryLines->sum('credit_amount');
                                }
                            @endphp
                            <div class="col-md-3">
                                <div class="card text-center border-success">
                                    <div class="card-body">
                                        <h5 class="card-title text-success">{{ number_format($totalDebitSum, 2) }}</h5>
                                        <p class="card-text">إجمالي المدين (ريال)</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center border-danger">
                                    <div class="card-body">
                                        <h5 class="card-title text-danger">{{ number_format($totalCreditSum, 2) }}</h5>
                                        <p class="card-text">إجمالي الدائن (ريال)</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center border-warning">
                                    <div class="card-body">
                                        <h5 class="card-title text-warning">{{ $draftCount }}</h5>
                                        <p class="card-text">القيود المسودة</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center border-primary">
                                    <div class="card-body">
                                        <h5 class="card-title text-primary">{{ $postedCount }}</h5>
                                        <p class="card-text">القيود المرحلة</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-book fa-5x text-muted mb-3"></i>
                            <h4 class="text-muted">لا توجد قيود يومية</h4>
                            @if(request()->hasAny(['entry_number', 'status', 'start_date', 'end_date', 'account_id', 'cost_center_id', 'description']))
                                <p class="text-muted">لا توجد نتائج للبحث المحدد. جرب تغيير معايير البحث.</p>
                                <a href="{{ route('accounting.journal-entries.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إعادة تعيين البحث
                                </a>
                            @else
                                <p class="text-muted">ابدأ بإنشاء أول قيد يومية في النظام</p>
                                <a href="{{ route('accounting.journal-entries.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> إنشاء قيد يومية
                                </a>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد الحذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من حذف هذا القيد؟ لا يمكن التراجع عن هذا الإجراء.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">حذف نهائي</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function postEntry(entryId) {
    if (confirm('هل تريد ترحيل هذا القيد؟ لن تتمكن من تعديله بعد الترحيل.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/accounting/journal-entries/${entryId}/post`;
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}

function deleteEntry(entryId) {
    const deleteForm = document.getElementById('deleteForm');
    deleteForm.action = `/accounting/journal-entries/${entryId}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}

// تحديث التصفية تلقائياً عند تغيير القيم
$(document).ready(function() {
    $('#status, #account_id, #cost_center_id').change(function() {
        $(this).closest('form').submit();
    });
});
</script>
@endpush