@extends('layouts.app')

@section('title', 'تعديل القيد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">تعديل القيد: {{ $journalEntry->entry_number }}</h5>
                    <div>
                        <a href="{{ route('accounting.journal-entries.show', $journalEntry) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> عرض القيد
                        </a>
                        <a href="{{ route('accounting.journal-entries.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if($journalEntry->status == 'posted')
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>تنبيه:</strong> هذا القيد مرحل ولا يمكن تعديله. يمكنك عرض التفاصيل فقط.
                        </div>
                    @else
                        <form id="journalEntryForm" action="{{ route('accounting.journal-entries.update', $journalEntry) }}" method="POST">
                            @csrf
                            @method('PUT')
                            
                            <!-- Entry Header -->
                            <div class="row mb-4">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="entry_number" class="form-label">رقم القيد</label>
                                        <input type="text" class="form-control" id="entry_number" name="entry_number" 
                                               value="{{ $journalEntry->entry_number }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="entry_date" class="form-label">تاريخ القيد <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control @error('entry_date') is-invalid @enderror" 
                                               id="entry_date" name="entry_date" value="{{ old('entry_date', $journalEntry->entry_date->format('Y-m-d')) }}" required>
                                        @error('entry_date')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="reference" class="form-label">المرجع</label>
                                        <input type="text" class="form-control @error('reference') is-invalid @enderror" 
                                               id="reference" name="reference" value="{{ old('reference', $journalEntry->reference) }}">
                                        @error('reference')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">البيان <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('description') is-invalid @enderror" 
                                          id="description" name="description" rows="2" required>{{ old('description', $journalEntry->description) }}</textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Journal Entry Lines -->
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h6 class="card-title mb-0">تفاصيل القيد</h6>
                                    <button type="button" class="btn btn-sm btn-success" onclick="addLine()">
                                        <i class="fas fa-plus"></i> إضافة سطر
                                    </button>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered" id="journalLinesTable">
                                                <tr>
                                                    <th width="25%">الحساب <span class="text-danger">*</span></th>
                                                    <th width="20%">البيان</th>
                                                    <th width="15%">مركز التكلفة</th>
                                                    <th width="15%">مدين</th>
                                                    <th width="15%">دائن</th>
                                                    <th width="10%">الإجراءات</th>
                                                </tr>
                                            <tbody id="journalLinesBody">
                                                @foreach($journalEntry->journalEntryLines as $index => $line)
                                                <tr class="journal-line" data-line="{{ $index }}">
                                                    <td>
                                                        <select class="form-select account-select" name="lines[{{ $index }}][account_id]" required>
                                                            <option value="">اختر الحساب</option>
                                                            @foreach($accounts as $account)
                                                                <option value="{{ $account->id }}" {{ $line->account_id == $account->id ? 'selected' : '' }}>
                                                                    {{ $account->code }} - {{ $account->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="lines[{{ $index }}][description]" 
                                                               value="{{ $line->description }}" placeholder="البيان">
                                                    </td>
                                                    <td>
                                                        <select class="form-select" name="lines[{{ $index }}][cost_center_id]">
                                                            <option value="">اختر مركز التكلفة</option>
                                                            @foreach($costCenters as $costCenter)
                                                                <option value="{{ $costCenter->id }}" {{ $line->cost_center_id == $costCenter->id ? 'selected' : '' }}>
                                                                    {{ $costCenter->code }} - {{ $costCenter->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="number" step="0.01" class="form-control debit-input" 
                                                               name="lines[{{ $index }}][debit]" value="{{ $line->debit }}" onchange="updateBalance()">
                                                    </td>
                                                    <td>
                                                        <input type="number" step="0.01" class="form-control credit-input" 
                                                               name="lines[{{ $index }}][credit]" value="{{ $line->credit }}" onchange="updateBalance()">
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-danger" onclick="removeLine(this)">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot class="table-secondary">
                                                <tr>
                                                    <td colspan="3"><strong>الإجمالي</strong></td>
                                                    <td><strong id="totalDebits">0.00</strong></td>
                                                    <td><strong id="totalCredits">0.00</strong></td>
                                                    <td></td>
                                                </tr>
                                                <tr>
                                                    <td colspan="3"><strong>الفرق</strong></td>
                                                    <td colspan="2">
                                                        <span id="difference" class="badge bg-secondary">0.00</span>
                                                    </td>
                                                    <td></td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>

                                    <div class="alert alert-info mt-3">
                                        <i class="fas fa-info-circle"></i>
                                        <strong>ملاحظة:</strong> يجب أن يكون إجمالي المدين مساوياً لإجمالي الدائن لضمان التوازن المحاسبي.
                                    </div>
                                </div>
                            </div>

                            <!-- Entry Info -->
                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <div class="card border-info">
                                        <div class="card-header bg-info text-white">
                                            <h6 class="mb-0">معلومات القيد</h6>
                                        </div>
                                        <div class="card-body">
                                            <p><strong>تاريخ الإنشاء:</strong> {{ $journalEntry->created_at->format('Y-m-d H:i') }}</p>
                                            <p><strong>آخر تحديث:</strong> {{ $journalEntry->updated_at->format('Y-m-d H:i') }}</p>
                                            <p><strong>الحالة:</strong> 
                                                @if($journalEntry->status == 'draft')
                                                    <span class="badge bg-warning">مسودة</span>
                                                @else
                                                    <span class="badge bg-success">مرحل</span>
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="card border-warning">
                                        <div class="card-header bg-warning text-dark">
                                            <h6 class="mb-0">تنبيهات</h6>
                                        </div>
                                        <div class="card-body">
                                            @if($journalEntry->bankTransactions->count() > 0 || $journalEntry->cashTransactions->count() > 0)
                                                <div class="alert alert-warning">
                                                    <i class="fas fa-exclamation-triangle"></i>
                                                    يوجد {{ $journalEntry->bankTransactions->count() + $journalEntry->cashTransactions->count() }} عملية مرتبطة بهذا القيد.
                                                    التعديل قد يؤثر على العمليات المرتبطة.
                                                </div>
                                            @else
                                                <div class="alert alert-success">
                                                    <i class="fas fa-check-circle"></i>
                                                    لا توجد عمليات مرتبطة بهذا القيد. يمكن التعديل بأمان.
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-between mt-4">
                                <div>
                                    <button type="submit" class="btn btn-primary" id="submitBtn" disabled>
                                        <i class="fas fa-save"></i> حفظ التغييرات
                                    </button>
                                    <button type="submit" class="btn btn-success" id="postBtn" name="post" value="1" disabled>
                                        <i class="fas fa-check"></i> حفظ وترحيل
                                    </button>
                                </div>
                                <div>
                                    <a href="{{ route('accounting.journal-entries.show', $journalEntry) }}" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> إلغاء
                                    </a>
                                    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                                        <i class="fas fa-trash"></i> حذف القيد
                                    </button>
                                </div>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
@if($journalEntry->status == 'draft')
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد الحذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من حذف القيد "{{ $journalEntry->entry_number }}"؟
                <br><small class="text-muted">لا يمكن التراجع عن هذا الإجراء.</small>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form action="{{ route('accounting.journal-entries.destroy', $journalEntry) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">حذف نهائي</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endif
@endsection

@push('scripts')
<script>
let lineIndex = {{ $journalEntry->journalEntryLines->count() }};

function addLine() {
    const tbody = document.getElementById('journalLinesBody');
    const newRow = document.createElement('tr');
    newRow.className = 'journal-line';
    newRow.setAttribute('data-line', lineIndex);
    
    newRow.innerHTML = `
        <td>
            <select class="form-select account-select" name="lines[${lineIndex}][account_id]" required>
                <option value="">اختر الحساب</option>
                @foreach($accounts as $account)
                    <option value="{{ $account->id }}">{{ $account->code }} - {{ $account->name }}</option>
                @endforeach
            </select>
        </td>
        <td>
            <input type="text" class="form-control" name="lines[${lineIndex}][description]" placeholder="البيان">
        </td>
        <td>
            <select class="form-select" name="lines[${lineIndex}][cost_center_id]">
                <option value="">اختر مركز التكلفة</option>
                @foreach($costCenters as $costCenter)
                    <option value="{{ $costCenter->id }}">{{ $costCenter->code }} - {{ $costCenter->name }}</option>
                @endforeach
            </select>
        </td>
        <td>
            <input type="number" step="0.01" class="form-control debit-input" name="lines[${lineIndex}][debit]" 
                   value="0" onchange="updateBalance()">
        </td>
        <td>
            <input type="number" step="0.01" class="form-control credit-input" name="lines[${lineIndex}][credit]" 
                   value="0" onchange="updateBalance()">
        </td>
        <td>
            <button type="button" class="btn btn-sm btn-danger" onclick="removeLine(this)">
                <i class="fas fa-trash"></i>
            </button>
        </td>
    `;
    
    tbody.appendChild(newRow);
    lineIndex++;
    updateBalance();
}

function removeLine(button) {
    const tbody = document.getElementById('journalLinesBody');
    if (tbody.children.length > 2) {
        button.closest('tr').remove();
        updateBalance();
    } else {
        showMinimumLinesModal();
    }
}

function updateBalance() {
    let totalDebits = 0;
    let totalCredits = 0;
    
    document.querySelectorAll('.debit-input').forEach(input => {
        totalDebits += parseFloat(input.value) || 0;
    });
    
    document.querySelectorAll('.credit-input').forEach(input => {
        totalCredits += parseFloat(input.value) || 0;
    });
    
    document.getElementById('totalDebits').textContent = totalDebits.toFixed(2);
    document.getElementById('totalCredits').textContent = totalCredits.toFixed(2);
    
    const difference = Math.abs(totalDebits - totalCredits);
    const differenceElement = document.getElementById('difference');
    
    differenceElement.textContent = difference.toFixed(2);
    
    if (difference === 0 && totalDebits > 0) {
        differenceElement.className = 'badge bg-success';
        document.getElementById('submitBtn').disabled = false;
        document.getElementById('postBtn').disabled = false;
    } else {
        differenceElement.className = 'badge bg-danger';
        document.getElementById('submitBtn').disabled = true;
        document.getElementById('postBtn').disabled = true;
    }
}

// Prevent entering both debit and credit on the same line
document.addEventListener('change', function(e) {
    if (e.target.classList.contains('debit-input')) {
        const creditInput = e.target.closest('tr').querySelector('.credit-input');
        if (parseFloat(e.target.value) > 0) {
            creditInput.value = '0';
        }
        updateBalance();
    } else if (e.target.classList.contains('credit-input')) {
        const debitInput = e.target.closest('tr').querySelector('.debit-input');
        if (parseFloat(e.target.value) > 0) {
            debitInput.value = '0';
        }
        updateBalance();
    }
});

// Auto-fill description from main description
document.getElementById('description').addEventListener('change', function() {
    const mainDescription = this.value;
    document.querySelectorAll('input[name*="[description]"]').forEach(input => {
        if (!input.value) {
            input.value = mainDescription;
        }
    });
});

// Initialize balance calculation
document.addEventListener('DOMContentLoaded', function() {
    updateBalance();
});

function showMinimumLinesModal() {
    const modal = new bootstrap.Modal(document.getElementById('minimumLinesModal'));
    modal.show();
}
</script>

<!-- Modal تنبيه الحد الأدنى للسطور -->
<div class="modal fade" id="minimumLinesModal" tabindex="-1" aria-labelledby="minimumLinesModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title" id="minimumLinesModalLabel">
                    <i class="fas fa-exclamation-triangle"></i>
                    تنبيه
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="fas fa-info-circle"></i>
                    <strong>تنبيه:</strong> لا يمكن حذف هذا السطر
                </div>
                <p class="mb-3">يجب وجود سطرين على الأقل في القيد لضمان التوازن المحاسبي.</p>
                <div class="card">
                    <div class="card-body bg-light">
                        <h6 class="card-title">متطلبات القيد المحاسبي:</h6>
                        <ul class="mb-0">
                            <li>حد أدنى سطرين في القيد</li>
                            <li>توازن بين إجمالي المدين والدائن</li>
                            <li>تحديد الحسابات المناسبة</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                    <i class="fas fa-check"></i>
                    موافق
                </button>
            </div>
        </div>
    </div>
</div>
@endpush