@extends('layouts.app')

@section('title', 'إنشاء قيد يومية جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">إنشاء قيد يومية جديد</h5>
                    <a href="{{ route('accounting.journal-entries.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    <form id="journalEntryForm" action="{{ route('accounting.journal-entries.store') }}" method="POST">
                        @csrf
                        
                        <!-- Entry Header -->
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="entry_number" class="form-label">رقم القيد</label>
                                    <input type="text" class="form-control" id="entry_number" name="entry_number" 
                                           value="{{ $entryNumber }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="entry_date" class="form-label">تاريخ القيد <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('entry_date') is-invalid @enderror" 
                                           id="entry_date" name="entry_date" value="{{ old('entry_date', date('Y-m-d')) }}" required>
                                    @error('entry_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="reference" class="form-label">المرجع</label>
                                    <input type="text" class="form-control @error('reference') is-invalid @enderror" 
                                           id="reference" name="reference" value="{{ old('reference') }}">
                                    @error('reference')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">البيان <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" name="description" rows="2" required>{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Journal Entry Lines -->
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h6 class="card-title mb-0">تفاصيل القيد</h6>
                                <button type="button" class="btn btn-sm btn-success" onclick="addLine()">
                                    <i class="fas fa-plus"></i> إضافة سطر
                                </button>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered" id="journalLinesTable">
                                            <tr>
                                                <th width="25%">الحساب <span class="text-danger">*</span></th>
                                                <th width="20%">البيان</th>
                                                <th width="15%">مركز التكلفة</th>
                                                <th width="15%">مدين</th>
                                                <th width="15%">دائن</th>
                                                <th width="10%">الإجراءات</th>
                                            </tr>
                                        <tbody id="journalLinesBody">
                                            <tr class="journal-line" data-line="0">
                                                <td>
                                                    <select class="form-select account-select searchable-select" name="lines[0][account_id]" required>
                                                        <option value="">اختر الحساب</option>
                                                        @foreach($accounts as $account)
                                                            <option value="{{ $account->id }}">{{ $account->code }} - {{ $account->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control" name="lines[0][description]" placeholder="البيان">
                                                </td>
                                                <td>
                                                    <select class="form-select cost-center-select searchable-select" name="lines[0][cost_center_id]">
                                                        <option value="">اختر مركز التكلفة</option>
                                                        @foreach($costCenters as $costCenter)
                                                            <option value="{{ $costCenter->id }}">{{ $costCenter->code }} - {{ $costCenter->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="number" step="0.01" class="form-control debit-input" name="lines[0][debit]" 
                                                           value="0" onchange="updateBalance()">
                                                </td>
                                                <td>
                                                    <input type="number" step="0.01" class="form-control credit-input" name="lines[0][credit]" 
                                                           value="0" onchange="updateBalance()">
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-danger" onclick="removeLine(this)">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <tr class="journal-line" data-line="1">
                                                <td>
                                                    <select class="form-select account-select searchable-select" name="lines[1][account_id]" required>
                                                        <option value="">اختر الحساب</option>
                                                        @foreach($accounts as $account)
                                                            <option value="{{ $account->id }}">{{ $account->code }} - {{ $account->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control" name="lines[1][description]" placeholder="البيان">
                                                </td>
                                                <td>
                                                    <select class="form-select cost-center-select searchable-select" name="lines[1][cost_center_id]">
                                                        <option value="">اختر مركز التكلفة</option>
                                                        @foreach($costCenters as $costCenter)
                                                            <option value="{{ $costCenter->id }}">{{ $costCenter->code }} - {{ $costCenter->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="number" step="0.01" class="form-control debit-input" name="lines[1][debit]" 
                                                           value="0" onchange="updateBalance()">
                                                </td>
                                                <td>
                                                    <input type="number" step="0.01" class="form-control credit-input" name="lines[1][credit]" 
                                                           value="0" onchange="updateBalance()">
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-danger" onclick="removeLine(this)">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot class="table-secondary">
                                            <tr>
                                                <td colspan="3"><strong>الإجمالي</strong></td>
                                                <td><strong id="totalDebits">0.00</strong></td>
                                                <td><strong id="totalCredits">0.00</strong></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td colspan="3"><strong>الفرق</strong></td>
                                                <td colspan="2">
                                                    <span id="difference" class="badge bg-secondary">0.00</span>
                                                </td>
                                                <td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>

                                <div class="alert alert-info mt-3">
                                    <i class="fas fa-info-circle"></i>
                                    <strong>ملاحظة:</strong> يجب أن يكون إجمالي المدين مساوياً لإجمالي الدائن لضمان التوازن المحاسبي.
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <div>
                                <button type="submit" class="btn btn-primary" id="submitBtn" disabled>
                                    <i class="fas fa-save"></i> حفظ كمسودة
                                </button>
                                <button type="submit" class="btn btn-success" id="postBtn" name="post" value="1" disabled>
                                    <i class="fas fa-check"></i> حفظ وترحيل
                                </button>
                            </div>
                            <a href="{{ route('accounting.journal-entries.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
.select2-container--default .select2-selection--single {
    height: 38px;
    border: 1px solid #ced4da;
    border-radius: 0.375rem;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 36px;
    padding-right: 20px;
}
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px;
}
.select2-dropdown {
    border: 1px solid #ced4da;
    border-radius: 0.375rem;
}
.select2-container {
    width: 100% !important;
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
let lineIndex = 2;

function addLine() {
    const tbody = document.getElementById('journalLinesBody');
    const newRow = document.createElement('tr');
    newRow.className = 'journal-line';
    newRow.setAttribute('data-line', lineIndex);
    
    newRow.innerHTML = `
        <td>
            <select class="form-select account-select searchable-select" name="lines[${lineIndex}][account_id]" required>
                <option value="">اختر الحساب</option>
                @foreach($accounts as $account)
                    <option value="{{ $account->id }}">{{ $account->code }} - {{ $account->name }}</option>
                @endforeach
            </select>
        </td>
        <td>
            <input type="text" class="form-control" name="lines[${lineIndex}][description]" placeholder="البيان">
        </td>
        <td>
            <select class="form-select cost-center-select searchable-select" name="lines[${lineIndex}][cost_center_id]">
                <option value="">اختر مركز التكلفة</option>
                @foreach($costCenters as $costCenter)
                    <option value="{{ $costCenter->id }}">{{ $costCenter->code }} - {{ $costCenter->name }}</option>
                @endforeach
            </select>
        </td>
        <td>
            <input type="number" step="0.01" class="form-control debit-input" name="lines[${lineIndex}][debit]" 
                   value="0" onchange="updateBalance()">
        </td>
        <td>
            <input type="number" step="0.01" class="form-control credit-input" name="lines[${lineIndex}][credit]" 
                   value="0" onchange="updateBalance()">
        </td>
        <td>
            <button type="button" class="btn btn-sm btn-danger" onclick="removeLine(this)">
                <i class="fas fa-trash"></i>
            </button>
        </td>
    `;
    
    tbody.appendChild(newRow);
    
    // Initialize Select2 for the new row
    initializeSelect2(newRow);
    
    lineIndex++;
    updateBalance();
}

function removeLine(button) {
    const tbody = document.getElementById('journalLinesBody');
    if (tbody.children.length > 2) {
        const row = button.closest('tr');
        
        // Destroy Select2 instances before removing the row
        $(row).find('.searchable-select').select2('destroy');
        
        row.remove();
        updateBalance();
    } else {
        showMinimumLinesModal();
    }
}

function updateBalance() {
    let totalDebits = 0;
    let totalCredits = 0;
    
    document.querySelectorAll('.debit-input').forEach(input => {
        totalDebits += parseFloat(input.value) || 0;
    });
    
    document.querySelectorAll('.credit-input').forEach(input => {
        totalCredits += parseFloat(input.value) || 0;
    });
    
    document.getElementById('totalDebits').textContent = totalDebits.toFixed(2);
    document.getElementById('totalCredits').textContent = totalCredits.toFixed(2);
    
    const difference = Math.abs(totalDebits - totalCredits);
    const differenceElement = document.getElementById('difference');
    
    differenceElement.textContent = difference.toFixed(2);
    
    if (difference === 0 && totalDebits > 0) {
        differenceElement.className = 'badge bg-success';
        document.getElementById('submitBtn').disabled = false;
        document.getElementById('postBtn').disabled = false;
    } else {
        differenceElement.className = 'badge bg-danger';
        document.getElementById('submitBtn').disabled = true;
        document.getElementById('postBtn').disabled = true;
    }
}

// Prevent entering both debit and credit on the same line
document.addEventListener('change', function(e) {
    if (e.target.classList.contains('debit-input')) {
        const creditInput = e.target.closest('tr').querySelector('.credit-input');
        if (parseFloat(e.target.value) > 0) {
            creditInput.value = '0';
        }
        updateBalance();
    } else if (e.target.classList.contains('credit-input')) {
        const debitInput = e.target.closest('tr').querySelector('.debit-input');
        if (parseFloat(e.target.value) > 0) {
            debitInput.value = '0';
        }
        updateBalance();
    }
});

// Auto-fill description from main description
document.getElementById('description').addEventListener('change', function() {
    const mainDescription = this.value;
    document.querySelectorAll('input[name*="[description]"]').forEach(input => {
        if (!input.value) {
            input.value = mainDescription;
        }
    });
});

// Function to initialize Select2 for a specific container or all searchable selects
function initializeSelect2(container = document) {
    const selects = container.querySelectorAll ?
        container.querySelectorAll('.searchable-select') :
        $(container).find('.searchable-select');
    
    $(selects).each(function() {
        // Skip if Select2 is already initialized
        if ($(this).hasClass('select2-hidden-accessible')) {
            return;
        }
        
        const isAccountSelect = $(this).hasClass('account-select');
        $(this).select2({
            placeholder: isAccountSelect ? 'اختر الحساب' : 'اختر مركز التكلفة',
            allowClear: true,
            language: {
                noResults: function() {
                    return "لا توجد نتائج";
                },
                searching: function() {
                    return "جاري البحث...";
                }
            },
            width: '100%'
        });
    });
}

// Initialize Select2 and balance calculation
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Select2 for all existing select elements
    initializeSelect2();
    
    updateBalance();
});

function showMinimumLinesModal() {
    const modal = new bootstrap.Modal(document.getElementById('minimumLinesModal'));
    modal.show();
}
</script>

<!-- Modal تنبيه الحد الأدنى للسطور -->
<div class="modal fade" id="minimumLinesModal" tabindex="-1" aria-labelledby="minimumLinesModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title" id="minimumLinesModalLabel">
                    <i class="fas fa-exclamation-triangle"></i>
                    تنبيه
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="fas fa-info-circle"></i>
                    <strong>تنبيه:</strong> لا يمكن حذف هذا السطر
                </div>
                <p class="mb-3">يجب وجود سطرين على الأقل في القيد لضمان التوازن المحاسبي.</p>
                <div class="card">
                    <div class="card-body bg-light">
                        <h6 class="card-title">متطلبات القيد المحاسبي:</h6>
                        <ul class="mb-0">
                            <li>حد أدنى سطرين في القيد</li>
                            <li>توازن بين إجمالي المدين والدائن</li>
                            <li>تحديد الحسابات المناسبة</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                    <i class="fas fa-check"></i>
                    موافق
                </button>
            </div>
        </div>
    </div>
</div>
@endpush