@extends('layouts.app')

@section('title', 'تفاصيل معاملة نقدية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-money-bill-wave"></i>
                        تفاصيل معاملة نقدية - {{ $cashTransaction->reference }}
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.cash-transactions.edit', $cashTransaction) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @if($cashTransaction->journal_entry_id)
                        <a href="{{ route('accounting.journal-entries.show', $cashTransaction->journal_entry_id) }}" 
                           class="btn btn-info">
                            <i class="fas fa-book"></i> عرض القيد
                        </a>
                        @endif
                        <button onclick="window.print()" class="btn btn-secondary">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                        <a href="{{ route('accounting.cash-transactions.index') }}" class="btn btn-primary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- معلومات المعاملة الأساسية -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-info-circle"></i>
                                        معلومات المعاملة
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label text-muted">رقم المرجع</label>
                                                <p class="fw-bold fs-5">{{ $cashTransaction->reference }}</p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label text-muted">التاريخ</label>
                                                <p class="fw-bold">{{ $cashTransaction->date->format('Y-m-d') }}</p>
                                                <small class="text-muted">{{ $cashTransaction->date->format('l, F j, Y') }}</small>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label text-muted">نوع المعاملة</label>
                                                <p>
                                                    @if($cashTransaction->type === 'receipt')
                                                        <span class="badge bg-success fs-6">
                                                            <i class="fas fa-arrow-down"></i> استلام نقدي (مقبوضات)
                                                        </span>
                                                    @else
                                                        <span class="badge bg-danger fs-6">
                                                            <i class="fas fa-arrow-up"></i> دفعة نقدية (مدفوعات)
                                                        </span>
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label text-muted">المبلغ</label>
                                                <p class="fw-bold fs-4 {{ $cashTransaction->type === 'receipt' ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($cashTransaction->amount, 2) }} ريال
                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label class="form-label text-muted">الوصف</label>
                                                <p class="fs-6">{{ $cashTransaction->description }}</p>
                                            </div>
                                        </div>
                                    </div>

                                    @if($cashTransaction->notes)
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label class="form-label text-muted">ملاحظات</label>
                                                <div class="border rounded p-3 bg-light">
                                                    {{ $cashTransaction->notes }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- معلومات إضافية -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-chart-bar"></i>
                                        معلومات إضافية
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label text-muted">حالة المطابقة</label>
                                        <p>
                                            @if($cashTransaction->is_reconciled)
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check"></i> مطابق
                                                </span>
                                            @else
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-clock"></i> في الانتظار
                                                </span>
                                            @endif
                                        </p>
                                    </div>

                                    @if($cashTransaction->cost_center_id)
                                    <div class="mb-3">
                                        <label class="form-label text-muted">مركز التكلفة</label>
                                        <p>
                                            <a href="{{ route('cost-centers.show', $cashTransaction->costCenter) }}" 
                                               class="text-decoration-none">
                                                <strong>{{ $cashTransaction->costCenter->code }}</strong> - 
                                                {{ $cashTransaction->costCenter->name }}
                                            </a>
                                        </p>
                                    </div>
                                    @endif

                                    <div class="mb-3">
                                        <label class="form-label text-muted">تاريخ الإنشاء</label>
                                        <p>{{ $cashTransaction->created_at->format('Y-m-d H:i') }}</p>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label text-muted">آخر تحديث</label>
                                        <p>{{ $cashTransaction->updated_at->format('Y-m-d H:i') }}</p>
                                    </div>

                                    @if($cashTransaction->creator)
                                    <div class="mb-3">
                                        <label class="form-label text-muted">المنشئ</label>
                                        <p>{{ $cashTransaction->creator->name }}</p>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- معلومات الحسابات -->
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-university"></i>
                                        الحساب النقدي
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">
                                                <a href="{{ route('accounting.accounts.show', $cashTransaction->account) }}" 
                                                   class="text-decoration-none">
                                                    <strong>{{ $cashTransaction->account->code }}</strong> - 
                                                    {{ $cashTransaction->account->name }}
                                                </a>
                                            </h6>
                                            <small class="text-muted">{{ $cashTransaction->account->type }}</small>
                                            <div class="mt-2">
                                                @if($cashTransaction->account->is_cash_account)
                                                    <span class="badge bg-warning">نقدي</span>
                                                @endif
                                                @if($cashTransaction->account->is_bank_account)
                                                    <span class="badge bg-info">بنكي</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="text-end">
                                            <div class="fs-5 fw-bold {{ $cashTransaction->type === 'receipt' ? 'text-success' : 'text-danger' }}">
                                                {{ $cashTransaction->type === 'receipt' ? '+' : '-' }}{{ number_format($cashTransaction->amount, 2) }}
                                            </div>
                                            <small class="text-muted">ريال</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-exchange-alt"></i>
                                        الحساب المقابل
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">
                                                <a href="{{ route('accounting.accounts.show', $cashTransaction->contraAccount) }}" 
                                                   class="text-decoration-none">
                                                    <strong>{{ $cashTransaction->contraAccount->code }}</strong> - 
                                                    {{ $cashTransaction->contraAccount->name }}
                                                </a>
                                            </h6>
                                            <small class="text-muted">{{ $cashTransaction->contraAccount->type }}</small>
                                        </div>
                                        <div class="text-end">
                                            <div class="fs-5 fw-bold {{ $cashTransaction->type === 'receipt' ? 'text-danger' : 'text-success' }}">
                                                {{ $cashTransaction->type === 'receipt' ? '-' : '+' }}{{ number_format($cashTransaction->amount, 2) }}
                                            </div>
                                            <small class="text-muted">ريال</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- القيد المحاسبي -->
                    @if($cashTransaction->journal_entry_id)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-book"></i>
                                        القيد المحاسبي المرتبط
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label class="form-label text-muted">رقم القيد</label>
                                            <p class="fw-bold">
                                                <a href="{{ route('accounting.journal-entries.show', $cashTransaction->journal_entry_id) }}" 
                                                   class="text-decoration-none">
                                                    {{ $cashTransaction->journalEntry->reference ?? 'N/A' }}
                                                </a>
                                            </p>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label text-muted">تاريخ القيد</label>
                                            <p>{{ $cashTransaction->journalEntry->date->format('Y-m-d') ?? 'N/A' }}</p>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label text-muted">حالة القيد</label>
                                            <p>
                                                @if($cashTransaction->journalEntry && $cashTransaction->journalEntry->is_approved)
                                                    <span class="badge bg-success">معتمد</span>
                                                @else
                                                    <span class="badge bg-warning">مسودة</span>
                                                @endif
                                            </p>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label text-muted">إجمالي القيد</label>
                                            <p class="fw-bold">{{ number_format($cashTransaction->amount, 2) }} ريال</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- أزرار الإجراءات -->
                    <div class="d-flex justify-content-between mt-4 no-print">
                        <div>
                            <a href="{{ route('accounting.cash-transactions.edit', $cashTransaction) }}" 
                               class="btn btn-warning">
                                <i class="fas fa-edit"></i> تعديل المعاملة
                            </a>
                            @if($cashTransaction->journal_entry_id)
                            <a href="{{ route('accounting.journal-entries.show', $cashTransaction->journal_entry_id) }}" 
                               class="btn btn-info">
                                <i class="fas fa-book"></i> عرض القيد المحاسبي
                            </a>
                            @endif
                        </div>
                        <div>
                            <button type="button" class="btn btn-danger" onclick="deleteTransaction()">
                                <i class="fas fa-trash"></i> حذف المعاملة
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تأكيد الحذف -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد الحذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من حذف هذه المعاملة النقدية؟</p>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>تحذير:</strong> 
                    @if($cashTransaction->journal_entry_id)
                        سيتم حذف القيد المحاسبي المرتبط أيضاً. 
                    @endif
                    هذا الإجراء لا يمكن التراجع عنه.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form method="POST" action="{{ route('accounting.cash-transactions.destroy', $cashTransaction) }}" 
                      style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">حذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function deleteTransaction() {
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}
</script>
@endsection

@section('styles')
<style>
.card {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    transition: all 0.3s ease;
}

.card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.form-label {
    font-weight: 600;
    font-size: 0.875rem;
    margin-bottom: 0.25rem;
}

.badge {
    font-size: 0.75em;
}

.fs-6 {
    font-size: 1rem !important;
}

@media print {
    .no-print, .btn-group, .card-header .btn-group {
        display: none !important;
    }
    
    .card {
        box-shadow: none !important;
        border: 1px solid #dee2e6 !important;
    }
    
    .card-header {
        background-color: #f8f9fa !important;
        color: #333 !important;
    }
    
    body {
        font-size: 12px;
    }
}

.text-decoration-none:hover {
    text-decoration: underline !important;
}
</style>
@endsection