<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير المعاملات النقدية</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            direction: rtl;
            text-align: right;
            margin: 0;
            padding: 20px;
            font-size: 12px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        
        .header h2 {
            margin: 5px 0;
            color: #666;
            font-size: 16px;
            font-weight: normal;
        }
        
        .filters {
            background-color: #f8f9fa;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            border: 1px solid #dee2e6;
        }
        
        .filters h3 {
            margin: 0 0 10px 0;
            color: #495057;
            font-size: 14px;
        }
        
        .filter-row {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 10px;
        }
        
        .filter-item {
            min-width: 150px;
        }
        
        .filter-label {
            font-weight: bold;
            color: #495057;
        }
        
        .summary {
            display: flex;
            justify-content: space-around;
            margin-bottom: 30px;
            gap: 15px;
        }
        
        .summary-item {
            flex: 1;
            text-align: center;
            padding: 15px;
            border-radius: 5px;
            border: 1px solid #dee2e6;
        }
        
        .summary-item.receipts {
            background-color: #d4edda;
            border-color: #c3e6cb;
        }
        
        .summary-item.payments {
            background-color: #f8d7da;
            border-color: #f5c6cb;
        }
        
        .summary-item.net {
            background-color: #d1ecf1;
            border-color: #bee5eb;
        }
        
        .summary-item.count {
            background-color: #fff3cd;
            border-color: #ffeaa7;
        }
        
        .summary-item h4 {
            margin: 0 0 5px 0;
            color: #495057;
            font-size: 12px;
        }
        
        .summary-item .amount {
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }
        
        th, td {
            border: 1px solid #dee2e6;
            padding: 8px;
            text-align: center;
        }
        
        th {
            background-color: #343a40;
            color: white;
            font-weight: bold;
        }
        
        tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .receipt {
            color: #28a745;
            font-weight: bold;
        }
        
        .payment {
            color: #dc3545;
            font-weight: bold;
        }
        
        .reconciled {
            color: #28a745;
        }
        
        .pending {
            color: #ffc107;
        }
        
        .footer {
            margin-top: 30px;
            text-align: center;
            color: #666;
            font-size: 10px;
            border-top: 1px solid #dee2e6;
            padding-top: 15px;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        @media print {
            body {
                padding: 0;
            }
            
            .summary {
                break-inside: avoid;
            }
            
            table {
                break-inside: auto;
            }
            
            tr {
                break-inside: avoid;
                break-after: auto;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>تقرير المعاملات النقدية</h1>
        <h2>{{ now()->format('Y-m-d H:i') }}</h2>
    </div>

    <!-- معايير التصفية -->
    @if($request->filled('start_date') || $request->filled('end_date') || $request->filled('type') || $request->filled('cash_account_id') || $request->filled('search'))
    <div class="filters">
        <h3>معايير التصفية المطبقة:</h3>
        
        <div class="filter-row">
            @if($request->filled('start_date'))
            <div class="filter-item">
                <span class="filter-label">من تاريخ:</span> {{ $request->start_date }}
            </div>
            @endif
            
            @if($request->filled('end_date'))
            <div class="filter-item">
                <span class="filter-label">إلى تاريخ:</span> {{ $request->end_date }}
            </div>
            @endif
            
            @if($request->filled('type'))
            <div class="filter-item">
                <span class="filter-label">نوع المعاملة:</span> 
                {{ $request->type == 'receipt' ? 'استلام نقدي' : 'دفعة نقدية' }}
            </div>
            @endif
        </div>
        
        <div class="filter-row">
            @if($request->filled('cash_account_id'))
            <div class="filter-item">
                <span class="filter-label">الحساب:</span>
                @php
                    $account = $cashAccounts->find($request->cash_account_id);
                @endphp
                {{ $account ? $account->code . ' - ' . $account->name : 'غير محدد' }}
            </div>
            @endif
            
            @if($request->filled('search'))
            <div class="filter-item">
                <span class="filter-label">البحث:</span> {{ $request->search }}
            </div>
            @endif
        </div>
    </div>
    @endif

    <!-- ملخص الإحصائيات -->
    <div class="summary">
        <div class="summary-item receipts">
            <h4>إجمالي المقبوضات</h4>
            <div class="amount">{{ number_format($totalReceipts, 2) }} ريال</div>
        </div>
        <div class="summary-item payments">
            <h4>إجمالي المدفوعات</h4>
            <div class="amount">{{ number_format($totalPayments, 2) }} ريال</div>
        </div>
        <div class="summary-item net">
            <h4>صافي التدفق النقدي</h4>
            <div class="amount">{{ number_format($netCashFlow, 2) }} ريال</div>
        </div>
        <div class="summary-item count">
            <h4>عدد المعاملات</h4>
            <div class="amount">{{ $transactions->count() }}</div>
        </div>
    </div>

    <!-- جدول المعاملات -->
    @if($transactions->count() > 0)
    <table>
            <tr>
                <th>التاريخ</th>
                <th>رقم المرجع</th>
                <th>النوع</th>
                <th>الحساب</th>
                <th>الوصف</th>
                <th>المبلغ (ريال)</th>
                <th>الحالة</th>
                <th>المنشئ</th>
            </tr>
            @foreach($transactions as $transaction)
            <tr>
                <td class="text-center">
                    {{ \Carbon\Carbon::parse($transaction->transaction_date)->format('Y-m-d') }}
                </td>
                <td class="text-center">
                    {{ $transaction->transaction_number }}
                </td>
                <td class="text-center">
                    @if($transaction->type === 'receipt')
                        <span class="receipt">استلام نقدي</span>
                    @else
                        <span class="payment">دفعة نقدية</span>
                    @endif
                </td>
                <td class="text-right">
                    {{ $transaction->cashAccount->code }} - {{ $transaction->cashAccount->name }}
                </td>
                <td class="text-right">
                    {{ $transaction->description }}
                </td>
                <td class="text-center {{ $transaction->type === 'receipt' ? 'receipt' : 'payment' }}">
                    {{ number_format($transaction->amount, 2) }}
                </td>
                <td class="text-center">
                    @if($transaction->is_reconciled ?? false)
                        <span class="reconciled">مطابق</span>
                    @else
                        <span class="pending">في الانتظار</span>
                    @endif
                </td>
                <td class="text-center">
                    {{ $transaction->creator ? $transaction->creator->name : '' }}
                </td>
            </tr>
            @endforeach
    </table>
    @else
    <div style="text-align: center; padding: 50px; color: #666;">
        <h3>لا توجد معاملات نقدية</h3>
        <p>لم يتم العثور على معاملات نقدية تطابق معايير البحث المحددة</p>
    </div>
    @endif

    <div class="footer">
        <p>تم إنشاء هذا التقرير في {{ now()->format('Y-m-d H:i:s') }}</p>
        <p>عدد المعاملات المعروضة: {{ $transactions->count() }}</p>
    </div>
</body>
</html>