@extends('layouts.app')

@section('title', 'المعاملات النقدية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-money-bill-wave"></i>
                        المعاملات النقدية
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.cash-transactions.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة معاملة نقدية
                        </a>
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
                                <i class="fas fa-download"></i> تصدير
                            </button>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="dropdown-item" href="{{ route('cash-transactions.export.excel', request()->all()) }}">
                                        <i class="fas fa-file-excel"></i> Excel
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('cash-transactions.export.pdf', request()->all()) }}">
                                        <i class="fas fa-file-pdf"></i> PDF
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-2">
                                <label for="start_date" class="form-label">من تاريخ</label>
                                <input type="date" name="start_date" id="start_date" 
                                       class="form-control" value="{{ request('start_date') }}">
                            </div>
                            <div class="col-md-2">
                                <label for="end_date" class="form-label">إلى تاريخ</label>
                                <input type="date" name="end_date" id="end_date" 
                                       class="form-control" value="{{ request('end_date') }}">
                            </div>
                            <div class="col-md-2">
                                <label for="type" class="form-label">نوع المعاملة</label>
                                <select name="type" id="type" class="form-select">
                                    <option value="">جميع الأنواع</option>
                                    <option value="receipt" {{ request('type') == 'receipt' ? 'selected' : '' }}>
                                        استلام نقدي
                                    </option>
                                    <option value="payment" {{ request('type') == 'payment' ? 'selected' : '' }}>
                                        دفعة نقدية
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="cash_account_id" class="form-label">الحساب</label>
                                <select name="cash_account_id" id="cash_account_id" class="form-select">
                                    <option value="">جميع الحسابات</option>
                                    @foreach($cashAccounts as $account)
                                        <option value="{{ $account->id }}"
                                                {{ request('cash_account_id') == $account->id ? 'selected' : '' }}>
                                            {{ $account->code }} - {{ $account->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="search" class="form-label">البحث</label>
                                <input type="text" name="search" id="search" 
                                       class="form-control" placeholder="رقم المرجع أو الوصف"
                                       value="{{ request('search') }}">
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary me-2">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                <a href="{{ route('accounting.cash-transactions.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-undo"></i> إعادة تعيين
                                </a>
                            </div>
                        </div>
                    </form>

                    <!-- إحصائيات سريعة -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="card-title mb-0">إجمالي المقبوضات</h6>
                                            <h4 class="mb-0">{{ number_format($totalReceipts, 2) }}</h4>
                                        </div>
                                        <i class="fas fa-arrow-down fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-danger text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="card-title mb-0">إجمالي المدفوعات</h6>
                                            <h4 class="mb-0">{{ number_format($totalPayments, 2) }}</h4>
                                        </div>
                                        <i class="fas fa-arrow-up fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="card-title mb-0">صافي التدفق النقدي</h6>
                                            <h4 class="mb-0">{{ number_format($netCashFlow, 2) }}</h4>
                                        </div>
                                        <i class="fas fa-exchange-alt fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-warning text-dark">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="card-title mb-0">عدد المعاملات</h6>
                                            <h4 class="mb-0">{{ $transactions->total() }}</h4>
                                        </div>
                                        <i class="fas fa-list fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول المعاملات النقدية -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                                <tr>
                                    <th class="text-center">التاريخ</th>
                                    <th class="text-center">رقم المرجع</th>
                                    <th class="text-center">النوع</th>
                                    <th>الحساب</th>
                                    <th>الوصف</th>
                                    <th class="text-center">المبلغ</th>
                                    <th class="text-center">الحالة</th>
                                    <th class="text-center">الإجراءات</th>
                                </tr>
                                @forelse($transactions as $transaction)
                                <tr>
                                    <td class="text-center">
                                        {{ \Carbon\Carbon::parse($transaction->transaction_date)->format('Y-m-d') }}
                                    </td>
                                    <td class="text-center">
                                        <strong>{{ $transaction->transaction_number }}</strong>
                                    </td>
                                    <td class="text-center">
                                        @if($transaction->type === 'receipt')
                                            <span class="badge bg-success">
                                                <i class="fas fa-arrow-down"></i> مقبوضات
                                            </span>
                                        @else
                                            <span class="badge bg-danger">
                                                <i class="fas fa-arrow-up"></i> مدفوعات
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $transaction->cashAccount) }}"
                                           class="text-decoration-none">
                                            <strong>{{ $transaction->cashAccount->code }}</strong> - {{ $transaction->cashAccount->name }}
                                        </a>
                                        <span class="badge bg-warning ms-1">نقدي</span>
                                    </td>
                                    <td>
                                        {{ $transaction->description }}
                                        @if($transaction->reference)
                                            <small class="text-muted d-block">المرجع: {{ $transaction->reference }}</small>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <span class="{{ $transaction->type === 'receipt' ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($transaction->amount, 2) }} ريال
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-info">
                                            <i class="fas fa-clock"></i> معالج
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('accounting.cash-transactions.show', $transaction) }}" 
                                               class="btn btn-info" title="عرض">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('accounting.cash-transactions.edit', $transaction) }}" 
                                               class="btn btn-warning" title="تعديل">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if($transaction->journal_entry_id)
                                            <a href="{{ route('accounting.journal-entries.show', $transaction->journal_entry_id) }}" 
                                               class="btn btn-secondary" title="عرض القيد">
                                                <i class="fas fa-book"></i>
                                            </a>
                                            @endif
                                            <button type="button" class="btn btn-danger" 
                                                    onclick="deleteTransaction({{ $transaction->id }})" title="حذف">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-info-circle fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">لا توجد معاملات نقدية</h5>
                                            <p class="text-muted">لم يتم العثور على معاملات نقدية تطابق معايير البحث</p>
                                            <a href="{{ route('accounting.cash-transactions.create') }}" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> إضافة معاملة نقدية جديدة
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                        </table>
                    </div>

                    <!-- التصفح -->
                    @if($transactions->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $transactions->appends(request()->query())->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تأكيد الحذف -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد الحذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من حذف هذه المعاملة النقدية؟</p>
                <p class="text-danger"><strong>تحذير:</strong> هذا الإجراء لا يمكن التراجع عنه.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">حذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function deleteTransaction(id) {
    const deleteForm = document.getElementById('deleteForm');
    deleteForm.action = `/accounting/cash-transactions/${id}`;
    
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}

// تحديث تلقائي للبيانات كل 30 ثانية
setInterval(function() {
    // يمكن إضافة كود AJAX هنا لتحديث الإحصائيات
}, 30000);
</script>
@endsection

@section('styles')
<style>
.card {
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.table th {
    border-top: none;
    font-weight: 600;
    white-space: nowrap;
}

.btn-group-sm > .btn, .btn-sm {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
}

.badge {
    font-size: 0.75em;
}

@media print {
    .btn-group, .card-header .btn-group, form {
        display: none !important;
    }
    
    .table {
        font-size: 12px;
    }
}
</style>
@endsection