@extends('layouts.app')

@section('title', 'تعديل معاملة نقدية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-edit"></i>
                        تعديل معاملة نقدية - {{ $cashTransaction->reference }}
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.cash-transactions.show', $cashTransaction) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> عرض
                        </a>
                        <a href="{{ route('accounting.cash-transactions.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if($cashTransaction->journal_entry_id)
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <strong>تنبيه:</strong> هذه المعاملة مرتبطة بقيد محاسبي 
                        <a href="{{ route('accounting.journal-entries.show', $cashTransaction->journal_entry_id) }}" 
                           class="alert-link">{{ $cashTransaction->journal_entry->reference ?? 'رقم القيد' }}</a>. 
                        سيتم تحديث القيد تلقائياً عند حفظ التعديلات.
                    </div>
                    @endif

                    <form method="POST" action="{{ route('accounting.cash-transactions.update', $cashTransaction) }}">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <!-- النوع والتاريخ -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">نوع المعاملة <span class="text-danger">*</span></label>
                                    <select name="type" id="type" class="form-select @error('type') is-invalid @enderror" required>
                                        <option value="">اختر نوع المعاملة</option>
                                        <option value="receipt" {{ old('type', $cashTransaction->type) == 'receipt' ? 'selected' : '' }}>
                                            استلام نقدي (مقبوضات)
                                        </option>
                                        <option value="payment" {{ old('type', $cashTransaction->type) == 'payment' ? 'selected' : '' }}>
                                            دفعة نقدية (مدفوعات)
                                        </option>
                                    </select>
                                    @error('type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="date" class="form-label">التاريخ <span class="text-danger">*</span></label>
                                    <input type="date" name="date" id="date" 
                                           class="form-control @error('date') is-invalid @enderror"
                                           value="{{ old('date', $cashTransaction->date->format('Y-m-d')) }}" required>
                                    @error('date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- رقم المرجع والحساب -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="reference" class="form-label">رقم المرجع <span class="text-danger">*</span></label>
                                    <input type="text" name="reference" id="reference" 
                                           class="form-control @error('reference') is-invalid @enderror"
                                           value="{{ old('reference', $cashTransaction->reference) }}" required>
                                    @error('reference')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="account_id" class="form-label">الحساب النقدي <span class="text-danger">*</span></label>
                                    <select name="account_id" id="account_id" class="form-select @error('account_id') is-invalid @enderror" required>
                                        <option value="">اختر الحساب النقدي</option>
                                        @foreach($cashAccounts as $account)
                                            <option value="{{ $account->id }}" 
                                                    {{ old('account_id', $cashTransaction->account_id) == $account->id ? 'selected' : '' }}>
                                                {{ $account->code }} - {{ $account->name }}
                                                @if($account->is_bank_account)
                                                    (بنكي)
                                                @else
                                                    (نقدي)
                                                @endif
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('account_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- المبلغ والحساب المقابل -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="amount" class="form-label">المبلغ <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" name="amount" id="amount" step="0.01" min="0.01"
                                               class="form-control @error('amount') is-invalid @enderror"
                                               value="{{ old('amount', $cashTransaction->amount) }}" required>
                                        <span class="input-group-text">ريال</span>
                                    </div>
                                    @error('amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="contra_account_id" class="form-label">الحساب المقابل <span class="text-danger">*</span></label>
                                    <select name="contra_account_id" id="contra_account_id" class="form-select @error('contra_account_id') is-invalid @enderror" required>
                                        <option value="">اختر الحساب المقابل</option>
                                        @foreach($allAccounts as $account)
                                            <option value="{{ $account->id }}" 
                                                    {{ old('contra_account_id', $cashTransaction->contra_account_id) == $account->id ? 'selected' : '' }}>
                                                {{ $account->code }} - {{ $account->name }}
                                                <span class="text-muted">({{ $account->type }})</span>
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('contra_account_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- الوصف -->
                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف <span class="text-danger">*</span></label>
                            <input type="text" name="description" id="description" 
                                   class="form-control @error('description') is-invalid @enderror"
                                   value="{{ old('description', $cashTransaction->description) }}" required>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- ملاحظات -->
                        <div class="mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea name="notes" id="notes" rows="3" 
                                      class="form-control @error('notes') is-invalid @enderror"
                                      placeholder="ملاحظات إضافية (اختيارية)">{{ old('notes', $cashTransaction->notes) }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- مركز التكلفة -->
                        @if(count($costCenters) > 0)
                        <div class="mb-3">
                            <label for="cost_center_id" class="form-label">مركز التكلفة</label>
                            <select name="cost_center_id" id="cost_center_id" class="form-select @error('cost_center_id') is-invalid @enderror">
                                <option value="">بدون مركز تكلفة</option>
                                @foreach($costCenters as $costCenter)
                                    <option value="{{ $costCenter->id }}" 
                                            {{ old('cost_center_id', $cashTransaction->cost_center_id) == $costCenter->id ? 'selected' : '' }}>
                                        {{ $costCenter->code }} - {{ $costCenter->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('cost_center_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        @endif

                        <!-- خيارات إضافية -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-check mb-3">
                                    <input type="checkbox" name="update_journal_entry" id="update_journal_entry" 
                                           class="form-check-input" value="1" 
                                           {{ old('update_journal_entry', $cashTransaction->journal_entry_id ? '1' : '') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="update_journal_entry">
                                        تحديث القيد المحاسبي
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check mb-3">
                                    <input type="checkbox" name="is_reconciled" id="is_reconciled" 
                                           class="form-check-input" value="1" 
                                           {{ old('is_reconciled', $cashTransaction->is_reconciled) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_reconciled">
                                        معاملة مطابقة
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- معلومات إضافية -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">معلومات المعاملة</h6>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <small class="text-muted">تاريخ الإنشاء:</small><br>
                                                <strong>{{ $cashTransaction->created_at->format('Y-m-d H:i') }}</strong>
                                            </div>
                                            <div class="col-md-3">
                                                <small class="text-muted">آخر تحديث:</small><br>
                                                <strong>{{ $cashTransaction->updated_at->format('Y-m-d H:i') }}</strong>
                                            </div>
                                            <div class="col-md-3">
                                                <small class="text-muted">المنشئ:</small><br>
                                                <strong>{{ $cashTransaction->creator->name ?? 'غير معروف' }}</strong>
                                            </div>
                                            <div class="col-md-3">
                                                <small class="text-muted">حالة المطابقة:</small><br>
                                                @if($cashTransaction->is_reconciled)
                                                    <span class="badge bg-success">مطابق</span>
                                                @else
                                                    <span class="badge bg-warning">في الانتظار</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- أزرار الحفظ -->
                        <div class="d-flex justify-content-between mt-4">
                            <div>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التعديلات
                                </button>
                                @if($cashTransaction->journal_entry_id)
                                <a href="{{ route('accounting.journal-entries.show', $cashTransaction->journal_entry_id) }}" 
                                   class="btn btn-info">
                                    <i class="fas fa-book"></i> عرض القيد المحاسبي
                                </a>
                                @endif
                            </div>
                            <div>
                                <a href="{{ route('accounting.cash-transactions.show', $cashTransaction) }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type');
    const amountInput = document.getElementById('amount');
    const contraAccountSelect = document.getElementById('contra_account_id');
    
    // تحديث placeholder المبلغ بناءً على نوع المعاملة
    typeSelect.addEventListener('change', function() {
        if (this.value === 'receipt') {
            amountInput.placeholder = 'المبلغ المستلم';
        } else if (this.value === 'payment') {
            amountInput.placeholder = 'المبلغ المدفوع';
        } else {
            amountInput.placeholder = '';
        }
    });

    // تنسيق المبلغ
    amountInput.addEventListener('input', function() {
        let value = this.value.replace(/[^\d.]/g, '');
        if (value.split('.').length > 2) {
            value = value.substring(0, value.lastIndexOf('.'));
        }
        this.value = value;
    });

    // منع اختيار نفس الحساب للحساب النقدي والحساب المقابل
    function validateAccounts() {
        const accountId = document.getElementById('account_id').value;
        const contraAccountId = contraAccountSelect.value;
        
        if (accountId && contraAccountId && accountId === contraAccountId) {
            contraAccountSelect.setCustomValidity('لا يمكن أن يكون الحساب المقابل نفس الحساب النقدي');
        } else {
            contraAccountSelect.setCustomValidity('');
        }
    }

    document.getElementById('account_id').addEventListener('change', validateAccounts);
    contraAccountSelect.addEventListener('change', validateAccounts);

    // تأكيد التعديل إذا كان هناك قيد محاسبي مرتبط
    const form = document.querySelector('form');
    const hasJournalEntry = {{ $cashTransaction->journal_entry_id ? 'true' : 'false' }};
    
    if (hasJournalEntry) {
        form.addEventListener('submit', function(e) {
            const updateJournalEntry = document.getElementById('update_journal_entry').checked;
            if (updateJournalEntry) {
                if (!confirm('سيتم تحديث القيد المحاسبي المرتبط بهذه المعاملة. هل تريد المتابعة؟')) {
                    e.preventDefault();
                }
            }
        });
    }
});
</script>
@endsection

@section('styles')
<style>
.form-label {
    font-weight: 600;
    color: #495057;
}

.form-control:focus,
.form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.input-group-text {
    background-color: #f8f9fa;
    border-color: #ced4da;
}

.form-check-input:checked {
    background-color: #0d6efd;
    border-color: #0d6efd;
}

.card {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

.btn {
    font-weight: 500;
}

.alert-link {
    text-decoration: none;
    font-weight: 600;
}

.alert-link:hover {
    text-decoration: underline;
}

.badge {
    font-size: 0.75em;
}
</style>
@endsection