@extends('layouts.app')

@section('title', 'إضافة معاملة نقدية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-plus-circle"></i>
                        إضافة معاملة نقدية جديدة
                    </h3>
                    <a href="{{ route('accounting.cash-transactions.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route('accounting.cash-transactions.store') }}">
                        @csrf
                        
                        <div class="row">
                            <!-- النوع والتاريخ -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">نوع المعاملة <span class="text-danger">*</span></label>
                                    <select name="type" id="type" class="form-select @error('type') is-invalid @enderror" required>
                                        <option value="">اختر نوع المعاملة</option>
                                        <option value="receipt" {{ old('type') == 'receipt' ? 'selected' : '' }}>
                                            استلام نقدي (مقبوضات)
                                        </option>
                                        <option value="payment" {{ old('type') == 'payment' ? 'selected' : '' }}>
                                            دفعة نقدية (مدفوعات)
                                        </option>
                                    </select>
                                    @error('type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="date" class="form-label">التاريخ <span class="text-danger">*</span></label>
                                    <input type="date" name="date" id="date" 
                                           class="form-control @error('date') is-invalid @enderror"
                                           value="{{ old('date', now()->format('Y-m-d')) }}" required>
                                    @error('date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- رقم المرجع والحساب -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="reference" class="form-label">رقم المرجع</label>
                                    <input type="text" name="reference" id="reference" 
                                           class="form-control @error('reference') is-invalid @enderror"
                                           value="{{ old('reference') }}" placeholder="سيتم توليده تلقائياً إذا ترك فارغاً">
                                    @error('reference')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">اتركه فارغاً للتوليد التلقائي</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="account_id" class="form-label">الحساب النقدي <span class="text-danger">*</span></label>
                                    <select name="account_id" id="account_id" class="form-select @error('account_id') is-invalid @enderror" required>
                                        <option value="">اختر الحساب النقدي</option>
                                        @foreach($cashAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->code }} - {{ $account->name }}
                                                @if($account->is_bank_account)
                                                    (بنكي)
                                                @else
                                                    (نقدي)
                                                @endif
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('account_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- المبلغ والحساب المقابل -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="amount" class="form-label">المبلغ <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" name="amount" id="amount" step="0.01" min="0.01"
                                               class="form-control @error('amount') is-invalid @enderror"
                                               value="{{ old('amount') }}" required>
                                        <span class="input-group-text">ريال</span>
                                    </div>
                                    @error('amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="contra_account_id" class="form-label">الحساب المقابل <span class="text-danger">*</span></label>
                                    <select name="contra_account_id" id="contra_account_id" class="form-select @error('contra_account_id') is-invalid @enderror" required>
                                        <option value="">اختر الحساب المقابل</option>
                                        @foreach($allAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('contra_account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->code }} - {{ $account->name }}
                                                <span class="text-muted">({{ $account->type }})</span>
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('contra_account_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- الوصف -->
                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف <span class="text-danger">*</span></label>
                            <input type="text" name="description" id="description" 
                                   class="form-control @error('description') is-invalid @enderror"
                                   value="{{ old('description') }}" required 
                                   placeholder="اكتب وصف المعاملة النقدية">
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- ملاحظات -->
                        <div class="mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea name="notes" id="notes" rows="3" 
                                      class="form-control @error('notes') is-invalid @enderror"
                                      placeholder="ملاحظات إضافية (اختيارية)">{{ old('notes') }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- مركز التكلفة -->
                        @if(count($costCenters) > 0)
                        <div class="mb-3">
                            <label for="cost_center_id" class="form-label">مركز التكلفة</label>
                            <select name="cost_center_id" id="cost_center_id" class="form-select @error('cost_center_id') is-invalid @enderror">
                                <option value="">بدون مركز تكلفة</option>
                                @foreach($costCenters as $costCenter)
                                    <option value="{{ $costCenter->id }}" {{ old('cost_center_id') == $costCenter->id ? 'selected' : '' }}>
                                        {{ $costCenter->code }} - {{ $costCenter->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('cost_center_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        @endif

                        <!-- خيارات إضافية -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-check mb-3">
                                    <input type="checkbox" name="create_journal_entry" id="create_journal_entry" 
                                           class="form-check-input" value="1" 
                                           {{ old('create_journal_entry', '1') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="create_journal_entry">
                                        إنشاء قيد محاسبي تلقائياً
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check mb-3">
                                    <input type="checkbox" name="is_reconciled" id="is_reconciled" 
                                           class="form-check-input" value="1" 
                                           {{ old('is_reconciled') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_reconciled">
                                        معاملة مطابقة
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- أزرار الحفظ -->
                        <div class="d-flex justify-content-between">
                            <div>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ المعاملة
                                </button>
                                <button type="submit" name="save_and_new" value="1" class="btn btn-success">
                                    <i class="fas fa-plus"></i> حفظ وإضافة جديد
                                </button>
                            </div>
                            <a href="{{ route('accounting.cash-transactions.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type');
    const amountInput = document.getElementById('amount');
    const contraAccountSelect = document.getElementById('contra_account_id');
    
    // تحديث placeholder المبلغ بناءً على نوع المعاملة
    typeSelect.addEventListener('change', function() {
        if (this.value === 'receipt') {
            amountInput.placeholder = 'المبلغ المستلم';
        } else if (this.value === 'payment') {
            amountInput.placeholder = 'المبلغ المدفوع';
        } else {
            amountInput.placeholder = '';
        }
    });

    // تنسيق المبلغ
    amountInput.addEventListener('input', function() {
        let value = this.value.replace(/[^\d.]/g, '');
        if (value.split('.').length > 2) {
            value = value.substring(0, value.lastIndexOf('.'));
        }
        this.value = value;
    });

    // منع اختيار نفس الحساب للحساب النقدي والحساب المقابل
    function validateAccounts() {
        const accountId = document.getElementById('account_id').value;
        const contraAccountId = contraAccountSelect.value;
        
        if (accountId && contraAccountId && accountId === contraAccountId) {
            contraAccountSelect.setCustomValidity('لا يمكن أن يكون الحساب المقابل نفس الحساب النقدي');
        } else {
            contraAccountSelect.setCustomValidity('');
        }
    }

    document.getElementById('account_id').addEventListener('change', validateAccounts);
    contraAccountSelect.addEventListener('change', validateAccounts);
});
</script>
@endsection

@section('styles')
<style>
.form-label {
    font-weight: 600;
    color: #495057;
}

.form-control:focus,
.form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.input-group-text {
    background-color: #f8f9fa;
    border-color: #ced4da;
}

.form-check-input:checked {
    background-color: #0d6efd;
    border-color: #0d6efd;
}

.card {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

.btn {
    font-weight: 500;
}

.form-text {
    font-size: 0.875em;
    color: #6c757d;
}
</style>
@endsection