@extends('layouts.app')

@section('title', 'شجرة الحسابات')

@section('styles')
<style>
.account-tree {
    padding-left: 0;
    list-style: none;
}

.account-tree ul {
    padding-left: 30px;
    list-style: none;
}

.account-item {
    margin: 5px 0;
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 5px;
    background: #f8f9fa;
}

.account-item:hover {
    background: #e9ecef;
}

.account-toggle {
    cursor: pointer;
    color: #007bff;
    margin-right: 5px;
}

.account-code {
    font-weight: bold;
    color: #495057;
}

.account-name {
    color: #212529;
    text-decoration: none;
}

.account-name:hover {
    color: #007bff;
    text-decoration: underline;
}

.account-balance {
    color: #28a745;
    font-weight: bold;
}

.account-badges .badge {
    margin-left: 5px;
}

.level-1 { border-left: 4px solid #007bff; }
.level-2 { border-left: 4px solid #28a745; }
.level-3 { border-left: 4px solid #ffc107; }
.level-4 { border-left: 4px solid #dc3545; }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-sitemap"></i>
                        شجرة الحسابات
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> عرض القائمة
                        </a>
                        <a href="{{ route('accounting.accounts.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> حساب جديد
                        </a>
                        <button type="button" class="btn btn-info" onclick="expandAll()">
                            <i class="fas fa-expand-arrows-alt"></i> توسيع الكل
                        </button>
                        <button type="button" class="btn btn-warning" onclick="collapseAll()">
                            <i class="fas fa-compress-arrows-alt"></i> طي الكل
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center">
                                <span class="me-3"><strong>مفتاح الألوان:</strong></span>
                                <span class="badge bg-primary me-2">المستوى الأول</span>
                                <span class="badge bg-success me-2">المستوى الثاني</span>
                                <span class="badge bg-warning me-2">المستوى الثالث</span>
                                <span class="badge bg-danger me-2">المستوى الرابع</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <input type="text" id="searchTree" class="form-control" placeholder="البحث في الشجرة...">
                        </div>
                    </div>

                    <div id="accountTree">
                        @if($accounts->count() > 0)
                            <ul class="account-tree">
                                @foreach($accounts as $account)
                                    @include('accounting.accounts.tree-item', ['account' => $account])
                                @endforeach
                            </ul>
                        @else
                            <div class="text-center p-4">
                                <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                                <h5>لا توجد حسابات</h5>
                                <p class="text-muted">لم يتم إنشاء أي حسابات بعد</p>
                                <a href="{{ route('accounting.accounts.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> إنشاء حساب جديد
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
// توسيع/طي الحسابات
function toggleAccount(element) {
    const children = element.closest('li').querySelector('ul');
    const icon = element.querySelector('i');
    
    if (children) {
        if (children.style.display === 'none') {
            children.style.display = 'block';
            icon.classList.remove('fa-plus');
            icon.classList.add('fa-minus');
        } else {
            children.style.display = 'none';
            icon.classList.remove('fa-minus');
            icon.classList.add('fa-plus');
        }
    }
}

// توسيع جميع الحسابات
function expandAll() {
    document.querySelectorAll('.account-tree ul').forEach(ul => {
        ul.style.display = 'block';
    });
    document.querySelectorAll('.account-toggle i').forEach(icon => {
        icon.classList.remove('fa-plus');
        icon.classList.add('fa-minus');
    });
}

// طي جميع الحسابات
function collapseAll() {
    document.querySelectorAll('.account-tree ul ul').forEach(ul => {
        ul.style.display = 'none';
    });
    document.querySelectorAll('.account-toggle i').forEach(icon => {
        icon.classList.remove('fa-minus');
        icon.classList.add('fa-plus');
    });
}

// البحث في الشجرة
document.getElementById('searchTree').addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const accountItems = document.querySelectorAll('.account-item');
    
    accountItems.forEach(item => {
        const accountText = item.textContent.toLowerCase();
        const listItem = item.closest('li');
        
        if (searchTerm === '' || accountText.includes(searchTerm)) {
            listItem.style.display = 'block';
            // إظهار الحسابات الأب
            let parent = listItem.parentElement.closest('li');
            while (parent) {
                parent.style.display = 'block';
                const parentUl = parent.querySelector('ul');
                if (parentUl) {
                    parentUl.style.display = 'block';
                }
                parent = parent.parentElement.closest('li');
            }
        } else {
            listItem.style.display = 'none';
        }
    });
    
    // إذا كان البحث فارغ، إعادة تعيين العرض
    if (searchTerm === '') {
        document.querySelectorAll('.account-tree li').forEach(li => {
            li.style.display = 'block';
        });
        collapseAll();
    }
});

// تهيئة الشجرة - طي الحسابات الفرعية افتراضياً
document.addEventListener('DOMContentLoaded', function() {
    collapseAll();
});
</script>
@endsection