<li>
    <div class="account-item level-{{ $account->level }}">
        <div class="d-flex justify-content-between align-items-center">
            <div class="d-flex align-items-center">
                @if($account->children->count() > 0)
                    <span class="account-toggle" onclick="toggleAccount(this)">
                        <i class="fas fa-plus"></i>
                    </span>
                @else
                    <span class="account-toggle" style="width: 16px;"></span>
                @endif

                <span class="account-code me-2">{{ $account->code }}</span>
                <a href="{{ route('accounting.accounts.show', $account) }}" class="account-name">
                    {{ $account->name }}
                </a>

                <div class="account-badges">
                    @if($account->is_cash_account)
                        <span class="badge bg-success">نقدي</span>
                    @endif
                    @if($account->is_bank_account)
                        <span class="badge bg-info">بنكي</span>
                    @endif
                    @if($account->is_control_account)
                        <span class="badge bg-warning">تحكم</span>
                    @endif
                    @switch($account->type)
                        @case('asset')
                            <span class="badge bg-primary">أصول</span>
                            @break
                        @case('liability')
                            <span class="badge bg-danger">خصوم</span>
                            @break
                        @case('equity')
                            <span class="badge bg-secondary">حقوق ملكية</span>
                            @break
                        @case('revenue')
                            <span class="badge bg-success">إيرادات</span>
                            @break
                        @case('expense')
                            <span class="badge bg-warning">مصروفات</span>
                            @break
                    @endswitch
                </div>
            </div>

            <div class="d-flex align-items-center">
                <span class="account-balance me-3">
                    {{ number_format($account->current_balance, 2) }} ريال
                </span>

                <div class="btn-group btn-group-sm">
                    <a href="{{ route('accounting.accounts.show', $account) }}" 
                       class="btn btn-outline-info btn-sm" title="عرض">
                        <i class="fas fa-eye"></i>
                    </a>
                    <a href="{{ route('accounting.accounts.ledger', $account) }}" 
                       class="btn btn-outline-secondary btn-sm" title="دفتر الأستاذ">
                        <i class="fas fa-book"></i>
                    </a>
                    <a href="{{ route('accounting.accounts.edit', $account) }}" 
                       class="btn btn-outline-warning btn-sm" title="تعديل">
                        <i class="fas fa-edit"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if($account->children->count() > 0)
        <ul style="display: none;">
            @foreach($account->children as $child)
                @include('accounting.accounts.tree-item', ['account' => $child])
            @endforeach
        </ul>
    @endif
</li>