@extends('layouts.app')

@section('title', 'تفاصيل الحساب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Account Details Card -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-list-alt"></i> تفاصيل الحساب
                    </h5>
                    <div>
                        <a href="{{ route('accounting.accounts.edit', $account) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('accounting.accounts.ledger', $account) }}" class="btn btn-info">
                            <i class="fas fa-book"></i> دفتر الأستاذ
                        </a>
                        <a href="{{ route('accounting.accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">كود الحساب:</th>
                                    <td><span class="badge bg-primary fs-6">{{ $account->code }}</span></td>
                                </tr>
                                <tr>
                                    <th>اسم الحساب:</th>
                                    <td><strong>{{ $account->name }}</strong></td>
                                </tr>
                                <tr>
                                    <th>نوع الحساب:</th>
                                    <td>
                                        @switch($account->type)
                                            @case('asset')
                                                <span class="badge bg-success">أصول</span>
                                                @break
                                            @case('liability')
                                                <span class="badge bg-danger">خصوم</span>
                                                @break
                                            @case('equity')
                                                <span class="badge bg-info">حقوق ملكية</span>
                                                @break
                                            @case('revenue')
                                                <span class="badge bg-primary">إيرادات</span>
                                                @break
                                            @case('expense')
                                                <span class="badge bg-warning">مصروفات</span>
                                                @break
                                        @endswitch
                                    </td>
                                </tr>
                                <tr>
                                    <th>الحساب الأب:</th>
                                    <td>
                                        @if($account->parent)
                                            <a href="{{ route('accounting.accounts.show', $account->parent) }}">
                                                {{ $account->parent->code }} - {{ $account->parent->name }}
                                            </a>
                                        @else
                                            <span class="text-muted">حساب رئيسي</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>الوصف:</th>
                                    <td>{{ $account->description ?: 'لا يوجد وصف' }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">الرصيد الافتتاحي:</th>
                                    <td>{{ number_format($account->opening_balance, 2) }} ريال</td>
                                </tr>
                                <tr>
                                    <th>إجمالي المدين:</th>
                                    <td class="text-success">{{ number_format($account->journalEntryLines->sum('debit_amount'), 2) }} ريال</td>
                                </tr>
                                <tr>
                                    <th>إجمالي الدائن:</th>
                                    <td class="text-danger">{{ number_format($account->journalEntryLines->sum('credit_amount'), 2) }} ريال</td>
                                </tr>
                                <tr>
                                    <th>الرصيد الحالي:</th>
                                    <td>
                                        <strong class="{{ $account->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($account->current_balance, 2) }} ريال
                                        </strong>
                                    </td>
                                </tr>
                                <tr>
                                    <th>عدد الحركات:</th>
                                    <td>{{ $account->journalEntryLines->count() }} حركة</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء:</th>
                                    <td>{{ $account->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Account Properties -->
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>خصائص الحساب:</h6>
                            <div class="d-flex gap-2">
                                @if($account->is_cash)
                                    <span class="badge bg-success">
                                        <i class="fas fa-money-bill"></i> حساب نقدي
                                    </span>
                                @endif
                                @if($account->is_banking)
                                    <span class="badge bg-info">
                                        <i class="fas fa-university"></i> حساب بنكي
                                    </span>
                                @endif
                                @if($account->is_control)
                                    <span class="badge bg-warning">
                                        <i class="fas fa-cog"></i> حساب تحكم
                                    </span>
                                @endif
                                @if(!$account->is_cash && !$account->is_banking && !$account->is_control)
                                    <span class="badge bg-secondary">حساب عادي</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sub Accounts -->
            @if($account->children->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-sitemap"></i> الحسابات الفرعية ({{ $account->children->count() }})
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th>الكود</th>
                                    <th>اسم الحساب</th>
                                    <th>النوع</th>
                                    <th>الرصيد الحالي</th>
                                    <th>الإجراءات</th>
                                </tr>
                                @foreach($account->children as $child)
                                <tr>
                                    <td><span class="badge bg-primary">{{ $child->code }}</span></td>
                                    <td>{{ $child->name }}</td>
                                    <td>
                                        @switch($child->type)
                                            @case('asset')
                                                <span class="badge bg-success">أصول</span>
                                                @break
                                            @case('liability')
                                                <span class="badge bg-danger">خصوم</span>
                                                @break
                                            @case('equity')
                                                <span class="badge bg-info">حقوق ملكية</span>
                                                @break
                                            @case('revenue')
                                                <span class="badge bg-primary">إيرادات</span>
                                                @break
                                            @case('expense')
                                                <span class="badge bg-warning">مصروفات</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td class="{{ $child->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($child->current_balance, 2) }} ريال
                                    </td>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $child) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('accounting.accounts.edit', $child) }}" class="btn btn-sm btn-outline-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </table>
                    </div>
                </div>
            </div>
            @endif

            <!-- Recent Transactions -->
            @if($recentTransactions->count() > 0)
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-history"></i> آخر الحركات ({{ $recentTransactions->count() }})
                    </h6>
                    <a href="{{ route('accounting.accounts.ledger', $account) }}" class="btn btn-sm btn-outline-primary">
                        عرض جميع الحركات
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th>التاريخ</th>
                                    <th>رقم القيد</th>
                                    <th>البيان</th>
                                    <th>مدين</th>
                                    <th>دائن</th>
                                    <th>الرصيد</th>
                                </tr>
                                @php $runningBalance = $account->opening_balance; @endphp
                                @foreach($recentTransactions as $transaction)
                                    @php 
                                        $runningBalance += ($transaction->debit_amount - $transaction->credit_amount);
                                    @endphp
                                    <tr>
                                        <td>{{ $transaction->journalEntry->entry_date->format('Y-m-d') }}</td>
                                        <td>
                                            <a href="{{ route('accounting.journal-entries.show', $transaction->journalEntry) }}">
                                                {{ $transaction->journalEntry->entry_number }}
                                            </a>
                                        </td>
                                        <td>{{ $transaction->description }}</td>
                                        <td class="text-success">
                                            {{ $transaction->debit_amount > 0 ? number_format($transaction->debit_amount, 2) : '-' }}
                                        </td>
                                        <td class="text-danger">
                                            {{ $transaction->credit_amount > 0 ? number_format($transaction->credit_amount, 2) : '-' }}
                                        </td>
                                        <td class="{{ $runningBalance >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($runningBalance, 2) }}
                                        </td>
                                    </tr>
                                @endforeach
                           </table>
                    </div>
                </div>
            </div>
            @else
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-info-circle fa-3x text-muted mb-3"></i>
                    <h5>لا توجد حركات مالية</h5>
                    <p class="text-muted">لم يتم تسجيل أي حركات مالية على هذا الحساب بعد.</p>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection