@extends('layouts.app')

@section('title', 'دفتر الأستاذ - ' . $account->name)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Account Ledger Header -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-book"></i> دفتر الأستاذ - {{ $account->name }}
                    </h5>
                    <div>
                        <a href="{{ route('accounting.accounts.show', $account) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> تفاصيل الحساب
                        </a>
                        <a href="{{ route('accounting.accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">كود الحساب:</th>
                                    <td><span class="badge bg-primary fs-6">{{ $account->code }}</span></td>
                                </tr>
                                <tr>
                                    <th>اسم الحساب:</th>
                                    <td><strong>{{ $account->name }}</strong></td>
                                </tr>
                                <tr>
                                    <th>نوع الحساب:</th>
                                    <td>
                                        @switch($account->type)
                                            @case('asset')
                                                <span class="badge bg-success">أصول</span>
                                                @break
                                            @case('liability')
                                                <span class="badge bg-danger">خصوم</span>
                                                @break
                                            @case('equity')
                                                <span class="badge bg-info">حقوق ملكية</span>
                                                @break
                                            @case('revenue')
                                                <span class="badge bg-primary">إيرادات</span>
                                                @break
                                            @case('expense')
                                                <span class="badge bg-warning">مصروفات</span>
                                                @break
                                        @endswitch
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">فترة التقرير:</th>
                                    <td>من {{ $startDate }} إلى {{ $endDate }}</td>
                                </tr>
                                <tr>
                                    <th>الرصيد الافتتاحي:</th>
                                    <td class="{{ $openingBalance >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($openingBalance, 2) }} ريال
                                    </td>
                                </tr>
                                <tr>
                                    <th>عدد الحركات:</th>
                                    <td>{{ $transactions->count() }} حركة</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date Filter -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-filter"></i> تصفية حسب التاريخ
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('accounting.accounts.ledger', $account) }}">
                        <div class="row">
                            <div class="col-md-4">
                                <label for="start_date" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}">
                            </div>
                            <div class="col-md-4">
                                <label for="end_date" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}">
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary me-2">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                <button type="button" class="btn btn-outline-secondary" onclick="printLedger()">
                                    <i class="fas fa-print"></i> طباعة
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Ledger Transactions -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-list"></i> حركات الحساب
                    </h6>
                </div>
                <div class="card-body">
                    @if($transactions->count() > 0)
                        <div class="table-responsive" id="ledger-table">
                            <table class="table table-striped table-hover">
                                    <tr>
                                        <th>التاريخ</th>
                                        <th>رقم القيد</th>
                                        <th>البيان</th>
                                        <th class="text-center">مدين</th>
                                        <th class="text-center">دائن</th>
                                        <th class="text-center">الرصيد</th>
                                        <th class="text-center">الإجراءات</th>
                                    </tr>
                                    <!-- Opening Balance Row -->
                                    <tr class="table-info">
                                        <td>{{ $startDate }}</td>
                                        <td>-</td>
                                        <td><strong>الرصيد الافتتاحي</strong></td>
                                        <td class="text-center">-</td>
                                        <td class="text-center">-</td>
                                        <td class="text-center {{ $openingBalance >= 0 ? 'text-success' : 'text-danger' }}">
                                            <strong>{{ number_format($openingBalance, 2) }}</strong>
                                        </td>
                                        <td class="text-center">-</td>
                                    </tr>

                                    @php 
                                        $runningBalance = $openingBalance;
                                        $totalDebit = 0;
                                        $totalCredit = 0;
                                    @endphp

                                    @foreach($transactions as $transaction)
                                        @php 
                                            $runningBalance += ($transaction->debit_amount - $transaction->credit_amount);
                                            $totalDebit += $transaction->debit_amount;
                                            $totalCredit += $transaction->credit_amount;
                                        @endphp
                                        <tr>
                                            <td>{{ $transaction->journalEntry->entry_date->format('Y-m-d') }}</td>
                                            <td>
                                                <a href="{{ route('accounting.journal-entries.show', $transaction->journalEntry) }}" class="text-decoration-none">
                                                    {{ $transaction->journalEntry->entry_number }}
                                                </a>
                                            </td>
                                            <td>{{ $transaction->description ?: $transaction->journalEntry->description }}</td>
                                            <td class="text-center text-success">
                                                {{ $transaction->debit_amount > 0 ? number_format($transaction->debit_amount, 2) : '-' }}
                                            </td>
                                            <td class="text-center text-danger">
                                                {{ $transaction->credit_amount > 0 ? number_format($transaction->credit_amount, 2) : '-' }}
                                            </td>
                                            <td class="text-center {{ $runningBalance >= 0 ? 'text-success' : 'text-danger' }}">
                                                <strong>{{ number_format($runningBalance, 2) }}</strong>
                                            </td>
                                            <td class="text-center">
                                                <a href="{{ route('accounting.journal-entries.show', $transaction->journalEntry) }}" 
                                                   class="btn btn-sm btn-outline-primary" title="عرض القيد">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach

                                    <!-- Totals Row -->
                                    <tr class="table-secondary">
                                        <td colspan="3"><strong>الإجماليات</strong></td>
                                        <td class="text-center text-success">
                                            <strong>{{ number_format($totalDebit, 2) }}</strong>
                                        </td>
                                        <td class="text-center text-danger">
                                            <strong>{{ number_format($totalCredit, 2) }}</strong>
                                        </td>
                                        <td class="text-center {{ $runningBalance >= 0 ? 'text-success' : 'text-danger' }}">
                                            <strong>{{ number_format($runningBalance, 2) }}</strong>
                                        </td>
                                        <td class="text-center">-</td>
                                    </tr>
                            </table>
                        </div>

                        <!-- Summary Card -->
                        <div class="row mt-4">
                            <div class="col-md-3">
                                <div class="card bg-light">
                                    <div class="card-body text-center">
                                        <h6 class="card-title">الرصيد الافتتاحي</h6>
                                        <h4 class="{{ $openingBalance >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($openingBalance, 2) }}
                                        </h4>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-light">
                                    <div class="card-body text-center">
                                        <h6 class="card-title">إجمالي المدين</h6>
                                        <h4 class="text-success">{{ number_format($totalDebit, 2) }}</h4>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-light">
                                    <div class="card-body text-center">
                                        <h6 class="card-title">إجمالي الدائن</h6>
                                        <h4 class="text-danger">{{ number_format($totalCredit, 2) }}</h4>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-primary text-white">
                                    <div class="card-body text-center">
                                        <h6 class="card-title">الرصيد الختامي</h6>
                                        <h4>{{ number_format($runningBalance, 2) }}</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-info-circle fa-3x text-muted mb-3"></i>
                            <h5>لا توجد حركات مالية</h5>
                            <p class="text-muted">لم يتم العثور على حركات مالية في الفترة المحددة.</p>
                            <a href="{{ route('accounting.journal-entries.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> إضافة قيد جديد
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function printLedger() {
    const printContent = document.getElementById('ledger-table').outerHTML;
    const accountInfo = `
        <div style="text-align: center; margin-bottom: 20px;">
            <h2>دفتر الأستاذ</h2>
            <h3>${{ $account->code }} - {{ $account->name }}</h3>
            <p>من {{ $startDate }} إلى {{ $endDate }}</p>
        </div>
    `;
    
    const printWindow = window.open('', '_blank');
    printWindow.document.write(`
        <html>
            <head>
                <title>دفتر الأستاذ - {{ $account->name }}</title>
                <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
                <style>
                    body { font-family: Arial, sans-serif; direction: rtl; }
                    .table { font-size: 12px; }
                    @media print {
                        .btn { display: none; }
                        .table { font-size: 10px; }
                    }
                </style>
            </head>
            <body>
                ${accountInfo}
                ${printContent}
            </body>
        </html>
    `);
    printWindow.document.close();
    printWindow.print();
}
</script>
@endsection