@extends('layouts.app')

@section('title', 'دليل الحسابات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-list-alt"></i>
                        دليل الحسابات
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.accounts.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> حساب جديد
                        </a>
                        <a href="{{ route('accounting.accounts.tree') }}" class="btn btn-info">
                            <i class="fas fa-sitemap"></i> شجرة الحسابات
                        </a>
                        <div class="btn-group">
                            <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                <i class="fas fa-download"></i> تصدير
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="{{ route('accounting.accounts.export') }}">
                                    <i class="fas fa-file-excel"></i> تصدير Excel
                                </a>
                            </div>
                        </div>
                        <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#importModal">
                            <i class="fas fa-upload"></i> استيراد
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <input type="text" name="search" class="form-control" 
                                       placeholder="البحث برمز أو اسم الحساب..." 
                                       value="{{ request('search') }}">
                            </div>
                            <div class="col-md-2">
                                <select name="type" class="form-control">
                                    <option value="">كل الأنواع</option>
                                    <option value="asset" {{ request('type') == 'asset' ? 'selected' : '' }}>أصول</option>
                                    <option value="liability" {{ request('type') == 'liability' ? 'selected' : '' }}>خصوم</option>
                                    <option value="equity" {{ request('type') == 'equity' ? 'selected' : '' }}>حقوق ملكية</option>
                                    <option value="revenue" {{ request('type') == 'revenue' ? 'selected' : '' }}>إيرادات</option>
                                    <option value="expense" {{ request('type') == 'expense' ? 'selected' : '' }}>مصروفات</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="parent_id" class="form-control">
                                    <option value="">كل الحسابات الرئيسية</option>
                                    @foreach($parentAccounts as $parent)
                                        <option value="{{ $parent->id }}" {{ request('parent_id') == $parent->id ? 'selected' : '' }}>
                                            {{ $parent->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ route('accounting.accounts.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-refresh"></i> إعادة تعيين
                                </a>
                            </div>
                        </div>
                    </form>

                    <!-- جدول الحسابات -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                                <tr>
                                    <th>رمز الحساب</th>
                                    <th>اسم الحساب</th>
                                    <th>النوع</th>
                                    <th>الحساب الأب</th>
                                    <th>المستوى</th>
                                    <th>الطبيعة</th>
                                    <th>الرصيد الحالي</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                                @forelse($accounts as $account)
                                <tr>
                                    <td>
                                        <strong>{{ $account->code }}</strong>
                                    </td>
                                    <td>
                                        <a href="{{ route('accounting.accounts.show', $account) }}" class="text-decoration-none">
                                            {{ $account->name }}
                                        </a>
                                        @if($account->is_cash_account)
                                            <span class="badge bg-success ms-1">نقدي</span>
                                        @endif
                                        @if($account->is_bank_account)
                                            <span class="badge bg-info ms-1">بنكي</span>
                                        @endif
                                        @if($account->is_control_account)
                                            <span class="badge bg-warning ms-1">تحكم</span>
                                        @endif
                                    </td>
                                    <td>
                                        @switch($account->type)
                                            @case('asset')
                                                <span class="badge bg-primary">أصول</span>
                                                @break
                                            @case('liability')
                                                <span class="badge bg-danger">خصوم</span>
                                                @break
                                            @case('equity')
                                                <span class="badge bg-secondary">حقوق ملكية</span>
                                                @break
                                            @case('revenue')
                                                <span class="badge bg-success">إيرادات</span>
                                                @break
                                            @case('expense')
                                                <span class="badge bg-warning">مصروفات</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>{{ $account->parent ? $account->parent->name : '-' }}</td>
                                    <td>{{ $account->level }}</td>
                                    <td>
                                        <span class="badge {{ $account->debit_credit == 'debit' ? 'bg-info' : 'bg-success' }}">
                                            {{ $account->debit_credit == 'debit' ? 'مدين' : 'دائن' }}
                                        </span>
                                    </td>
                                    <td class="text-end">
                                        <strong>{{ number_format($account->current_balance, 2) }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge {{ $account->is_active ? 'bg-success' : 'bg-danger' }}">
                                            {{ $account->is_active ? 'نشط' : 'غير نشط' }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('accounting.accounts.show', $account) }}" class="btn btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('accounting.accounts.ledger', $account) }}" class="btn btn-secondary">
                                                <i class="fas fa-book"></i>
                                            </a>
                                            <a href="{{ route('accounting.accounts.edit', $account) }}" class="btn btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#deleteModal"
                                                    data-account-id="{{ $account->id }}"
                                                    data-account-name="{{ $account->name }}"
                                                    data-account-code="{{ $account->code }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد حسابات</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    {{ $accounts->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal استيراد -->
<div class="modal fade" id="importModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('accounting.accounts.import') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">استيراد الحسابات من Excel</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="file" class="form-label">ملف Excel</label>
                        <input type="file" class="form-control" id="file" name="file" accept=".xlsx,.xls" required>
                        <div class="form-text">يجب أن يكون الملف بصيغة Excel (.xlsx أو .xls)</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">استيراد</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal تأكيد الحذف -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteModalLabel">
                    <i class="fas fa-exclamation-triangle"></i>
                    تأكيد حذف الحساب
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>تحذير:</strong> هذا الإجراء لا يمكن التراجع عنه!
                </div>
                <p class="mb-3">هل أنت متأكد من حذف هذا الحساب؟</p>
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">تفاصيل الحساب:</h6>
                        <p class="mb-1"><strong>رمز الحساب:</strong> <span id="accountCode"></span></p>
                        <p class="mb-0"><strong>اسم الحساب:</strong> <span id="accountName"></span></p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times"></i>
                    إلغاء
                </button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i>
                        تأكيد الحذف
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const deleteModal = document.getElementById('deleteModal');
    const deleteForm = document.getElementById('deleteForm');
    const accountCode = document.getElementById('accountCode');
    const accountName = document.getElementById('accountName');

    deleteModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const accountId = button.getAttribute('data-account-id');
        const accountNameValue = button.getAttribute('data-account-name');
        const accountCodeValue = button.getAttribute('data-account-code');

        // تحديث النموذج
        deleteForm.action = `{{ url('accounting/accounts') }}/${accountId}`;
        
        // تحديث محتوى المودال
        accountCode.textContent = accountCodeValue;
        accountName.textContent = accountNameValue;
    });
});
</script>

@endsection