@extends('layouts.app')

@section('title', 'إضافة حساب جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-plus-circle"></i>
                        إضافة حساب جديد
                    </h3>
                    <div class="btn-group">
                        <a href="{{ route('accounting.accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        <a href="{{ route('accounting.accounts.tree') }}" class="btn btn-info">
                            <i class="fas fa-sitemap"></i> شجرة الحسابات
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route('accounting.accounts.store') }}">
                        @csrf
                        
                        <div class="row">
                            <!-- رمز الحساب -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="code" class="form-label">رمز الحساب <span class="text-danger">*</span></label>
                                    <input type="text" name="code" id="code" 
                                           class="form-control @error('code') is-invalid @enderror"
                                           value="{{ old('code') }}" required 
                                           placeholder="مثال: 1101">
                                    @error('code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">رمز فريد للحساب (أرقام فقط)</div>
                                </div>
                            </div>

                            <!-- اسم الحساب -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">اسم الحساب <span class="text-danger">*</span></label>
                                    <input type="text" name="name" id="name"
                                           class="form-control searchable-input @error('name') is-invalid @enderror"
                                           value="{{ old('name') }}" required
                                           placeholder="مثال: النقدية في الصندوق"
                                           list="account-names-list"
                                           autocomplete="off">
                                    <datalist id="account-names-list">
                                        @if(isset($existingAccounts))
                                            @foreach($existingAccounts as $account)
                                                <option value="{{ $account->name }}">{{ $account->code }} - {{ $account->name }}</option>
                                            @endforeach
                                        @endif
                                    </datalist>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">ابدأ بالكتابة للبحث في أسماء الحسابات الموجودة</div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- نوع الحساب -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">نوع الحساب <span class="text-danger">*</span></label>
                                    <select name="type" id="type" class="form-select @error('type') is-invalid @enderror" required>
                                        <option value="">اختر نوع الحساب</option>
                                        <option value="asset" {{ old('type') == 'asset' ? 'selected' : '' }}>
                                            الأصول (Assets)
                                        </option>
                                        <option value="liability" {{ old('type') == 'liability' ? 'selected' : '' }}>
                                            الخصوم (Liabilities)
                                        </option>
                                        <option value="equity" {{ old('type') == 'equity' ? 'selected' : '' }}>
                                            حقوق الملكية (Equity)
                                        </option>
                                        <option value="revenue" {{ old('type') == 'revenue' ? 'selected' : '' }}>
                                            الإيرادات (Revenue)
                                        </option>
                                        <option value="expense" {{ old('type') == 'expense' ? 'selected' : '' }}>
                                            المصروفات (Expenses)
                                        </option>
                                    </select>
                                    @error('type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- الحساب الأب -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="parent_id" class="form-label">الحساب الأب</label>
                                    <select name="parent_id" id="parent_id" class="form-select @error('parent_id') is-invalid @enderror" style="width: 100%;">
                                        <option value="">حساب رئيسي (بدون حساب أب)</option>
                                        @foreach($parentAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('parent_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->code }} - {{ $account->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('parent_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- مركز التكلفة -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="cost_center_id" class="form-label">مركز التكلفة</label>
                                    <select name="cost_center_id" id="cost_center_id"
                                            class="form-select searchable-select @error('cost_center_id') is-invalid @enderror"
                                            style="width: 100%;">
                                        <option value="">بدون مركز تكلفة</option>
                                        @if(isset($costCenters))
                                            @foreach($costCenters as $costCenter)
                                                <option value="{{ $costCenter->id }}" {{ old('cost_center_id') == $costCenter->id ? 'selected' : '' }}>
                                                    {{ $costCenter->code }} - {{ $costCenter->name }}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select>
                                    @error('cost_center_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">اختر مركز التكلفة المرتبط بهذا الحساب (اختياري)</div>
                                </div>
                            </div>

                            <!-- رقم المرجع -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="reference_number" class="form-label">رقم المرجع</label>
                                    <input type="text" name="reference_number" id="reference_number"
                                           class="form-control @error('reference_number') is-invalid @enderror"
                                           value="{{ old('reference_number') }}"
                                           placeholder="رقم مرجعي للحساب">
                                    @error('reference_number')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">رقم مرجعي اختياري للحساب</div>
                                </div>
                            </div>
                        </div>

                        <!-- الوصف -->
                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف</label>
                            <textarea name="description" id="description" rows="3" 
                                      class="form-control @error('description') is-invalid @enderror"
                                      placeholder="وصف مفصل للحساب (اختيارية)">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- الإعدادات المتقدمة -->
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-cogs"></i>
                                    الإعدادات المتقدمة
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="is_active" id="is_active" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('is_active', '1') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_active">
                                                حساب نشط
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="is_cash_account" id="is_cash_account" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('is_cash_account') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_cash_account">
                                                حساب نقدي
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="is_bank_account" id="is_bank_account" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('is_bank_account') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_bank_account">
                                                حساب بنكي
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="is_control_account" id="is_control_account" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('is_control_account') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_control_account">
                                                حساب تحكم (Control Account)
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="requires_cost_center" id="requires_cost_center" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('requires_cost_center') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="requires_cost_center">
                                                يتطلب مركز تكلفة
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input type="checkbox" name="allow_manual_entries" id="allow_manual_entries" 
                                                   class="form-check-input" value="1" 
                                                   {{ old('allow_manual_entries', '1') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="allow_manual_entries">
                                                السماح بالقيود اليدوية
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <!-- الرصيد الافتتاحي -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="opening_balance" class="form-label">الرصيد الافتتاحي</label>
                                            <div class="input-group">
                                                <input type="number" name="opening_balance" id="opening_balance" 
                                                       step="0.01" class="form-control @error('opening_balance') is-invalid @enderror"
                                                       value="{{ old('opening_balance', '0') }}">
                                                <span class="input-group-text">ريال</span>
                                            </div>
                                            @error('opening_balance')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="opening_balance_type" class="form-label">نوع الرصيد الافتتاحي</label>
                                            <select name="opening_balance_type" id="opening_balance_type" class="form-select">
                                                <option value="debit" {{ old('opening_balance_type', 'debit') == 'debit' ? 'selected' : '' }}>
                                                    مدين (Debit)
                                                </option>
                                                <option value="credit" {{ old('opening_balance_type') == 'credit' ? 'selected' : '' }}>
                                                    دائن (Credit)
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                           </div>
                       </div>

                       <!-- إعدادات الضريبة -->
                       <div class="card mt-4">
                           <div class="card-header">
                               <h5 class="card-title mb-0">
                                   <i class="fas fa-percentage"></i>
                                   إعدادات الضريبة
                               </h5>
                           </div>
                           <div class="card-body">
                               <div class="row">
                                   <div class="col-md-6">
                                       <div class="form-check mb-3">
                                           <input type="checkbox" name="applies_tax" id="applies_tax"
                                                  class="form-check-input" value="1"
                                                  {{ old('applies_tax', '1') ? 'checked' : '' }}>
                                           <label class="form-check-label" for="applies_tax">
                                               تطبيق الضريبة على هذا الحساب
                                           </label>
                                       </div>
                                       
                                       <div class="mb-3" id="tax_settings_section">
                                           <label for="tax_calculation_method" class="form-label">طريقة حساب الضريبة</label>
                                           <select name="tax_calculation_method" id="tax_calculation_method"
                                                   class="form-select @error('tax_calculation_method') is-invalid @enderror">
                                               <option value="exclusive" {{ old('tax_calculation_method', 'exclusive') == 'exclusive' ? 'selected' : '' }}>
                                                   غير شامل الضريبة (Exclusive)
                                               </option>
                                               <option value="inclusive" {{ old('tax_calculation_method') == 'inclusive' ? 'selected' : '' }}>
                                                   شامل الضريبة (Inclusive)
                                               </option>
                                           </select>
                                           @error('tax_calculation_method')
                                               <div class="invalid-feedback">{{ $message }}</div>
                                           @enderror
                                           <div class="form-text">
                                               <strong>غير شامل الضريبة:</strong> يتم إضافة الضريبة إلى المبلغ الأساسي<br>
                                               <strong>شامل الضريبة:</strong> المبلغ المدخل يتضمن الضريبة بالفعل
                                           </div>
                                       </div>
                                   </div>
                                   
                                   <div class="col-md-6">
                                       <div class="mb-3" id="default_tax_rate_section">
                                           <label for="default_tax_rate" class="form-label">معدل الضريبة الافتراضي (%)</label>
                                           <div class="input-group">
                                               <input type="number" name="default_tax_rate" id="default_tax_rate"
                                                      step="0.01" min="0" max="100"
                                                      class="form-control @error('default_tax_rate') is-invalid @enderror"
                                                      value="{{ old('default_tax_rate', '15') }}">
                                               <span class="input-group-text">%</span>
                                           </div>
                                           @error('default_tax_rate')
                                               <div class="invalid-feedback">{{ $message }}</div>
                                           @enderror
                                           <div class="form-text">معدل الضريبة الافتراضي المطبق على هذا الحساب (15% للقيمة المضافة في السعودية)</div>
                                       </div>
                                       
                                       <!-- أمثلة توضيحية -->
                                       <div class="alert alert-info" id="tax_examples">
                                           <h6 class="alert-heading"><i class="fas fa-info-circle"></i> مثال توضيحي:</h6>
                                           <div id="tax_example_content">
                                               <p class="mb-1"><strong>مبلغ 100 ر.س مع ضريبة 15%:</strong></p>
                                               <ul class="mb-0 small">
                                                   <li id="exclusive_example">غير شامل: 100 + 15 = 115 ر.س</li>
                                                   <li id="inclusive_example" style="display: none;">شامل: 86.96 + 13.04 = 100 ر.س</li>
                                               </ul>
                                           </div>
                                       </div>
                                   </div>
                               </div>
                           </div>
                       </div>

                       <!-- أزرار الحفظ -->
                        <div class="d-flex justify-content-between mt-4">
                            <div>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ الحساب
                                </button>
                                <button type="submit" name="save_and_new" value="1" class="btn btn-success">
                                    <i class="fas fa-plus"></i> حفظ وإضافة جديد
                                </button>
                            </div>
                            <a href="{{ route('accounting.accounts.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type');
    const openingBalanceTypeSelect = document.getElementById('opening_balance_type');
    const isCashAccount = document.getElementById('is_cash_account');
    const isBankAccount = document.getElementById('is_bank_account');
    const codeInput = document.getElementById('code');

    // Initialize Select2 for parent account field
    $('#parent_id').select2({
        theme: 'bootstrap-5',
        placeholder: 'ابحث عن الحساب الأب...',
        allowClear: true,
        language: {
            noResults: function() {
                return "لا توجد نتائج";
            },
            searching: function() {
                return "جاري البحث...";
            },
            inputTooShort: function(args) {
                return "أدخل " + (args.minimum - args.input.length) + " أحرف أو أكثر";
            }
        },
        escapeMarkup: function(markup) {
            return markup;
        }
    });

    // Initialize Select2 for cost center field
    $('#cost_center_id').select2({
        theme: 'bootstrap-5',
        placeholder: 'ابحث عن مركز التكلفة...',
        allowClear: true,
        language: {
            noResults: function() {
                return "لا توجد نتائج";
            },
            searching: function() {
                return "جاري البحث...";
            },
            inputTooShort: function(args) {
                return "أدخل " + (args.minimum - args.input.length) + " أحرف أو أكثر";
            }
        },
        escapeMarkup: function(markup) {
            return markup;
        }
    });

    // Enhanced search functionality for account name field
    const nameInput = document.getElementById('name');
    const accountNamesList = document.getElementById('account-names-list');
    
    nameInput.addEventListener('input', function() {
        const query = this.value.toLowerCase();
        if (query.length >= 2) {
            // Filter datalist options based on input
            const options = accountNamesList.querySelectorAll('option');
            options.forEach(option => {
                const text = option.textContent.toLowerCase();
                option.style.display = text.includes(query) ? 'block' : 'none';
            });
        }
    });

    // Add autocomplete styling and behavior
    nameInput.addEventListener('focus', function() {
        this.setAttribute('placeholder', 'ابدأ بالكتابة للبحث في أسماء الحسابات...');
    });

    nameInput.addEventListener('blur', function() {
        this.setAttribute('placeholder', 'مثال: النقدية في الصندوق');
    });

    // تحديث نوع الرصيد الافتتاحي بناءً على نوع الحساب
    typeSelect.addEventListener('change', function() {
        const accountType = this.value;
        
        // تحديد نوع الرصيد الافتتاحي المناسب
        if (accountType === 'asset' || accountType === 'expense') {
            openingBalanceTypeSelect.value = 'debit';
        } else if (accountType === 'liability' || accountType === 'equity' || accountType === 'revenue') {
            openingBalanceTypeSelect.value = 'credit';
        }

        // إخفاء/إظهار خيارات الحساب النقدي والبنكي بناءً على نوع الحساب
        const cashBankSection = document.querySelector('.cash-bank-options');
        if (accountType === 'asset') {
            if (cashBankSection) cashBankSection.style.display = 'block';
        } else {
            if (cashBankSection) cashBankSection.style.display = 'none';
            isCashAccount.checked = false;
            isBankAccount.checked = false;
        }
    });

    // منع اختيار نقدي وبنكي في نفس الوقت
    isCashAccount.addEventListener('change', function() {
        if (this.checked) {
            isBankAccount.checked = false;
        }
    });

    isBankAccount.addEventListener('change', function() {
        if (this.checked) {
            isCashAccount.checked = false;
        }
    });

    // تنسيق رمز الحساب (أرقام فقط)
    codeInput.addEventListener('input', function() {
        this.value = this.value.replace(/[^\d]/g, '');
    });

    // التحقق من صحة النموذج
    const form = document.querySelector('form');
    form.addEventListener('submit', function(e) {
        const code = codeInput.value;
        const name = document.getElementById('name').value;
        const type = typeSelect.value;

        if (!code || !name || !type) {
            e.preventDefault();
            showValidationModal('حقول مطلوبة', 'يرجى ملء جميع الحقول المطلوبة', 'warning');
            return;
        }

        if (code.length < 3) {
            e.preventDefault();
            showValidationModal('رمز غير صحيح', 'رمز الحساب يجب أن يكون على الأقل 3 أرقام', 'danger');
            return;
        }
    });

    // إدارة إعدادات الضريبة
    const appliesTaxCheckbox = document.getElementById('applies_tax');
    const taxSettingsSection = document.getElementById('tax_settings_section');
    const defaultTaxRateSection = document.getElementById('default_tax_rate_section');
    const taxExamples = document.getElementById('tax_examples');
    const taxCalculationMethod = document.getElementById('tax_calculation_method');
    const defaultTaxRate = document.getElementById('default_tax_rate');

    // إظهار/إخفاء إعدادات الضريبة
    appliesTaxCheckbox.addEventListener('change', function() {
        if (this.checked) {
            taxSettingsSection.style.display = 'block';
            defaultTaxRateSection.style.display = 'block';
            taxExamples.style.display = 'block';
            taxCalculationMethod.required = true;
        } else {
            taxSettingsSection.style.display = 'none';
            defaultTaxRateSection.style.display = 'none';
            taxExamples.style.display = 'none';
            taxCalculationMethod.required = false;
        }
    });

    // تحديث المثال التوضيحي
    function updateTaxExample() {
        const method = taxCalculationMethod.value;
        const rate = parseFloat(defaultTaxRate.value) || 15;
        const exclusiveExample = document.getElementById('exclusive_example');
        const inclusiveExample = document.getElementById('inclusive_example');
        
        if (method === 'exclusive') {
            const taxAmount = (100 * rate) / 100;
            const total = 100 + taxAmount;
            exclusiveExample.innerHTML = `غير شامل: 100 + ${taxAmount.toFixed(2)} = ${total.toFixed(2)} ر.س`;
            exclusiveExample.style.display = 'list-item';
            inclusiveExample.style.display = 'none';
        } else {
            const exclusiveAmount = 100 / (1 + (rate / 100));
            const taxAmount = 100 - exclusiveAmount;
            inclusiveExample.innerHTML = `شامل: ${exclusiveAmount.toFixed(2)} + ${taxAmount.toFixed(2)} = 100 ر.س`;
            inclusiveExample.style.display = 'list-item';
            exclusiveExample.style.display = 'none';
        }
    }

    // تحديث المثال عند تغيير الطريقة أو المعدل
    taxCalculationMethod.addEventListener('change', updateTaxExample);
    defaultTaxRate.addEventListener('input', updateTaxExample);

    // تهيئة أولية للضريبة
    appliesTaxCheckbox.dispatchEvent(new Event('change'));
    updateTaxExample();
});

// دالة عرض رسائل التحقق في modal
function showValidationModal(title, message, type = 'warning') {
    const iconClass = type === 'danger' ? 'fas fa-exclamation-triangle' :
                     type === 'warning' ? 'fas fa-exclamation-circle' :
                     'fas fa-info-circle';
    
    const modalHtml = `
        <div class="modal fade" id="validationModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header bg-${type} text-white">
                        <h5 class="modal-title">
                            <i class="${iconClass}"></i>
                            ${title}
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-${type} border-0">
                            <i class="${iconClass} me-2"></i>
                            ${message}
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-check"></i>
                            فهمت
                        </button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // إزالة modal سابق إن وجد
    const existingModal = document.getElementById('validationModal');
    if (existingModal) {
        existingModal.remove();
    }
    
    // إضافة modal جديد
    document.body.insertAdjacentHTML('beforeend', modalHtml);
    
    // عرض modal
    const modal = new bootstrap.Modal(document.getElementById('validationModal'));
    modal.show();
    
    // إزالة modal بعد إغلاقه
    document.getElementById('validationModal').addEventListener('hidden.bs.modal', function() {
        this.remove();
    });
}
</script>
@endsection

@section('styles')
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<style>
.form-label {
    font-weight: 600;
    color: #495057;
}

.form-control:focus,
.form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.form-check-input:checked {
    background-color: #0d6efd;
    border-color: #0d6efd;
}

.card {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

.btn {
    font-weight: 500;
}

.form-text {
    font-size: 0.875em;
    color: #6c757d;
}

.input-group-text {
    background-color: #f8f9fa;
    border-color: #ced4da;
}

.invalid-feedback {
    display: block;
}

.searchable-input {
    position: relative;
}

.searchable-input:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.searchable-select {
    min-height: 38px;
}

/* Select2 custom styling */
.select2-container--bootstrap-5 .select2-selection {
    min-height: 38px;
    border: 1px solid #ced4da;
}

.select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
    padding-left: 12px;
    padding-right: 20px;
    color: #495057;
    line-height: 36px;
}

.select2-container--bootstrap-5 .select2-selection--single .select2-selection__arrow {
    height: 36px;
    right: 3px;
}

.select2-container--bootstrap-5.select2-container--focus .select2-selection {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.select2-dropdown {
    border: 1px solid #ced4da;
    border-radius: 0.375rem;
}

.select2-search--dropdown .select2-search__field {
    border: 1px solid #ced4da;
    border-radius: 0.25rem;
    padding: 6px 12px;
}

.select2-results__option {
    padding: 8px 12px;
}

.select2-results__option--highlighted {
    background-color: #0d6efd;
    color: white;
}

/* Datalist styling */
datalist {
    position: absolute;
    background-color: white;
    border: 1px solid #ced4da;
    border-radius: 0.375rem;
    max-height: 200px;
    overflow-y: auto;
    z-index: 1000;
}
</style>
@endsection