<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ZatcaSettings;
use App\Models\Company;

class ZatcaSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $companies = Company::all();

        foreach ($companies as $company) {
            ZatcaSettings::firstOrCreate(
                ['company_id' => $company->id],
                [
                    // نوع الربط والبيئة
                    'connection_type' => 'clearance',
                    'environment' => 'sandbox',
                    
                    // بيانات جهاز التوقيع الإلكتروني (CSID) - تجريبية
                    'certificate' => '-----BEGIN CERTIFICATE-----
MIIDdTCCAl2gAwIBAgIUGjTq9+TestCertificateDataForZATCADemo123
ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789
TestCertificateContentForDemoAndDevelopmentOnlyNotForProduction
DQYJKoZIhvcNAQELBQAwSjELMAkGA1UEBhMCU0ExEzARBgNVBAgMClJpeWFkaCBD
-----END CERTIFICATE-----',
                    
                    'private_key' => '-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTestPrivateKey
ForZATCADemoAndDevelopmentOnlyNotForProductionUse123456789ABCDEF
TestPrivateKeyContentForDemoAndDevelopmentOnlyNotForProduction
-----END PRIVATE KEY-----',
                    
                    'public_key' => '-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQTestPublicKeyForZATCADemo12345
ABCDEFGHIJKLMNOPQRSTUVWXYZTestPublicKeyContentForDemo
TestPublicKeyContentForDemoAndDevelopmentOnlyNotForProduction
-----END PUBLIC KEY-----',
                    
                    'certificate_serial' => '1-' . $company->vat_number . '|2-TST-886431145|3-ed22f1d8-e6a2-1118-9b58-d9a8f11e445f',
                    'certificate_expires_at' => now()->addYears(2),
                    
                    // بيانات الاتصال - تجريبية
                    'client_id' => 'ZATCA_DEMO_CLIENT_' . $company->id,
                    'client_secret' => base64_encode('demo_secret_for_company_' . $company->id . '_zatca_testing'),
                    'username' => 'demo_user_' . $company->id,
                    'password' => base64_encode('demo_password_' . $company->id),
                    'access_token' => base64_encode('demo_access_token_' . $company->id . '_' . time()),
                    'token_expires_at' => now()->addHours(24),
                    
                    // إعدادات الفواتير
                    'invoice_counter' => 1,
                    'previous_invoice_hash' => 'NWZlY2ViNjZmZmM4NmYzOGQ5NTI3ODZjNmQ2OTZjNzljMmRiYzIzOWRkNGU5MWI0',
                    
                    // حالة الاتصال
                    'is_active' => true,
                    'last_connection_test' => now(),
                    'connection_status' => 'connected',
                    'last_error' => null,
                    
                    // سجل العمليات
                    'operation_log' => json_encode([
                        [
                            'timestamp' => now()->toISOString(),
                            'operation' => 'initialization',
                            'status' => 'success',
                            'message' => 'ZATCA settings initialized for demo/testing',
                            'environment' => 'sandbox'
                        ],
                        [
                            'timestamp' => now()->subMinutes(5)->toISOString(),
                            'operation' => 'certificate_validation',
                            'status' => 'success',
                            'message' => 'Demo certificate validated successfully',
                            'environment' => 'sandbox'
                        ]
                    ]),
                ]
            );
        }
    }
}
