<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // مدير النظام الرئيسي
        User::firstOrCreate(
            ['email' => 'admin@company.com'],
            [
                'name' => 'أحمد محمد الإدارة',
                'password' => Hash::make('password123'),
                'phone' => '+966501234567',
                'role' => 'admin',
                'is_active' => true,
                'email_verified_at' => now(),
            ]
        );

        // محاسب
        User::firstOrCreate(
            ['email' => 'accountant@company.com'],
            [
                'name' => 'فاطمة أحمد المحاسبة',
                'password' => Hash::make('password123'),
                'phone' => '+966507654321',
                'role' => 'manager',
                'is_active' => true,
                'email_verified_at' => now(),
            ]
        );

        // موظف مبيعات
        User::firstOrCreate(
            ['email' => 'sales@company.com'],
            [
                'name' => 'محمد علي المبيعات',
                'password' => Hash::make('password123'),
                'phone' => '+966509876543',
                'role' => 'employee',
                'is_active' => true,
                'email_verified_at' => now(),
            ]
        );

        // موظف فواتير
        User::firstOrCreate(
            ['email' => 'invoicing@company.com'],
            [
                'name' => 'سارة حسن الفواتير',
                'password' => Hash::make('password123'),
                'phone' => '+966502468135',
                'role' => 'employee',
                'is_active' => true,
                'email_verified_at' => now(),
            ]
        );

        // مطور للاختبار
        User::firstOrCreate(
            ['email' => 'developer@test.com'],
            [
                'name' => 'Developer Test User',
                'password' => Hash::make('dev123456'),
                'phone' => '+966500000000',
                'role' => 'admin',
                'is_active' => true,
                'email_verified_at' => now(),
            ]
        );
    }
}
