<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Account;

class TaxAccountTypesSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        // إنشاء حسابات تجريبية بأنواع ضريبية مختلفة
        $accounts = [
            [
                'code' => '4100',
                'name' => 'مبيعات - غير شامل الضريبة',
                'name_en' => 'Sales - Tax Exclusive',
                'type' => 'revenue',
                'subtype' => 'sales',
                'debit_credit' => 'credit',
                'tax_calculation_method' => 'exclusive',
                'applies_tax' => true,
                'default_tax_rate' => 15.00,
                'is_active' => true,
                'description' => 'حساب المبيعات - يتم إضافة الضريبة إلى السعر المدخل'
            ],
            [
                'code' => '4101',
                'name' => 'مبيعات - شامل الضريبة',
                'name_en' => 'Sales - Tax Inclusive',
                'type' => 'revenue',
                'subtype' => 'sales',
                'debit_credit' => 'credit',
                'tax_calculation_method' => 'inclusive',
                'applies_tax' => true,
                'default_tax_rate' => 15.00,
                'is_active' => true,
                'description' => 'حساب المبيعات - السعر المدخل يتضمن الضريبة'
            ],
            [
                'code' => '4200',
                'name' => 'خدمات - غير شامل الضريبة',
                'name_en' => 'Services - Tax Exclusive',
                'type' => 'revenue',
                'subtype' => 'services',
                'debit_credit' => 'credit',
                'tax_calculation_method' => 'exclusive',
                'applies_tax' => true,
                'default_tax_rate' => 15.00,
                'is_active' => true,
                'description' => 'حساب الخدمات - يتم إضافة الضريبة إلى السعر المدخل'
            ],
            [
                'code' => '4201',
                'name' => 'خدمات - شامل الضريبة',
                'name_en' => 'Services - Tax Inclusive',
                'type' => 'revenue',
                'subtype' => 'services',
                'debit_credit' => 'credit',
                'tax_calculation_method' => 'inclusive',
                'applies_tax' => true,
                'default_tax_rate' => 15.00,
                'is_active' => true,
                'description' => 'حساب الخدمات - السعر المدخل يتضمن الضريبة'
            ],
            [
                'code' => '4300',
                'name' => 'مبيعات معفاة من الضريبة',
                'name_en' => 'Tax Exempt Sales',
                'type' => 'revenue',
                'subtype' => 'sales',
                'debit_credit' => 'credit',
                'tax_calculation_method' => 'exclusive',
                'applies_tax' => false,
                'default_tax_rate' => 0.00,
                'is_active' => true,
                'description' => 'حساب المبيعات المعفاة من الضريبة'
            ]
        ];

        foreach ($accounts as $accountData) {
            Account::firstOrCreate(
                ['code' => $accountData['code']],
                $accountData
            );
        }

        $this->command->info('تم إنشاء الحسابات التجريبية بأنواع ضريبية مختلفة بنجاح!');
    }
}