<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Supplier;

class SupplierSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $suppliers = [
            [
                'name' => 'شركة التقنيات المتقدمة',
                'name_en' => 'Advanced Technologies Company',
                'contact_person' => 'أحمد محمد',
                'email' => 'info@advtech.sa',
                'phone' => '+966501234567',
                'address' => 'الرياض، المملكة العربية السعودية',
                'tax_number' => '300012345600003',
                'commercial_registration' => '1010123456',
                'payment_terms' => 'نت 30 يوم',
                'credit_limit' => 100000.00,
                'is_active' => true,
            ],
            [
                'name' => 'مؤسسة الإمدادات الصناعية',
                'name_en' => 'Industrial Supplies Est.',
                'contact_person' => 'فاطمة أحمد',
                'email' => 'supplies@industrial.sa',
                'phone' => '+966502345678',
                'address' => 'جدة، المملكة العربية السعودية',
                'tax_number' => '300012345600004',
                'commercial_registration' => '4030123456',
                'payment_terms' => 'نت 15 يوم',
                'credit_limit' => 50000.00,
                'is_active' => true,
            ],
            [
                'name' => 'شركة المواد الخام المحدودة',
                'name_en' => 'Raw Materials Ltd.',
                'contact_person' => 'خالد العتيبي',
                'email' => 'raw@materials.sa',
                'phone' => '+966503456789',
                'address' => 'الدمام، المملكة العربية السعودية',
                'tax_number' => '300012345600005',
                'commercial_registration' => '2050123456',
                'payment_terms' => 'نقدي عند التسليم',
                'credit_limit' => 75000.00,
                'is_active' => true,
            ],
            [
                'name' => 'مؤسسة الأجهزة الإلكترونية',
                'name_en' => 'Electronics Devices Est.',
                'contact_person' => 'نورا السالم',
                'email' => 'electronics@devices.sa',
                'phone' => '+966504567890',
                'address' => 'الخبر، المملكة العربية السعودية',
                'tax_number' => '300012345600006',
                'commercial_registration' => '2051123456',
                'payment_terms' => 'نت 45 يوم',
                'credit_limit' => 120000.00,
                'is_active' => true,
            ],
            [
                'name' => 'شركة اللوازم المكتبية الحديثة',
                'name_en' => 'Modern Office Supplies Co.',
                'contact_person' => 'عبدالرحمن الشمري',
                'email' => 'office@supplies.sa',
                'phone' => '+966505678901',
                'address' => 'مكة المكرمة، المملكة العربية السعودية',
                'tax_number' => '300012345600007',
                'commercial_registration' => '5020123456',
                'payment_terms' => 'نت 30 يوم',
                'credit_limit' => 30000.00,
                'is_active' => true,
            ],
        ];

        foreach ($suppliers as $supplier) {
            Supplier::create($supplier);
        }
    }
}