<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;

class RestaurantProductsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تحقق من وجود منتجات المطعم
        if (Product::whereIn('category', ['meals', 'appetizers', 'beverages', 'desserts'])->exists()) {
            $this->command->info('منتجات المطعم موجودة بالفعل.');
            return;
        }

        $products = [
            // الوجبات الرئيسية
            [
                'name' => 'برجر كلاسيكي',
                'description' => 'برجر لحم بقري مشوي مع خس وطماطم وجبن شيدر',
                'sku' => 'MEAL001',
                'price' => 45.00,
                'price_with_tax' => 51.75,
                'cost_price' => 25.00,
                'stock_quantity' => 50,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'meals',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890001',
            ],
            [
                'name' => 'برجر دجاج مقرمش',
                'description' => 'قطعة دجاج مقرمشة مع صوص خاص وخضروات طازجة',
                'sku' => 'MEAL002',
                'price' => 42.00,
                'price_with_tax' => 48.30,
                'cost_price' => 23.00,
                'stock_quantity' => 40,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'meals',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890002',
            ],
            [
                'name' => 'شاورما لحم',
                'description' => 'شاورما لحم خروف مع الخضروات والصوص العربي',
                'sku' => 'MEAL003',
                'price' => 35.00,
                'price_with_tax' => 40.25,
                'cost_price' => 20.00,
                'stock_quantity' => 30,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'meals',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890003',
            ],
            [
                'name' => 'شاورما دجاج',
                'description' => 'شاورما دجاج مشوي مع الثوم والخضروات',
                'sku' => 'MEAL004',
                'price' => 32.00,
                'price_with_tax' => 36.80,
                'cost_price' => 18.00,
                'stock_quantity' => 35,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'meals',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890004',
            ],
            [
                'name' => 'دجاج مشوي',
                'description' => 'نصف دجاجة مشوية مع البهارات الخاصة',
                'sku' => 'MEAL005',
                'price' => 55.00,
                'price_with_tax' => 63.25,
                'cost_price' => 30.00,
                'stock_quantity' => 25,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'meals',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890005',
            ],
            [
                'name' => 'كباب مشكل',
                'description' => 'طبق من الكباب المشكل مع الأرز والسلطة',
                'sku' => 'MEAL006',
                'price' => 65.00,
                'price_with_tax' => 74.75,
                'cost_price' => 35.00,
                'stock_quantity' => 20,
                'unit' => 'طبق',
                'type' => 'product',
                'category' => 'meals',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890006',
            ],

            // المقبلات
            [
                'name' => 'سلطة فتوش',
                'description' => 'سلطة خضروات طازجة مع الخبز المحمص وصوص الليمون',
                'sku' => 'APP001',
                'price' => 18.00,
                'price_with_tax' => 20.70,
                'cost_price' => 8.00,
                'stock_quantity' => 100,
                'unit' => 'طبق',
                'type' => 'product',
                'category' => 'appetizers',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890101',
            ],
            [
                'name' => 'سلطة تبولة',
                'description' => 'سلطة بقدونس وطماطم وبرغل مع عصير الليمون',
                'sku' => 'APP002',
                'price' => 15.00,
                'price_with_tax' => 17.25,
                'cost_price' => 6.00,
                'stock_quantity' => 80,
                'unit' => 'طبق',
                'type' => 'product',
                'category' => 'appetizers',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890102',
            ],
            [
                'name' => 'حمص بالطحينة',
                'description' => 'حمص مسلوق مع الطحينة وزيت الزيتون',
                'sku' => 'APP003',
                'price' => 12.00,
                'price_with_tax' => 13.80,
                'cost_price' => 5.00,
                'stock_quantity' => 90,
                'unit' => 'طبق',
                'type' => 'product',
                'category' => 'appetizers',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890103',
            ],
            [
                'name' => 'متبل باذنجان',
                'description' => 'باذنجان مشوي مع الطحينة والثوم',
                'sku' => 'APP004',
                'price' => 14.00,
                'price_with_tax' => 16.10,
                'cost_price' => 6.00,
                'stock_quantity' => 70,
                'unit' => 'طبق',
                'type' => 'product',
                'category' => 'appetizers',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890104',
            ],
            [
                'name' => 'كبة مقلية',
                'description' => 'كبة محشوة باللحم والصنوبر',
                'sku' => 'APP005',
                'price' => 25.00,
                'price_with_tax' => 28.75,
                'cost_price' => 12.00,
                'stock_quantity' => 60,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'appetizers',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890105',
            ],
            [
                'name' => 'فطائر سبانخ',
                'description' => 'فطائر محشوة بالسبانخ والبصل',
                'sku' => 'APP006',
                'price' => 8.00,
                'price_with_tax' => 9.20,
                'cost_price' => 3.00,
                'stock_quantity' => 120,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'appetizers',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890106',
            ],

            // المشروبات
            [
                'name' => 'عصير برتقال طازج',
                'description' => 'عصير برتقال طبيعي طازج',
                'sku' => 'BEV001',
                'price' => 12.00,
                'price_with_tax' => 13.80,
                'cost_price' => 4.00,
                'stock_quantity' => 200,
                'unit' => 'كوب',
                'type' => 'product',
                'category' => 'beverages',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890201',
            ],
            [
                'name' => 'عصير ليمون بالنعناع',
                'description' => 'عصير ليمون منعش مع أوراق النعناع',
                'sku' => 'BEV002',
                'price' => 10.00,
                'price_with_tax' => 11.50,
                'cost_price' => 3.00,
                'stock_quantity' => 150,
                'unit' => 'كوب',
                'type' => 'product',
                'category' => 'beverages',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890202',
            ],
            [
                'name' => 'شاي أحمر',
                'description' => 'شاي أحمر تقليدي',
                'sku' => 'BEV003',
                'price' => 5.00,
                'price_with_tax' => 5.75,
                'cost_price' => 1.00,
                'stock_quantity' => 300,
                'unit' => 'كوب',
                'type' => 'product',
                'category' => 'beverages',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890203',
            ],
            [
                'name' => 'قهوة عربية',
                'description' => 'قهوة عربية أصيلة مع الهيل',
                'sku' => 'BEV004',
                'price' => 8.00,
                'price_with_tax' => 9.20,
                'cost_price' => 2.00,
                'stock_quantity' => 250,
                'unit' => 'كوب',
                'type' => 'product',
                'category' => 'beverages',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890204',
            ],
            [
                'name' => 'مياه معدنية',
                'description' => 'مياه معدنية صحية',
                'sku' => 'BEV005',
                'price' => 3.00,
                'price_with_tax' => 3.45,
                'cost_price' => 1.00,
                'stock_quantity' => 500,
                'unit' => 'زجاجة',
                'type' => 'product',
                'category' => 'beverages',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890205',
            ],
            [
                'name' => 'مشروب غازي',
                'description' => 'مشروب غازي بنكهات متنوعة',
                'sku' => 'BEV006',
                'price' => 6.00,
                'price_with_tax' => 6.90,
                'cost_price' => 2.00,
                'stock_quantity' => 400,
                'unit' => 'علبة',
                'type' => 'product',
                'category' => 'beverages',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890206',
            ],

            // الحلويات
            [
                'name' => 'كنافة نابلسية',
                'description' => 'كنافة تقليدية محشوة بالجبن والمكسرات',
                'sku' => 'DES001',
                'price' => 22.00,
                'price_with_tax' => 25.30,
                'cost_price' => 10.00,
                'stock_quantity' => 40,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'desserts',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890301',
            ],
            [
                'name' => 'بقلاوة مشكلة',
                'description' => 'قطع بقلاوة متنوعة بالفستق واللوز',
                'sku' => 'DES002',
                'price' => 18.00,
                'price_with_tax' => 20.70,
                'cost_price' => 8.00,
                'stock_quantity' => 60,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'desserts',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890302',
            ],
            [
                'name' => 'أم علي',
                'description' => 'حلو أم علي بالحليب والمكسرات',
                'sku' => 'DES003',
                'price' => 15.00,
                'price_with_tax' => 17.25,
                'cost_price' => 6.00,
                'stock_quantity' => 30,
                'unit' => 'طبق',
                'type' => 'product',
                'category' => 'desserts',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890303',
            ],
            [
                'name' => 'مهلبية',
                'description' => 'مهلبية تقليدية مع الفستق المطحون',
                'sku' => 'DES004',
                'price' => 12.00,
                'price_with_tax' => 13.80,
                'cost_price' => 5.00,
                'stock_quantity' => 50,
                'unit' => 'كوب',
                'type' => 'product',
                'category' => 'desserts',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890304',
            ],
            [
                'name' => 'كيك شوكولاتة',
                'description' => 'قطعة كيك شوكولاتة غنية',
                'sku' => 'DES005',
                'price' => 20.00,
                'price_with_tax' => 23.00,
                'cost_price' => 8.00,
                'stock_quantity' => 25,
                'unit' => 'قطعة',
                'type' => 'product',
                'category' => 'desserts',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890305',
            ],
            [
                'name' => 'آيس كريم فانيليا',
                'description' => 'كرات آيس كريم بنكهة الفانيليا',
                'sku' => 'DES006',
                'price' => 14.00,
                'price_with_tax' => 16.10,
                'cost_price' => 5.00,
                'stock_quantity' => 80,
                'unit' => 'كوب',
                'type' => 'product',
                'category' => 'desserts',
                'tax_rate' => 15.00,
                'is_active' => true,
                'barcode' => '1234567890306',
            ],
        ];

        foreach ($products as $product) {
            // حساب السعر مع الضريبة تلقائياً إذا لم يكن موجوداً
            if (!isset($product['price_with_tax'])) {
                $product['price_with_tax'] = $product['price'] * (1 + ($product['tax_rate'] / 100));
            }
            Product::create($product);
        }
    }
}