<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $products = [
            [
                'sku' => 'DELL-INS-001',
                'name' => 'جهاز كمبيوتر محمول Dell Inspiron',
                'name_en' => 'Dell Inspiron Laptop',
                'description' => 'جهاز كمبيوتر محمول عالي الأداء مناسب للأعمال والدراسة',
                'barcode' => '1234567890123',
                'type' => 'product',
                'price' => 2173.91,
                'price_with_tax' => 2500.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 15,
                'min_stock' => 5,
                'unit' => 'PCE',
                'zatca_category_code' => '84713000',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'sku' => 'HP-LJ-002',
                'name' => 'طابعة HP LaserJet Pro',
                'name_en' => 'HP LaserJet Pro Printer',
                'description' => 'طابعة ليزر عالية الجودة للمكاتب',
                'barcode' => '2345678901234',
                'type' => 'product',
                'price' => 695.65,
                'price_with_tax' => 800.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 8,
                'min_stock' => 2,
                'unit' => 'PCE',
                'zatca_category_code' => '84433200',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'sku' => 'HDMI-CAB-003',
                'name' => 'كابل HDMI عالي الجودة',
                'name_en' => 'High Quality HDMI Cable',
                'description' => 'كابل HDMI بطول 2 متر يدعم دقة 4K',
                'barcode' => '3456789012345',
                'type' => 'product',
                'price' => 39.13,
                'price_with_tax' => 45.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 100,
                'min_stock' => 20,
                'unit' => 'PCE',
                'zatca_category_code' => '85444290',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'sku' => 'TECH-SUP-004',
                'name' => 'خدمة الدعم التقني',
                'name_en' => 'Technical Support Service',
                'description' => 'خدمة دعم تقني شاملة لمدة ساعة واحدة',
                'type' => 'service',
                'price' => 130.43,
                'price_with_tax' => 150.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 0,
                'min_stock' => 0,
                'unit' => 'HR',
                'zatca_category_code' => '84430000',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'sku' => 'TRAIN-SW-005',
                'name' => 'خدمة التدريب على البرمجيات',
                'name_en' => 'Software Training Service',
                'description' => 'دورة تدريبية شاملة على استخدام البرمجيات المكتبية',
                'type' => 'service',
                'price' => 260.87,
                'price_with_tax' => 300.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 0,
                'min_stock' => 0,
                'unit' => 'HR',
                'zatca_category_code' => '92000000',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'sku' => 'PAPER-A4-006',
                'name' => 'ورق طباعة A4',
                'name_en' => 'A4 Printing Paper',
                'description' => 'حزمة ورق طباعة A4 عالي الجودة - 500 ورقة',
                'barcode' => '4567890123456',
                'type' => 'product',
                'price' => 21.74,
                'price_with_tax' => 25.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 200,
                'min_stock' => 50,
                'unit' => 'PCK',
                'zatca_category_code' => '48025610',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'sku' => 'PEN-BLUE-007',
                'name' => 'قلم حبر جاف أزرق',
                'name_en' => 'Blue Ballpoint Pen',
                'description' => 'قلم حبر جاف عالي الجودة',
                'barcode' => '5678901234567',
                'type' => 'product',
                'price' => 2.61,
                'price_with_tax' => 3.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 500,
                'min_stock' => 100,
                'unit' => 'PCE',
                'zatca_category_code' => '96081000',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'sku' => 'BOOK-EDU-008',
                'name' => 'كتاب تعليمي',
                'name_en' => 'Educational Book',
                'description' => 'كتاب تعليمي في تقنية المعلومات',
                'barcode' => '6789012345678',
                'type' => 'product',
                'price' => 80.00,
                'price_with_tax' => 80.00,
                'tax_rate' => 0.00,
                'stock_quantity' => 30,
                'min_stock' => 5,
                'unit' => 'PCE',
                'zatca_category_code' => '49019900',
                'is_taxable' => false,
                'is_active' => true,
            ],
            [
                'sku' => 'CONSULT-010',
                'name' => 'استشارة تقنية متخصصة',
                'name_en' => 'Specialized Technical Consultation',
                'description' => 'جلسة استشارة تقنية متخصصة مع خبير',
                'type' => 'service',
                'price' => 434.78,
                'price_with_tax' => 500.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 0,
                'min_stock' => 0,
                'unit' => 'HR',
                'zatca_category_code' => '84430000',
                'is_taxable' => true,
                'is_active' => true,
            ],
            [
                'sku' => 'INACTIVE-009',
                'name' => 'منتج غير نشط',
                'name_en' => 'Inactive Product',
                'description' => 'منتج متوقف مؤقتاً',
                'barcode' => '7890123456789',
                'type' => 'product',
                'price' => 86.96,
                'price_with_tax' => 100.00,
                'tax_rate' => 15.00,
                'stock_quantity' => 0,
                'min_stock' => 0,
                'unit' => 'PCE',
                'zatca_category_code' => '99999999',
                'is_taxable' => true,
                'is_active' => false,
            ]
        ];

        foreach ($products as $productData) {
            $sku = $productData['sku'];
            unset($productData['sku']);
            
            Product::firstOrCreate(['sku' => $sku], $productData);
        }
    }
}
